/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.junit;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.adapter.SlingAdaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.testing.mock.osgi.context.ContextCallback;
import org.apache.sling.testing.mock.osgi.context.OsgiContextImpl;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.junit.SlingContext;
import org.apache.sling.testing.mock.sling.junit.SlingContextBuilder;
import org.apache.sling.testing.mock.sling.junit.SlingContextCallback;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SlingContextTest {
    private final SlingContextCallback contextBeforeSetup = (SlingContextCallback)Mockito.mock(SlingContextCallback.class);
    private final SlingContextCallback contextAfterSetup = (SlingContextCallback)Mockito.mock(SlingContextCallback.class);
    private final SlingContextCallback contextBeforeTeardown = (SlingContextCallback)Mockito.mock(SlingContextCallback.class);
    private final SlingContextCallback contextAfterTeardown = (SlingContextCallback)Mockito.mock(SlingContextCallback.class);
    @Rule
    public SlingContext context = new SlingContextBuilder(ResourceResolverType.JCR_MOCK).beforeSetUp(new ContextCallback[]{this.contextBeforeSetup}).afterSetUp(new ContextCallback[]{this.contextAfterSetup}).beforeTearDown(new ContextCallback[]{this.contextBeforeTeardown}).afterTearDown(new ContextCallback[]{this.contextAfterTeardown}).resourceResolverFactoryActivatorProps((Map)ImmutableMap.of((Object)"resource.resolver.searchpath", (Object)new String[]{"/apps", "/libs", "/testpath"}, (Object)"resource.resolver.mapping", (Object)new String[]{"/:/", "/content/test/</"})).build();

    @Before
    public void setUp() throws Exception {
        ((SlingContextCallback)Mockito.verify((Object)this.contextBeforeSetup)).execute((OsgiContextImpl)this.context);
        ((SlingContextCallback)Mockito.verify((Object)this.contextAfterSetup)).execute((OsgiContextImpl)this.context);
    }

    @Test
    public void testRequest() {
        Assert.assertNotNull((Object)this.context.request());
    }

    @Test
    public void testResourceResolverFactoryActivatorProps() {
        this.context.create().resource("/apps/node1");
        this.context.create().resource("/libs/node1");
        this.context.create().resource("/libs/node2");
        this.context.create().resource("/testpath/node1");
        this.context.create().resource("/testpath/node2");
        this.context.create().resource("/testpath/node3");
        Assert.assertEquals((Object)"/apps/node1", (Object)this.context.resourceResolver().getResource("node1").getPath());
        Assert.assertEquals((Object)"/libs/node2", (Object)this.context.resourceResolver().getResource("node2").getPath());
        Assert.assertEquals((Object)"/testpath/node3", (Object)this.context.resourceResolver().getResource("node3").getPath());
        Assert.assertNull((Object)this.context.resourceResolver().getResource("node4"));
    }

    @Test
    public void testRegisterAdapter() {
        this.context.registerAdapter(ResourceResolver.class, Integer.class, (Object)5);
        this.context.registerAdapter(ResourceResolver.class, String.class, (Function)new Function<ResourceResolver, String>(){

            public String apply(ResourceResolver input) {
                return ">" + input.toString();
            }
        });
        Assert.assertEquals((Object)5, (Object)this.context.resourceResolver().adaptTo(Integer.class));
        Assert.assertEquals((Object)(">" + this.context.resourceResolver().toString()), (Object)this.context.resourceResolver().adaptTo(String.class));
        Assert.assertNull((Object)this.context.resourceResolver().adaptTo(Double.class));
    }

    @Test
    public void testRegisterAdapterOverlayStatic() {
        this.prepareInitialAdapterFactory();
        this.context.registerAdapter(TestAdaptable.class, String.class, (Object)"static-adaption");
        Assert.assertEquals((Object)"static-adaption", (Object)new TestAdaptable("testMessage2").adaptTo(String.class));
    }

    @Test
    public void testRegisterAdapterOverlayDynamic() {
        this.prepareInitialAdapterFactory();
        this.context.registerAdapter(TestAdaptable.class, String.class, (Function)new Function<TestAdaptable, String>(){

            public String apply(TestAdaptable input) {
                return input.getMessage() + "-dynamic";
            }
        });
        Assert.assertEquals((Object)"testMessage3-dynamic", (Object)new TestAdaptable("testMessage3").adaptTo(String.class));
    }

    @Test
    public void testResourceBuilder() {
        this.context.build().resource("/test1", new Object[]{"prop1", "value1"}).siblingsMode().resource("a", new Object[0]).resource("b", new Object[0]);
        Resource test1 = this.context.resourceResolver().getResource("/test1");
        Assert.assertNotNull((Object)test1);
        Assert.assertEquals((Object)"value1", (Object)test1.getValueMap().get("prop1", String.class));
        Assert.assertNotNull((Object)test1.getChild("a"));
        Assert.assertNotNull((Object)test1.getChild("b"));
    }

    @Test
    public void testUrlMapping() {
        Assert.assertEquals((Object)"/foo", (Object)this.context.resourceResolver().map("/content/test/foo"));
    }

    private void prepareInitialAdapterFactory() {
        AdapterFactory adapterFactory = new AdapterFactory(){

            public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
                return (AdapterType)(((TestAdaptable)((Object)adaptable)).getMessage() + "-initial");
            }
        };
        this.context.registerService(AdapterFactory.class, (Object)adapterFactory, (Map)ImmutableMap.builder().put((Object)"adaptables", (Object)new String[]{TestAdaptable.class.getName()}).put((Object)"adapters", (Object)new String[]{String.class.getName()}).build());
        Assert.assertEquals((Object)"testMessage1-initial", (Object)new TestAdaptable("testMessage1").adaptTo(String.class));
    }

    private static class TestAdaptable
    extends SlingAdaptable {
        private final String message;

        public TestAdaptable(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

