/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.context;

import aQute.bnd.annotation.ConsumerType;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.UUID;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.testing.mock.sling.context.SlingContextImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConsumerType
public class UniqueRoot {
    private final SlingContextImpl context;
    protected final String uniquePathPart;
    private Resource contentRoot;
    private Resource appsRoot;
    private Resource libsRoot;
    private static final Logger log = LoggerFactory.getLogger(UniqueRoot.class);

    protected UniqueRoot(SlingContextImpl context) {
        this.context = context;
        this.uniquePathPart = UUID.randomUUID().toString();
    }

    protected final Resource getOrCreateResource(String path, String primaryType) {
        try {
            return ResourceUtil.getOrCreateResource((ResourceResolver)this.context.resourceResolver(), (String)path, (Map)ImmutableMap.of((Object)"jcr:primaryType", (Object)primaryType), null, (boolean)true);
        }
        catch (PersistenceException ex) {
            throw new RuntimeException("Unable to create resource at " + path + ": " + ex.getMessage(), ex);
        }
    }

    public final String content() {
        if (this.contentRoot == null) {
            this.contentRoot = this.getOrCreateResource("/content/" + this.uniquePathPart, "sling:OrderedFolder");
        }
        return this.contentRoot.getPath();
    }

    public final String apps() {
        if (this.appsRoot == null) {
            this.appsRoot = this.getOrCreateResource("/apps/" + this.uniquePathPart, "sling:OrderedFolder");
        }
        return this.appsRoot.getPath();
    }

    public final String libs() {
        if (this.libsRoot == null) {
            this.libsRoot = this.getOrCreateResource("/libs/" + this.uniquePathPart, "sling:OrderedFolder");
        }
        return this.libsRoot.getPath();
    }

    protected void cleanUp() {
        this.deleteResources(this.contentRoot, this.appsRoot, this.libsRoot);
    }

    protected final void deleteResources(Resource ... resources) {
        for (Resource resource : resources) {
            if (resource == null || this.context.resourceResolver.getResource(resource.getPath()) == null) continue;
            try {
                this.context.resourceResolver().delete(resource);
            }
            catch (PersistenceException ex) {
                log.warn("Unable to delete root path " + resource.getPath(), (Throwable)ex);
            }
        }
        try {
            this.context.resourceResolver().commit();
        }
        catch (PersistenceException ex) {
            log.warn("Unable to commit root path deletions.", (Throwable)ex);
        }
    }
}

