/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.paxexam;

import org.apache.sling.testing.paxexam.SlingVersionResolver;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.cm.ConfigurationAdminOptions;
import org.ops4j.pax.exam.options.MavenArtifactProvisionOption;
import org.ops4j.pax.exam.options.MavenUrlReference;
import org.ops4j.pax.exam.options.ModifiableCompositeOption;
import org.ops4j.pax.exam.options.UrlReference;
import org.ops4j.pax.exam.util.PathUtils;

public final class SlingOptions {
    public static SlingVersionResolver versionResolver = new SlingVersionResolver();

    private SlingOptions() {
    }

    public static ModifiableCompositeOption awaitility() {
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.mavenBundle().groupId("org.awaitility").artifactId("awaitility").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.servicemix.bundles").artifactId("org.apache.servicemix.bundles.hamcrest").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption backing() {
        int version = SlingVersionResolver.getJavaVersion();
        if (version >= 11) {
            return CoreOptions.composite((Option[])new Option[]{CoreOptions.mavenBundle().groupId("org.apache.servicemix.specs").artifactId("org.apache.servicemix.specs.annotation-api-1.3").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.servicemix.specs").artifactId("org.apache.servicemix.specs.activation-api-1.1").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.servicemix.specs").artifactId("org.apache.servicemix.specs.stax-api-1.2").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.servicemix.specs").artifactId("org.apache.servicemix.specs.jaxb-api-2.3").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.servicemix.bundles").artifactId("org.apache.servicemix.bundles.jaxb-impl").version((MavenUrlReference.VersionResolver)versionResolver)});
        }
        if (version >= 9) {
            return CoreOptions.composite((Option[])new Option[]{CoreOptions.vmOption((String)"--add-modules=java.se.ee")});
        }
        return CoreOptions.composite((Option[])new Option[0]);
    }

    public static ModifiableCompositeOption config() {
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.mavenBundle().groupId("org.apache.felix").artifactId("org.apache.felix.configadmin").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption eventadmin() {
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.mavenBundle().groupId("org.apache.felix").artifactId("org.apache.felix.eventadmin").version((MavenUrlReference.VersionResolver)versionResolver), SlingOptions.config()});
    }

    public static ModifiableCompositeOption greenmail() {
        MavenArtifactProvisionOption greenmail = CoreOptions.mavenBundle().groupId("com.icegreen").artifactId("greenmail").version((MavenUrlReference.VersionResolver)versionResolver);
        MavenArtifactProvisionOption slf4jApi = CoreOptions.mavenBundle().groupId("org.slf4j").artifactId("slf4j-api").version((MavenUrlReference.VersionResolver)versionResolver);
        MavenArtifactProvisionOption slf4jSimple = CoreOptions.mavenBundle().groupId("org.slf4j").artifactId("slf4j-simple").version((MavenUrlReference.VersionResolver)versionResolver);
        return CoreOptions.composite((Option[])new Option[]{greenmail, CoreOptions.mavenBundle().groupId("jakarta.mail").artifactId("jakarta.mail-api").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("com.sun.mail").artifactId("jakarta.mail").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.servicemix.specs").artifactId("org.apache.servicemix.specs.activation-api-2.0.1").version((MavenUrlReference.VersionResolver)versionResolver), SlingOptions.junit(), CoreOptions.bootClasspathLibrary((UrlReference)greenmail).afterFramework(), CoreOptions.bootClasspathLibrary((UrlReference)slf4jApi).afterFramework(), CoreOptions.bootClasspathLibrary((UrlReference)slf4jSimple).afterFramework()});
    }

    public static ModifiableCompositeOption hamcrest() {
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.mavenBundle().groupId("org.hamcrest").artifactId("hamcrest").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption http() {
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.mavenBundle().groupId("org.apache.felix").artifactId("org.apache.felix.http.jetty").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.felix").artifactId("org.apache.felix.http.servlet-api").version((MavenUrlReference.VersionResolver)versionResolver), SlingOptions.config()});
    }

    public static ModifiableCompositeOption httpWhiteboard() {
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.mavenBundle().groupId("org.apache.felix").artifactId("org.apache.felix.http.whiteboard").version((MavenUrlReference.VersionResolver)versionResolver), SlingOptions.http()});
    }

    public static ModifiableCompositeOption jackson() {
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.mavenBundle().groupId("com.fasterxml.jackson.core").artifactId("jackson-annotations").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("com.fasterxml.jackson.core").artifactId("jackson-core").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("com.fasterxml.jackson.core").artifactId("jackson-databind").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption junit() {
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.mavenBundle().groupId("org.apache.servicemix.bundles").artifactId("org.apache.servicemix.bundles.junit").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption management() {
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.mavenBundle().groupId("org.apache.aries").artifactId("org.apache.aries.util").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.aries.jmx").artifactId("org.apache.aries.jmx.api").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.aries.jmx").artifactId("org.apache.aries.jmx.core").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.aries.jmx").artifactId("org.apache.aries.jmx.whiteboard").version((MavenUrlReference.VersionResolver)versionResolver), SlingOptions.config()});
    }

    public static ModifiableCompositeOption scr() {
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.mavenBundle().groupId("org.apache.felix").artifactId("org.apache.felix.metatype").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.felix").artifactId("org.apache.felix.scr").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.osgi").artifactId("org.osgi.service.component").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.osgi").artifactId("org.osgi.util.function").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.osgi").artifactId("org.osgi.util.promise").version((MavenUrlReference.VersionResolver)versionResolver), SlingOptions.config()});
    }

    public static ModifiableCompositeOption spifly() {
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.mavenBundle().groupId("org.apache.aries").artifactId("org.apache.aries.util").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.aries.spifly").artifactId("org.apache.aries.spifly.dynamic.bundle").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.ow2.asm").artifactId("asm").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.ow2.asm").artifactId("asm-analysis").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.ow2.asm").artifactId("asm-commons").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.ow2.asm").artifactId("asm-util").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.ow2.asm").artifactId("asm-tree").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption webconsole() {
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.mavenBundle().groupId("org.apache.felix").artifactId("org.apache.felix.webconsole").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.felix").artifactId("org.apache.felix.inventory").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("commons-fileupload").artifactId("commons-fileupload").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("commons-io").artifactId("commons-io").version((MavenUrlReference.VersionResolver)versionResolver), SlingOptions.http()});
    }

    public static ModifiableCompositeOption paxLoggingApi() {
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.mavenBundle().groupId("org.ops4j.pax.logging").artifactId("pax-logging-api").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption paxLoggingLog4j2(String configurationFile) {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.paxLoggingApi(), ConfigurationAdminOptions.newConfiguration((String)"org.ops4j.pax.logging").put("org.ops4j.pax.logging.log4j2.config.file", (Object)configurationFile).asOption(), CoreOptions.mavenBundle().groupId("org.ops4j.pax.logging").artifactId("pax-logging-log4j2").version((MavenUrlReference.VersionResolver)versionResolver), SlingOptions.config()});
    }

    public static ModifiableCompositeOption paxLoggingLog4j2() {
        String filename = String.format("%s/src/test/resources/log4j2.xml", PathUtils.getBaseDir());
        return SlingOptions.paxLoggingLog4j2(filename);
    }

    public static ModifiableCompositeOption paxLoggingLogback(String configurationFile) {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.paxLoggingApi(), ConfigurationAdminOptions.newConfiguration((String)"org.ops4j.pax.logging").put("org.ops4j.pax.logging.logback.config.file", (Object)configurationFile).asOption(), CoreOptions.mavenBundle().groupId("org.ops4j.pax.logging").artifactId("pax-logging-logback").version((MavenUrlReference.VersionResolver)versionResolver), SlingOptions.config()});
    }

    public static ModifiableCompositeOption paxLoggingLogback() {
        String filename = String.format("%s/src/test/resources/logback.xml", PathUtils.getBaseDir());
        return SlingOptions.paxLoggingLogback(filename);
    }

    public static ModifiableCompositeOption paxUrl() {
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.mavenBundle().groupId("org.ops4j.pax.url").artifactId("pax-url-commons").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.ops4j.base").artifactId("ops4j-base-lang").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.ops4j.base").artifactId("ops4j-base-util-property").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.ops4j.pax.swissbox").artifactId("pax-swissbox-property").version((MavenUrlReference.VersionResolver)versionResolver), SlingOptions.config()});
    }

    public static ModifiableCompositeOption paxUrlClasspath() {
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.mavenBundle().groupId("org.ops4j.pax.url").artifactId("pax-url-classpath").version((MavenUrlReference.VersionResolver)versionResolver), SlingOptions.paxUrl()});
    }

    public static ModifiableCompositeOption paxUrlWrap() {
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.mavenBundle().groupId("org.ops4j.pax.url").artifactId("pax-url-wrap").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.ops4j.pax.swissbox").artifactId("pax-swissbox-bnd").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("biz.aQute.bnd").artifactId("bndlib").version((MavenUrlReference.VersionResolver)versionResolver), SlingOptions.paxUrl()});
    }

    public static ModifiableCompositeOption paxTinybundles() {
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.mavenBundle().groupId("org.ops4j.pax.tinybundles").artifactId("tinybundles").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.ops4j.base").artifactId("ops4j-base-store").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("biz.aQute.bnd").artifactId("biz.aQute.bndlib").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("biz.aQute.bnd").artifactId("biz.aQute.bnd.util").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.osgi").artifactId("org.osgi.service.repository").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.osgi").artifactId("org.osgi.util.function").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.osgi").artifactId("org.osgi.util.promise").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption logback() {
        String filename = String.format("file:%s/src/test/resources/logback.xml", PathUtils.getBaseDir());
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.systemProperty((String)"logback.configurationFile").value(filename), CoreOptions.mavenBundle().groupId("org.slf4j").artifactId("slf4j-api").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.slf4j").artifactId("jcl-over-slf4j").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("ch.qos.logback").artifactId("logback-core").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("ch.qos.logback").artifactId("logback-classic").version((MavenUrlReference.VersionResolver)versionResolver), SlingOptions.config()});
    }

    public static ModifiableCompositeOption restassured() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.config(), CoreOptions.mavenBundle().groupId("io.rest-assured").artifactId("rest-assured").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("io.rest-assured").artifactId("rest-assured-common").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("io.rest-assured").artifactId("json-path").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("io.rest-assured").artifactId("xml-path").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.commons").artifactId("commons-lang3").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.groovy").artifactId("groovy").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.groovy").artifactId("groovy-json").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.groovy").artifactId("groovy-xml").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.servicemix.bundles").artifactId("org.apache.servicemix.bundles.jaxb-impl").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.servicemix.bundles").artifactId("org.apache.servicemix.bundles.tagsoup").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.servicemix.specs").artifactId("org.apache.servicemix.specs.activation-api-1.1").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.servicemix.specs").artifactId("org.apache.servicemix.specs.jaxb-api-2.3").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.servicemix.specs").artifactId("org.apache.servicemix.specs.stax-api-1.2").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.httpcomponents").artifactId("httpcore-osgi").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.httpcomponents").artifactId("httpclient-osgi").version((MavenUrlReference.VersionResolver)versionResolver), SlingOptions.hamcrest()});
    }

    public static ModifiableCompositeOption testcontainers() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.junit(), SlingOptions.paxUrlWrap(), CoreOptions.wrappedBundle((UrlReference)CoreOptions.mavenBundle().groupId("org.rnorth.duct-tape").artifactId("duct-tape").version((MavenUrlReference.VersionResolver)versionResolver)), CoreOptions.wrappedBundle((UrlReference)CoreOptions.mavenBundle().groupId("org.testcontainers").artifactId("testcontainers").version((MavenUrlReference.VersionResolver)versionResolver))});
    }

    public static ModifiableCompositeOption sling() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.config(), SlingOptions.eventadmin(), SlingOptions.scr(), SlingOptions.management(), SlingOptions.http(), SlingOptions.httpWhiteboard(), SlingOptions.paxUrlClasspath(), SlingOptions.slingCommonsFsclassloader(), SlingOptions.slingCommonsOsgi(), SlingOptions.slingCommonsScheduler(), SlingOptions.slingCommonsThreads(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.api").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.auth.core").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.engine").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.resourceresolver").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.serviceusermapper").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.settings").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.commons.johnzon").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.commons.mime").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("commons-codec").artifactId("commons-codec").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("commons-collections").artifactId("commons-collections").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("commons-fileupload").artifactId("commons-fileupload").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("commons-io").artifactId("commons-io").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.commons").artifactId("commons-collections4").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.commons").artifactId("commons-lang3").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.commons").artifactId("commons-math").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.osgi").artifactId("org.osgi.util.converter").version((MavenUrlReference.VersionResolver)versionResolver), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl.amended").put("user.mapping", (Object)new String[]{"org.apache.sling.auth.core=[sling-readall]"}).asOption(), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl.amended").put("user.mapping", (Object)new String[]{"org.apache.sling.resourceresolver:mapping=[sling-mapping]", "org.apache.sling.resourceresolver:hierarchy=[sling-readall]", "org.apache.sling.resourceresolver:observation=[sling-readall]", "org.apache.sling.resourceresolver:console=[sling-readall]"}).asOption()});
    }

    public static ModifiableCompositeOption slingAuthForm() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), SlingOptions.jackrabbitOak(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.auth.form").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingCommonsClam() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.scr(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.commons.clam").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("commons-io").artifactId("commons-io").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingCommonsCompiler() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.scr(), SlingOptions.slingCommonsClassloader(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.commons.compiler").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingCommonsClassloader() {
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.commons.classloader").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingCommonsCrypto() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.scr(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.commons.crypto").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.commons").artifactId("commons-lang3").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.servicemix.bundles").artifactId("org.apache.servicemix.bundles.jasypt").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingCommonsFsclassloader() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.scr(), SlingOptions.webconsole(), SlingOptions.slingCommonsClassloader(), SlingOptions.slingCommonsOsgi(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.commons.fsclassloader").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("commons-io").artifactId("commons-io").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.commons").artifactId("commons-lang3").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingCommonsHtml() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.scr(), SlingOptions.slingCommonsOsgi(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.commons.html").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingCommonsMessaging() {
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.commons.messaging").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingCommonsMessagingMail() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.scr(), SlingOptions.slingCommonsCrypto(), SlingOptions.slingCommonsMessaging(), SlingOptions.slingCommonsThreads(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.commons.messaging.mail").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("com.sun.mail").artifactId("jakarta.mail").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("jakarta.mail").artifactId("jakarta.mail-api").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.commons").artifactId("commons-lang3").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.servicemix.specs").artifactId("org.apache.servicemix.specs.activation-api-2.0.1").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingCommonsMetrics() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.scr(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.commons.metrics").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("io.dropwizard.metrics").artifactId("metrics-core").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.commons").artifactId("commons-lang3").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingCommonsOsgi() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.eventadmin(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.commons.osgi").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingCommonsScheduler() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.scr(), SlingOptions.slingCommonsMetrics(), SlingOptions.slingCommonsThreads(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.commons.scheduler").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("javax.servlet").artifactId("javax.servlet-api").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.geronimo.specs").artifactId("geronimo-jta_1.1_spec").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingCommonsThreads() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.config(), SlingOptions.slingCommonsMetrics(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.commons.threads").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingAdapter() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.adapter").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingBundleresource() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.bundleresource.impl").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingCaconfig() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), SlingOptions.slingScripting(), SlingOptions.slingXss(), SlingOptions.webconsole(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.caconfig.api").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.caconfig.impl").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.caconfig.spi").version((MavenUrlReference.VersionResolver)versionResolver), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.jcr.repoinit.RepositoryInitializer").put("scripts", (Object)new String[]{"create path (sling:Folder) /conf"}).asOption(), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl.amended").put("user.mapping", (Object)new String[]{"org.apache.sling.caconfig.impl=[sling-readall]"}).asOption()});
    }

    public static ModifiableCompositeOption slingClam() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), SlingOptions.slingCommonsClam(), SlingOptions.slingEvent(), SlingOptions.slingJcr(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.clam").version((MavenUrlReference.VersionResolver)versionResolver), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.jcr.repoinit.RepositoryInitializer").put("scripts", (Object)new String[]{"create service user sling-clam with path system/sling\n\nset principal ACL for sling-clam\n  allow     jcr:read    on /\n  allow     rep:write   on /var/clam\nend\n\ncreate path (sling:Folder) /var/clam/results(sling:OrderedFolder)"}).asOption(), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl.amended").put("user.mapping", (Object)new String[]{"org.apache.sling.clam=[sling-clam]", "org.apache.sling.clam:result-writer=[sling-clam]"}).asOption()});
    }

    public static ModifiableCompositeOption slingDiscovery() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.discovery.api").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingDiscoveryOak() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.webconsole(), SlingOptions.slingDiscovery(), SlingOptions.felixHealthcheck(), SlingOptions.httpcomponentsClient(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.discovery.base").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.discovery.commons").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.discovery.oak").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.discovery.support").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("javax.jcr").artifactId("jcr").version((MavenUrlReference.VersionResolver)versionResolver), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.jcr.base.internal.LoginAdminWhitelist.fragment").put("whitelist.bundles", (Object)new String[]{"org.apache.sling.discovery.commons", "org.apache.sling.discovery.base", "org.apache.sling.discovery.oak"}).put("whitelist.name", (Object)"sling-discovery").asOption(), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.jcr.repoinit.RepositoryInitializer").put("scripts", (Object)new String[]{"create service user sling-discovery with path system/sling\n\nset principal ACL for sling-discovery\n  allow   jcr:read,rep:write    on /var/discovery\nend\n\ncreate path (sling:Folder) /var/discovery\ncreate path (sling:Folder) /var/discovery/oak"}).asOption(), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl.amended").put("user.mapping", (Object)new String[]{"org.apache.sling.discovery.commons=[sling-discovery]", "org.apache.sling.discovery.base=[sling-discovery]", "org.apache.sling.discovery.oak=[sling-discovery]"}).asOption()});
    }

    public static ModifiableCompositeOption slingDiscoveryStandalone() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.slingDiscovery(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.discovery.standalone").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingDistribution() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), SlingOptions.slingJcr(), SlingOptions.slingEvent(), SlingOptions.felixHealthcheck(), SlingOptions.httpcomponentsClient(), SlingOptions.jackrabbitVault(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.distribution.api").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.distribution.core").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingEvent() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), SlingOptions.slingDiscovery(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.event").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.event.dea").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.felix").artifactId("org.apache.felix.inventory").version((MavenUrlReference.VersionResolver)versionResolver), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.jcr.repoinit.RepositoryInitializer").put("scripts", (Object)new String[]{"create service user sling-event with path system/sling\n\nset principal ACL for sling-event\n    allow   jcr:all     on /var/eventing\nend\n\ncreate path (sling:Folder) /var/eventing"}).asOption(), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl.amended").put("user.mapping", (Object)new String[]{"org.apache.sling.event=[sling-event]", "org.apache.sling.event.dea=[sling-event]"}).asOption()});
    }

    public static ModifiableCompositeOption slingExtensionsWebconsolesecurityprovider() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), SlingOptions.jackrabbit(), SlingOptions.webconsole(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.extensions.webconsolesecurityprovider").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingFeatureflags() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.featureflags").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingFsresource() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), SlingOptions.jackrabbitVault(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.fsresource").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("javax.jcr").artifactId("jcr").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("com.google.guava").artifactId("guava").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.jackrabbit").artifactId("oak-jackrabbit-api").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.jackrabbit").artifactId("jackrabbit-jcr-commons").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingI18n() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.i18n").version((MavenUrlReference.VersionResolver)versionResolver), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl.amended").put("user.mapping", (Object)new String[]{"org.apache.sling.i18n=[sling-readall]"}).asOption()});
    }

    public static ModifiableCompositeOption slingJmxProvider() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.jmx.provider").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingModels() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), SlingOptions.slingAdapter(), SlingOptions.slingScripting(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.models.api").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.models.impl").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.servicemix.specs").artifactId("org.apache.servicemix.specs.annotation-api-1.3").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingModelsJacksonexporter() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.slingModels(), SlingOptions.jackson(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.models.jacksonexporter").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingPipes() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), SlingOptions.jackrabbit(), SlingOptions.jackrabbitVault(), SlingOptions.slingCaconfig(), SlingOptions.slingEvent(), SlingOptions.slingModels(), SlingOptions.slingQuery(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.pipes").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingQuery() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.query").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("javax.jcr").artifactId("jcr").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingResourceInventory() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.resource.inventory").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.felix").artifactId("org.apache.felix.inventory").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingResourcePresence() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.resource.presence").version((MavenUrlReference.VersionResolver)versionResolver), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl.amended").put("user.mapping", (Object)new String[]{"org.apache.sling.resource.presence=[sling-readall]"}).asOption()});
    }

    public static ModifiableCompositeOption slingResourcemerger() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.resourcemerger").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingRewriter() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), SlingOptions.slingCommonsHtml(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.rewriter").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.commons").artifactId("commons-text").version((MavenUrlReference.VersionResolver)versionResolver), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl.amended").put("user.mapping", (Object)new String[]{"org.apache.sling.rewriter=[sling-readall]"}).asOption()});
    }

    public static ModifiableCompositeOption slingSecurity() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.security").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingUrlrewriter() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.urlrewriter").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.servicemix.bundles").artifactId("org.apache.servicemix.bundles.urlrewritefilter").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingValidation() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), SlingOptions.slingI18n(), SlingOptions.slingServlets(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.validation.api").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.validation.core").version((MavenUrlReference.VersionResolver)versionResolver), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.jcr.repoinit.RepositoryInitializer").put("scripts", (Object)new String[]{"create service user sling-validation with path system/sling\n\nset principal ACL for sling-validation\n  allow   jcr:read    on /apps\n  allow   jcr:read    on /libs\nend"}).asOption(), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl.amended").put("user.mapping", (Object)new String[]{"org.apache.sling.validation.core=[sling-validation]"}).asOption()});
    }

    public static ModifiableCompositeOption slingXss() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), SlingOptions.httpcomponentsClient(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.xss").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.commons").artifactId("commons-text").version((MavenUrlReference.VersionResolver)versionResolver), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.jcr.repoinit.RepositoryInitializer").put("scripts", (Object)new String[]{"create service user sling-xss with path system/sling\n\nset principal ACL for sling-xss\n  allow   jcr:read    on /apps/sling/xss\n  allow   jcr:read    on /libs/sling/xss\nend\n\ncreate path (sling:Folder) /apps/sling/xss\ncreate path (sling:Folder) /libs/sling/xss"}).asOption(), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl.amended").put("user.mapping", (Object)new String[]{"org.apache.sling.xss=[sling-xss]"}).asOption()});
    }

    public static ModifiableCompositeOption slingInstaller() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.installer.console").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.installer.core").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.felix").artifactId("org.apache.felix.cm.json").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingInstallerFactoryConfiguration() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.slingInstaller(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.installer.factory.configuration").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingInstallerFactoryPackages() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.slingInstaller(), SlingOptions.slingJcr(), SlingOptions.jackrabbitVault(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.installer.factory.packages").version((MavenUrlReference.VersionResolver)versionResolver), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.jcr.repoinit.RepositoryInitializer").put("scripts", (Object)new String[]{"create service user sling-installer-factory-packages with path system/sling\n\nset principal ACL for sling-installer-factory-packages\n    allow   jcr:all     on    /\n    allow   jcr:namespaceManagement,jcr:nodeTypeDefinitionManagement on :repository\nend"}).asOption(), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl.amended").put("user.mapping", (Object)new String[]{"org.apache.sling.installer.factory.packages=[sling-installer-factory-packages]"}).asOption()});
    }

    public static ModifiableCompositeOption slingInstallerHealthcheck() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.slingInstaller(), SlingOptions.felixHealthcheck(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.installer.hc").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingInstallerProviderFile() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.slingInstaller(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.installer.provider.file").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingInstallerProviderJcr() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.slingInstaller(), SlingOptions.slingJcr(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.installer.provider.jcr").version((MavenUrlReference.VersionResolver)versionResolver), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.jcr.repoinit.RepositoryInitializer").put("scripts", (Object)new String[]{"create service user sling-installer-provider-jcr with path system/sling\n\nset principal ACL for sling-installer-provider-jcr\n    allow   jcr:read    on /\n    allow   rep:write   on /apps/sling/install\nend\n\ncreate path (sling:Folder) /apps/sling/install"}).asOption(), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl.amended").put("user.mapping", (Object)new String[]{"org.apache.sling.installer.provider.jcr=[sling-installer-provider-jcr]"}).asOption()});
    }

    public static ModifiableCompositeOption slingJcr() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.webconsole(), SlingOptions.sling(), SlingOptions.jackrabbit(), SlingOptions.jackrabbitOak(), SlingOptions.tika(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.jcr.api").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.jcr.base").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.jcr.contentloader").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.jcr.davex").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.jcr.resource").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.jcr.webconsole").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.jcr.webdav").version((MavenUrlReference.VersionResolver)versionResolver), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.jcr.base.internal.LoginAdminWhitelist.fragment").put("whitelist.bundles", (Object)new String[]{"org.apache.sling.jcr.base", "org.apache.sling.jcr.classloader", "org.apache.sling.jcr.oak.server", "org.apache.sling.jcr.repoinit", "org.apache.sling.jcr.webconsole"}).put("whitelist.name", (Object)"sling-jcr").asOption(), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.jcr.repoinit.RepositoryInitializer").put("scripts", (Object)new String[]{"create service user sling-jcr-contentloader with path system/sling\n\nset principal ACL for sling-jcr-contentloader\n  allow   jcr:all    on /\nend"}).asOption(), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl.amended").put("user.mapping", (Object)new String[]{"org.apache.sling.jcr.resource:observation=[sling-readall]", "org.apache.sling.jcr.resource:validation=[sling-readall]"}).asOption(), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl.amended").put("user.mapping", (Object)new String[]{"org.apache.sling.jcr.contentloader=[sling-jcr-contentloader]"}).asOption()});
    }

    public static ModifiableCompositeOption slingJcrCompiler() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), SlingOptions.slingJcr(), SlingOptions.slingCommonsCompiler(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.jcr.compiler").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingJcrJackrabbitAccessmanager() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.slingJcr(), SlingOptions.slingServlets(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.jcr.jackrabbit.accessmanager").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingJcrJackrabbitUsermanager() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.slingJcr(), SlingOptions.slingServlets(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.jcr.jackrabbit.usermanager").version((MavenUrlReference.VersionResolver)versionResolver), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.jcr.repoinit.RepositoryInitializer").put("scripts", (Object)new String[]{"create service user sling-jcr-jackrabbit-usermanager with path system/sling\n\nset principal ACL for sling-jcr-jackrabbit-usermanager\n  allow jcr:read,jcr:readAccessControl,jcr:modifyAccessControl,rep:write,rep:userManagement on /home\nend"}).asOption(), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl.amended").put("user.mapping", (Object)new String[]{"org.apache.sling.jcr.jackrabbit.usermanager=[sling-jcr-jackrabbit-usermanager]"}).asOption()});
    }

    public static ModifiableCompositeOption slingJcrRepoinit() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), SlingOptions.slingJcr(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.jcr.repoinit").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.repoinit.parser").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.provisioning.model").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingQuickstartOak() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.webconsole(), SlingOptions.sling(), SlingOptions.slingServlets(), SlingOptions.slingJcr(), SlingOptions.slingJcrRepoinit(), SlingOptions.slingAdapter(), SlingOptions.slingDiscoveryStandalone(), SlingOptions.felixHealthcheck(), CoreOptions.mavenBundle().groupId("org.apache.felix").artifactId("org.apache.felix.prefs").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.felix").artifactId("org.apache.felix.webconsole.plugins.memoryusage").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.felix").artifactId("org.apache.felix.webconsole.plugins.packageadmin").version((MavenUrlReference.VersionResolver)versionResolver), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.felix.jaas.Configuration.factory").put("jaas.classname", (Object)"org.apache.jackrabbit.oak.spi.security.authentication.GuestLoginModule").put("jaas.controlFlag", (Object)"optional").put("jaas.ranking", (Object)300).asOption(), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.felix.jaas.Configuration.factory").put("jaas.classname", (Object)"org.apache.jackrabbit.oak.security.authentication.user.LoginModuleImpl").put("jaas.controlFlag", (Object)"required").asOption(), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.felix.jaas.Configuration.factory").put("jaas.classname", (Object)"org.apache.jackrabbit.oak.security.authentication.token.TokenLoginModule").put("jaas.controlFlag", (Object)"sufficient").put("jaas.ranking", (Object)200).asOption(), ConfigurationAdminOptions.newConfiguration((String)"org.apache.felix.jaas.ConfigurationSpi").put("jaas.configProviderName", (Object)"FelixJaasProvider").put("jaas.defaultRealmName", (Object)"jackrabbit.oak").asOption(), ConfigurationAdminOptions.newConfiguration((String)"org.apache.jackrabbit.oak.security.authentication.AuthenticationConfigurationImpl").put("org.apache.jackrabbit.oak.authentication.configSpiName", (Object)"FelixJaasProvider").asOption(), ConfigurationAdminOptions.newConfiguration((String)"org.apache.jackrabbit.oak.security.authorization.AuthorizationConfigurationImpl").put("importBehavior", (Object)"besteffort").asOption(), ConfigurationAdminOptions.newConfiguration((String)"org.apache.jackrabbit.oak.security.internal.SecurityProviderRegistration").put("requiredServicePids", (Object)new String[]{"org.apache.jackrabbit.oak.security.authorization.AuthorizationConfigurationImpl", "org.apache.jackrabbit.oak.security.principal.PrincipalConfigurationImpl", "org.apache.jackrabbit.oak.security.authentication.token.TokenConfigurationImpl", "org.apache.jackrabbit.oak.spi.security.user.action.DefaultAuthorizableActionProvider", "org.apache.jackrabbit.oak.security.authorization.restriction.RestrictionProviderImpl", "org.apache.jackrabbit.oak.security.user.UserAuthenticationFactoryImpl", "org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.PrincipalBasedAuthorizationConfiguration"}).asOption(), ConfigurationAdminOptions.newConfiguration((String)"org.apache.jackrabbit.oak.security.user.UserConfigurationImpl").put("defaultDepth", (Object)1).put("groupsPath", (Object)"/home/groups").put("importBehavior", (Object)"besteffort").put("usersPath", (Object)"/home/users").asOption(), ConfigurationAdminOptions.newConfiguration((String)"org.apache.jackrabbit.oak.security.user.RandomAuthorizableNodeName").put("length", (Object)21).asOption(), ConfigurationAdminOptions.newConfiguration((String)"org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.FilterProviderImpl").put("path", (Object)"/home/users/system/sling").asOption(), ConfigurationAdminOptions.newConfiguration((String)"org.apache.jackrabbit.oak.spi.security.authorization.principalbased.impl.PrincipalBasedAuthorizationConfiguration").put("enableAggregationFilter", (Object)true).asOption(), ConfigurationAdminOptions.newConfiguration((String)"org.apache.jackrabbit.oak.spi.security.user.action.DefaultAuthorizableActionProvider").put("enabledActions", (Object)new String[]{"org.apache.jackrabbit.oak.spi.security.user.action.AccessControlAction"}).put("groupPrivilegeNames", (Object)new String[]{"jcr:read"}).put("userPrivilegeNames", (Object)new String[]{"jcr:all"}).asOption(), ConfigurationAdminOptions.newConfiguration((String)"org.apache.jackrabbit.vault.packaging.impl.PackagingImpl").put("authIdsForHookExecution", (Object)new String[]{"sling-installer-factory-packages"}).put("authIdsForRootInstallation", (Object)new String[]{"sling-installer-factory-packages"}).put("packageRoots", (Object)new String[]{"/var/packages"}).asOption(), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.jcr.repoinit.RepositoryInitializer").put("scripts", (Object)new String[]{"create path (sling:Folder) /apps\ncreate path (sling:Folder) /libs\ncreate path (sling:Folder) /var\ncreate path (sling:OrderedFolder) /content"}).asOption(), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.jcr.repoinit.RepositoryInitializer").put("scripts", (Object)new String[]{"create service user sling-mapping with path system/sling\n\nset principal ACL for sling-mapping\n  allow   jcr:read    on /\nend"}).asOption(), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.jcr.repoinit.RepositoryInitializer").put("scripts", (Object)new String[]{"create service user sling-readall with path system/sling\n\nset principal ACL for sling-readall\n  allow   jcr:read    on /\nend"}).asOption()});
    }

    public static ModifiableCompositeOption slingQuickstartOakTar() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.slingQuickstartOak(), CoreOptions.mavenBundle().groupId("org.apache.jackrabbit").artifactId("oak-lucene").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.jackrabbit").artifactId("oak-segment-tar").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.jackrabbit").artifactId("oak-store-document").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.jcr.oak.server").version((MavenUrlReference.VersionResolver)versionResolver), ConfigurationAdminOptions.newConfiguration((String)"org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexProviderService").put("localIndexDir", (Object)"sling/repository/index").asOption(), ConfigurationAdminOptions.newConfiguration((String)"org.apache.jackrabbit.oak.segment.SegmentNodeStoreService").put("name", (Object)"Default NodeStore").put("repository.home", (Object)"sling/repository").asOption()});
    }

    public static ModifiableCompositeOption slingQuickstartOakMongo() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.slingQuickstartOak(), CoreOptions.mavenBundle().groupId("org.apache.jackrabbit").artifactId("oak-lucene").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.jackrabbit").artifactId("oak-store-document").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("com.h2database").artifactId("h2-mvstore").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.mongodb").artifactId("mongo-java-driver").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.jcr.oak.server").version((MavenUrlReference.VersionResolver)versionResolver), ConfigurationAdminOptions.newConfiguration((String)"org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexProviderService").put("localIndexDir", (Object)"sling/repository/index").asOption(), ConfigurationAdminOptions.newConfiguration((String)"org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreService").put("db", (Object)"sling").put("mongouri", (Object)"mongodb://localhost:27017").put("repository.home", (Object)"sling/repository").asOption()});
    }

    public static ModifiableCompositeOption slingScripting() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), SlingOptions.slingCommonsCompiler(), SlingOptions.webconsole(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.scripting.api").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.scripting.spi").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.scripting.core").version((MavenUrlReference.VersionResolver)versionResolver), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.jcr.repoinit.RepositoryInitializer").put("scripts", (Object)new String[]{"create service user sling-scripting with path system/sling\n\nset principal ACL for sling-scripting\n  allow   jcr:read    on /apps\n  allow   jcr:read    on /libs\nend"}).asOption(), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl.amended").put("user.mapping", (Object)new String[]{"org.apache.sling.scripting.core=[sling-scripting]"}).asOption()});
    }

    public static ModifiableCompositeOption slingScriptingFreemarker() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), SlingOptions.slingAdapter(), SlingOptions.slingScripting(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.scripting.freemarker").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.freemarker").artifactId("freemarker").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingScriptingGroovy() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), SlingOptions.slingScripting(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.scripting.groovy").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.groovy").artifactId("groovy").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.groovy").artifactId("groovy-templates").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingScriptingJava() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), SlingOptions.slingScripting(), SlingOptions.slingCommonsCompiler(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.scripting.java").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingScriptingJavascript() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.slingScripting(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.scripting.javascript").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("javax.jcr").artifactId("jcr").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.servicemix.bundles").artifactId("org.apache.servicemix.bundles.rhino").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingScriptingJsp() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.slingScripting(), SlingOptions.slingCommonsCompiler(), SlingOptions.slingCaconfig(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.scripting.jsp").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.scripting.jsp.taglib").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.scripting.el-api").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.scripting.jsp-api").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.geronimo.bundles").artifactId("jstl").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingScriptingHtl() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), SlingOptions.slingJcr(), SlingOptions.slingScripting(), SlingOptions.slingScriptingJavascript(), SlingOptions.slingI18n(), SlingOptions.slingModels(), SlingOptions.slingXss(), SlingOptions.slingCommonsCompiler(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.scripting.sightly").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.scripting.sightly.compiler").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.scripting.sightly.compiler.java").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.scripting.sightly.js.provider").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.scripting.sightly.runtime").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.servicemix.bundles").artifactId("org.apache.servicemix.bundles.rhino").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.antlr").artifactId("antlr4-runtime").version((MavenUrlReference.VersionResolver)versionResolver), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl.amended").put("user.mapping", (Object)new String[]{"org.apache.sling.scripting.sightly.js.provider=[sling-scripting]"}).asOption()});
    }

    public static ModifiableCompositeOption slingScriptingThymeleaf() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.thymeleaf(), SlingOptions.sling(), SlingOptions.slingScripting(), SlingOptions.slingI18n(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.scripting.thymeleaf").version((MavenUrlReference.VersionResolver)versionResolver), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl.amended").put("user.mapping", (Object)new String[]{"org.apache.sling.scripting.thymeleaf=[sling-scripting]"}).asOption()});
    }

    public static ModifiableCompositeOption slingServlets() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), SlingOptions.slingScripting(), SlingOptions.slingXss(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.servlets.get").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.servlets.post").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.servlets.resolver").version((MavenUrlReference.VersionResolver)versionResolver), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.jcr.base.internal.LoginAdminWhitelist.fragment").put("whitelist.bundles", (Object)new String[]{"org.apache.sling.servlets.post"}).put("whitelist.name", (Object)"sling-servlets").asOption(), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl.amended").put("user.mapping", (Object)new String[]{"org.apache.sling.servlets.resolver:console=[sling-readall]", "org.apache.sling.servlets.resolver:scripts=[sling-scripting]"}).asOption()});
    }

    public static ModifiableCompositeOption slingStarterContent() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), SlingOptions.slingAuthForm(), SlingOptions.slingScriptingJavascript(), SlingOptions.composumNodes(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.starter.content").version((MavenUrlReference.VersionResolver)versionResolver), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.jcr.repoinit.RepositoryInitializer").put("scripts", (Object)new String[]{"create path (sling:OrderedFolder) /content/starter\n\nset ACL for everyone\n  allow     jcr:read    on /content/starter\nend"}).asOption()});
    }

    public static ModifiableCompositeOption felixHealthcheck() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.eventadmin(), SlingOptions.scr(), SlingOptions.webconsole(), CoreOptions.mavenBundle().groupId("org.apache.felix").artifactId("org.apache.felix.healthcheck.api").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.felix").artifactId("org.apache.felix.healthcheck.core").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.felix").artifactId("org.apache.felix.healthcheck.generalchecks").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.felix").artifactId("org.apache.felix.healthcheck.webconsoleplugin").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.commons").artifactId("commons-lang3").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption httpcomponentsClient() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.config(), CoreOptions.mavenBundle().groupId("org.apache.httpcomponents").artifactId("httpclient-osgi").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.httpcomponents").artifactId("httpcore-osgi").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption jackrabbit() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.httpcomponentsClient(), CoreOptions.mavenBundle().groupId("org.apache.jackrabbit").artifactId("oak-jackrabbit-api").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.jackrabbit").artifactId("jackrabbit-data").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.jackrabbit").artifactId("jackrabbit-jcr-commons").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.jackrabbit").artifactId("jackrabbit-jcr-rmi").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.jackrabbit").artifactId("jackrabbit-spi").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.jackrabbit").artifactId("jackrabbit-spi-commons").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.jackrabbit").artifactId("jackrabbit-webdav").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("javax.jcr").artifactId("jcr").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("javax.servlet").artifactId("javax.servlet-api").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("commons-codec").artifactId("commons-codec").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("commons-fileupload").artifactId("commons-fileupload").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("commons-io").artifactId("commons-io").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("commons-lang").artifactId("commons-lang").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.commons").artifactId("commons-collections4").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.geronimo.specs").artifactId("geronimo-atinject_1.0_spec").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.geronimo.specs").artifactId("geronimo-el_2.2_spec").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.geronimo.specs").artifactId("geronimo-interceptor_1.1_spec").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.geronimo.specs").artifactId("geronimo-jcdi_1.0_spec").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.geronimo.specs").artifactId("geronimo-jta_1.1_spec").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption jackrabbitOak() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.scr(), SlingOptions.slingCommonsMetrics(), SlingOptions.slingCommonsThreads(), SlingOptions.jackrabbit(), SlingOptions.tika(), CoreOptions.mavenBundle().groupId("org.apache.jackrabbit").artifactId("oak-api").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.jackrabbit").artifactId("oak-authorization-principalbased").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.jackrabbit").artifactId("oak-blob").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.jackrabbit").artifactId("oak-blob-plugins").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.jackrabbit").artifactId("oak-commons").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.jackrabbit").artifactId("oak-core").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.jackrabbit").artifactId("oak-core-spi").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.jackrabbit").artifactId("oak-jcr").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.jackrabbit").artifactId("oak-query-spi").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.jackrabbit").artifactId("oak-security-spi").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.jackrabbit").artifactId("oak-store-composite").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.jackrabbit").artifactId("oak-store-spi").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("com.google.guava").artifactId("guava").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.felix").artifactId("org.apache.felix.jaas").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption jackrabbitVault() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.scr(), SlingOptions.jackrabbit(), CoreOptions.mavenBundle().groupId("org.apache.jackrabbit.vault").artifactId("org.apache.jackrabbit.vault").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("commons-collections").artifactId("commons-collections").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption tika() {
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.mavenBundle().groupId("org.apache.tika").artifactId("tika-core").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.tika").artifactId("tika-parsers").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.pdfbox").artifactId("pdfbox").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.pdfbox").artifactId("fontbox").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.pdfbox").artifactId("jempbox").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption composumNodes() {
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.sling(), SlingOptions.slingI18n(), SlingOptions.slingJcr(), SlingOptions.slingScriptingJsp(), SlingOptions.slingServlets(), SlingOptions.slingEvent(), SlingOptions.jackrabbitVault(), CoreOptions.mavenBundle().groupId("com.composum.nodes").artifactId("composum-nodes-commons").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("com.composum.nodes").artifactId("composum-nodes-console").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("com.composum.nodes").artifactId("composum-nodes-jslibs").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("com.composum.nodes").artifactId("composum-nodes-pckgmgr").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("com.composum.nodes").artifactId("composum-nodes-usermgr").version((MavenUrlReference.VersionResolver)versionResolver), ConfigurationAdminOptions.factoryConfiguration((String)"org.apache.sling.jcr.base.internal.LoginAdminWhitelist.fragment").put("whitelist.bundles", (Object)new String[]{"com.composum.nodes.commons", "com.composum.nodes.pckgmgr", "com.composum.nodes.usermgr"}).put("whitelist.name", (Object)"composum-nodes").asOption()});
    }

    public static ModifiableCompositeOption thymeleaf() {
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.mavenBundle().groupId("org.apache.servicemix.bundles").artifactId("org.apache.servicemix.bundles.thymeleaf").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.attoparser").artifactId("attoparser").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.unbescape").artifactId("unbescape").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.servicemix.bundles").artifactId("org.apache.servicemix.bundles.ognl").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.javassist").artifactId("javassist").version((MavenUrlReference.VersionResolver)versionResolver)});
    }

    public static ModifiableCompositeOption slingQuickstartOakTar(String workingDirectory, int httpPort) {
        String slingHome = String.format("%s/sling", workingDirectory);
        String repositoryHome = String.format("%s/repository", slingHome);
        String localIndexDir = String.format("%s/index", repositoryHome);
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.slingQuickstartOak(), CoreOptions.mavenBundle().groupId("org.apache.jackrabbit").artifactId("oak-lucene").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.jackrabbit").artifactId("oak-segment-tar").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.jackrabbit").artifactId("oak-store-document").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.jcr.oak.server").version((MavenUrlReference.VersionResolver)versionResolver), ConfigurationAdminOptions.newConfiguration((String)"org.apache.felix.http").put("org.osgi.service.http.port", (Object)httpPort).asOption(), ConfigurationAdminOptions.newConfiguration((String)"org.apache.jackrabbit.oak.segment.SegmentNodeStoreService").put("repository.home", (Object)repositoryHome).put("name", (Object)"Default NodeStore").asOption(), ConfigurationAdminOptions.newConfiguration((String)"org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexProviderService").put("localIndexDir", (Object)localIndexDir).asOption()});
    }

    public static ModifiableCompositeOption slingQuickstartOakMongo(String workingDirectory, int httpPort, String mongouri) {
        String slingHome = String.format("%s/sling", workingDirectory);
        String repositoryHome = String.format("%s/repository", slingHome);
        String localIndexDir = String.format("%s/index", repositoryHome);
        return CoreOptions.composite((Option[])new Option[]{SlingOptions.slingQuickstartOak(), CoreOptions.mavenBundle().groupId("org.apache.jackrabbit").artifactId("oak-lucene").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.jackrabbit").artifactId("oak-store-document").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.mongodb").artifactId("mongo-java-driver").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("com.h2database").artifactId("h2-mvstore").version((MavenUrlReference.VersionResolver)versionResolver), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.jcr.oak.server").version((MavenUrlReference.VersionResolver)versionResolver), ConfigurationAdminOptions.newConfiguration((String)"org.apache.felix.http").put("org.osgi.service.http.port", (Object)httpPort).asOption(), ConfigurationAdminOptions.newConfiguration((String)"org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexProviderService").put("localIndexDir", (Object)localIndexDir).asOption(), ConfigurationAdminOptions.newConfiguration((String)"org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreService").put("db", (Object)"sling").put("mongouri", (Object)mongouri).asOption()});
    }
}

