/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.paxexam;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.util.Dictionary;
import java.util.Objects;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.sling.testing.paxexam.SlingOptions;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.options.MavenUrlReference;
import org.ops4j.pax.exam.options.ModifiableCompositeOption;
import org.ops4j.pax.exam.options.OptionalCompositeOption;
import org.ops4j.pax.exam.options.SystemPropertyOption;
import org.ops4j.pax.exam.options.UrlProvisionOption;
import org.ops4j.pax.exam.options.extra.VMOption;
import org.ops4j.pax.exam.util.PathUtils;
import org.ops4j.pax.tinybundles.core.BuildStrategy;
import org.ops4j.pax.tinybundles.core.TinyBundle;
import org.ops4j.pax.tinybundles.core.TinyBundles;
import org.osgi.service.cm.ConfigurationAdmin;

public abstract class TestSupport {
    private static final String WORKING_DIRECTORY_PROPERTY_KEY = "sling.testing.paxexam.workingDirectory";
    @Inject
    protected ConfigurationAdmin configurationAdmin;
    private final String workingDirectory = String.format("%s/target/paxexam/%s/%s", PathUtils.getBaseDir(), this.getClass().getSimpleName(), UUID.randomUUID());

    protected String workingDirectory() {
        return this.workingDirectory;
    }

    protected int httpPort() throws IOException {
        Dictionary properties = this.configurationAdmin.getConfiguration("org.apache.felix.http").getProperties();
        return Integer.parseInt(properties.get("org.osgi.service.http.port").toString());
    }

    protected OptionalCompositeOption jacoco() {
        String jacocoCommand = System.getProperty("jacoco.it.command");
        VMOption option = Objects.nonNull(jacocoCommand) && !jacocoCommand.trim().isBlank() ? CoreOptions.vmOption((String)jacocoCommand) : null;
        return CoreOptions.when((boolean)Objects.nonNull(option)).useOptions(new Option[]{option});
    }

    protected ModifiableCompositeOption commonConfiguration() {
        return CoreOptions.composite((Option[])new Option[]{TestSupport.failOnUnresolvedBundles(), CoreOptions.keepCaches(), TestSupport.localMavenRepo(), CoreOptions.repository((String)"https://repository.apache.org/snapshots/").id("apache-snapshots").allowSnapshots(), CoreOptions.systemProperty((String)WORKING_DIRECTORY_PROPERTY_KEY).value(this.workingDirectory()), CoreOptions.workingDirectory((String)this.workingDirectory()), SlingOptions.paxTinybundles(), SlingOptions.backing(), SlingOptions.spifly(), this.jacoco()});
    }

    protected ModifiableCompositeOption baseConfiguration() {
        return CoreOptions.composite((Option[])new Option[]{this.commonConfiguration(), CoreOptions.mavenBundle().groupId("org.apache.sling").artifactId("org.apache.sling.testing.paxexam").versionAsInProject(), CoreOptions.mavenBundle().groupId("org.apache.servicemix.bundles").artifactId("org.apache.servicemix.bundles.hamcrest").version((MavenUrlReference.VersionResolver)SlingOptions.versionResolver), CoreOptions.junitBundles()});
    }

    protected ModifiableCompositeOption serverBaseConfiguration() {
        return this.commonConfiguration();
    }

    public static int findFreePort() {
        int n;
        ServerSocket serverSocket = new ServerSocket(0);
        try {
            n = serverSocket.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    serverSocket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        serverSocket.close();
        return n;
    }

    public static SystemPropertyOption failOnUnresolvedBundles() {
        return CoreOptions.systemProperty((String)"pax.exam.osgi.unresolved.fail").value("true");
    }

    public static OptionalCompositeOption localMavenRepo() {
        String localRepository = System.getProperty("maven.repo.local", "");
        return CoreOptions.when((!localRepository.isBlank() ? 1 : 0) != 0).useOptions(new Option[]{CoreOptions.systemProperty((String)"org.ops4j.pax.url.mvn.localRepository").value(localRepository)});
    }

    public static UrlProvisionOption testBundle(String systemProperty) {
        String pathname = System.getProperty(systemProperty);
        File file = new File(pathname);
        return CoreOptions.bundle((String)file.toURI().toString());
    }

    public static UrlProvisionOption buildBundleWithBnd(Class ... classes) {
        TinyBundle bundle = TinyBundles.bundle();
        for (Class clazz : classes) {
            bundle.add(clazz);
        }
        return (UrlProvisionOption)CoreOptions.streamBundle((InputStream)bundle.build((BuildStrategy)TinyBundles.withBnd())).start();
    }
}

