/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.ServiceInterface1;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.ServiceInterface1Optional;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.ServiceInterface2;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.ServiceInterface3;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.ServiceSuperInterface3;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.FieldOption;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(reference={@Reference(name="reference2", service=ServiceInterface2.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, bind="bindReference2", unbind="unbindReference2")})
public class Service3 {
    @Reference(bind="bindReference1", unbind="unbindReference1", policy=ReferencePolicy.DYNAMIC)
    private volatile ServiceInterface1 reference1;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, bind="bindReference1Optional", unbind="unbindReference1Optional")
    private volatile ServiceInterface1Optional reference1Optional;
    private List<ServiceReference<ServiceInterface2>> references2 = new ArrayList<ServiceReference<ServiceInterface2>>();
    @Reference(name="reference3", service=ServiceInterface3.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, bind="bindReference3", unbind="unbindReference3")
    private volatile List<ServiceSuperInterface3> references3 = new ArrayList<ServiceSuperInterface3>();
    private List<Map<String, Object>> reference3Configs = new ArrayList<Map<String, Object>>();
    @Reference(name="references3Set", service=ServiceInterface3.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, fieldOption=FieldOption.UPDATE)
    private volatile Set<ServiceSuperInterface3> references3Set = new HashSet<ServiceSuperInterface3>();
    private ComponentContext componentContext;
    private Map<String, Object> config;

    @Activate
    private void activate(ComponentContext ctx) {
        this.componentContext = ctx;
        this.config = new HashMap<String, Object>();
        Enumeration keys = ctx.getProperties().keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.config.put(key, ctx.getProperties().get(key));
        }
    }

    @Deactivate
    private void deactivate(ComponentContext ctx) {
        this.componentContext = null;
    }

    @Modified
    private void modified(Map<String, Object> newConfig) {
        this.config = newConfig;
    }

    public ServiceInterface1 getReference1() {
        return this.reference1;
    }

    public ServiceInterface1Optional getReference1Optional() {
        return this.reference1Optional;
    }

    public List<ServiceInterface2> getReferences2() {
        ArrayList<ServiceInterface2> services = new ArrayList<ServiceInterface2>();
        for (ServiceReference<ServiceInterface2> serviceReference : this.references2) {
            services.add((ServiceInterface2)this.componentContext.getBundleContext().getService(serviceReference));
        }
        return services;
    }

    public List<ServiceSuperInterface3> getReferences3() {
        return this.references3;
    }

    public List<Map<String, Object>> getReference3Configs() {
        return this.reference3Configs;
    }

    public Set<ServiceSuperInterface3> getReferences3Set() {
        return this.references3Set;
    }

    public ComponentContext getComponentContext() {
        return this.componentContext;
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    void bindReference1Optional(ServiceInterface1Optional service) {
        this.reference1Optional = service;
    }

    void unbindReference1Optional(ServiceInterface1Optional service) {
        this.reference1Optional = null;
    }

    void bindReference1(ServiceInterface1 service) {
        this.reference1 = service;
    }

    void unbindReference1(ServiceInterface1 service) {
        this.reference1 = null;
    }

    void bindReference2(ServiceReference<ServiceInterface2> serviceReference) {
        this.references2.add(serviceReference);
    }

    void unbindReference2(ServiceReference<ServiceInterface2> serviceReference) {
        this.references2.remove(serviceReference);
    }

    void bindReference3(ServiceSuperInterface3 service, Map<String, Object> serviceConfig) {
        this.references3.add(service);
        this.reference3Configs.add(serviceConfig);
    }

    void unbindReference3(ServiceSuperInterface3 service, Map<String, Object> serviceConfig) {
        this.references3.remove(service);
        this.reference3Configs.remove(serviceConfig);
    }

    void bindReference3Set(ServiceSuperInterface3 service, Map<String, Object> serviceConfig) {
        this.references3Set.add(service);
    }

    void unbindReference3Set(ServiceSuperInterface3 service, Map<String, Object> serviceConfig) {
        this.references3Set.remove(service);
    }
}

