/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi.config;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Executable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.sling.testing.mock.osgi.config.ConfigAnnotationUtil;
import org.apache.sling.testing.mock.osgi.config.annotations.AutoConfig;
import org.apache.sling.testing.mock.osgi.config.annotations.ConfigCollection;
import org.apache.sling.testing.mock.osgi.config.annotations.ConfigType;
import org.apache.sling.testing.mock.osgi.config.annotations.ConfigTypes;
import org.apache.sling.testing.mock.osgi.config.annotations.SetConfig;
import org.apache.sling.testing.mock.osgi.config.annotations.SetConfigs;
import org.apache.sling.testing.mock.osgi.config.annotations.TypedConfig;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.quality.Strictness;
import org.osgi.service.component.propertytypes.ServiceRanking;
import org.osgi.service.component.propertytypes.ServiceVendor;

public class ConfigAnnotationUtilTest {
    @Test
    public void findAnnotationsFromAnnotatedElement() {
        List annotations = ConfigAnnotationUtil.findConfigTypeAnnotations(Configured.class).collect(Collectors.toList());
        Assert.assertEquals((long)4L, (long)annotations.size());
        Assert.assertTrue((boolean)(annotations.get(0) instanceof ConfigType));
        Assert.assertSame(ServiceRanking.class, (Object)((ConfigType)annotations.get(0)).type());
        Assert.assertTrue((boolean)(annotations.get(1) instanceof RuntimeRetained));
        Assert.assertEquals((Object)"expected", (Object)((RuntimeRetained)annotations.get(1)).property());
        Assert.assertTrue((boolean)(annotations.get(2) instanceof ConfigType));
        Assert.assertSame(ServiceRanking.class, (Object)((ConfigType)annotations.get(2)).type());
        Assert.assertTrue((boolean)(annotations.get(3) instanceof ConfigType));
        Assert.assertSame(ServiceVendor.class, (Object)((ConfigType)annotations.get(3)).type());
    }

    @Test
    public void findAnnotationsFromCollection() {
        List<Annotation> allAnnotations = Arrays.asList(Configured.class.getAnnotations());
        List annotations = ConfigAnnotationUtil.findConfigTypeAnnotations(allAnnotations).collect(Collectors.toList());
        Assert.assertEquals((long)4L, (long)annotations.size());
        Assert.assertTrue((boolean)(annotations.get(0) instanceof ConfigType));
        Assert.assertSame(ServiceRanking.class, (Object)((ConfigType)annotations.get(0)).type());
        Assert.assertTrue((boolean)(annotations.get(1) instanceof RuntimeRetained));
        Assert.assertEquals((Object)"expected", (Object)((RuntimeRetained)annotations.get(1)).property());
        Assert.assertTrue((boolean)(annotations.get(2) instanceof ConfigType));
        Assert.assertSame(ServiceRanking.class, (Object)((ConfigType)annotations.get(2)).type());
        Assert.assertTrue((boolean)(annotations.get(3) instanceof ConfigType));
        Assert.assertSame(ServiceVendor.class, (Object)((ConfigType)annotations.get(3)).type());
    }

    @Test
    public void findUpdateConfigsFromAnnotatedElement() {
        List annotations = ConfigAnnotationUtil.findUpdateConfigAnnotations(Configured.class).collect(Collectors.toList());
        Assert.assertEquals((long)3L, (long)annotations.size());
        Assert.assertEquals((Object)"first", (Object)((SetConfig)annotations.get(0)).pid());
        Assert.assertEquals((Object)"second", (Object)((SetConfig)annotations.get(1)).pid());
        Assert.assertEquals((Object)"third", (Object)((SetConfig)annotations.get(2)).pid());
    }

    @Test
    public void findUpdateConfigsFromCollection() {
        List<Annotation> allAnnotations = Arrays.asList(Configured.class.getAnnotations());
        List annotations = ConfigAnnotationUtil.findUpdateConfigAnnotations(allAnnotations).collect(Collectors.toList());
        Assert.assertEquals((long)3L, (long)annotations.size());
        Assert.assertEquals((Object)"first", (Object)((SetConfig)annotations.get(0)).pid());
        Assert.assertEquals((Object)"second", (Object)((SetConfig)annotations.get(1)).pid());
        Assert.assertEquals((Object)"third", (Object)((SetConfig)annotations.get(2)).pid());
    }

    @Test
    public void determineSupportedConfigType() {
        Assert.assertFalse((boolean)ConfigAnnotationUtil.determineSupportedConfigType(Configured.class).isPresent());
        Assert.assertFalse((boolean)ConfigAnnotationUtil.determineSupportedConfigType(AnEnum.class).isPresent());
        Assert.assertFalse((boolean)ConfigAnnotationUtil.determineSupportedConfigType(AnAbstractClass.class).isPresent());
        Assert.assertFalse((boolean)ConfigAnnotationUtil.determineSupportedConfigType(Configured[].class).isPresent());
        Assert.assertFalse((boolean)ConfigAnnotationUtil.determineSupportedConfigType(AnEnum[].class).isPresent());
        Assert.assertFalse((boolean)ConfigAnnotationUtil.determineSupportedConfigType(AnAbstractClass[].class).isPresent());
        Assert.assertSame(AnInterface.class, ConfigAnnotationUtil.determineSupportedConfigType(AnInterface.class).orElseThrow());
        Assert.assertSame(AnInterface.class, ConfigAnnotationUtil.determineSupportedConfigType(AnInterface[].class).orElseThrow());
        Assert.assertSame(AnAnnotation.class, ConfigAnnotationUtil.determineSupportedConfigType(AnAnnotation.class).orElseThrow());
        Assert.assertSame(AnAnnotation.class, ConfigAnnotationUtil.determineSupportedConfigType(AnAnnotation[].class).orElseThrow());
    }

    ParameterType1 newMockType1Value(@NotNull String value) {
        ParameterType1 mocked = (ParameterType1)Mockito.mock(ParameterType1.class, (MockSettings)Mockito.withSettings().strictness(Strictness.LENIENT));
        ((ParameterType1)Mockito.doReturn((Object)value).when((Object)mocked)).value();
        return mocked;
    }

    TypedConfig<ParameterType1> newMockTypedConfig1(@NotNull String value) {
        ParameterType1 mockedConfig = this.newMockType1Value(value);
        TypedConfig mocked = (TypedConfig)Mockito.mock(TypedConfig.class, (MockSettings)Mockito.withSettings().strictness(Strictness.LENIENT));
        ((TypedConfig)Mockito.doReturn((Object)mockedConfig).when((Object)mocked)).getConfig();
        ((TypedConfig)Mockito.doAnswer(call -> Map.of("parameter.type1", value)).when((Object)mocked)).getConfigMap();
        return mocked;
    }

    @Test
    public void resolveParameterToArray() {
        List<ParameterType1> type1Values = List.of(this.newMockType1Value("one"), this.newMockType1Value("two"), this.newMockType1Value("three"));
        ConfigCollection configCollection = (ConfigCollection)Mockito.mock(ConfigCollection.class);
        ((ConfigCollection)Mockito.doAnswer(call -> type1Values.stream()).when((Object)configCollection)).configStream(ParameterType1.class);
        Assert.assertArrayEquals((Object[])type1Values.toArray(new ParameterType1[0]), (Object[])ConfigAnnotationUtil.resolveParameterToArray((ConfigCollection)configCollection, ParameterType1.class));
    }

    @Test
    public void resolveFirstParameter() {
        List<ParameterType1> type1Values = List.of(this.newMockType1Value("one"), this.newMockType1Value("two"), this.newMockType1Value("three"));
        ConfigCollection configCollection = (ConfigCollection)Mockito.mock(ConfigCollection.class);
        ((ConfigCollection)Mockito.doAnswer(call -> type1Values.stream()).when((Object)configCollection)).configStream(ParameterType1.class);
        ((ConfigCollection)Mockito.doCallRealMethod().when((Object)configCollection)).firstConfig((Class)ArgumentMatchers.any(Class.class));
        Assert.assertEquals((Object)type1Values.get(0), (Object)configCollection.firstConfig(ParameterType1.class));
    }

    @Test(expected=NoSuchElementException.class)
    public void resolveFirstParameterAbsent() {
        List<ParameterType1> type1Values = List.of(this.newMockType1Value("one"), this.newMockType1Value("two"), this.newMockType1Value("three"));
        ConfigCollection configCollection = (ConfigCollection)Mockito.mock(ConfigCollection.class);
        ((ConfigCollection)Mockito.doAnswer(call -> type1Values.stream()).when((Object)configCollection)).configStream(ParameterType1.class);
        ((ConfigCollection)Mockito.doCallRealMethod().when((Object)configCollection)).firstConfig((Class)ArgumentMatchers.any(Class.class));
        configCollection.firstConfig(ParameterType2.class);
    }

    @Test
    public void resolveParameterToValueOrConfigMap() throws Exception {
        List<TypedConfig<ParameterType1>> type1Values = List.of(this.newMockTypedConfig1("one"), this.newMockTypedConfig1("two"), this.newMockTypedConfig1("three"));
        ConfigCollection configCollection = (ConfigCollection)Mockito.mock(ConfigCollection.class);
        ((ConfigCollection)Mockito.doAnswer(call -> type1Values.stream()).when((Object)configCollection)).stream(ParameterType1.class);
        Executable executable = ExecutableClass.getExecutable();
        Assert.assertNull(ConfigAnnotationUtil.resolveParameterToValue((ConfigCollection)configCollection, ParameterType1.class, (Class[])executable.getParameterTypes(), (int)-1).orElse(null));
        Assert.assertEquals((Object)"one", (Object)((ParameterType1)ConfigAnnotationUtil.resolveParameterToValue((ConfigCollection)configCollection, ParameterType1.class, (Class[])executable.getParameterTypes(), (int)0).orElseThrow()).value());
        Assert.assertEquals(Map.of("parameter.type1", "one"), ConfigAnnotationUtil.resolveParameterToConfigMap((ConfigCollection)configCollection, ParameterType1.class, (Class[])executable.getParameterTypes(), (int)0).orElseThrow());
        Assert.assertNull(ConfigAnnotationUtil.resolveParameterToValue((ConfigCollection)configCollection, ParameterType1.class, (Class[])executable.getParameterTypes(), (int)1).orElse(null));
        Assert.assertNull(ConfigAnnotationUtil.resolveParameterToConfigMap((ConfigCollection)configCollection, ParameterType1.class, (Class[])executable.getParameterTypes(), (int)1).orElse(null));
        Assert.assertNull(ConfigAnnotationUtil.resolveParameterToValue((ConfigCollection)configCollection, ParameterType1.class, (Class[])executable.getParameterTypes(), (int)2).orElse(null));
        Assert.assertNull(ConfigAnnotationUtil.resolveParameterToConfigMap((ConfigCollection)configCollection, ParameterType1.class, (Class[])executable.getParameterTypes(), (int)2).orElse(null));
        Assert.assertEquals((Object)"two", (Object)((ParameterType1)ConfigAnnotationUtil.resolveParameterToValue((ConfigCollection)configCollection, ParameterType1.class, (Class[])executable.getParameterTypes(), (int)3).orElseThrow()).value());
        Assert.assertEquals(Map.of("parameter.type1", "two"), ConfigAnnotationUtil.resolveParameterToConfigMap((ConfigCollection)configCollection, ParameterType1.class, (Class[])executable.getParameterTypes(), (int)3).orElseThrow());
        Assert.assertEquals((Object)"three", (Object)((ParameterType1)ConfigAnnotationUtil.resolveParameterToValue((ConfigCollection)configCollection, ParameterType1.class, (Class[])executable.getParameterTypes(), (int)4).orElseThrow()).value());
        Assert.assertEquals(Map.of("parameter.type1", "three"), ConfigAnnotationUtil.resolveParameterToConfigMap((ConfigCollection)configCollection, ParameterType1.class, (Class[])executable.getParameterTypes(), (int)4).orElseThrow());
        Assert.assertNull(ConfigAnnotationUtil.resolveParameterToValue((ConfigCollection)configCollection, ParameterType1.class, (Class[])executable.getParameterTypes(), (int)executable.getParameterTypes().length).orElse(null));
        Assert.assertNull(ConfigAnnotationUtil.resolveParameterToConfigMap((ConfigCollection)configCollection, ParameterType1.class, (Class[])executable.getParameterTypes(), (int)executable.getParameterTypes().length).orElse(null));
        Assert.assertNull(ConfigAnnotationUtil.resolveParameterToValue((ConfigCollection)configCollection, ParameterType1.class, (Class[])executable.getParameterTypes(), (int)(executable.getParameterTypes().length + 1)).orElse(null));
        Assert.assertNull(ConfigAnnotationUtil.resolveParameterToConfigMap((ConfigCollection)configCollection, ParameterType1.class, (Class[])executable.getParameterTypes(), (int)(executable.getParameterTypes().length + 1)).orElse(null));
    }

    @Test
    public void testIsValidConfigType() {
        Assert.assertFalse((boolean)ConfigAnnotationUtil.isValidConfigType(AnAbstractClass.class));
        Assert.assertFalse((boolean)ConfigAnnotationUtil.isValidConfigType(AnEnum.class));
        Assert.assertTrue((boolean)ConfigAnnotationUtil.isValidConfigType(AnAnnotation.class));
        Assert.assertTrue((boolean)ConfigAnnotationUtil.isValidConfigType(AnInterface.class));
    }

    @Test
    public void testConfigTypeAnnotationFilter() {
        RuntimeRetained cpt = Configured.class.getAnnotation(RuntimeRetained.class);
        Assert.assertTrue((boolean)ConfigAnnotationUtil.configTypeAnnotationFilter((parent, configType) -> parent.isEmpty() && configType.equals(cpt.annotationType())).test(cpt));
        ConfigType cta = Configured.class.getAnnotation(ConfigType.class);
        Assert.assertFalse((boolean)ConfigAnnotationUtil.configTypeAnnotationFilter((parent, configType) -> parent.isEmpty()).test(cta));
        InvalidCpt invalidCpt = Configured.class.getAnnotation(InvalidCpt.class);
        Assert.assertFalse((boolean)ConfigAnnotationUtil.configTypeAnnotationFilter((parent, configType) -> parent.isEmpty()).test(invalidCpt));
        AutoConfig aca = AutoConfigured.class.getAnnotation(AutoConfig.class);
        Assert.assertFalse((boolean)ConfigAnnotationUtil.configTypeAnnotationFilter((parent, configType) -> parent.isEmpty()).test(aca));
    }

    @AutoConfig(value=Void.class)
    public static class AutoConfigured {
    }

    public static class ExecutableClass {
        public static void execute(ParameterType1 param0, ParameterType1[] param1, ParameterType2 param2, ParameterType1 param3, ParameterType1 param4) {
        }

        public static Executable getExecutable() throws NoSuchMethodException {
            return ExecutableClass.class.getMethod("execute", ParameterType1.class, ParameterType1[].class, ParameterType2.class, ParameterType1.class, ParameterType1.class);
        }
    }

    public static @interface ParameterType2 {
        public String value();
    }

    public static @interface ParameterType1 {
        public String value();
    }

    public static @interface AnAnnotation {
    }

    public static interface AnInterface {
    }

    public static abstract class AnAbstractClass {
    }

    public static enum AnEnum {
        YES,
        NO;

    }

    @SetConfig(pid="first")
    @ConfigType(type=ServiceRanking.class)
    @RuntimeRetained(property="expected")
    @InvalidCpt
    @SetConfigs(value={@SetConfig(pid="second"), @SetConfig(pid="third")})
    @ConfigTypes(value={@ConfigType(type=ServiceRanking.class), @ConfigType(type=ServiceVendor.class), @ConfigType(type=ConfigType.class), @ConfigType(type=ConfigTypes.class)})
    public static class Configured {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface InvalidCpt {
        public RuntimeRetained nestedAnnotation() default @RuntimeRetained(property="defaultDefaultdEfAuLt");
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface RuntimeRetained {
        public String property() default "default";
    }
}

