/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi.config;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.sling.testing.mock.osgi.config.ComponentPropertyParser;
import org.apache.sling.testing.mock.osgi.config.ConfigAnnotationUtilTest;
import org.apache.sling.testing.mock.osgi.config.ConfigTypeStrictnessViolation;
import org.apache.sling.testing.mock.osgi.config.SingleElementAnnotationReflectionProvider;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.service.component.propertytypes.ServiceRanking;
import org.osgi.service.component.propertytypes.ServiceVendor;

public class ComponentPropertyParserTest {
    @Test
    public void testPutSingleOrMany() {
        Map<List<String>, ValueCardinality> expectations = Map.of(List.of(), ValueCardinality.ABSENT, List.of("one"), ValueCardinality.ONE, List.of("2"), ValueCardinality.ONE, List.of("one", "2"), ValueCardinality.MANY);
        for (Map.Entry<List<String>, ValueCardinality> entry : expectations.entrySet()) {
            HashMap properties = new HashMap();
            ComponentPropertyParser.putSingleOrMany(properties, (String)"test", entry.getKey(), Function.identity(), String[]::new);
            switch (entry.getValue()) {
                case ONE: {
                    Assert.assertEquals((Object)entry.getKey().get(0), properties.get("test"));
                    break;
                }
                case MANY: {
                    Assert.assertArrayEquals((Object[])entry.getKey().toArray(new String[0]), (Object[])((String[])properties.get("test")));
                    break;
                }
                case ABSENT: {
                    Assert.assertNull(properties.get("test"));
                }
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnescapeUnsupported() {
        ComponentPropertyParser.unescape((String)"unsupported");
    }

    @Test
    public void testIdentifierToPropertyName() {
        String[] prefixes;
        Map<String, String> expectations = Map.of("prop__name", "prop_name", "prop_name", "prop.name", "prop$_$name", "prop-name", "prop$$name", "prop$name", "prop$name", "propname", "propName", "propName", "two_period_name", "two.period.name");
        for (String prefix : prefixes = new String[]{null, "", "prefix-"}) {
            for (Map.Entry<String, String> entry : expectations.entrySet()) {
                String expected = entry.getValue();
                Assert.assertEquals((Object)Optional.ofNullable(prefix).map(pfx -> pfx.concat(expected)).orElse(expected), (Object)ComponentPropertyParser.identifierToPropertyName((String)entry.getKey(), (String)prefix));
            }
        }
    }

    @Test
    public void testSingleElementAnnotationKey() {
        String[] prefixes;
        Map<String, String> expectations = Map.of(ServiceRanking.class.getSimpleName(), "service.ranking", ServiceVendor.class.getSimpleName(), "service.vendor", InnerAnnotation.class.getSimpleName(), "inner.annotation", "$SomehowStartsWithDollar", "$somehow.starts.with.dollar", "simpler", "simpler", "endsWith$", "");
        for (String prefix : prefixes = new String[]{null, "", "prefix-"}) {
            for (Map.Entry<String, String> entry : expectations.entrySet()) {
                String expected = entry.getValue();
                Assert.assertEquals((Object)Optional.ofNullable(prefix).map(pfx -> pfx.concat(expected)).orElse(expected), (Object)ComponentPropertyParser.singleElementAnnotationKey((String)entry.getKey(), (String)prefix));
            }
        }
    }

    public Object[] toObjectArray(boolean[] array) {
        Object[] boxes = new Object[array.length];
        for (int i = 0; i < array.length; ++i) {
            boxes[i] = array[i];
        }
        return boxes;
    }

    public Object[] toObjectArray(byte[] array) {
        Object[] boxes = new Object[array.length];
        for (int i = 0; i < array.length; ++i) {
            boxes[i] = array[i];
        }
        return boxes;
    }

    public Object[] toObjectArray(char[] array) {
        Object[] boxes = new Object[array.length];
        for (int i = 0; i < array.length; ++i) {
            boxes[i] = Character.valueOf(array[i]);
        }
        return boxes;
    }

    public Object[] toObjectArray(short[] array) {
        Object[] boxes = new Object[array.length];
        for (int i = 0; i < array.length; ++i) {
            boxes[i] = array[i];
        }
        return boxes;
    }

    public Object[] toObjectArray(int[] array) {
        return Arrays.stream(array).boxed().toArray(Object[]::new);
    }

    public Object[] toObjectArray(long[] array) {
        return Arrays.stream(array).boxed().toArray(Object[]::new);
    }

    public Object[] toObjectArray(float[] array) {
        Object[] boxes = new Object[array.length];
        for (int i = 0; i < array.length; ++i) {
            boxes[i] = Float.valueOf(array[i]);
        }
        return boxes;
    }

    public Object[] toObjectArray(double[] array) {
        return Arrays.stream(array).boxed().toArray(Object[]::new);
    }

    public Object[] toObjectArray(Object[] array) {
        return array;
    }

    public Object[] toObjectArray(@NotNull Object array) {
        if (array instanceof boolean[]) {
            return this.toObjectArray((boolean[])array);
        }
        if (array instanceof byte[]) {
            return this.toObjectArray((byte[])array);
        }
        if (array instanceof char[]) {
            return this.toObjectArray((char[])array);
        }
        if (array instanceof short[]) {
            return this.toObjectArray((short[])array);
        }
        if (array instanceof int[]) {
            return this.toObjectArray((int[])array);
        }
        if (array instanceof long[]) {
            return this.toObjectArray((long[])array);
        }
        if (array instanceof float[]) {
            return this.toObjectArray((float[])array);
        }
        if (array instanceof double[]) {
            return this.toObjectArray((double[])array);
        }
        if (array instanceof Object[]) {
            return this.toObjectArray((Object[])array);
        }
        return new Object[]{array};
    }

    public void assertMapDeepEquals(Map<String, Object> expected, Map<String, Object> actual) {
        Assert.assertEquals(expected.keySet(), actual.keySet());
        for (String key : expected.keySet()) {
            Object value = expected.get(key);
            if (value.getClass().isArray()) {
                Assert.assertArrayEquals((Object[])this.toObjectArray(value), (Object[])this.toObjectArray(actual.get(key)));
                continue;
            }
            Assert.assertEquals((Object)value, (Object)actual.get(key));
        }
    }

    /*
     * Exception decompiling
     */
    public void assertGetAnnotationDefaultsExpectations(@NotNull Map<Class<? extends Annotation>, Map<String, Object>> expectations) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void testGetAnnotationDefaults() {
        Map<Class<? extends Annotation>, Map<String, Object>> expectations = Map.of(PropertyEscaped.class, Map.of("prop_name", new String[]{"prop__name default"}, "prop.name", new String[]{"prop_name default"}, "prop-name", new String[]{"prop$_$name default"}, "prop$name", new String[]{"prop$$name default"}, "propname", new String[]{"prop$name default"}, "propName", new String[]{"propName default"}), PrefixedPropertyEscaped.class, Map.of("prefix-prop_name", new String[]{"prop__name default"}, "prefix-prop.name", new String[]{"prop_name default"}, "prefix-prop-name", new String[]{"prop$_$name default"}, "prefix-prop$name", new String[]{"prop$$name default"}, "prefix-propname", new String[]{"prop$name default"}, "prefix-propName", new String[]{"propName default"}));
        this.assertGetAnnotationDefaultsExpectations(expectations);
    }

    @Test
    public void testGetAnnotationDefaultsSingleElementString() {
        Map<Class<? extends Annotation>, Map<String, Object>> expectations = Map.of(SingleElementString.class, Collections.emptyMap(), SingleElementStringDefault.class, Map.of("single.element.string.default", new String[]{"defaultDefaults"}), SingleElementStringArray.class, Collections.emptyMap(), SingleElementStringArrayDefault.class, Map.of("single.element.string.array.default", new String[]{"arrayDefaultDefaults"}));
        this.assertGetAnnotationDefaultsExpectations(expectations);
    }

    @Test
    public void testGetAnnotationDefaultsSingleElementClass() {
        Map<Class<? extends Annotation>, Map<String, Object>> expectations = Map.of(SingleElementClass.class, Collections.emptyMap(), SingleElementClassDefault.class, Map.of("single.element.class.default", new String[]{ComponentPropertyParser.class.getName()}), SingleElementClassArray.class, Collections.emptyMap(), SingleElementClassArrayDefault.class, Map.of("single.element.class.array.default", new String[]{ComponentPropertyParserTest.class.getName()}));
        this.assertGetAnnotationDefaultsExpectations(expectations);
    }

    @Test
    public void testGetAnnotationDefaultsSingleElementInteger() {
        Map<Class<? extends Annotation>, Map<String, Object>> expectations = Map.of(SingleElementInteger.class, Collections.emptyMap(), SingleElementIntegerDefault.class, Map.of("single.element.integer.default", new int[]{-2}), SingleElementIntegerArray.class, Collections.emptyMap(), SingleElementIntegerArrayDefault.class, Map.of("single.element.integer.array.default", new int[]{-20}));
        this.assertGetAnnotationDefaultsExpectations(expectations);
    }

    @Test
    public void testParsePrimitives() {
        this.assertMapDeepEquals(Map.of("single.element.string.default", new String[]{"defaultDefaults"}, "string.value", new String[]{"a string"}, "boolean.value", new Boolean[]{false, true}, "byte.value", new Byte[]{(byte)20}, "char.value", new Character[]{Character.valueOf('a'), Character.valueOf('x')}, "short.value", new Short[]{(short)1}, "int.value", new Integer[]{10}, "long.value", new Long[]{100L}, "float.value", new Float[]{Float.valueOf(11.0f)}, "double.value", new Double[]{111.0}), ComponentPropertyParser.parse(SingleElementStringDefault.class, (String[])new String[]{"ignore", "string.value=a string", "boolean.value:String=false", "boolean.value:Boolean=true", "byte.value:Byte=20", "char.value:Character=abc", "char.value=xyz", "short.value:Short=1", "int.value:Integer=10", "long.value:Long=100", "float.value:Float=11.0", "double.value:Double=111.0"}));
    }

    @Test
    public void testParseInterface() {
        Map props = ComponentPropertyParser.parse(AnInterface.class, (String[])new String[]{"prefix-value=a value", "prefix-anotherProperty=another value"});
        Assert.assertEquals(Map.of("prefix-value", "a value", "prefix-anotherProperty", "another value"), (Object)props);
    }

    @Test
    public void testIsSupportedPropertyMapValueType() {
        Stream.of(Boolean.TYPE, boolean[].class, Boolean.class, Boolean[].class, Byte.TYPE, byte[].class, Byte.class, Byte[].class, Character.TYPE, char[].class, Character.class, Character[].class, Short.TYPE, short[].class, Short.class, Short[].class, Integer.TYPE, int[].class, Integer.class, Integer[].class, Long.TYPE, long[].class, Long.class, Long[].class, Float.TYPE, float[].class, Float.class, Float[].class, Double.TYPE, double[].class, Double.class, Double[].class).forEach(type -> Assert.assertTrue((boolean)ComponentPropertyParser.isSupportedPropertyMapValueType((Class)type)));
        Stream.of(Class.class, Class[].class).forEach(type -> Assert.assertFalse((boolean)ComponentPropertyParser.isSupportedPropertyMapValueType((Class)type)));
        Stream.of(ConfigAnnotationUtilTest.AnEnum.class, ConfigAnnotationUtilTest.AnEnum[].class).forEach(type -> Assert.assertFalse((boolean)ComponentPropertyParser.isSupportedPropertyMapValueType((Class)type)));
        Stream.of(ConfigAnnotationUtilTest.AnAbstractClass.class, ConfigAnnotationUtilTest.AnAbstractClass.class).forEach(type -> Assert.assertFalse((boolean)ComponentPropertyParser.isSupportedPropertyMapValueType((Class)type)));
    }

    @Test
    public void testIsSupportedConfigTypeValueType() {
        Stream.of(Boolean.TYPE, boolean[].class, Boolean.class, Boolean[].class, Byte.TYPE, byte[].class, Byte.class, Byte[].class, Character.TYPE, char[].class, Character.class, Character[].class, Short.TYPE, short[].class, Short.class, Short[].class, Integer.TYPE, int[].class, Integer.class, Integer[].class, Long.TYPE, long[].class, Long.class, Long[].class, Float.TYPE, float[].class, Float.class, Float[].class, Double.TYPE, double[].class, Double.class, Double[].class).forEach(type -> Assert.assertTrue((boolean)ComponentPropertyParser.isSupportedConfigTypeValueType((Class)type)));
        Stream.of(Class.class, Class[].class).forEach(type -> Assert.assertTrue((boolean)ComponentPropertyParser.isSupportedConfigTypeValueType((Class)type)));
        Stream.of(ConfigAnnotationUtilTest.AnEnum.class, ConfigAnnotationUtilTest.AnEnum[].class).forEach(type -> Assert.assertTrue((boolean)ComponentPropertyParser.isSupportedConfigTypeValueType((Class)type)));
        Stream.of(ConfigAnnotationUtilTest.AnAbstractClass.class, ConfigAnnotationUtilTest.AnAbstractClass.class).forEach(type -> Assert.assertFalse((boolean)ComponentPropertyParser.isSupportedConfigTypeValueType((Class)type)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSingleElementAnnotationPropertyDefaultsProvider() throws Exception {
        SingleElementAnnotationReflectionProvider defaultsProvider = new SingleElementAnnotationReflectionProvider(NotSingleElementAnnotation.class, null);
        defaultsProvider.getPropertyName(NotSingleElementAnnotation.class.getMethod("anotherProperty", new Class[0]));
    }

    @Test
    public void testGetAnnotationDefaultsSingleElementEnum() {
        Map<Class<? extends Annotation>, Map<String, Object>> expectations = Map.of(SingleElementEnum.class, Collections.emptyMap(), SingleElementEnumDefault.class, Map.of("single.element.enum.default", new String[]{"NO"}), SingleElementEnumArray.class, Collections.emptyMap(), SingleElementEnumArrayDefault.class, Map.of("single.element.enum.array.default", new String[]{"YES"}));
        this.assertGetAnnotationDefaultsExpectations(expectations);
    }

    @Test
    public void testAssertOneToOneMapping() {
        Map<Class<PrefixedPropertyEscapedNoDefaults>, String[]> expectations = Map.of(SingleElementString.class, new String[]{"single.element.string=value"}, PropertyEscapedNoDefaults.class, new String[]{"prop_name=prop__name", "prop.name=prop_name", "prop-name=prop$_$name", "prop$name=prop$$name", "propname=prop$name", "propName=propName"}, PrefixedPropertyEscapedNoDefaults.class, new String[]{"prefix-prop_name=prop__name", "prefix-prop.name=prop_name", "prefix-prop-name=prop$_$name", "prefix-prop$name=prop$$name", "prefix-propname=prop$name", "prefix-propName=propName"});
        for (Map.Entry<Class<PrefixedPropertyEscapedNoDefaults>, String[]> entry : expectations.entrySet()) {
            ComponentPropertyParser.assertOneToOneMapping(entry.getKey(), (String[])entry.getValue());
        }
    }

    @Test(expected=ConfigTypeStrictnessViolation.class)
    public void testAssertOneToOneMappingMissingExpected() {
        ComponentPropertyParser.assertOneToOneMapping(SingleElementString.class, (String[])new String[0]);
    }

    @Test(expected=ConfigTypeStrictnessViolation.class)
    public void testAssertOneToOneMappingUnexpectedParsed() {
        ComponentPropertyParser.assertOneToOneMapping(SingleElementString.class, (String[])new String[]{"single.element.string=value", "single.element.integer:Integer=10"});
    }

    private static /* synthetic */ Object lambda$assertGetAnnotationDefaultsExpectations$7(String key) {
        return new String[]{"im set"};
    }

    public static @interface PrefixedPropertyEscapedNoDefaults {
        public static final String PREFIX_ = "prefix-";

        public String prop__name();

        public String prop_name();

        public String prop$_$name();

        public String prop$$name();

        public String prop$name();

        public String propName();
    }

    public static @interface PropertyEscapedNoDefaults {
        public String prop__name();

        public String prop_name();

        public String prop$_$name();

        public String prop$$name();

        public String prop$name();

        public String propName();
    }

    public static @interface SingleElementEnumArrayDefault {
        public YesOrNo[] value() default {YesOrNo.YES};
    }

    public static @interface SingleElementEnumArray {
        public YesOrNo[] value();
    }

    public static @interface SingleElementEnumDefault {
        public YesOrNo value() default YesOrNo.NO;
    }

    public static @interface SingleElementEnum {
        public YesOrNo value();
    }

    public static enum YesOrNo {
        YES,
        NO;

    }

    public static @interface NotSingleElementAnnotation {
        public String anotherProperty() default "another one";

        public String value() default "expected";
    }

    public static interface AnInterface {
        public static final String PREFIX_ = "prefix-";

        public String anotherProperty();

        public String value();
    }

    public static @interface SingleElementIntegerArrayDefault {
        public int[] value() default {-20};
    }

    public static @interface SingleElementIntegerArray {
        public int[] value();
    }

    public static @interface SingleElementIntegerDefault {
        public int value() default -2;
    }

    public static @interface SingleElementInteger {
        public int value();
    }

    public static @interface SingleElementClassArrayDefault {
        public Class<?>[] value() default {ComponentPropertyParserTest.class};
    }

    public static @interface SingleElementClassArray {
        public Class<?>[] value();
    }

    public static @interface SingleElementClassDefault {
        public Class<?> value() default ComponentPropertyParser.class;
    }

    public static @interface SingleElementClass {
        public Class<?> value();
    }

    public static @interface SingleElementStringArrayDefault {
        public String[] value() default {"arrayDefaultDefaults"};
    }

    public static @interface SingleElementStringArray {
        public String[] value();
    }

    public static @interface SingleElementStringDefault {
        public String value() default "defaultDefaults";
    }

    public static @interface SingleElementString {
        public String value();
    }

    public static @interface PrefixedPropertyEscaped {
        public static final String PREFIX_ = "prefix-";

        public String prop__name() default "prop__name default";

        public String prop_name() default "prop_name default";

        public String prop$_$name() default "prop$_$name default";

        public String prop$$name() default "prop$$name default";

        public String prop$name() default "prop$name default";

        public String propName() default "propName default";
    }

    public static @interface PropertyEscaped {
        public String prop__name() default "prop__name default";

        public String prop_name() default "prop_name default";

        public String prop$_$name() default "prop$_$name default";

        public String prop$$name() default "prop$$name default";

        public String prop$name() default "prop$name default";

        public String propName() default "propName default";
    }

    static @interface InnerAnnotation {
        public String value();
    }

    static enum ValueCardinality {
        ABSENT,
        ONE,
        MANY;

    }
}

