/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.Service3;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.ServiceInterface1;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.ServiceInterface1Optional;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.ServiceInterface2;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.ServiceInterface3;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.ServiceSuperInterface3;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@RunWith(value=MockitoJUnitRunner.class)
public class MockBundleContextDynamicReferencesTest {
    private BundleContext bundleContext;
    private Service3 service;
    private ServiceRegistration reg1a;
    private ServiceRegistration reg2a;
    @Mock
    private ServiceInterface1 dependency1a;
    @Mock
    private ServiceInterface1 dependency1b;
    @Mock
    private ServiceInterface1Optional dependency1aOptional;
    @Mock
    private ServiceInterface1Optional dependency1bOptional;
    @Mock
    private ServiceInterface2 dependency2a;
    @Mock
    private ServiceInterface2 dependency2b;
    @Mock
    private ServiceSuperInterface3 dependency3a;
    @Mock
    private ServiceSuperInterface3 dependency3b;

    @Before
    public void setUp() {
        this.bundleContext = MockOsgi.newBundleContext();
        this.reg1a = this.bundleContext.registerService(ServiceInterface1.class.getName(), (Object)this.dependency1a, null);
        this.reg2a = this.bundleContext.registerService(ServiceInterface2.class.getName(), (Object)this.dependency2a, null);
        this.service = new Service3();
        MockOsgi.injectServices((Object)this.service, (BundleContext)this.bundleContext);
        MockOsgi.activate((Object)this.service, (BundleContext)this.bundleContext);
        this.bundleContext.registerService(Service3.class.getName(), (Object)this.service, null);
        this.assertDependency1(this.dependency1a);
        this.assertDependency1Optional(null);
        this.assertDependencies2(this.dependency2a);
        this.assertDependencies3(new ServiceSuperInterface3[0]);
    }

    @Test
    public void testAddRemoveOptionalUnaryService() {
        ServiceRegistration reg1aOptional = this.bundleContext.registerService(ServiceInterface1Optional.class.getName(), (Object)this.dependency1aOptional, null);
        this.assertDependency1Optional(this.dependency1aOptional);
        reg1aOptional.unregister();
        this.assertDependency1Optional(null);
    }

    public void testAddOptionalUnaryService_TooMany() {
        this.bundleContext.registerService(ServiceInterface1Optional.class.getName(), (Object)this.dependency1aOptional, null);
        this.assertDependency1Optional(this.dependency1aOptional);
        this.bundleContext.registerService(ServiceInterface1Optional.class.getName(), (Object)this.dependency1bOptional, null);
        this.assertDependency1Optional(this.dependency1bOptional);
    }

    @Test
    public void testAddMandatoryUnaryService_TooMany() {
        this.bundleContext.registerService(ServiceInterface1.class.getName(), (Object)this.dependency1b, null);
    }

    @Test
    public void testRemoveMandatoryUnaryService_TooMany() {
        this.reg1a.unregister();
    }

    @Test
    public void testAddRemoveOptionalMultipleService() {
        ServiceRegistration reg3a = this.bundleContext.registerService(ServiceInterface3.class.getName(), (Object)this.dependency3a, null);
        this.assertDependencies3(this.dependency3a);
        ServiceRegistration reg3b = this.bundleContext.registerService(ServiceInterface3.class.getName(), (Object)this.dependency3b, null);
        this.assertDependencies3(this.dependency3a, this.dependency3b);
        reg3a.unregister();
        this.assertDependencies3(this.dependency3b);
        reg3b.unregister();
        this.assertDependencies3(new ServiceSuperInterface3[0]);
    }

    @Test
    public void testAddRemoveMandatoryMultipleService() {
        ServiceRegistration reg2b = this.bundleContext.registerService(ServiceInterface2.class.getName(), (Object)this.dependency2b, null);
        this.assertDependencies2(this.dependency2a, this.dependency2b);
        reg2b.unregister();
        this.assertDependencies2(this.dependency2a);
        this.reg2a.unregister();
        this.assertDependencies2(new ServiceInterface2[0]);
    }

    private void assertDependency1(ServiceInterface1 instance) {
        if (instance == null) {
            Assert.assertNull((Object)this.service.getReference1());
        } else {
            Assert.assertSame((Object)instance, (Object)this.service.getReference1());
        }
    }

    private void assertDependency1Optional(ServiceInterface1Optional instance) {
        if (instance == null) {
            Assert.assertNull((Object)this.service.getReference1Optional());
        } else {
            Assert.assertSame((Object)instance, (Object)this.service.getReference1Optional());
        }
    }

    private void assertDependencies2(ServiceInterface2 ... instances) {
        Assert.assertEquals((Object)ImmutableSet.copyOf((Object[])instances), (Object)ImmutableSet.copyOf((Collection)this.service.getReferences2()));
    }

    private void assertDependencies3(ServiceSuperInterface3 ... instances) {
        Assert.assertEquals((Object)ImmutableSet.copyOf((Object[])instances), (Object)ImmutableSet.copyOf((Collection)this.service.getReferences3()));
    }
}

