/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.io.File;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.sling.testing.mock.osgi.MapUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public final class MockBundle
implements Bundle {
    private static final AtomicLong BUNDLE_ID_COUNTER = new AtomicLong();
    private final long bundleId;
    private final BundleContext bundleContext;
    private Map<String, String> headers = Collections.emptyMap();
    private String symbolicName;
    private long lastModified;
    private Version version = Version.emptyVersion;

    MockBundle(BundleContext bundleContext, long bundleId) {
        this.bundleId = bundleId;
        this.bundleContext = bundleContext;
        this.symbolicName = bundleId == 0L ? "system.bundle" : "mock-bundle";
    }

    public MockBundle(BundleContext bundleContext) {
        this(bundleContext, BUNDLE_ID_COUNTER.incrementAndGet());
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public URL getEntry(String name) {
        Object nameToQuery = name.startsWith("/") ? name : "/" + name;
        return this.getClass().getResource((String)nameToQuery);
    }

    public int getState() {
        return 32;
    }

    public Dictionary<String, String> getHeaders() {
        return MapUtil.toDictionary(this.headers);
    }

    public Dictionary<String, String> getHeaders(String locale) {
        return this.getHeaders();
    }

    public void setHeaders(Map<String, String> value) {
        this.headers = value;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public void setSymbolicName(String value) {
        this.symbolicName = value;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public Enumeration<String> getEntryPaths(String path) {
        Object queryPath = path.startsWith("/") ? path : "/" + path;
        URL res = this.getClass().getResource((String)queryPath);
        if (res == null) {
            return null;
        }
        ArrayList<CallSite> matching = new ArrayList<CallSite>();
        try {
            File file = new File(res.toURI());
            if (file.isDirectory()) {
                for (File entry : file.listFiles()) {
                    Object name = entry.isDirectory() ? entry.getName() + "/" : entry.getName();
                    matching.add((CallSite)((Object)(this.relativeWithTrailingSlash(((String)queryPath).substring(1, ((String)queryPath).length())) + (String)name)));
                }
            }
        }
        catch (RuntimeException | URISyntaxException e) {
            throw new RuntimeException("Failed opening file from " + res, e);
        }
        if (matching.isEmpty()) {
            return null;
        }
        return Collections.enumeration(matching);
    }

    private String relativeWithTrailingSlash(String queryPath) {
        if (((String)queryPath).startsWith("/")) {
            queryPath = ((String)queryPath).substring(1, ((String)queryPath).length());
        }
        if (!((String)queryPath).isEmpty() && !((String)queryPath).endsWith("/")) {
            queryPath = (String)queryPath + "/";
        }
        return queryPath;
    }

    public String getLocation() {
        if (this.bundleId == 0L) {
            return "System Bundle";
        }
        return null;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
        throw new UnsupportedOperationException();
    }

    public ServiceReference<?>[] getRegisteredServices() {
        throw new UnsupportedOperationException();
    }

    public URL getResource(String name) {
        throw new UnsupportedOperationException();
    }

    public Enumeration<URL> getResources(String name) {
        throw new UnsupportedOperationException();
    }

    public ServiceReference<?>[] getServicesInUse() {
        throw new UnsupportedOperationException();
    }

    public boolean hasPermission(Object permission) {
        throw new UnsupportedOperationException();
    }

    public Class<?> loadClass(String name) {
        throw new UnsupportedOperationException();
    }

    public void start() {
        throw new UnsupportedOperationException();
    }

    public void stop() {
        throw new UnsupportedOperationException();
    }

    public void uninstall() {
        throw new UnsupportedOperationException();
    }

    public void update() {
        throw new UnsupportedOperationException();
    }

    public void update(InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    public void start(int options) {
        throw new UnsupportedOperationException();
    }

    public void stop(int options) {
        throw new UnsupportedOperationException();
    }

    public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int signersType) {
        throw new UnsupportedOperationException();
    }

    public int compareTo(Bundle o) {
        throw new UnsupportedOperationException();
    }

    public <A> A adapt(Class<A> type) {
        throw new UnsupportedOperationException();
    }

    public File getDataFile(String filename) {
        throw new UnsupportedOperationException();
    }
}

