/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sling.testing.mock.osgi.junit.OsgiContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

public class MockEventAdminTest {
    private static final String TOPIC_SAMPLE_1 = "sample/topic1";
    private static final String TOPIC_SAMPLE_2 = "sample/topic2";
    private static final String TOPIC_SAMPLE_ALL = "sample/*";
    private static final String TOPIC_OTHER_3 = "other/topic3";
    private static final Event EVENT_SAMPLE_1 = new Event("sample/topic1", (Dictionary)null);
    private static final Event EVENT_SAMPLE_2 = new Event("sample/topic2", (Dictionary)null);
    private static final Event EVENT_OTHER_3 = new Event("other/topic3", (Dictionary)null);
    @Rule
    public OsgiContext context = new OsgiContext();
    private DummyEventHandler eventHandler1;
    private DummyEventHandler eventHandler12;
    private DummyEventHandler eventHandlerSampleAll;
    private DummyEventHandler eventHandlerAll;

    @Before
    public void setUp() {
        this.eventHandler1 = (DummyEventHandler)this.context.registerService(EventHandler.class, new DummyEventHandler(), Map.of("event.topics", TOPIC_SAMPLE_1));
        this.eventHandler12 = (DummyEventHandler)this.context.registerService(EventHandler.class, new DummyEventHandler(), Map.of("event.topics", new String[]{TOPIC_SAMPLE_1, TOPIC_SAMPLE_2}));
        this.eventHandlerSampleAll = (DummyEventHandler)this.context.registerService(EventHandler.class, new DummyEventHandler(), Map.of("event.topics", TOPIC_SAMPLE_ALL));
        this.eventHandlerAll = (DummyEventHandler)this.context.registerService(EventHandler.class, new DummyEventHandler());
    }

    @Test
    public void testSendEvent_Sample1() {
        EventAdmin eventAdmin = (EventAdmin)this.context.getService(EventAdmin.class);
        eventAdmin.sendEvent(EVENT_SAMPLE_1);
        Assert.assertEquals(List.of(EVENT_SAMPLE_1), this.eventHandler1.getReceivedEvents());
        Assert.assertEquals(List.of(EVENT_SAMPLE_1), this.eventHandler12.getReceivedEvents());
        Assert.assertEquals(List.of(EVENT_SAMPLE_1), this.eventHandlerSampleAll.getReceivedEvents());
        Assert.assertEquals(List.of(EVENT_SAMPLE_1), this.eventHandlerAll.getReceivedEvents());
    }

    @Test
    public void testSendEvent_Sample2() {
        EventAdmin eventAdmin = (EventAdmin)this.context.getService(EventAdmin.class);
        eventAdmin.sendEvent(EVENT_SAMPLE_2);
        Assert.assertEquals(List.of(), this.eventHandler1.getReceivedEvents());
        Assert.assertEquals(List.of(EVENT_SAMPLE_2), this.eventHandler12.getReceivedEvents());
        Assert.assertEquals(List.of(EVENT_SAMPLE_2), this.eventHandlerSampleAll.getReceivedEvents());
        Assert.assertEquals(List.of(EVENT_SAMPLE_2), this.eventHandlerAll.getReceivedEvents());
    }

    @Test
    public void testSendEvent_Other3() {
        EventAdmin eventAdmin = (EventAdmin)this.context.getService(EventAdmin.class);
        eventAdmin.sendEvent(EVENT_OTHER_3);
        Assert.assertEquals(List.of(), this.eventHandler1.getReceivedEvents());
        Assert.assertEquals(List.of(), this.eventHandler12.getReceivedEvents());
        Assert.assertEquals(List.of(), this.eventHandlerSampleAll.getReceivedEvents());
        Assert.assertEquals(List.of(EVENT_OTHER_3), this.eventHandlerAll.getReceivedEvents());
    }

    @Test(timeout=3000L)
    public void testPostEvents() {
        EventAdmin eventAdmin = (EventAdmin)this.context.getService(EventAdmin.class);
        eventAdmin.postEvent(EVENT_SAMPLE_2);
        eventAdmin.postEvent(EVENT_OTHER_3);
        boolean expectedResult = false;
        while (!expectedResult) {
            expectedResult = Objects.equals(List.of(), this.eventHandler1.getReceivedEvents()) && Objects.equals(List.of(EVENT_SAMPLE_2), this.eventHandler12.getReceivedEvents()) && Objects.equals(List.of(EVENT_SAMPLE_2), this.eventHandlerSampleAll.getReceivedEvents()) && Objects.equals(List.of(EVENT_SAMPLE_2, EVENT_OTHER_3), this.eventHandlerAll.getReceivedEvents());
        }
    }

    private static class DummyEventHandler
    implements EventHandler {
        private final List<Event> receivedEvents = new ArrayList<Event>();

        private DummyEventHandler() {
        }

        public void handleEvent(Event event) {
            this.receivedEvents.add(event);
        }

        public List<Event> getReceivedEvents() {
            return Collections.unmodifiableList(this.receivedEvents);
        }
    }
}

