/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.testing.mock.osgi.MockComponentContext;
import org.apache.sling.testing.mock.osgi.MockServiceRegistration;
import org.apache.sling.testing.mock.osgi.NoScrMetadataException;
import org.apache.sling.testing.mock.osgi.OsgiMetadataUtil;
import org.apache.sling.testing.mock.osgi.ReferenceViolationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentServiceObjects;
import osgimock.org.apache.felix.scr.impl.inject.Annotations;

final class OsgiServiceUtil {
    private OsgiServiceUtil() {
    }

    public static boolean activateDeactivate(Object target, MockComponentContext componentContext, boolean activate) {
        Class<?> targetClass = target.getClass();
        OsgiMetadataUtil.OsgiMetadata metadata = OsgiMetadataUtil.getMetadata(targetClass);
        if (metadata == null) {
            throw new NoScrMetadataException(targetClass);
        }
        String methodName = activate ? metadata.getActivateMethodName() : metadata.getDeactivateMethodName();
        boolean fallbackDefaultName = false;
        if (StringUtils.isEmpty((CharSequence)methodName)) {
            fallbackDefaultName = true;
            methodName = activate ? "activate" : "deactivate";
        }
        if (OsgiServiceUtil.invokeLifecycleMethod(target, targetClass, methodName, !activate, componentContext, componentContext.getPropertiesAsMap())) {
            return true;
        }
        if (fallbackDefaultName) {
            return false;
        }
        throw new RuntimeException("No matching " + (activate ? "activation" : "deactivation") + " method with name '" + methodName + "'  found in class " + targetClass.getName());
    }

    public static boolean modified(Object target, MockComponentContext componentContext, Map<String, Object> properties) {
        Class<?> targetClass = target.getClass();
        OsgiMetadataUtil.OsgiMetadata metadata = OsgiMetadataUtil.getMetadata(targetClass);
        if (metadata == null) {
            throw new NoScrMetadataException(targetClass);
        }
        String methodName = metadata.getModifiedMethodName();
        if (StringUtils.isEmpty((CharSequence)methodName)) {
            return false;
        }
        if (OsgiServiceUtil.invokeLifecycleMethod(target, targetClass, methodName, false, componentContext, properties)) {
            return true;
        }
        throw new RuntimeException("No matching modified method with name '" + methodName + "'  found in class " + targetClass.getName());
    }

    private static boolean invokeLifecycleMethod(Object target, Class<?> targetClass, String methodName, boolean allowIntegerArgument, MockComponentContext componentContext, Map<String, Object> properties) {
        Class[] classArray;
        Method method = OsgiServiceUtil.getMethod(targetClass, methodName, new Class[]{ComponentContext.class});
        if (method != null) {
            OsgiServiceUtil.invokeMethod(target, method, new Object[]{componentContext});
            return true;
        }
        method = OsgiServiceUtil.getMethod(targetClass, methodName, new Class[]{BundleContext.class});
        if (method != null) {
            OsgiServiceUtil.invokeMethod(target, method, new Object[]{componentContext.getBundleContext()});
            return true;
        }
        method = OsgiServiceUtil.getMethod(targetClass, methodName, new Class[]{Map.class});
        if (method != null) {
            OsgiServiceUtil.invokeMethod(target, method, new Object[]{componentContext.getPropertiesAsMap()});
            return true;
        }
        method = OsgiServiceUtil.getMethod(targetClass, methodName, new Class[]{Annotation.class});
        if (method != null) {
            OsgiServiceUtil.invokeMethod(target, method, new Object[]{Annotations.toObject(method.getParameterTypes()[0], componentContext.getPropertiesAsMap(), componentContext.getBundleContext().getBundle(), false)});
            return true;
        }
        if (allowIntegerArgument && (method = OsgiServiceUtil.getMethod(targetClass, methodName, new Class[]{Integer.TYPE})) != null) {
            OsgiServiceUtil.invokeMethod(target, method, new Object[]{0});
            return true;
        }
        if (allowIntegerArgument && (method = OsgiServiceUtil.getMethod(targetClass, methodName, new Class[]{Integer.class})) != null) {
            OsgiServiceUtil.invokeMethod(target, method, new Object[]{0});
            return true;
        }
        if (allowIntegerArgument) {
            Class[] classArray2 = new Class[6];
            classArray2[0] = ComponentContext.class;
            classArray2[1] = BundleContext.class;
            classArray2[2] = Map.class;
            classArray2[3] = Annotation.class;
            classArray2[4] = Integer.TYPE;
            classArray = classArray2;
            classArray2[5] = Integer.class;
        } else {
            Class[] classArray3 = new Class[4];
            classArray3[0] = ComponentContext.class;
            classArray3[1] = BundleContext.class;
            classArray3[2] = Map.class;
            classArray = classArray3;
            classArray3[3] = Annotation.class;
        }
        Class[] mixedArgsAllowed = classArray;
        method = OsgiServiceUtil.getMethodWithAnyCombinationArgs(targetClass, methodName, mixedArgsAllowed);
        if (method != null) {
            Object[] args = new Object[method.getParameterTypes().length];
            for (int i = 0; i < args.length; ++i) {
                if (method.getParameterTypes()[i] == ComponentContext.class) {
                    args[i] = componentContext;
                    continue;
                }
                if (method.getParameterTypes()[i] == BundleContext.class) {
                    args[i] = componentContext.getBundleContext();
                    continue;
                }
                if (method.getParameterTypes()[i] == Map.class) {
                    args[i] = componentContext.getPropertiesAsMap();
                    continue;
                }
                if (method.getParameterTypes()[i].isAnnotation()) {
                    args[i] = Annotations.toObject(method.getParameterTypes()[i], componentContext.getPropertiesAsMap(), componentContext.getBundleContext().getBundle(), false);
                    continue;
                }
                if (method.getParameterTypes()[i] != Integer.TYPE && method.getParameterTypes()[i] != Integer.class) continue;
                args[i] = 0;
            }
            OsgiServiceUtil.invokeMethod(target, method, args);
            return true;
        }
        method = OsgiServiceUtil.getMethod(targetClass, methodName, new Class[0]);
        if (method != null) {
            OsgiServiceUtil.invokeMethod(target, method, new Object[0]);
            return true;
        }
        return false;
    }

    private static Method getMethod(Class clazz, String methodName, Class<?>[] types) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!StringUtils.equals((CharSequence)method.getName(), (CharSequence)methodName) || method.getParameterTypes().length != types.length) continue;
            boolean foundMismatch = false;
            for (int i = 0; i < types.length; ++i) {
                if (method.getParameterTypes()[i] == types[i] || types[i] == Annotation.class && method.getParameterTypes()[i].isAnnotation()) continue;
                foundMismatch = true;
                break;
            }
            if (foundMismatch) continue;
            return method;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            return OsgiServiceUtil.getMethod(superClass, methodName, types);
        }
        return null;
    }

    private static Method getMethodWithAssignableTypes(Class clazz, String methodName, Class<?>[] types) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!StringUtils.equals((CharSequence)method.getName(), (CharSequence)methodName) || method.getParameterTypes().length != types.length) continue;
            boolean foundMismatch = false;
            for (int i = 0; i < types.length; ++i) {
                if (method.getParameterTypes()[i].isAssignableFrom(types[i])) continue;
                foundMismatch = true;
                break;
            }
            if (foundMismatch) continue;
            return method;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            return OsgiServiceUtil.getMethodWithAssignableTypes(superClass, methodName, types);
        }
        return null;
    }

    private static Method getMethodWithAnyCombinationArgs(Class clazz, String methodName, Class<?>[] types) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!StringUtils.equals((CharSequence)method.getName(), (CharSequence)methodName) || method.getParameterTypes().length <= 1) continue;
            boolean foundMismatch = false;
            for (Class<?> parameterType : method.getParameterTypes()) {
                boolean foundAnyMatch = false;
                for (int i = 0; i < types.length; ++i) {
                    if (types[i] == Annotation.class) {
                        if (!parameterType.isAnnotation()) continue;
                        foundAnyMatch = true;
                        break;
                    }
                    if (types[i] == ComponentContext.class || types[i] == BundleContext.class || types[i] == ServiceReference.class || types[i] == ComponentServiceObjects.class || types[i] == Map.class || types[i] == Integer.TYPE || types[i] == Integer.class) {
                        if (parameterType != types[i]) continue;
                        foundAnyMatch = true;
                        break;
                    }
                    if (!parameterType.isAssignableFrom(types[i])) continue;
                    foundAnyMatch = true;
                    break;
                }
                if (foundAnyMatch) continue;
                foundMismatch = true;
                break;
            }
            if (foundMismatch) continue;
            return method;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            return OsgiServiceUtil.getMethodWithAnyCombinationArgs(superClass, methodName, types);
        }
        return null;
    }

    private static void invokeMethod(Object target, Method method, Object[] args) {
        try {
            method.setAccessible(true);
            method.invoke(target, args);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Unable to invoke method '" + method.getName() + "' for class " + target.getClass().getName(), ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException("Unable to invoke method '" + method.getName() + "' for class " + target.getClass().getName(), ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("Unable to invoke method '" + method.getName() + "' for class " + target.getClass().getName(), ex.getCause());
        }
    }

    private static Field getField(Class clazz, String fieldName, Class<?> type) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!StringUtils.equals((CharSequence)field.getName(), (CharSequence)fieldName) || !field.getType().equals(type)) continue;
            return field;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            return OsgiServiceUtil.getField(superClass, fieldName, type);
        }
        return null;
    }

    private static Field getFieldWithAssignableType(Class clazz, String fieldName, Class<?> type) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!StringUtils.equals((CharSequence)field.getName(), (CharSequence)fieldName) || !field.getType().isAssignableFrom(type)) continue;
            return field;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            return OsgiServiceUtil.getFieldWithAssignableType(superClass, fieldName, type);
        }
        return null;
    }

    private static Field getCollectionField(Class clazz, String fieldName) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!StringUtils.equals((CharSequence)field.getName(), (CharSequence)fieldName) || !Collection.class.isAssignableFrom(field.getType())) continue;
            return field;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            return OsgiServiceUtil.getCollectionField(superClass, fieldName);
        }
        return null;
    }

    private static void setField(Object target, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(target, value);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Unable to set field '" + field.getName() + "' for class " + target.getClass().getName(), ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException("Unable to set field '" + field.getName() + "' for class " + target.getClass().getName(), ex);
        }
    }

    public static boolean injectServices(Object target, BundleContext bundleContext, Map<String, Object> properties) {
        Class<?> targetClass = target.getClass();
        OsgiMetadataUtil.OsgiMetadata metadata = OsgiMetadataUtil.getMetadata(targetClass);
        if (metadata == null) {
            throw new NoScrMetadataException(targetClass);
        }
        boolean foundAny = false;
        for (OsgiMetadataUtil.Reference reference : metadata.getReferences()) {
            Object o;
            if (reference.isConstructorParameter()) continue;
            if (properties != null && (o = properties.get(reference.getName() + ".target")) instanceof String) {
                reference = new OsgiMetadataUtil.DynamicReference(reference, (String)o);
            }
            OsgiServiceUtil.injectServiceReference(reference, target, bundleContext);
            foundAny = true;
        }
        return foundAny;
    }

    @NotNull
    public static <T> T activateInjectServices(Class<T> targetClass, MockComponentContext componentContext) {
        T target;
        try {
            target = OsgiServiceUtil.instantiateServiceWithActivateInject(targetClass, componentContext);
            if (target == null) {
                target = targetClass.newInstance();
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            throw new RuntimeException("Error creating instance of " + targetClass.getName() + ": " + ex.getMessage(), ex);
        }
        OsgiServiceUtil.injectServices(target, componentContext.getBundleContext(), componentContext.getPropertiesAsMap());
        OsgiServiceUtil.activateDeactivate(target, componentContext, true);
        return target;
    }

    @Nullable
    private static <T> T instantiateServiceWithActivateInject(Class<T> targetClass, MockComponentContext componentContext) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        OsgiMetadataUtil.OsgiMetadata metadata = OsgiMetadataUtil.getMetadata(targetClass);
        if (metadata == null) {
            return null;
        }
        List<OsgiMetadataUtil.Reference> constructorInjectionReferences = metadata.getReferences().stream().filter(OsgiMetadataUtil.Reference::isConstructorParameter).sorted((ref1, ref2) -> ref1.getParameter().compareTo(ref2.getParameter())).collect(Collectors.toList());
        Constructor<?> matchingConstructor = null;
        List<Object> constructorParamValues = null;
        for (Constructor<?> constructor : targetClass.getConstructors()) {
            Optional<List<Object>> values = OsgiServiceUtil.buildConstructorInjectionValues(targetClass, constructor, componentContext, constructorInjectionReferences);
            if (!values.isPresent()) continue;
            matchingConstructor = constructor;
            constructorParamValues = values.get();
            break;
        }
        if (matchingConstructor != null && constructorParamValues != null) {
            return matchingConstructor.newInstance(constructorParamValues.toArray(new Object[0]));
        }
        return null;
    }

    private static <T> Optional<List<Object>> buildConstructorInjectionValues(Class<T> targetClass, Constructor<T> constructor, MockComponentContext componentContext, List<OsgiMetadataUtil.Reference> constructorInjectionReferences) throws InstantiationException, IllegalAccessException {
        Iterator<OsgiMetadataUtil.Reference> referenceIterator = constructorInjectionReferences.iterator();
        ArrayList<Object> values = new ArrayList<Object>();
        for (Parameter parameter : constructor.getParameters()) {
            if (parameter.getType() == ComponentContext.class) {
                values.add(componentContext);
                continue;
            }
            if (parameter.getType() == BundleContext.class) {
                values.add(componentContext.getBundleContext());
                continue;
            }
            if (parameter.getType() == Map.class) {
                values.add(componentContext.getPropertiesAsMap());
                continue;
            }
            if (parameter.getType().isAnnotation()) {
                values.add(Annotations.toObject(parameter.getType(), componentContext.getPropertiesAsMap(), componentContext.getBundleContext().getBundle(), false));
                continue;
            }
            if (referenceIterator.hasNext()) {
                OsgiMetadataUtil.Reference reference = referenceIterator.next();
                Optional<T> referenceValue = OsgiServiceUtil.buildConstructorInjectionValue(targetClass, parameter.getType(), reference, componentContext);
                if (referenceValue != null) {
                    values.add(referenceValue.isPresent() ? (Object)referenceValue.get() : null);
                    continue;
                }
                return Optional.empty();
            }
            return Optional.empty();
        }
        return Optional.of(values);
    }

    @Nullable
    private static <T> Optional<?> buildConstructorInjectionValue(Class<?> targetClass, Class<T> parameterType, OsgiMetadataUtil.Reference reference, MockComponentContext componentContext) throws InstantiationException, IllegalAccessException {
        List<ServiceInfo<?>> matchingServices = OsgiServiceUtil.getMatchingServices(reference.getInterfaceTypeAsClass(), componentContext.getBundleContext(), reference.getTarget());
        if (matchingServices.isEmpty() && !reference.isCardinalityOptional()) {
            throw new ReferenceViolationException("Unable to inject mandatory reference '" + reference.getName() + "' for class " + targetClass.getName() + " : no matching services were found.");
        }
        if (reference.isCardinalityMultiple()) {
            Collection<Object> collection = OsgiServiceUtil.newCollectionInstance(parameterType);
            switch (reference.getFieldCollectionType()) {
                case SERVICE: {
                    matchingServices.stream().map(ServiceInfo::getServiceInstance).forEach(collection::add);
                    break;
                }
                case REFERENCE: {
                    matchingServices.stream().map(ServiceInfo::getServiceReference).forEach(collection::add);
                    break;
                }
                default: {
                    throw new RuntimeException("Field collection type '" + (Object)((Object)reference.getFieldCollectionType()) + "' not supported for reference '" + reference.getName() + "' for class " + targetClass.getName());
                }
            }
            return Optional.of(collection);
        }
        Optional firstServiceInfo = matchingServices.stream().findFirst();
        if (parameterType.isAssignableFrom(reference.getInterfaceTypeAsClass())) {
            return firstServiceInfo.map(ServiceInfo::getServiceInstance);
        }
        if (parameterType == ServiceReference.class) {
            return firstServiceInfo.map(ServiceInfo::getServiceReference);
        }
        return null;
    }

    private static void injectServiceReference(OsgiMetadataUtil.Reference reference, Object target, BundleContext bundleContext) {
        Class<?> targetClass = target.getClass();
        Class type = reference.getInterfaceTypeAsClass();
        List<ServiceInfo<?>> matchingServices = OsgiServiceUtil.getMatchingServices(type, bundleContext, reference.getTarget());
        if (matchingServices.isEmpty()) {
            if (!reference.isCardinalityOptional()) {
                throw new ReferenceViolationException("Unable to inject mandatory reference '" + reference.getName() + "' for class " + targetClass.getName() + " : no matching services were found.");
            }
            if (reference.isCardinalityMultiple()) {
                OsgiServiceUtil.invokeBindUnbindMethod(reference, target, null, bundleContext, true);
            }
        }
        if (matchingServices.size() > 1 && !reference.isCardinalityMultiple()) {
            matchingServices = matchingServices.subList(0, 1);
        } else {
            matchingServices.sort(Comparator.comparing(ServiceInfo::getServiceReference));
        }
        for (ServiceInfo<?> matchingService : matchingServices) {
            OsgiServiceUtil.invokeBindUnbindMethod(reference, target, matchingService, bundleContext, true);
        }
    }

    private static void invokeBindUnbindMethod(OsgiMetadataUtil.Reference reference, Object target, ServiceInfo<?> serviceInfo, BundleContext bundleContext, boolean bind) {
        block21: {
            String fieldName;
            Class<?> targetClass;
            block22: {
                targetClass = target.getClass();
                String methodName = bind ? reference.getBind() : reference.getUnbind();
                fieldName = reference.getField();
                if (StringUtils.isEmpty((CharSequence)methodName) && StringUtils.isEmpty((CharSequence)fieldName)) {
                    throw new RuntimeException("No bind/unbind method name or file name defined for reference '" + reference.getName() + "' for class " + targetClass.getName());
                }
                if (StringUtils.isNotEmpty((CharSequence)methodName) && serviceInfo != null) {
                    Method method = OsgiServiceUtil.getMethod(targetClass, methodName, new Class[]{ServiceReference.class});
                    if (method != null) {
                        OsgiServiceUtil.invokeMethod(target, method, new Object[]{serviceInfo.getServiceReference()});
                        return;
                    }
                    method = OsgiServiceUtil.getMethod(targetClass, methodName, new Class[]{ComponentServiceObjects.class});
                    if (method != null) {
                        OsgiServiceUtil.invokeMethod(target, method, new Object[]{OsgiServiceUtil.toComponentServiceObjects(bundleContext.getServiceObjects(serviceInfo.getServiceReference()))});
                        return;
                    }
                    Class interfaceType = reference.getInterfaceTypeAsClass();
                    method = OsgiServiceUtil.getMethodWithAssignableTypes(targetClass, methodName, new Class[]{interfaceType});
                    if (method != null) {
                        OsgiServiceUtil.invokeMethod(target, method, new Object[]{serviceInfo.getServiceInstance()});
                        return;
                    }
                    method = OsgiServiceUtil.getMethod(targetClass, methodName, new Class[]{Map.class});
                    if (method != null) {
                        OsgiServiceUtil.invokeMethod(target, method, new Object[]{serviceInfo.getServiceConfig()});
                        return;
                    }
                    Class[] mixedArgsAllowed = new Class[]{ServiceReference.class, ComponentServiceObjects.class, interfaceType, Map.class};
                    method = OsgiServiceUtil.getMethodWithAnyCombinationArgs(targetClass, methodName, mixedArgsAllowed);
                    if (method != null) {
                        Object[] args = new Object[method.getParameterTypes().length];
                        for (int i = 0; i < args.length; ++i) {
                            if (method.getParameterTypes()[i] == ServiceReference.class) {
                                args[i] = serviceInfo.getServiceReference();
                                continue;
                            }
                            if (method.getParameterTypes()[i] == ComponentServiceObjects.class) {
                                args[i] = OsgiServiceUtil.toComponentServiceObjects(bundleContext.getServiceObjects(serviceInfo.getServiceReference()));
                                continue;
                            }
                            if (method.getParameterTypes()[i].isAssignableFrom(interfaceType)) {
                                args[i] = serviceInfo.getServiceInstance();
                                continue;
                            }
                            if (method.getParameterTypes()[i] != Map.class) continue;
                            args[i] = serviceInfo.getServiceConfig();
                        }
                        OsgiServiceUtil.invokeMethod(target, method, args);
                        return;
                    }
                    throw new RuntimeException((bind ? "Bind" : "Unbind") + " method with name " + methodName + " not found for reference '" + reference.getName() + "' for class " + targetClass.getName());
                }
                if (!StringUtils.isNotEmpty((CharSequence)fieldName)) break block21;
                if (!reference.isCardinalityMultiple()) break block22;
                switch (reference.getFieldCollectionType()) {
                    case SERVICE: 
                    case REFERENCE: {
                        Field field;
                        ServiceReference<?> item = null;
                        if (serviceInfo != null) {
                            item = (ServiceReference<?>)serviceInfo.getServiceInstance();
                            if (reference.getFieldCollectionType() == OsgiMetadataUtil.FieldCollectionType.REFERENCE) {
                                item = serviceInfo.getServiceReference();
                            }
                        }
                        if ((field = OsgiServiceUtil.getCollectionField(targetClass, fieldName)) != null) {
                            if (bind) {
                                OsgiServiceUtil.addToCollection(target, field, item);
                            } else {
                                OsgiServiceUtil.removeFromCollection(target, field, item);
                            }
                            return;
                        }
                        break block21;
                    }
                    default: {
                        throw new RuntimeException("Field collection type '" + (Object)((Object)reference.getFieldCollectionType()) + "' not supported for reference '" + reference.getName() + "' for class " + targetClass.getName());
                    }
                }
            }
            Class interfaceType = reference.getInterfaceTypeAsClass();
            Field field = OsgiServiceUtil.getFieldWithAssignableType(targetClass, fieldName, interfaceType);
            if (field != null) {
                OsgiServiceUtil.setField(target, field, bind && serviceInfo != null ? serviceInfo.getServiceInstance() : null);
                return;
            }
            field = OsgiServiceUtil.getField(targetClass, fieldName, ServiceReference.class);
            if (field != null) {
                OsgiServiceUtil.setField(target, field, bind && serviceInfo != null ? serviceInfo.getServiceReference() : null);
                return;
            }
        }
    }

    private static <T> ComponentServiceObjects<T> toComponentServiceObjects(final ServiceObjects<T> serviceObjects) {
        return new ComponentServiceObjects<T>(){

            public T getService() {
                return serviceObjects.getService();
            }

            public void ungetService(T service) {
                serviceObjects.ungetService(service);
            }

            public ServiceReference<T> getServiceReference() {
                return serviceObjects.getServiceReference();
            }
        };
    }

    private static void addToCollection(Object target, Field field, Object item) {
        try {
            field.setAccessible(true);
            Collection<Object> collection = (Collection<Object>)field.get(target);
            if (collection == null) {
                collection = OsgiServiceUtil.newCollectionInstance(field.getType());
            }
            if (item != null) {
                collection.add(item);
            }
            field.set(target, collection);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException ex) {
            throw new RuntimeException("Unable to set field '" + field.getName() + "' for class " + target.getClass().getName(), ex);
        }
    }

    private static void removeFromCollection(Object target, Field field, Object item) {
        try {
            field.setAccessible(true);
            Collection<Object> collection = (Collection<Object>)field.get(target);
            if (collection == null) {
                collection = OsgiServiceUtil.newCollectionInstance(field.getType());
            }
            if (item != null) {
                collection.remove(item);
            }
            field.set(target, collection);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException ex) {
            throw new RuntimeException("Unable to set field '" + field.getName() + "' for class " + target.getClass().getName(), ex);
        }
    }

    @NotNull
    private static Collection<Object> newCollectionInstance(Class<?> collectionType) throws InstantiationException, IllegalAccessException {
        if (collectionType == List.class || collectionType == Collection.class) {
            return new ArrayList<Object>();
        }
        if (collectionType == Set.class) {
            return new HashSet<Object>();
        }
        if (collectionType == SortedSet.class) {
            return new TreeSet<Object>();
        }
        return (Collection)collectionType.newInstance();
    }

    public static void invokeBindMethod(OsgiMetadataUtil.Reference reference, Object target, ServiceInfo serviceInfo, BundleContext bundleContext) {
        OsgiServiceUtil.invokeBindUnbindMethod(reference, target, serviceInfo, bundleContext, true);
    }

    public static void invokeUnbindMethod(OsgiMetadataUtil.Reference reference, Object target, ServiceInfo serviceInfo, BundleContext bundleContext) {
        OsgiServiceUtil.invokeBindUnbindMethod(reference, target, serviceInfo, bundleContext, false);
    }

    private static List<ServiceInfo<?>> getMatchingServices(Class<?> type, BundleContext bundleContext, String filter) {
        ArrayList matchingServices = new ArrayList();
        try {
            ServiceReference[] references = bundleContext.getServiceReferences(type.getName(), filter);
            if (references != null) {
                for (ServiceReference serviceReference : references) {
                    String[] keys;
                    Object serviceInstance = bundleContext.getService(serviceReference);
                    HashMap<String, Object> serviceConfig = new HashMap<String, Object>();
                    for (String key : keys = serviceReference.getPropertyKeys()) {
                        serviceConfig.put(key, serviceReference.getProperty(key));
                    }
                    matchingServices.add(new ServiceInfo<Object>(serviceInstance, serviceConfig, serviceReference));
                }
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        return matchingServices;
    }

    public static List<ReferenceInfo<?>> getMatchingDynamicReferences(SortedSet<MockServiceRegistration> registeredServices, MockServiceRegistration<?> registration) {
        ArrayList references = new ArrayList();
        for (MockServiceRegistration existingRegistration : registeredServices) {
            OsgiMetadataUtil.OsgiMetadata metadata = OsgiMetadataUtil.getMetadata(existingRegistration.getService().getClass());
            if (metadata == null) continue;
            for (OsgiMetadataUtil.Reference reference : metadata.getReferences()) {
                if (reference.isConstructorParameter() || reference.getPolicy() != OsgiMetadataUtil.ReferencePolicy.DYNAMIC) continue;
                for (String serviceInterface : registration.getClasses()) {
                    if (!StringUtils.equals((CharSequence)serviceInterface, (CharSequence)reference.getInterfaceType())) continue;
                    references.add(new ReferenceInfo(existingRegistration, reference));
                }
            }
        }
        return references;
    }

    public static List<ReferenceInfo<?>> getMatchingStaticGreedyReferences(SortedSet<MockServiceRegistration> registeredServices, MockServiceRegistration<?> registration) {
        ArrayList references = new ArrayList();
        for (MockServiceRegistration existingRegistration : registeredServices) {
            OsgiMetadataUtil.OsgiMetadata metadata = OsgiMetadataUtil.getMetadata(existingRegistration.getService().getClass());
            if (metadata == null) continue;
            for (OsgiMetadataUtil.Reference reference : metadata.getReferences()) {
                if (reference.getPolicy() != OsgiMetadataUtil.ReferencePolicy.STATIC || reference.getPolicyOption() != OsgiMetadataUtil.ReferencePolicyOption.GREEDY) continue;
                for (String serviceInterface : registration.getClasses()) {
                    if (!StringUtils.equals((CharSequence)serviceInterface, (CharSequence)reference.getInterfaceType())) continue;
                    references.add(new ReferenceInfo(existingRegistration, reference));
                }
            }
        }
        return references;
    }

    static class ReferenceInfo<T> {
        private final MockServiceRegistration<T> serviceRegistration;
        private final OsgiMetadataUtil.Reference reference;

        public ReferenceInfo(MockServiceRegistration<T> serviceRegistration, OsgiMetadataUtil.Reference reference) {
            this.serviceRegistration = serviceRegistration;
            this.reference = reference;
        }

        public MockServiceRegistration<T> getServiceRegistration() {
            return this.serviceRegistration;
        }

        public OsgiMetadataUtil.Reference getReference() {
            return this.reference;
        }
    }

    static class ServiceInfo<T> {
        private final T serviceInstance;
        private final Map<String, Object> serviceConfig;
        private final ServiceReference<T> serviceReference;

        public ServiceInfo(T serviceInstance, Map<String, Object> serviceConfig, ServiceReference<T> serviceReference) {
            this.serviceInstance = serviceInstance;
            this.serviceConfig = serviceConfig;
            this.serviceReference = serviceReference;
        }

        public ServiceInfo(MockServiceRegistration<T> registration) {
            this.serviceInstance = registration.getService();
            this.serviceConfig = registration.getPropertiesAsMap();
            this.serviceReference = registration.getReference();
        }

        public T getServiceInstance() {
            return this.serviceInstance;
        }

        public Map<String, Object> getServiceConfig() {
            return this.serviceConfig;
        }

        public ServiceReference<T> getServiceReference() {
            return this.serviceReference;
        }
    }
}

