/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.sling.testing.mock.osgi.MockConfiguration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

class MockConfigurationAdmin
implements ConfigurationAdmin {
    private final BundleContext bundleContext;
    private final ConcurrentMap<String, Configuration> configs = new ConcurrentHashMap<String, Configuration>();

    MockConfigurationAdmin(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public Configuration getConfiguration(String pid) throws IOException {
        this.configs.putIfAbsent(pid, new MockConfiguration(pid));
        return (Configuration)this.configs.get(pid);
    }

    public Configuration getConfiguration(String pid, String location) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Configuration createFactoryConfiguration(String factoryPid) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Configuration createFactoryConfiguration(String factoryPid, String location) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Configuration[] listConfigurations(String filter) throws IOException, InvalidSyntaxException {
        Filter filterObject = this.bundleContext.createFilter(filter);
        Configuration[] filtered = (Configuration[])this.configs.values().stream().filter(configuration -> filterObject.match(configuration.getProperties())).toArray(Configuration[]::new);
        if (filtered.length != 0) {
            return filtered;
        }
        return null;
    }

    public Configuration getFactoryConfiguration(String factoryPid, String name, String location) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Configuration getFactoryConfiguration(String factoryPid, String name) throws IOException {
        throw new UnsupportedOperationException();
    }
}

