/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.io.IOException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.testing.mock.osgi.MapUtil;
import org.apache.sling.testing.mock.osgi.OsgiMetadataUtil;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

final class MapMergeUtil {
    private MapMergeUtil() {
    }

    static Dictionary<String, Object> propertiesMergeWithOsgiMetadata(Class<?> targetClass, ConfigurationAdmin configAdmin, Dictionary<String, Object> properties) {
        return MapUtil.toDictionary(MapMergeUtil.propertiesMergeWithOsgiMetadata(targetClass, configAdmin, MapUtil.toMap(properties)));
    }

    static Map<String, Object> propertiesMergeWithOsgiMetadata(Class<?> targetClass, ConfigurationAdmin configAdmin, Map<String, Object> properties) {
        Map<String, Object> metadataProperties;
        HashMap<String, Object> mergedProperties = new HashMap<String, Object>();
        OsgiMetadataUtil.OsgiMetadata metadata = OsgiMetadataUtil.getMetadata(targetClass);
        if (metadata != null && (metadataProperties = metadata.getProperties()) != null) {
            mergedProperties.putAll(metadataProperties);
            if (configAdmin != null) {
                for (String pid : metadata.getConfigurationPID()) {
                    if (pid == null) continue;
                    try {
                        Configuration config = configAdmin.getConfiguration(pid);
                        mergedProperties.putAll(MapUtil.toMap(config.getProperties()));
                    }
                    catch (IOException ex) {
                        throw new RuntimeException("Unable to read config for pid " + pid, ex);
                    }
                }
            }
        }
        if (properties != null) {
            mergedProperties.putAll(properties);
        }
        return mergedProperties;
    }
}

