/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi.context;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.sling.testing.mock.osgi.NoScrMetadataException;
import org.apache.sling.testing.mock.osgi.context.OsgiContextImpl;
import org.apache.sling.testing.mock.osgi.testsvc.osgicontextimpl.MyComponent;
import org.apache.sling.testing.mock.osgi.testsvc.osgicontextimpl.MyService;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.Service3;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.ServiceInterface1;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.ServiceInterface2;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class OsgiContextImplTest {
    private OsgiContextImpl context;

    @Before
    public void setUp() throws Exception {
        this.context = new OsgiContextImpl();
        this.context.setUp();
    }

    @After
    public void tearDown() throws Exception {
        this.context.tearDown();
    }

    @Test
    public void testContextObjects() {
        Assert.assertNotNull((Object)this.context.componentContext());
        Assert.assertNotNull((Object)this.context.bundleContext());
    }

    @Test
    public void testRegisterService() {
        HashSet myService = new HashSet();
        this.context.registerService(Set.class, myService);
        Set serviceResult = (Set)this.context.getService(Set.class);
        Assert.assertSame(myService, (Object)serviceResult);
    }

    @Test
    public void testRegisterServiceWithProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("prop1", "value1");
        HashSet myService = new HashSet();
        this.context.registerService(Set.class, myService, props);
        ServiceReference serviceReference = this.context.bundleContext().getServiceReference(Set.class.getName());
        Object serviceResult = this.context.bundleContext().getService(serviceReference);
        Assert.assertSame(myService, (Object)serviceResult);
        Assert.assertEquals((Object)"value1", (Object)serviceReference.getProperty("prop1"));
    }

    @Test
    public void testRegisterServiceWithPropertiesVarargs() {
        HashSet myService = new HashSet();
        this.context.registerService(Set.class, myService, new Object[]{"prop1", "value1"});
        ServiceReference serviceReference = this.context.bundleContext().getServiceReference(Set.class.getName());
        Object serviceResult = this.context.bundleContext().getService(serviceReference);
        Assert.assertSame(myService, (Object)serviceResult);
        Assert.assertEquals((Object)"value1", (Object)serviceReference.getProperty("prop1"));
    }

    @Test
    public void testRegisterMultipleServices() {
        Set[] serviceResults = (Set[])this.context.getServices(Set.class, null);
        Assert.assertEquals((long)0L, (long)serviceResults.length);
        HashSet myService1 = new HashSet();
        this.context.registerService(Set.class, myService1);
        HashSet myService2 = new HashSet();
        this.context.registerService(Set.class, myService2);
        Assert.assertSame(myService1, (Object)this.context.getService(Set.class));
        serviceResults = (Set[])this.context.getServices(Set.class, null);
        Assert.assertEquals((long)2L, (long)serviceResults.length);
        Assert.assertSame(myService1, (Object)serviceResults[0]);
        Assert.assertSame(myService2, (Object)serviceResults[1]);
    }

    @Test
    public void testRegisterInjectActivate_Instance() {
        this.context.registerService(ServiceInterface1.class, (Object)((ServiceInterface1)Mockito.mock(ServiceInterface1.class)));
        this.context.registerService(ServiceInterface2.class, (Object)((ServiceInterface2)Mockito.mock(ServiceInterface2.class)));
        Service3 service = (Service3)this.context.registerInjectActivateService((Object)new Service3());
        Assert.assertNotNull((Object)service.getReference1());
        Assert.assertEquals((long)1L, (long)service.getReferences2().size());
    }

    @Test
    public void testRegisterInjectActivate_Class() {
        this.context.registerService(ServiceInterface1.class, (Object)((ServiceInterface1)Mockito.mock(ServiceInterface1.class)));
        this.context.registerService(ServiceInterface2.class, (Object)((ServiceInterface2)Mockito.mock(ServiceInterface2.class)));
        Service3 service = (Service3)this.context.registerInjectActivateService(Service3.class);
        Assert.assertNotNull((Object)service.getReference1());
        Assert.assertEquals((long)1L, (long)service.getReferences2().size());
    }

    @Test
    public void testRegisterInjectActivateWithProperties_Instance() {
        this.context.registerService(ServiceInterface1.class, (Object)((ServiceInterface1)Mockito.mock(ServiceInterface1.class)));
        this.context.registerService(ServiceInterface2.class, (Object)((ServiceInterface2)Mockito.mock(ServiceInterface2.class)));
        Service3 service = (Service3)this.context.registerInjectActivateService((Object)new Service3(), new Object[]{"prop1", "value3"});
        Assert.assertEquals((Object)"value3", service.getConfig().get("prop1"));
    }

    @Test
    public void testRegisterInjectActivateWithProperties_Class() {
        this.context.registerService(ServiceInterface1.class, (Object)((ServiceInterface1)Mockito.mock(ServiceInterface1.class)));
        this.context.registerService(ServiceInterface2.class, (Object)((ServiceInterface2)Mockito.mock(ServiceInterface2.class)));
        Service3 service = (Service3)this.context.registerInjectActivateService(Service3.class, new Object[]{"prop1", "value3"});
        Assert.assertEquals((Object)"value3", service.getConfig().get("prop1"));
    }

    @Test
    public void testRegisterInjectActivateWithPropertiesWithNulls() {
        this.context.registerService(ServiceInterface1.class, (Object)((ServiceInterface1)Mockito.mock(ServiceInterface1.class)));
        this.context.registerService(ServiceInterface2.class, (Object)((ServiceInterface2)Mockito.mock(ServiceInterface2.class)));
        Service3 service = (Service3)this.context.registerInjectActivateService((Object)new Service3(), new Object[]{"prop1", "value3", "prop2", null, null, "value4", null, null});
        Assert.assertEquals((Object)"value3", service.getConfig().get("prop1"));
    }

    @Test
    public void testRegisterInjectActivateWithPropertyMapNulls() {
        this.context.registerService(ServiceInterface1.class, (Object)((ServiceInterface1)Mockito.mock(ServiceInterface1.class)));
        this.context.registerService(ServiceInterface2.class, (Object)((ServiceInterface2)Mockito.mock(ServiceInterface2.class)));
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("prop1", "value3");
        props.put("prop2", null);
        props.put(null, "value4");
        props.put(null, null);
        Service3 service = (Service3)this.context.registerInjectActivateService((Object)new Service3(), props);
        Assert.assertEquals((Object)"value3", service.getConfig().get("prop1"));
    }

    @Test(expected=RuntimeException.class)
    public void testRegisterInjectActivate_RefrenceMissing_Instance() {
        this.context.registerInjectActivateService((Object)new Service3());
    }

    @Test(expected=RuntimeException.class)
    public void testRegisterInjectActivate_RefrenceMissing_Class() {
        this.context.registerInjectActivateService(Service3.class);
    }

    @Test(expected=NoScrMetadataException.class)
    public void testRegisterInjectActivateInvalid_Instance() {
        this.context.registerInjectActivateService(new Object());
    }

    @Test(expected=NoScrMetadataException.class)
    public void testRegisterInjectActivateInvalid_Class() {
        this.context.registerInjectActivateService(Object.class);
    }

    @Test
    public void testServiceTracker() {
        BundleContext bundleContext = this.context.bundleContext();
        ServiceTracker tracker = new ServiceTracker(bundleContext, MyService.class, null);
        tracker.open();
        this.context.registerInjectActivateService((Object)new MyComponent());
        Assert.assertNotNull((Object)tracker.getServiceReferences());
        Assert.assertEquals((long)1L, (long)tracker.getServiceReferences().length);
        tracker.close();
    }
}

