/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.osgi.OsgiMetadataUtilTest;
import org.apache.sling.testing.mock.osgi.junit.OsgiContext;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class MockConfigurationAdminTest {
    private static final String[] TEST_ADAPTABLES = new String[]{"adaptable1", "adaptable2"};
    @Rule
    public OsgiContext context = new OsgiContext();

    @Test
    public void testGetConfigurationString() throws IOException {
        MockOsgi.setConfigForPid((BundleContext)this.context.bundleContext(), (String)"org.apache.sling.testing.mock.osgi.OsgiMetadataUtilTest$ServiceWithMetadata", (Object[])new Object[]{"service.ranking", 3000, "adaptables", TEST_ADAPTABLES, "prop2", 2});
        this.context.registerInjectActivateService(new OsgiMetadataUtilTest.ServiceWithMetadata(), (Map)ImmutableMap.builder().put((Object)"service.ranking", (Object)4000).put((Object)"prop1", (Object)1).build());
        ServiceReference reference = this.context.bundleContext().getServiceReference(Comparable.class.getName());
        Assert.assertEquals((Object)4000, (Object)reference.getProperty("service.ranking"));
        Assert.assertEquals((Object)1, (Object)reference.getProperty("prop1"));
        Assert.assertArrayEquals((Object[])TEST_ADAPTABLES, (Object[])((String[])reference.getProperty("adaptables")));
        Assert.assertEquals((Object)2, (Object)reference.getProperty("prop2"));
        Assert.assertEquals((Object)"The Apache Software Foundation", (Object)reference.getProperty("service.vendor"));
        Assert.assertEquals((Object)"org.apache.sling.testing.mock.osgi.OsgiMetadataUtilTest$ServiceWithMetadata", (Object)reference.getProperty("service.pid"));
    }

    @Test
    public void testConfigurationPID() throws IOException {
        MockOsgi.setConfigForPid((BundleContext)this.context.bundleContext(), (String)ServiceWithConfigurationPID.class.getSimpleName(), (Object[])new Object[]{"prop1", 1});
        this.context.registerInjectActivateService(new ServiceWithConfigurationPID(), (Map)ImmutableMap.builder().put((Object)"prop2", (Object)2).build());
        ServiceReference reference = this.context.bundleContext().getServiceReference(Comparable.class.getName());
        Assert.assertEquals((Object)1, (Object)reference.getProperty("prop1"));
        Assert.assertEquals((Object)2, (Object)reference.getProperty("prop2"));
    }

    @Test
    public void testMultipleConfigurationPID() throws IOException {
        MockOsgi.setConfigForPid((BundleContext)this.context.bundleContext(), (String)"Configuration1", (Object[])new Object[]{"prop1", 1});
        MockOsgi.setConfigForPid((BundleContext)this.context.bundleContext(), (String)"Configuration2", (Object[])new Object[]{"prop1", 2});
        this.context.registerInjectActivateService(new ServiceWithMultipleConfigurationPID(), (Map)ImmutableMap.builder().put((Object)"prop2", (Object)2).build());
        ServiceReference reference = this.context.bundleContext().getServiceReference(Comparable.class.getName());
        Assert.assertEquals((Object)2, (Object)reference.getProperty("prop1"));
        Assert.assertEquals((Object)2, (Object)reference.getProperty("prop2"));
    }

    @Test
    public void testFilteringConfigurations() throws IOException, InvalidSyntaxException {
        MockOsgi.setConfigForPid((BundleContext)this.context.bundleContext(), (String)"Configuration1", (Object[])new Object[]{"prop1", 1, "prop2", "B"});
        MockOsgi.setConfigForPid((BundleContext)this.context.bundleContext(), (String)"Configuration2", (Object[])new Object[]{"prop1", 2, "prop2", "A"});
        MockOsgi.setConfigForPid((BundleContext)this.context.bundleContext(), (String)"Configuration3", (Object[])new Object[]{"prop1", 3, "prop2", "A"});
        ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)this.context.bundleContext().getService(this.context.bundleContext().getServiceReference(ConfigurationAdmin.class));
        Configuration[] allConfigurations = configurationAdmin.listConfigurations("(prop1=*)");
        Assert.assertEquals((long)3L, (long)allConfigurations.length);
        Configuration[] prop2AConfigurations = configurationAdmin.listConfigurations("(prop2=A)");
        Assert.assertEquals((long)2L, (long)prop2AConfigurations.length);
        Configuration[] searchForAllConfigurations = configurationAdmin.listConfigurations(null);
        Assert.assertTrue((searchForAllConfigurations.length >= 3 ? 1 : 0) != 0);
        Configuration[] noConfigurations = configurationAdmin.listConfigurations("(nonexistingprop=nonexistingvalue)");
        Assert.assertNull((Object)noConfigurations);
    }

    static class ServiceWithMultipleConfigurationPID {
        ServiceWithMultipleConfigurationPID() {
        }
    }

    static class ServiceWithConfigurationPID {
        ServiceWithConfigurationPID() {
        }
    }
}

