/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.TreeBidiMap;
import org.apache.commons.lang3.StringUtils;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import osgimock.org.apache.felix.framework.FilterImpl;

final class OsgiMetadataUtil {
    private static final Logger log = LoggerFactory.getLogger(OsgiMetadataUtil.class);
    private static final String METADATA_PATH = "OSGI-INF";
    private static final String METADATA_METATYPE_PATH = "OSGI-INF/metatype/";
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private static final XPathFactory XPATH_FACTORY;
    private static final BidiMap<String, String> NAMESPACES;
    private static final OsgiMetadata NULL_METADATA;
    private static final NamespaceContext NAMESPACE_CONTEXT;
    private static final Map<String, Document> METADATA_DOCUMENT_CACHE;
    private static final ConcurrentMap<Class, OsgiMetadata> METADATA_CACHE;

    private OsgiMetadataUtil() {
    }

    public static OsgiMetadata getMetadata(Class clazz) {
        OsgiMetadata metadata = METADATA_CACHE.computeIfAbsent(clazz, key -> {
            Document metadataDocument = METADATA_DOCUMENT_CACHE.get(OsgiMetadataUtil.cleanupClassName(key.getName()));
            if (metadataDocument != null) {
                return new OsgiMetadata((Class)key, metadataDocument);
            }
            return NULL_METADATA;
        });
        if (metadata == NULL_METADATA) {
            return null;
        }
        return metadata;
    }

    private static Map<String, Document> initMetadataDocumentCache() {
        XPathExpression xpathExpression;
        HashMap<String, Document> cacheMap = new HashMap<String, Document>();
        XPath xpath = XPATH_FACTORY.newXPath();
        xpath.setNamespaceContext(NAMESPACE_CONTEXT);
        try {
            xpathExpression = xpath.compile("//*[implementation/@class]");
        }
        catch (XPathExpressionException ex) {
            throw new RuntimeException("Compiling XPath expression failed.", ex);
        }
        Reflections reflections = new Reflections(METADATA_PATH, new Scanner[]{new ResourcesScanner()});
        Pattern xmlFilesPattern = Pattern.compile("^.*\\.xml$");
        Set paths = reflections.getResources(xmlFilesPattern);
        Pattern metatypeFilesPattern = Pattern.compile("^" + Pattern.quote(METADATA_METATYPE_PATH) + ".*$");
        paths.stream().filter(path -> !metatypeFilesPattern.matcher((CharSequence)path).matches()).forEach(path -> OsgiMetadataUtil.parseMetadataDocuments(cacheMap, path, xpathExpression));
        return cacheMap;
    }

    private static void parseMetadataDocuments(Map<String, Document> cacheMap, String resourcePath, XPathExpression xpathExpression) {
        try {
            Enumeration<URL> resourceUrls = OsgiMetadataUtil.class.getClassLoader().getResources(resourcePath);
            while (resourceUrls.hasMoreElements()) {
                URL resourceUrl = resourceUrls.nextElement();
                InputStream fileStream = resourceUrl.openStream();
                try {
                    OsgiMetadataUtil.parseMetadataDocument(cacheMap, resourcePath, fileStream, xpathExpression);
                }
                finally {
                    if (fileStream == null) continue;
                    fileStream.close();
                }
            }
        }
        catch (Exception ex) {
            log.warn("Error reading SCR metadata XML document from " + resourcePath, (Throwable)ex);
        }
    }

    private static void parseMetadataDocument(Map<String, Document> cacheMap, String resourcePath, InputStream fileStream, XPathExpression xpathExpression) throws XPathExpressionException {
        Document metadata = OsgiMetadataUtil.toXmlDocument(fileStream, resourcePath);
        NodeList nodes = (NodeList)xpathExpression.evaluate(metadata, XPathConstants.NODESET);
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String implementationClass = OsgiMetadataUtil.getImplementationClassName(node);
                if (implementationClass == null) continue;
                cacheMap.put(implementationClass, metadata);
            }
        }
    }

    private static String getImplementationClassName(Node componentNode) {
        NodeList childNodes = componentNode.getChildNodes();
        for (int j = 0; j < childNodes.getLength(); ++j) {
            Node childNode = childNodes.item(j);
            if (!childNode.getNodeName().equals("implementation")) continue;
            String implementationClass = OsgiMetadataUtil.getAttributeValue(childNode, "class");
            if (StringUtils.isBlank((CharSequence)implementationClass)) break;
            return implementationClass;
        }
        return null;
    }

    private static Document toXmlDocument(InputStream inputStream, String path) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            return document;
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException("Unable to read classpath resource: " + path, ex);
        }
        catch (SAXException ex) {
            throw new RuntimeException("Unable to read classpath resource: " + path, ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to read classpath resource: " + path, ex);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static String getComponentXPathQuery(Class clazz) {
        String className = OsgiMetadataUtil.cleanupClassName(clazz.getName());
        return "//*[implementation/@class='" + className + "' or @name='" + className + "']";
    }

    public static final String cleanupClassName(String className) {
        return StringUtils.substringBefore((String)StringUtils.substringBefore((String)className, (String)"$MockitoMock$"), (String)"$$Enhancer");
    }

    private static String getComponentName(Class clazz, Document metadata) {
        String query = OsgiMetadataUtil.getComponentXPathQuery(clazz);
        NodeList nodes = OsgiMetadataUtil.queryNodes(metadata, query);
        if (nodes != null && nodes.getLength() > 0) {
            return OsgiMetadataUtil.getAttributeValue(nodes.item(0), "name");
        }
        return clazz.getName();
    }

    private static String[] getConfigurationPID(Class clazz, Document metadata) {
        String value = null;
        String query = OsgiMetadataUtil.getComponentXPathQuery(clazz);
        NodeList nodes = OsgiMetadataUtil.queryNodes(metadata, query);
        if (nodes != null && nodes.getLength() > 0) {
            value = OsgiMetadataUtil.getAttributeValue(nodes.item(0), "configuration-pid");
        }
        if (value == null) {
            value = OsgiMetadataUtil.getComponentName(clazz, metadata);
        }
        return StringUtils.split(value);
    }

    private static Set<String> getServiceInterfaces(Class clazz, Document metadata) {
        HashSet<String> serviceInterfaces = new HashSet<String>();
        String query = OsgiMetadataUtil.getComponentXPathQuery(clazz) + "/service/provide[@interface!='']";
        NodeList nodes = OsgiMetadataUtil.queryNodes(metadata, query);
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String serviceInterface = OsgiMetadataUtil.getAttributeValue(node, "interface");
                if (!StringUtils.isNotBlank((CharSequence)serviceInterface)) continue;
                serviceInterfaces.add(serviceInterface);
            }
        }
        return serviceInterfaces;
    }

    private static Map<String, Object> getProperties(Class clazz, Document metadata) {
        String[] value;
        String name;
        Node node;
        int i;
        HashMap<String, Object> props = new HashMap<String, Object>();
        String query = OsgiMetadataUtil.getComponentXPathQuery(clazz) + "/property[@name!='' and @value!='']";
        NodeList nodes = OsgiMetadataUtil.queryNodes(metadata, query);
        if (nodes != null) {
            for (i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                name = OsgiMetadataUtil.getAttributeValue(node, "name");
                value = OsgiMetadataUtil.getAttributeValue(node, "value");
                String type = OsgiMetadataUtil.getAttributeValue(node, "type");
                if (StringUtils.equals((CharSequence)"Integer", (CharSequence)type)) {
                    props.put(name, Integer.parseInt((String)value));
                    continue;
                }
                if (StringUtils.equals((CharSequence)"Long", (CharSequence)type)) {
                    props.put(name, Long.parseLong((String)value));
                    continue;
                }
                if (StringUtils.equals((CharSequence)"Boolean", (CharSequence)type)) {
                    props.put(name, Boolean.parseBoolean((String)value));
                    continue;
                }
                props.put(name, value);
            }
        }
        if ((nodes = OsgiMetadataUtil.queryNodes(metadata, query = OsgiMetadataUtil.getComponentXPathQuery(clazz) + "/property[@name!='' and text()!='']")) != null) {
            for (i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                name = OsgiMetadataUtil.getAttributeValue(node, "name");
                value = StringUtils.split((String)StringUtils.trim((String)node.getTextContent()), (String)"\n\r");
                for (int j = 0; j < value.length; ++j) {
                    value[j] = StringUtils.trim((String)value[j]);
                }
                props.put(name, value);
            }
        }
        return props;
    }

    private static List<Reference> getReferences(Class clazz, Document metadata) {
        ArrayList<Reference> references = new ArrayList<Reference>();
        String query = OsgiMetadataUtil.getComponentXPathQuery(clazz) + "/reference[@name!='']";
        NodeList nodes = OsgiMetadataUtil.queryNodes(metadata, query);
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                references.add(new Reference(clazz, node));
            }
        }
        return references;
    }

    private static String getLifecycleMethodName(Class clazz, Document metadata, String methodName) {
        String query = OsgiMetadataUtil.getComponentXPathQuery(clazz);
        Node node = OsgiMetadataUtil.queryNode(metadata, query);
        if (node != null) {
            return OsgiMetadataUtil.getAttributeValue(node, methodName);
        }
        return null;
    }

    private static NodeList queryNodes(Document metadata, String xpathQuery) {
        try {
            XPath xpath = XPATH_FACTORY.newXPath();
            xpath.setNamespaceContext(NAMESPACE_CONTEXT);
            return (NodeList)xpath.evaluate(xpathQuery, metadata, XPathConstants.NODESET);
        }
        catch (XPathExpressionException ex) {
            throw new RuntimeException("Error evaluating XPath: " + xpathQuery, ex);
        }
    }

    private static Node queryNode(Document metadata, String xpathQuery) {
        try {
            XPath xpath = XPATH_FACTORY.newXPath();
            xpath.setNamespaceContext(NAMESPACE_CONTEXT);
            return (Node)xpath.evaluate(xpathQuery, metadata, XPathConstants.NODE);
        }
        catch (XPathExpressionException ex) {
            throw new RuntimeException("Error evaluating XPath: " + xpathQuery, ex);
        }
    }

    private static String getAttributeValue(Node node, String attributeName) {
        Node namedItem = node.getAttributes().getNamedItem(attributeName);
        if (namedItem != null) {
            return namedItem.getNodeValue();
        }
        return null;
    }

    static {
        DOCUMENT_BUILDER_FACTORY.setNamespaceAware(true);
        Reflections.log = null;
        XPATH_FACTORY = XPathFactory.newInstance();
        NAMESPACES = new TreeBidiMap();
        NAMESPACES.put((Object)"scr", (Object)"http://www.osgi.org/xmlns/scr/v1.1.0");
        NULL_METADATA = new OsgiMetadata();
        NAMESPACE_CONTEXT = new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                return (String)NAMESPACES.get((Object)prefix);
            }

            @Override
            public String getPrefix(String namespaceURI) {
                return (String)NAMESPACES.getKey((Object)namespaceURI);
            }

            public Iterator getPrefixes(String namespaceURI) {
                return NAMESPACES.keySet().iterator();
            }
        };
        METADATA_DOCUMENT_CACHE = OsgiMetadataUtil.initMetadataDocumentCache();
        METADATA_CACHE = new ConcurrentHashMap<Class, OsgiMetadata>();
    }

    static enum FieldCollectionType {
        SERVICE,
        REFERENCE,
        SERVICEOBJECTS,
        PROPERTIES,
        TUPLE;

    }

    static enum ReferencePolicyOption {
        RELUCTANT,
        GREEDY;

    }

    static enum ReferencePolicy {
        STATIC,
        DYNAMIC;

    }

    static enum ReferenceCardinality {
        OPTIONAL_UNARY("0..1"),
        MANDATORY_UNARY("1..1"),
        OPTIONAL_MULTIPLE("0..n"),
        MANDATORY_MULTIPLE("1..n");

        private final String cardinalityString;

        private ReferenceCardinality(String cardinalityString) {
            this.cardinalityString = cardinalityString;
        }

        public String getCardinalityString() {
            return this.cardinalityString;
        }
    }

    static class DynamicReference
    extends Reference {
        public DynamicReference(Reference reference, String target) {
            super(reference);
            this.target = target;
            if (StringUtils.isNotEmpty((CharSequence)this.target)) {
                try {
                    this.targetFilter = new FilterImpl(this.target);
                }
                catch (InvalidSyntaxException ex) {
                    throw new RuntimeException("Invalid target filter in reference '" + this.name + "' of class " + this.clazz.getName(), ex);
                }
            } else {
                this.targetFilter = null;
            }
        }
    }

    static class Reference {
        protected final Class<?> clazz;
        protected final String name;
        protected final String interfaceType;
        protected final ReferenceCardinality cardinality;
        protected final ReferencePolicy policy;
        protected final ReferencePolicyOption policyOption;
        protected final String bind;
        protected final String unbind;
        protected final String field;
        protected final FieldCollectionType fieldCollectionType;
        protected String target;
        protected Filter targetFilter;
        protected Integer parameter;

        protected Reference(Class<?> clazz, Node node) {
            this.clazz = clazz;
            this.name = OsgiMetadataUtil.getAttributeValue(node, "name");
            this.interfaceType = OsgiMetadataUtil.getAttributeValue(node, "interface");
            this.cardinality = Reference.toCardinality(OsgiMetadataUtil.getAttributeValue(node, "cardinality"));
            this.policy = Reference.toPolicy(OsgiMetadataUtil.getAttributeValue(node, "policy"));
            this.policyOption = Reference.toPolicyOption(OsgiMetadataUtil.getAttributeValue(node, "policy-option"));
            this.bind = OsgiMetadataUtil.getAttributeValue(node, "bind");
            this.unbind = OsgiMetadataUtil.getAttributeValue(node, "unbind");
            this.field = OsgiMetadataUtil.getAttributeValue(node, "field");
            this.fieldCollectionType = Reference.toFieldCollectionType(OsgiMetadataUtil.getAttributeValue(node, "field-collection-type"));
            this.target = OsgiMetadataUtil.getAttributeValue(node, "target");
            if (StringUtils.isNotEmpty((CharSequence)this.target)) {
                try {
                    this.targetFilter = new FilterImpl(this.target);
                }
                catch (InvalidSyntaxException ex) {
                    throw new RuntimeException("Invalid target filter in reference '" + this.name + "' of class " + clazz.getName(), ex);
                }
            } else {
                this.targetFilter = null;
            }
            String parameterString = OsgiMetadataUtil.getAttributeValue(node, "parameter");
            if (parameterString != null) {
                this.parameter = Integer.valueOf(parameterString);
            }
        }

        protected Reference(Reference reference) {
            this.clazz = reference.clazz;
            this.name = reference.name;
            this.interfaceType = reference.interfaceType;
            this.cardinality = reference.cardinality;
            this.policy = reference.policy;
            this.policyOption = reference.policyOption;
            this.bind = reference.bind;
            this.unbind = reference.unbind;
            this.field = reference.field;
            this.fieldCollectionType = reference.fieldCollectionType;
            this.target = reference.target;
            this.targetFilter = reference.targetFilter;
        }

        public Class<?> getServiceClass() {
            return this.clazz;
        }

        public String getName() {
            return this.name;
        }

        public String getInterfaceType() {
            return this.interfaceType;
        }

        public Class getInterfaceTypeAsClass() {
            try {
                return Class.forName(this.getInterfaceType());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Service reference type not found: " + this.getInterfaceType());
            }
        }

        public ReferenceCardinality getCardinality() {
            return this.cardinality;
        }

        public boolean isCardinalityMultiple() {
            return this.cardinality == ReferenceCardinality.OPTIONAL_MULTIPLE || this.cardinality == ReferenceCardinality.MANDATORY_MULTIPLE;
        }

        public boolean isCardinalityOptional() {
            return this.cardinality == ReferenceCardinality.OPTIONAL_UNARY || this.cardinality == ReferenceCardinality.OPTIONAL_MULTIPLE;
        }

        public ReferencePolicy getPolicy() {
            return this.policy;
        }

        public ReferencePolicyOption getPolicyOption() {
            return this.policyOption;
        }

        public String getBind() {
            return this.bind;
        }

        public String getUnbind() {
            return this.unbind;
        }

        public String getField() {
            return this.field;
        }

        public String getTarget() {
            return this.target;
        }

        public Integer getParameter() {
            return this.parameter;
        }

        public boolean isConstructorParameter() {
            return this.parameter != null;
        }

        public boolean matchesTargetFilter(ServiceReference<?> serviceReference) {
            if (this.targetFilter == null) {
                return true;
            }
            return this.targetFilter.match(serviceReference);
        }

        public FieldCollectionType getFieldCollectionType() {
            return this.fieldCollectionType;
        }

        private static ReferenceCardinality toCardinality(String value) {
            for (ReferenceCardinality item : ReferenceCardinality.values()) {
                if (!StringUtils.equals((CharSequence)item.getCardinalityString(), (CharSequence)value)) continue;
                return item;
            }
            return ReferenceCardinality.MANDATORY_UNARY;
        }

        private static ReferencePolicy toPolicy(String value) {
            for (ReferencePolicy item : ReferencePolicy.values()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)item.name(), (CharSequence)value)) continue;
                return item;
            }
            return ReferencePolicy.STATIC;
        }

        private static ReferencePolicyOption toPolicyOption(String value) {
            for (ReferencePolicyOption item : ReferencePolicyOption.values()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)item.name(), (CharSequence)value)) continue;
                return item;
            }
            return ReferencePolicyOption.RELUCTANT;
        }

        private static FieldCollectionType toFieldCollectionType(String value) {
            for (FieldCollectionType item : FieldCollectionType.values()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)item.name(), (CharSequence)value)) continue;
                return item;
            }
            return FieldCollectionType.SERVICE;
        }
    }

    static class OsgiMetadata {
        private final Class<?> clazz;
        private final String name;
        private final String[] configurationPID;
        private final Set<String> serviceInterfaces;
        private final Map<String, Object> properties;
        private final List<Reference> references;
        private final String activateMethodName;
        private final String deactivateMethodName;
        private final String modifiedMethodName;

        private OsgiMetadata(Class<?> clazz, Document metadataDocument) {
            this.clazz = clazz;
            this.name = OsgiMetadataUtil.getComponentName(clazz, metadataDocument);
            this.configurationPID = OsgiMetadataUtil.getConfigurationPID(clazz, metadataDocument);
            this.serviceInterfaces = OsgiMetadataUtil.getServiceInterfaces(clazz, metadataDocument);
            this.properties = OsgiMetadataUtil.getProperties(clazz, metadataDocument);
            this.references = OsgiMetadataUtil.getReferences(clazz, metadataDocument);
            this.activateMethodName = OsgiMetadataUtil.getLifecycleMethodName(clazz, metadataDocument, "activate");
            this.deactivateMethodName = OsgiMetadataUtil.getLifecycleMethodName(clazz, metadataDocument, "deactivate");
            this.modifiedMethodName = OsgiMetadataUtil.getLifecycleMethodName(clazz, metadataDocument, "modified");
        }

        private OsgiMetadata() {
            this.clazz = null;
            this.name = null;
            this.configurationPID = null;
            this.serviceInterfaces = null;
            this.properties = null;
            this.references = null;
            this.activateMethodName = null;
            this.deactivateMethodName = null;
            this.modifiedMethodName = null;
        }

        public Class<?> getServiceClass() {
            return this.clazz;
        }

        public String getName() {
            return this.name;
        }

        public String getPID() {
            String pid = null;
            if (this.properties != null) {
                pid = (String)this.properties.get("service.pid");
            }
            return StringUtils.defaultString(pid, (String)this.name);
        }

        public String[] getConfigurationPID() {
            return this.configurationPID;
        }

        public Set<String> getServiceInterfaces() {
            return this.serviceInterfaces;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public List<Reference> getReferences() {
            return this.references;
        }

        public String getActivateMethodName() {
            return this.activateMethodName;
        }

        public String getDeactivateMethodName() {
            return this.deactivateMethodName;
        }

        public String getModifiedMethodName() {
            return this.modifiedMethodName;
        }
    }
}

