/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Set;
import org.apache.sling.testing.mock.osgi.MapUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;

class MockConfiguration
implements Configuration {
    private final String pid;
    private Dictionary<String, Object> props;

    public MockConfiguration(String pid) {
        this.pid = pid;
        this.props = MockConfiguration.newConfig(pid);
    }

    public String getPid() {
        return this.pid;
    }

    public Dictionary<String, Object> getProperties() {
        return new Hashtable<String, Object>(MapUtil.toMap(this.props));
    }

    public void update() {
    }

    public void update(Dictionary properties) {
        this.props = new Hashtable(MapUtil.toMap(properties));
        this.props.put("service.pid", this.pid);
        this.update();
    }

    public void delete() {
        this.props = MockConfiguration.newConfig(this.pid);
    }

    public String toString() {
        return this.props.toString();
    }

    private static Dictionary<String, Object> newConfig(String pid) {
        Hashtable<String, Object> config = new Hashtable<String, Object>();
        ((Dictionary)config).put("service.pid", pid);
        return config;
    }

    public void setBundleLocation(String bundleLocation) {
        throw new UnsupportedOperationException();
    }

    public String getBundleLocation() {
        throw new UnsupportedOperationException();
    }

    public String getFactoryPid() {
        throw new UnsupportedOperationException();
    }

    public long getChangeCount() {
        throw new UnsupportedOperationException();
    }

    public Dictionary<String, Object> getProcessedProperties(ServiceReference<?> reference) {
        throw new UnsupportedOperationException();
    }

    public boolean updateIfDifferent(Dictionary<String, ?> properties) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void addAttributes(Configuration.ConfigurationAttribute ... attrs) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Set<Configuration.ConfigurationAttribute> getAttributes() {
        throw new UnsupportedOperationException();
    }

    public void removeAttributes(Configuration.ConfigurationAttribute ... attrs) throws IOException {
        throw new UnsupportedOperationException();
    }
}

