/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.osgi.OsgiServiceUtilTest;
import org.apache.sling.testing.mock.osgi.junit.OsgiContext;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.osgi.framework.BundleContext;

public class OsgiServiceRegisterTest {
    @Rule
    public OsgiContext context = new OsgiContext();

    @Test
    public void testRegisterClassesFromMetadata() {
        this.context.registerInjectActivateService(new OsgiServiceUtilTest.Service2());
        Assert.assertEquals((long)1L, (long)((OsgiServiceUtilTest.ServiceInterface2[])this.context.getServices(OsgiServiceUtilTest.ServiceInterface2.class, null)).length);
        Assert.assertEquals((long)1L, (long)((OsgiServiceUtilTest.ServiceInterface3[])this.context.getServices(OsgiServiceUtilTest.ServiceInterface3.class, null)).length);
    }

    @Test
    public void testRegisterExplicitClass1() {
        OsgiServiceUtilTest.Service2 service = new OsgiServiceUtilTest.Service2();
        MockOsgi.injectServices((Object)service, (BundleContext)this.context.bundleContext());
        MockOsgi.activate((Object)service, (BundleContext)this.context.bundleContext());
        this.context.registerService(OsgiServiceUtilTest.ServiceInterface2.class, service);
        Assert.assertEquals((long)1L, (long)((OsgiServiceUtilTest.ServiceInterface2[])this.context.getServices(OsgiServiceUtilTest.ServiceInterface2.class, null)).length);
        Assert.assertEquals((long)0L, (long)((OsgiServiceUtilTest.ServiceInterface3[])this.context.getServices(OsgiServiceUtilTest.ServiceInterface3.class, null)).length);
    }

    @Test
    public void testRegisterExplicitClass2() {
        OsgiServiceUtilTest.Service2 service = new OsgiServiceUtilTest.Service2();
        MockOsgi.injectServices((Object)service, (BundleContext)this.context.bundleContext());
        MockOsgi.activate((Object)service, (BundleContext)this.context.bundleContext());
        this.context.registerService(OsgiServiceUtilTest.ServiceInterface3.class, service);
        Assert.assertEquals((long)0L, (long)((OsgiServiceUtilTest.ServiceInterface2[])this.context.getServices(OsgiServiceUtilTest.ServiceInterface2.class, null)).length);
        Assert.assertEquals((long)1L, (long)((OsgiServiceUtilTest.ServiceInterface3[])this.context.getServices(OsgiServiceUtilTest.ServiceInterface3.class, null)).length);
    }

    @Test
    public void testRegisterExplicitClass3() {
        OsgiServiceUtilTest.Service2 service = new OsgiServiceUtilTest.Service2();
        MockOsgi.injectServices((Object)service, (BundleContext)this.context.bundleContext());
        MockOsgi.activate((Object)service, (BundleContext)this.context.bundleContext());
        this.context.registerService(OsgiServiceUtilTest.ServiceInterface2.class, service);
        this.context.registerService(OsgiServiceUtilTest.ServiceInterface3.class, service);
        Assert.assertEquals((long)1L, (long)((OsgiServiceUtilTest.ServiceInterface2[])this.context.getServices(OsgiServiceUtilTest.ServiceInterface2.class, null)).length);
        Assert.assertEquals((long)1L, (long)((OsgiServiceUtilTest.ServiceInterface3[])this.context.getServices(OsgiServiceUtilTest.ServiceInterface3.class, null)).length);
    }

    @Test
    public void testInjectMandatoryUnaryReferenceOutOfMultipleServices() {
        this.context.registerService(OsgiServiceUtilTest.ServiceInterface2.class, Mockito.mock(OsgiServiceUtilTest.ServiceInterface2.class));
        OsgiServiceUtilTest.ServiceInterface1 service1_ranking100 = (OsgiServiceUtilTest.ServiceInterface1)Mockito.mock(OsgiServiceUtilTest.ServiceInterface1.class);
        this.context.registerService(OsgiServiceUtilTest.ServiceInterface1.class, service1_ranking100, new Object[]{"service.ranking", 100});
        OsgiServiceUtilTest.ServiceInterface1 service1_ranking200 = (OsgiServiceUtilTest.ServiceInterface1)Mockito.mock(OsgiServiceUtilTest.ServiceInterface1.class);
        this.context.registerService(OsgiServiceUtilTest.ServiceInterface1.class, service1_ranking200, new Object[]{"service.ranking", 200});
        OsgiServiceUtilTest.ServiceInterface1 service1_ranking10 = (OsgiServiceUtilTest.ServiceInterface1)Mockito.mock(OsgiServiceUtilTest.ServiceInterface1.class);
        this.context.registerService(OsgiServiceUtilTest.ServiceInterface1.class, service1_ranking10, new Object[]{"service.ranking", 10});
        OsgiServiceUtilTest.Service3 service3 = (OsgiServiceUtilTest.Service3)this.context.registerInjectActivateService(new OsgiServiceUtilTest.Service3());
        Assert.assertSame((Object)service1_ranking200, (Object)service3.getReference1());
    }
}

