/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.osgi.OsgiMetadataUtilTest;
import org.apache.sling.testing.mock.osgi.junit.OsgiContext;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class MockConfigurationAdminTest {
    private static final String[] TEST_ADAPTABLES = new String[]{"adaptable1", "adaptable2"};
    @Rule
    public OsgiContext context = new OsgiContext();

    @Test
    public void testGetConfigurationString() throws IOException {
        MockOsgi.setConfigForPid((BundleContext)this.context.bundleContext(), (String)"org.apache.sling.testing.mock.osgi.OsgiMetadataUtilTest$ServiceWithMetadata", (Object[])new Object[]{"service.ranking", 3000, "adaptables", TEST_ADAPTABLES, "prop2", 2});
        this.context.registerInjectActivateService(new OsgiMetadataUtilTest.ServiceWithMetadata(), (Map)ImmutableMap.builder().put((Object)"service.ranking", (Object)4000).put((Object)"prop1", (Object)1).build());
        ServiceReference reference = this.context.bundleContext().getServiceReference(Comparable.class.getName());
        Assert.assertEquals((Object)4000, (Object)reference.getProperty("service.ranking"));
        Assert.assertEquals((Object)1, (Object)reference.getProperty("prop1"));
        Assert.assertArrayEquals((Object[])TEST_ADAPTABLES, (Object[])((String[])reference.getProperty("adaptables")));
        Assert.assertEquals((Object)2, (Object)reference.getProperty("prop2"));
        Assert.assertEquals((Object)"The Apache Software Foundation", (Object)reference.getProperty("service.vendor"));
        Assert.assertEquals((Object)"org.apache.sling.testing.mock.osgi.OsgiMetadataUtilTest$ServiceWithMetadata", (Object)reference.getProperty("service.pid"));
    }

    @Test
    public void testConfigurationPID() throws IOException {
        MockOsgi.setConfigForPid((BundleContext)this.context.bundleContext(), (String)ServiceWithConfigurationPID.class.getSimpleName(), (Object[])new Object[]{"prop1", 1});
        this.context.registerInjectActivateService(new ServiceWithConfigurationPID(), (Map)ImmutableMap.builder().put((Object)"prop2", (Object)2).build());
        ServiceReference reference = this.context.bundleContext().getServiceReference(Comparable.class.getName());
        Assert.assertEquals((Object)1, (Object)reference.getProperty("prop1"));
        Assert.assertEquals((Object)2, (Object)reference.getProperty("prop2"));
    }

    @Test
    public void testMultipleConfigurationPID() throws IOException {
        MockOsgi.setConfigForPid((BundleContext)this.context.bundleContext(), (String)"Configuration1", (Object[])new Object[]{"prop1", 1});
        MockOsgi.setConfigForPid((BundleContext)this.context.bundleContext(), (String)"Configuration2", (Object[])new Object[]{"prop1", 2});
        this.context.registerInjectActivateService(new ServiceWithMultipleConfigurationPID(), (Map)ImmutableMap.builder().put((Object)"prop2", (Object)2).build());
        ServiceReference reference = this.context.bundleContext().getServiceReference(Comparable.class.getName());
        Assert.assertEquals((Object)2, (Object)reference.getProperty("prop1"));
        Assert.assertEquals((Object)2, (Object)reference.getProperty("prop2"));
    }

    static class ServiceWithMultipleConfigurationPID {
        ServiceWithMultipleConfigurationPID() {
        }
    }

    static class ServiceWithConfigurationPID {
        ServiceWithConfigurationPID() {
        }
    }
}

