/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import org.apache.sling.testing.mock.osgi.MapUtil;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.osgi.OsgiServiceUtilTest;
import org.apache.sling.testing.mock.osgi.ReferenceViolationException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@RunWith(value=MockitoJUnitRunner.class)
public class MockBundleContextDynamicReferencesOsgiR6Test {
    private BundleContext bundleContext;
    private OsgiServiceUtilTest.Service3OsgiR6 service;
    private ServiceRegistration reg1a;
    private ServiceRegistration reg2a;
    @Mock
    private OsgiServiceUtilTest.ServiceInterface1 dependency1a;
    @Mock
    private OsgiServiceUtilTest.ServiceInterface1 dependency1b;
    @Mock
    private OsgiServiceUtilTest.ServiceInterface1Optional dependency1aOptional;
    @Mock
    private OsgiServiceUtilTest.ServiceInterface1Optional dependency1bOptional;
    @Mock
    private OsgiServiceUtilTest.ServiceInterface2 dependency2a;
    @Mock
    private OsgiServiceUtilTest.ServiceInterface2 dependency2b;
    @Mock
    private OsgiServiceUtilTest.ServiceSuperInterface3 dependency3a;
    @Mock
    private OsgiServiceUtilTest.ServiceSuperInterface3 dependency3b;
    @Mock
    private OsgiServiceUtilTest.ServiceSuperInterface3 dependency3c;

    @Before
    public void setUp() {
        this.bundleContext = MockOsgi.newBundleContext();
        this.reg1a = this.bundleContext.registerService(OsgiServiceUtilTest.ServiceInterface1.class.getName(), (Object)this.dependency1a, null);
        this.reg2a = this.bundleContext.registerService(OsgiServiceUtilTest.ServiceInterface2.class.getName(), (Object)this.dependency2a, null);
        this.service = new OsgiServiceUtilTest.Service3OsgiR6();
        MockOsgi.injectServices((Object)this.service, (BundleContext)this.bundleContext);
        MockOsgi.activate((Object)this.service, (BundleContext)this.bundleContext);
        this.bundleContext.registerService(OsgiServiceUtilTest.Service3OsgiR6.class.getName(), (Object)this.service, MapUtil.toDictionary((Map)ImmutableMap.of((Object)"reference3DynamicFiltered.target", (Object)"(prop1=def)")));
        this.assertDependency1(this.dependency1a);
        this.assertDependency1Optional(null);
        this.assertDependencies2(this.dependency2a);
        this.assertDependencies3(new OsgiServiceUtilTest.ServiceSuperInterface3[0]);
    }

    @Test
    public void testAddRemoveOptionalUnaryService() {
        ServiceRegistration reg1aOptional = this.bundleContext.registerService(OsgiServiceUtilTest.ServiceInterface1Optional.class.getName(), (Object)this.dependency1aOptional, null);
        this.assertDependency1Optional(this.dependency1aOptional);
        reg1aOptional.unregister();
        this.assertDependency1Optional(null);
    }

    public void testAddOptionalUnaryService_TooMany() {
        this.bundleContext.registerService(OsgiServiceUtilTest.ServiceInterface1Optional.class.getName(), (Object)this.dependency1aOptional, null);
        this.assertDependency1Optional(this.dependency1aOptional);
        this.bundleContext.registerService(OsgiServiceUtilTest.ServiceInterface1Optional.class.getName(), (Object)this.dependency1bOptional, null);
        this.assertDependency1Optional(this.dependency1bOptional);
    }

    @Test(expected=ReferenceViolationException.class)
    public void testAddMandatoryUnaryService_TooMany() {
        this.bundleContext.registerService(OsgiServiceUtilTest.ServiceInterface1.class.getName(), (Object)this.dependency1b, null);
    }

    @Test(expected=ReferenceViolationException.class)
    public void testRemoveMandatoryUnaryService_TooMany() {
        this.reg1a.unregister();
    }

    @Test
    public void testAddRemoveOptionalMultipleService() {
        ServiceRegistration reg3a = this.bundleContext.registerService(OsgiServiceUtilTest.ServiceInterface3.class.getName(), (Object)this.dependency3a, null);
        this.assertDependencies3(this.dependency3a);
        ServiceRegistration reg3b = this.bundleContext.registerService(OsgiServiceUtilTest.ServiceInterface3.class.getName(), (Object)this.dependency3b, null);
        this.assertDependencies3(this.dependency3a, this.dependency3b);
        reg3a.unregister();
        this.assertDependencies3(this.dependency3b);
        reg3b.unregister();
        this.assertDependencies3(new OsgiServiceUtilTest.ServiceSuperInterface3[0]);
    }

    @Test
    public void testAddRemoveMandatoryMultipleService() {
        ServiceRegistration reg2b = this.bundleContext.registerService(OsgiServiceUtilTest.ServiceInterface2.class.getName(), (Object)this.dependency2b, null);
        this.assertDependencies2(this.dependency2a, this.dependency2b);
        reg2b.unregister();
        this.assertDependencies2(this.dependency2a);
        this.reg2a.unregister();
        this.assertDependencies2(new OsgiServiceUtilTest.ServiceInterface2[0]);
    }

    @Test
    public void testReferenceWithTargetFilter() {
        this.assertDependencies3Filtered(new OsgiServiceUtilTest.ServiceSuperInterface3[0]);
        this.bundleContext.registerService(OsgiServiceUtilTest.ServiceInterface3.class.getName(), (Object)this.dependency3a, MapUtil.toDictionary((Map)ImmutableMap.of((Object)"prop1", (Object)"abc")));
        this.bundleContext.registerService(OsgiServiceUtilTest.ServiceInterface3.class.getName(), (Object)this.dependency3b, MapUtil.toDictionary((Map)ImmutableMap.of((Object)"prop1", (Object)"def")));
        this.assertDependencies3Filtered(this.dependency3a);
    }

    @Test
    public void testReferenceWithDynamicTargetFilter() {
        this.assertDependencies3DynamicFiltered(null);
        this.bundleContext.registerService(OsgiServiceUtilTest.ServiceInterface3.class.getName(), (Object)this.dependency3a, MapUtil.toDictionary((Map)ImmutableMap.of((Object)"prop1", (Object)"abc")));
        this.bundleContext.registerService(OsgiServiceUtilTest.ServiceInterface3.class.getName(), (Object)this.dependency3b, MapUtil.toDictionary((Map)ImmutableMap.of((Object)"prop1", (Object)"def")));
        this.bundleContext.registerService(OsgiServiceUtilTest.ServiceInterface3.class.getName(), (Object)this.dependency3c, MapUtil.toDictionary((Map)ImmutableMap.of((Object)"prop1", (Object)"hij")));
        this.assertDependencies3DynamicFiltered(this.dependency3b);
    }

    private void assertDependency1(OsgiServiceUtilTest.ServiceInterface1 instance) {
        if (instance == null) {
            Assert.assertNull((Object)this.service.getReference1());
        } else {
            Assert.assertSame((Object)instance, (Object)this.service.getReference1());
        }
    }

    private void assertDependency1Optional(OsgiServiceUtilTest.ServiceInterface1Optional instance) {
        if (instance == null) {
            Assert.assertNull((Object)this.service.getReference1Optional());
        } else {
            Assert.assertSame((Object)instance, (Object)this.service.getReference1Optional());
        }
    }

    private void assertDependencies2(OsgiServiceUtilTest.ServiceInterface2 ... instances) {
        Assert.assertEquals((Object)ImmutableSet.copyOf((Object[])instances), (Object)ImmutableSet.copyOf(this.service.getReferences2()));
    }

    private void assertDependencies3(OsgiServiceUtilTest.ServiceSuperInterface3 ... instances) {
        Assert.assertEquals((Object)ImmutableSet.copyOf((Object[])instances), (Object)ImmutableSet.copyOf(this.service.getReferences3()));
    }

    private void assertDependencies3Filtered(OsgiServiceUtilTest.ServiceSuperInterface3 ... instances) {
        Assert.assertEquals((Object)ImmutableSet.copyOf((Object[])instances), (Object)ImmutableSet.copyOf(this.service.getReferences3Filtered()));
    }

    private void assertDependencies3DynamicFiltered(OsgiServiceUtilTest.ServiceSuperInterface3 instance) {
        Assert.assertEquals((Object)instance, (Object)this.service.getReference3DynamicFiltered());
    }
}

