/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.sling.testing.mock.osgi.MapUtil;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.osgi.NoScrMetadataException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

public class OsgiServiceUtilTest {
    private BundleContext bundleContext = MockOsgi.newBundleContext();
    private Service1 service1;
    private Service2 service2;

    @Before
    public void setUp() {
        this.service1 = new Service1();
        this.service2 = new Service2();
        this.bundleContext.registerService(ServiceInterface1.class.getName(), (Object)this.service1, null);
        this.bundleContext.registerService(ServiceInterface2.class.getName(), (Object)this.service2, null);
    }

    @After
    public void tearDown() {
        MockOsgi.shutdown((BundleContext)this.bundleContext);
    }

    @Test
    public void testService3() {
        Service3 service3 = new Service3();
        Assert.assertTrue((boolean)MockOsgi.injectServices((Object)service3, (BundleContext)this.bundleContext));
        Hashtable<String, String> service3Config = new Hashtable<String, String>();
        ((Dictionary)service3Config).put("prop1", "value1");
        Assert.assertTrue((boolean)MockOsgi.activate((Object)service3, (BundleContext)this.bundleContext, service3Config));
        Assert.assertNotNull((Object)service3.getComponentContext());
        Assert.assertEquals(((Dictionary)service3Config).get("prop1"), service3.getComponentContext().getProperties().get("prop1"));
        Assert.assertSame((Object)this.service1, (Object)service3.getReference1());
        List<ServiceInterface2> references2 = service3.getReferences2();
        Assert.assertEquals((long)1L, (long)references2.size());
        Assert.assertSame((Object)this.service2, (Object)references2.get(0));
        List<ServiceSuperInterface3> references3 = service3.getReferences3();
        Assert.assertEquals((long)1L, (long)references3.size());
        Assert.assertSame((Object)this.service2, (Object)references3.get(0));
        List<Map<String, Object>> reference3Configs = service3.getReference3Configs();
        Assert.assertEquals((long)1L, (long)reference3Configs.size());
        Assert.assertEquals((Object)200, (Object)reference3Configs.get(0).get("service.ranking"));
        Assert.assertTrue((boolean)MockOsgi.deactivate((Object)service3, (BundleContext)this.bundleContext));
        Assert.assertNull((Object)service3.getComponentContext());
    }

    @Test
    public void testService3_Config() {
        BundleContext bundleContext = MockOsgi.newBundleContext();
        ImmutableMap initialProperites = ImmutableMap.of((Object)"prop1", (Object)"value1");
        Service3 service3 = new Service3();
        MockOsgi.activate((Object)service3, (BundleContext)bundleContext, (Map)initialProperites);
        Assert.assertEquals(initialProperites.get("prop1"), (Object)service3.getConfig().get("prop1"));
        ImmutableMap newProperties = ImmutableMap.of((Object)"prop2", (Object)"value2");
        MockOsgi.modified((Object)service3, (BundleContext)bundleContext, (Map)newProperties);
        Assert.assertEquals(newProperties.get("prop2"), (Object)service3.getConfig().get("prop2"));
        newProperties = ImmutableMap.of((Object)"prop3", (Object)"value3");
        Hashtable newPropertiesDictonary = new Hashtable(newProperties);
        MockOsgi.modified((Object)service3, (BundleContext)bundleContext, newPropertiesDictonary);
        Assert.assertEquals(newProperties.get("prop3"), (Object)service3.getConfig().get("prop3"));
        MockOsgi.modified((Object)service3, (BundleContext)bundleContext, (Object[])new Object[]{"prop3", "value4"});
        Assert.assertEquals((Object)"value4", (Object)service3.getConfig().get("prop3"));
    }

    @Test
    public void testService4() {
        Service4 service4 = new Service4();
        Assert.assertTrue((boolean)MockOsgi.injectServices((Object)service4, (BundleContext)this.bundleContext));
        Assert.assertFalse((boolean)MockOsgi.activate((Object)service4, (BundleContext)this.bundleContext));
        Assert.assertSame((Object)this.service1, (Object)service4.getReference1());
    }

    @Test(expected=NoScrMetadataException.class)
    public void testInjectServicesNoMetadata() {
        MockOsgi.injectServices((Object)new Object(), (BundleContext)MockOsgi.newBundleContext());
    }

    @Test(expected=NoScrMetadataException.class)
    public void testActivateNoMetadata() {
        MockOsgi.activate((Object)new Object(), (BundleContext)this.bundleContext);
    }

    @Test(expected=NoScrMetadataException.class)
    public void testDeactivateNoMetadata() {
        MockOsgi.deactivate((Object)new Object(), (BundleContext)this.bundleContext);
    }

    @Test(expected=NoScrMetadataException.class)
    public void testModifiedNoMetadata() {
        MockOsgi.modified((Object)new Object(), (BundleContext)MockOsgi.newBundleContext(), (Map)ImmutableMap.of());
    }

    @Test
    public void testMockedService() {
        Service5 service5 = (Service5)Mockito.spy((Object)new Service5());
        ((Service5)Mockito.doReturn((Object)true).when((Object)service5)).doRemoteThing();
        MockOsgi.injectServices((Object)service5, (BundleContext)this.bundleContext);
        MockOsgi.activate((Object)service5, (BundleContext)this.bundleContext, (Dictionary)null);
        this.bundleContext.registerService(ServiceInterface5.class.getName(), (Object)service5, null);
        Assert.assertSame((Object)service5, (Object)this.bundleContext.getService(this.bundleContext.getServiceReference(ServiceInterface5.class.getName())));
        Assert.assertEquals((Object)true, (Object)service5.doRemoteThing());
    }

    @Test
    public void testServiceFactoryViaScr() {
        ServiceFactory1 serviceFactory1 = new ServiceFactory1();
        MockOsgi.injectServices((Object)serviceFactory1, (BundleContext)this.bundleContext);
        MockOsgi.activate((Object)serviceFactory1, (BundleContext)this.bundleContext, (Dictionary)null);
        this.bundleContext.registerService(ServiceFactory1.class.getName(), (Object)serviceFactory1, null);
        Assert.assertSame((Object)serviceFactory1, (Object)this.bundleContext.getService(this.bundleContext.getServiceReference(ServiceFactory1.class.getName())));
    }

    @Test
    public void testServiceFactoryViaManualRegistration() {
        final ServiceFactory1 serviceFactory1 = new ServiceFactory1();
        this.bundleContext.registerService(ServiceFactory1.class.getName(), (Object)new ServiceFactory(){

            public Object getService(Bundle bundle, ServiceRegistration registration) {
                return serviceFactory1;
            }

            public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
            }
        }, null);
        Assert.assertSame((Object)serviceFactory1, (Object)this.bundleContext.getService(this.bundleContext.getServiceReference(ServiceFactory1.class.getName())));
    }

    @Component(service={ServiceFactory1.class}, servicefactory=true)
    public static class ServiceFactory1 {
    }

    public static interface ServiceInterface5 {
        public boolean doRemoteThing();
    }

    @Component(service={ServiceInterface5.class})
    public static class Service5
    implements ServiceInterface5 {
        @Override
        public boolean doRemoteThing() {
            return false;
        }
    }

    @Component(reference={@Reference(service=ServiceInterface1.class, name="customName", bind="customBind", unbind="customUnbind")})
    public static class Service4 {
        private ServiceInterface1 reference1;

        public ServiceInterface1 getReference1() {
            return this.reference1;
        }

        protected void customBind(ServiceInterface1 service) {
            this.reference1 = service;
        }

        protected void customUnbind(ServiceInterface1 service) {
            this.reference1 = null;
        }
    }

    @Component(reference={@Reference(name="reference2", service=ServiceInterface2.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, bind="bindReference2", unbind="unbindReference2")})
    public static class Service3StaticGreedy {
        @Reference(bind="bindReference1", unbind="unbindReference1")
        private ServiceInterface1 reference1;
        @Reference(cardinality=ReferenceCardinality.OPTIONAL, bind="bindReference1Optional", unbind="unbindReference1Optional")
        private ServiceInterface1Optional reference1Optional;
        private List<ServiceReference> references2 = new ArrayList<ServiceReference>();
        @Reference(name="reference3", service=ServiceInterface3.class, cardinality=ReferenceCardinality.MULTIPLE, bind="bindReference3", unbind="unbindReference3")
        private List<ServiceSuperInterface3> references3 = new ArrayList<ServiceSuperInterface3>();
        private List<Map<String, Object>> reference3Configs = new ArrayList<Map<String, Object>>();
        private ComponentContext componentContext;
        private Map<String, Object> config;

        @Activate
        private void activate(ComponentContext ctx) {
            this.componentContext = ctx;
            this.config = MapUtil.toMap((Dictionary)ctx.getProperties());
        }

        @Deactivate
        private void deactivate(ComponentContext ctx) {
            this.componentContext = null;
        }

        @Modified
        private void modified(Map<String, Object> newConfig) {
            this.config = newConfig;
        }

        public ServiceInterface1 getReference1() {
            return this.reference1;
        }

        public ServiceInterface1Optional getReference1Optional() {
            return this.reference1Optional;
        }

        public List<ServiceInterface2> getReferences2() {
            ArrayList<ServiceInterface2> services = new ArrayList<ServiceInterface2>();
            for (ServiceReference serviceReference : this.references2) {
                services.add((ServiceInterface2)this.componentContext.getBundleContext().getService(serviceReference));
            }
            return services;
        }

        public List<ServiceSuperInterface3> getReferences3() {
            return this.references3;
        }

        public List<Map<String, Object>> getReference3Configs() {
            return this.reference3Configs;
        }

        public ComponentContext getComponentContext() {
            return this.componentContext;
        }

        public Map<String, Object> getConfig() {
            return this.config;
        }

        protected void bindReference1Optional(ServiceInterface1Optional service) {
            this.reference1Optional = service;
        }

        protected void unbindReference1Optional(ServiceInterface1Optional service) {
            this.reference1Optional = null;
        }

        protected void bindReference1(ServiceInterface1 service) {
            this.reference1 = service;
        }

        protected void unbindReference1(ServiceInterface1 service) {
            this.reference1 = null;
        }

        protected void bindReference2(ServiceReference serviceReference) {
            this.references2.add(serviceReference);
        }

        protected void unbindReference2(ServiceReference serviceReference) {
            this.references2.remove(serviceReference);
        }

        protected void bindReference3(ServiceSuperInterface3 service, Map<String, Object> serviceConfig) {
            this.references3.add(service);
            this.reference3Configs.add(serviceConfig);
        }

        protected void unbindReference3(ServiceSuperInterface3 service, Map<String, Object> serviceConfig) {
            this.references3.remove(service);
            this.reference3Configs.remove(serviceConfig);
        }
    }

    public static class Service3OsgiR6 {
        private ServiceInterface1 reference1;
        private ServiceInterface1Optional reference1Optional;
        private List<ServiceReference> references2;
        private List<ServiceSuperInterface3> references3;
        private List<ServiceSuperInterface3> references3Filtered;
        private ServiceSuperInterface3 reference3DynamicFiltered;
        private ComponentContext componentContext;
        private Map<String, Object> config;

        @Activate
        private void activate(ComponentContext ctx) {
            this.componentContext = ctx;
            this.config = MapUtil.toMap((Dictionary)ctx.getProperties());
        }

        @Deactivate
        private void deactivate(ComponentContext ctx) {
            this.componentContext = null;
        }

        @Modified
        private void modified(Map<String, Object> newConfig) {
            this.config = newConfig;
        }

        public ServiceInterface1 getReference1() {
            return this.reference1;
        }

        public ServiceInterface1Optional getReference1Optional() {
            return this.reference1Optional;
        }

        public List<ServiceInterface2> getReferences2() {
            ArrayList<ServiceInterface2> services = new ArrayList<ServiceInterface2>();
            for (ServiceReference serviceReference : this.references2) {
                services.add((ServiceInterface2)this.componentContext.getBundleContext().getService(serviceReference));
            }
            return services;
        }

        public List<ServiceSuperInterface3> getReferences3() {
            return this.references3;
        }

        public List<ServiceSuperInterface3> getReferences3Filtered() {
            return this.references3Filtered;
        }

        public ServiceSuperInterface3 getReference3DynamicFiltered() {
            return this.reference3DynamicFiltered;
        }

        public ComponentContext getComponentContext() {
            return this.componentContext;
        }

        public Map<String, Object> getConfig() {
            return this.config;
        }
    }

    @Component(reference={@Reference(name="reference2", service=ServiceInterface2.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, bind="bindReference2", unbind="unbindReference2")})
    public static class Service3 {
        @Reference(bind="bindReference1", unbind="unbindReference1")
        private ServiceInterface1 reference1;
        @Reference(cardinality=ReferenceCardinality.OPTIONAL, bind="bindReference1Optional", unbind="unbindReference1Optional")
        private ServiceInterface1Optional reference1Optional;
        private List<ServiceReference> references2 = new ArrayList<ServiceReference>();
        @Reference(name="reference3", service=ServiceInterface3.class, cardinality=ReferenceCardinality.MULTIPLE, bind="bindReference3", unbind="unbindReference3")
        private List<ServiceSuperInterface3> references3 = new ArrayList<ServiceSuperInterface3>();
        private List<Map<String, Object>> reference3Configs = new ArrayList<Map<String, Object>>();
        private ComponentContext componentContext;
        private Map<String, Object> config;

        @Activate
        private void activate(ComponentContext ctx) {
            this.componentContext = ctx;
            this.config = MapUtil.toMap((Dictionary)ctx.getProperties());
        }

        @Deactivate
        private void deactivate(ComponentContext ctx) {
            this.componentContext = null;
        }

        @Modified
        private void modified(Map<String, Object> newConfig) {
            this.config = newConfig;
        }

        public ServiceInterface1 getReference1() {
            return this.reference1;
        }

        public ServiceInterface1Optional getReference1Optional() {
            return this.reference1Optional;
        }

        public List<ServiceInterface2> getReferences2() {
            ArrayList<ServiceInterface2> services = new ArrayList<ServiceInterface2>();
            for (ServiceReference serviceReference : this.references2) {
                services.add((ServiceInterface2)this.componentContext.getBundleContext().getService(serviceReference));
            }
            return services;
        }

        public List<ServiceSuperInterface3> getReferences3() {
            return this.references3;
        }

        public List<Map<String, Object>> getReference3Configs() {
            return this.reference3Configs;
        }

        public ComponentContext getComponentContext() {
            return this.componentContext;
        }

        public Map<String, Object> getConfig() {
            return this.config;
        }

        protected void bindReference1Optional(ServiceInterface1Optional service) {
            this.reference1Optional = service;
        }

        protected void unbindReference1Optional(ServiceInterface1Optional service) {
            this.reference1Optional = null;
        }

        protected void bindReference1(ServiceInterface1 service) {
            this.reference1 = service;
        }

        protected void unbindReference1(ServiceInterface1 service) {
            this.reference1 = null;
        }

        protected void bindReference2(ServiceReference serviceReference) {
            this.references2.add(serviceReference);
        }

        protected void unbindReference2(ServiceReference serviceReference) {
            this.references2.remove(serviceReference);
        }

        protected void bindReference3(ServiceSuperInterface3 service, Map<String, Object> serviceConfig) {
            this.references3.add(service);
            this.reference3Configs.add(serviceConfig);
        }

        protected void unbindReference3(ServiceSuperInterface3 service, Map<String, Object> serviceConfig) {
            this.references3.remove(service);
            this.reference3Configs.remove(serviceConfig);
        }
    }

    @Component(service={ServiceInterface2.class, ServiceInterface3.class}, property={"service.ranking:Integer=200"})
    public static class Service2
    implements ServiceInterface2,
    ServiceInterface3 {
    }

    @Component(service={ServiceInterface1.class}, property={"service.ranking:Integer=100"})
    public static class Service1
    implements ServiceInterface1 {
    }

    public static interface ServiceSuperInterface3 {
    }

    public static interface ServiceInterface3
    extends ServiceSuperInterface3 {
    }

    public static interface ServiceInterface2 {
    }

    public static interface ServiceInterface1Optional {
    }

    public static interface ServiceInterface1 {
    }
}

