/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.util.Arrays;
import java.util.Hashtable;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class MockServiceReferencesSortTest {
    private BundleContext bundleContext;

    @Before
    public void setUp() {
        this.bundleContext = MockOsgi.newBundleContext();
    }

    @After
    public void tearDown() {
        MockOsgi.shutdown((BundleContext)this.bundleContext);
    }

    @Test
    public void testAllWithRanking() {
        this.registerStringServiceWithRanking("A", 3);
        this.registerStringServiceWithRanking("B", 5);
        this.registerStringServiceWithRanking("C", 4);
        this.registerStringServiceWithRanking("D", 1);
        this.registerStringServiceWithRanking("E", 2);
        Assert.assertEquals((Object)"DEACB", (Object)this.getSortedServicesString());
        Assert.assertEquals((Object)"B", (Object)this.bundleContext.getService(this.bundleContext.getServiceReference(String.class)));
    }

    @Test
    public void testAllWithoutRanking() {
        this.registerStringServiceWithoutRanking("A");
        this.registerStringServiceWithoutRanking("B");
        this.registerStringServiceWithoutRanking("C");
        this.registerStringServiceWithoutRanking("D");
        this.registerStringServiceWithoutRanking("E");
        Assert.assertEquals((Object)"EDCBA", (Object)this.getSortedServicesString());
        Assert.assertEquals((Object)"A", (Object)this.bundleContext.getService(this.bundleContext.getServiceReference(String.class)));
    }

    @Test
    public void testMixed() {
        this.registerStringServiceWithoutRanking("A");
        this.registerStringServiceWithRanking("B", 5);
        this.registerStringServiceWithoutRanking("C");
        this.registerStringServiceWithRanking("D", 10);
        this.registerStringServiceWithoutRanking("E");
        Assert.assertEquals((Object)"ECABD", (Object)this.getSortedServicesString());
        Assert.assertEquals((Object)"D", (Object)this.bundleContext.getService(this.bundleContext.getServiceReference(String.class)));
    }

    private ServiceRegistration<?> registerStringServiceWithoutRanking(String serviceValue) {
        return this.bundleContext.registerService(String.class, (Object)serviceValue, new Hashtable());
    }

    private ServiceRegistration<?> registerStringServiceWithRanking(String serviceValue, int index) {
        Hashtable<String, Integer> props = new Hashtable<String, Integer>();
        props.put("service.ranking", new Integer(index));
        return this.bundleContext.registerService(String.class, (Object)serviceValue, props);
    }

    private String getSortedServicesString() {
        Object[] refs = null;
        try {
            refs = this.bundleContext.getServiceReferences(String.class.getName(), null);
        }
        catch (InvalidSyntaxException ise) {
            Assert.fail((String)"Unexpected InvalidSyntaxException");
        }
        Assert.assertNotNull((String)"Expecting our service references", (Object)refs);
        Arrays.sort(refs);
        StringBuilder sb = new StringBuilder();
        for (Object ref : refs) {
            sb.append(this.bundleContext.getService((ServiceReference)ref).toString());
            this.bundleContext.ungetService((ServiceReference)ref);
        }
        return sb.toString();
    }
}

