/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

@RunWith(value=MockitoJUnitRunner.class)
public class MockBundleContextTest {
    private BundleContext bundleContext;

    @Before
    public void setUp() {
        this.bundleContext = MockOsgi.newBundleContext();
    }

    @After
    public void tearDown() {
        MockOsgi.shutdown((BundleContext)this.bundleContext);
    }

    @Test
    public void testBundle() {
        Assert.assertNotNull((Object)this.bundleContext.getBundle());
    }

    @Test
    public void testServiceRegistration() throws InvalidSyntaxException {
        String[] clazzes1 = new String[]{String.class.getName(), Integer.class.getName()};
        Object service1 = new Object();
        Dictionary<String, Object> properties2 = MockBundleContextTest.ranking(null);
        ServiceRegistration reg1 = this.bundleContext.registerService(clazzes1, service1, properties2);
        String clazz2 = String.class.getName();
        Object service2 = new Object();
        Dictionary<String, Object> properties1 = MockBundleContextTest.ranking(null);
        ServiceRegistration reg2 = this.bundleContext.registerService(clazz2, service2, properties1);
        String clazz3 = Integer.class.getName();
        Object service3 = new Object();
        Dictionary<String, Object> properties3 = MockBundleContextTest.ranking(-100);
        ServiceRegistration reg3 = this.bundleContext.registerService(clazz3, service3, properties3);
        ServiceReference refString = this.bundleContext.getServiceReference(String.class.getName());
        Assert.assertSame((Object)reg1.getReference(), (Object)refString);
        ServiceReference refInteger = this.bundleContext.getServiceReference(Integer.class.getName());
        Assert.assertSame((Object)reg1.getReference(), (Object)refInteger);
        Object[] refsString = this.bundleContext.getServiceReferences(String.class.getName(), null);
        Assert.assertEquals((long)2L, (long)refsString.length);
        Assert.assertSame((Object)reg1.getReference(), (Object)refsString[0]);
        Assert.assertSame((Object)reg2.getReference(), (Object)refsString[1]);
        Collection refColString = this.bundleContext.getServiceReferences(String.class, null);
        Assert.assertEquals((long)2L, (long)refColString.size());
        Assert.assertSame((Object)reg1.getReference(), refColString.iterator().next());
        ServiceReference[] refsInteger = this.bundleContext.getServiceReferences(Integer.class.getName(), null);
        Assert.assertEquals((long)2L, (long)refsInteger.length);
        Assert.assertSame((Object)reg1.getReference(), (Object)refsInteger[0]);
        Assert.assertSame((Object)reg3.getReference(), (Object)refsInteger[1]);
        Object[] allRefsString = this.bundleContext.getAllServiceReferences(String.class.getName(), null);
        Assert.assertArrayEquals((Object[])refsString, (Object[])allRefsString);
        Assert.assertSame((Object)service1, (Object)this.bundleContext.getService((ServiceReference)refsString[0]));
        Assert.assertSame((Object)service2, (Object)this.bundleContext.getService((ServiceReference)refsString[1]));
        Assert.assertSame((Object)service1, (Object)this.bundleContext.getService(refInteger));
        this.bundleContext.ungetService((ServiceReference)refsString[0]);
        this.bundleContext.ungetService((ServiceReference)refsString[1]);
        this.bundleContext.ungetService(refInteger);
    }

    @Test
    public void testModifyServiceRegistration() throws InvalidSyntaxException {
        String service1 = "service";
        Hashtable<String, String> properties1 = new Hashtable<String, String>();
        ((Dictionary)properties1).put("a", "1");
        ((Dictionary)properties1).put("b", "2");
        final ArrayList events = new ArrayList();
        ServiceListener listener = new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                events.add(event);
            }
        };
        this.bundleContext.addServiceListener(listener);
        ServiceRegistration reg1 = this.bundleContext.registerService(String.class, (Object)service1, properties1);
        Assert.assertEquals((long)4L, (long)reg1.getReference().getPropertyKeys().length);
        Assert.assertNotNull((Object)reg1.getReference().getProperty("service.id"));
        Assert.assertNotNull((Object)reg1.getReference().getProperty("objectClass"));
        Assert.assertEquals((Object)"1", (Object)reg1.getReference().getProperty("a"));
        Assert.assertEquals((Object)"2", (Object)reg1.getReference().getProperty("b"));
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertEquals((long)1L, (long)((ServiceEvent)events.get(0)).getType());
        Assert.assertSame((Object)reg1.getReference(), (Object)((ServiceEvent)events.get(0)).getServiceReference());
        Hashtable<String, String> properties2 = new Hashtable<String, String>();
        ((Dictionary)properties2).put("a", "1");
        ((Dictionary)properties2).put("c", "3");
        reg1.setProperties(properties2);
        Assert.assertEquals((long)4L, (long)reg1.getReference().getPropertyKeys().length);
        Assert.assertNotNull((Object)reg1.getReference().getProperty("service.id"));
        Assert.assertNotNull((Object)reg1.getReference().getProperty("objectClass"));
        Assert.assertEquals((Object)"1", (Object)reg1.getReference().getProperty("a"));
        Assert.assertEquals((Object)"3", (Object)reg1.getReference().getProperty("c"));
        Assert.assertEquals((long)2L, (long)events.size());
        Assert.assertEquals((long)2L, (long)((ServiceEvent)events.get(1)).getType());
        Assert.assertSame((Object)reg1.getReference(), (Object)((ServiceEvent)events.get(1)).getServiceReference());
        reg1.unregister();
        Assert.assertEquals((long)3L, (long)events.size());
        Assert.assertEquals((long)4L, (long)((ServiceEvent)events.get(2)).getType());
        Assert.assertSame((Object)reg1.getReference(), (Object)((ServiceEvent)events.get(2)).getServiceReference());
    }

    @Test
    public void testServiceFactoryRegistration() throws InvalidSyntaxException {
        Class<String> clazz = String.class;
        String service = "abc";
        Dictionary<String, Object> properties1 = MockBundleContextTest.ranking(null);
        ServiceRegistration reg = this.bundleContext.registerService(clazz, (ServiceFactory)new ServiceFactory<String>(){

            public String getService(Bundle bundle, ServiceRegistration<String> registration) {
                return "abc";
            }

            public void ungetService(Bundle bundle, ServiceRegistration<String> registration, String service) {
            }
        }, properties1);
        ServiceReference ref = this.bundleContext.getServiceReference(clazz);
        Assert.assertNotNull((Object)ref);
        Assert.assertSame((Object)reg.getReference(), (Object)ref);
        Assert.assertSame((Object)"abc", (Object)this.bundleContext.getService(ref));
        this.bundleContext.ungetService(ref);
    }

    @Test
    public void testNoServiceReferences() throws InvalidSyntaxException {
        ServiceReference[] refs = this.bundleContext.getServiceReferences(String.class.getName(), null);
        Assert.assertNull((Object)refs);
        Collection refCol = this.bundleContext.getServiceReferences(String.class, null);
        Assert.assertNotNull((Object)refCol);
        Assert.assertTrue((boolean)refCol.isEmpty());
    }

    @Test
    public void testServiceUnregistration() {
        String clazz1 = String.class.getName();
        Object service1 = new Object();
        Dictionary<String, Object> properties1 = MockBundleContextTest.ranking(null);
        ServiceRegistration reg1 = this.bundleContext.registerService(clazz1, service1, properties1);
        Assert.assertNotNull((Object)this.bundleContext.getServiceReference(clazz1));
        reg1.unregister();
        Assert.assertNull((Object)this.bundleContext.getServiceReference(clazz1));
    }

    @Test
    public void testGetBundles() throws Exception {
        Assert.assertEquals((long)0L, (long)this.bundleContext.getBundles().length);
    }

    @Test
    public void testServiceListener() throws Exception {
        ServiceListener serviceListener = (ServiceListener)Mockito.mock(ServiceListener.class);
        this.bundleContext.addServiceListener(serviceListener);
        String clazz1 = String.class.getName();
        Object service1 = new Object();
        this.bundleContext.registerService(clazz1, service1, null);
        ((ServiceListener)Mockito.verify((Object)serviceListener)).serviceChanged((ServiceEvent)ArgumentMatchers.any(ServiceEvent.class));
        this.bundleContext.removeServiceListener(serviceListener);
    }

    @Test
    public void testBundleListener() throws Exception {
        BundleListener bundleListener = (BundleListener)Mockito.mock(BundleListener.class);
        BundleEvent bundleEvent = (BundleEvent)Mockito.mock(BundleEvent.class);
        this.bundleContext.addBundleListener(bundleListener);
        MockOsgi.sendBundleEvent((BundleContext)this.bundleContext, (BundleEvent)bundleEvent);
        ((BundleListener)Mockito.verify((Object)bundleListener)).bundleChanged(bundleEvent);
        this.bundleContext.removeBundleListener(bundleListener);
    }

    @Test
    public void testFrameworkListener() throws Exception {
        this.bundleContext.addFrameworkListener(null);
        this.bundleContext.removeFrameworkListener(null);
    }

    @Test
    public void testGetProperty() {
        Assert.assertNull((Object)this.bundleContext.getProperty("anyProperty"));
    }

    @Test
    public void testObjectClassFilterMatches() throws InvalidSyntaxException {
        Filter filter = this.bundleContext.createFilter("(objectClass=" + Integer.class.getName() + ")");
        ServiceRegistration serviceRegistration = this.bundleContext.registerService(Integer.class.getName(), (Object)1, null);
        Assert.assertTrue((boolean)filter.match(serviceRegistration.getReference()));
    }

    @Test
    public void testObjectClassFilterDoesNotMatch() throws InvalidSyntaxException {
        Filter filter = this.bundleContext.createFilter("(objectClass=" + Integer.class.getName() + ")");
        ServiceRegistration serviceRegistration = this.bundleContext.registerService(Long.class.getName(), (Object)1L, null);
        Assert.assertFalse((boolean)filter.match(serviceRegistration.getReference()));
    }

    @Test
    public void testGetDataFile() {
        File rootFile = this.bundleContext.getDataFile("");
        Assert.assertNotNull((Object)rootFile);
        File childFile = this.bundleContext.getDataFile("child");
        Assert.assertNotNull((Object)childFile);
        Assert.assertEquals((Object)childFile.getParentFile(), (Object)rootFile);
    }

    @Test
    public void testSystemBundleById() {
        Bundle systemBundle = this.bundleContext.getBundle(0L);
        Assert.assertNotNull((Object)systemBundle);
        Assert.assertEquals((long)0L, (long)systemBundle.getBundleId());
        Assert.assertEquals((Object)"system.bundle", (Object)systemBundle.getSymbolicName());
        Assert.assertEquals((Object)"System Bundle", (Object)systemBundle.getLocation());
    }

    @Test
    public void testSystemBundleByLocation() {
        Bundle systemBundle = this.bundleContext.getBundle("System Bundle");
        Assert.assertNotNull((Object)systemBundle);
        Assert.assertEquals((long)0L, (long)systemBundle.getBundleId());
        Assert.assertEquals((Object)"system.bundle", (Object)systemBundle.getSymbolicName());
        Assert.assertEquals((Object)"System Bundle", (Object)systemBundle.getLocation());
    }

    @Test
    public void testGetServiceOrderWithRanking() {
        this.bundleContext.registerService(String.class, (Object)"service1", MockBundleContextTest.ranking(10));
        this.bundleContext.registerService(String.class, (Object)"service2", MockBundleContextTest.ranking(20));
        this.bundleContext.registerService(String.class, (Object)"service3", MockBundleContextTest.ranking(5));
        ServiceReference ref = this.bundleContext.getServiceReference(String.class);
        String service = (String)this.bundleContext.getService(ref);
        Assert.assertEquals((Object)"service2", (Object)service);
        this.bundleContext.ungetService(ref);
    }

    @Test
    public void testGetServiceOrderWithoutRanking() {
        this.bundleContext.registerService(String.class, (Object)"service1", MockBundleContextTest.ranking(null));
        this.bundleContext.registerService(String.class, (Object)"service2", MockBundleContextTest.ranking(null));
        this.bundleContext.registerService(String.class, (Object)"service3", MockBundleContextTest.ranking(null));
        ServiceReference ref = this.bundleContext.getServiceReference(String.class);
        String service = (String)this.bundleContext.getService(ref);
        Assert.assertEquals((Object)"service1", (Object)service);
        this.bundleContext.ungetService(ref);
    }

    @Test
    public void testGetServicesWithNoClassOnlyFilter() throws InvalidSyntaxException {
        this.bundleContext.registerService(String.class, (Object)"service1", MockBundleContextTest.testProperty());
        this.bundleContext.registerService(Long.class, (Object)new Long(2L), MockBundleContextTest.testProperty());
        this.bundleContext.registerService(Integer.class, (Object)new Integer(9), MockBundleContextTest.testProperty());
        ServiceReference[] refs = this.bundleContext.getServiceReferences((String)null, "(prop1=value1)");
        Assert.assertNotNull((Object)refs);
        Assert.assertEquals((long)3L, (long)refs.length);
    }

    private static Dictionary<String, Object> ranking(Integer serviceRanking) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        if (serviceRanking != null) {
            ((Dictionary)props).put("service.ranking", serviceRanking);
        }
        return props;
    }

    private static Dictionary<String, Object> testProperty() {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("prop1", "value1");
        return props;
    }
}

