/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sling.testing.mock.osgi.OsgiMetadataUtil;
import org.apache.sling.testing.mock.osgi.OsgiServiceUtilTest;
import org.junit.Assert;
import org.junit.Test;

public class OsgiMetadataUtilTest {
    @Test
    public void testMetadata() {
        OsgiMetadataUtil.OsgiMetadata metadata = OsgiMetadataUtil.getMetadata(ServiceWithMetadata.class);
        Assert.assertEquals((Object)"org.apache.sling.testing.mock.osgi.OsgiMetadataUtilTest$ServiceWithMetadata", (Object)metadata.getPID());
        Set serviceInterfaces = metadata.getServiceInterfaces();
        Assert.assertEquals((long)3L, (long)serviceInterfaces.size());
        Assert.assertTrue((boolean)serviceInterfaces.contains("org.apache.sling.models.spi.Injector"));
        Assert.assertTrue((boolean)serviceInterfaces.contains("org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessorFactory"));
        Assert.assertTrue((boolean)serviceInterfaces.contains("java.lang.Comparable"));
        Map props = metadata.getProperties();
        Assert.assertEquals((long)3L, (long)props.size());
        Assert.assertEquals((Object)5000, props.get("service.ranking"));
        Assert.assertEquals((Object)"The Apache Software Foundation", props.get("service.vendor"));
        Assert.assertArrayEquals((Object[])new String[]{"org.apache.sling.api.resource.Resource", "org.apache.sling.api.resource.ResourceResolver"}, (Object[])((String[])props.get("adaptables")));
    }

    @Test
    public void testNoMetadata() {
        OsgiMetadataUtil.OsgiMetadata metadata = OsgiMetadataUtil.getMetadata(ServiceWithoutMetadata.class);
        Assert.assertNull((Object)metadata);
    }

    @Test
    public void testReferences() {
        OsgiMetadataUtil.OsgiMetadata metadata = OsgiMetadataUtil.getMetadata(OsgiServiceUtilTest.Service3.class);
        List references = metadata.getReferences();
        Assert.assertEquals((long)5L, (long)references.size());
        OsgiMetadataUtil.Reference ref1 = (OsgiMetadataUtil.Reference)references.get(2);
        Assert.assertEquals((Object)"reference2", (Object)ref1.getName());
        Assert.assertEquals((Object)"org.apache.sling.testing.mock.osgi.OsgiServiceUtilTest$ServiceInterface2", (Object)ref1.getInterfaceType());
        Assert.assertEquals((Object)OsgiMetadataUtil.ReferenceCardinality.MANDATORY_MULTIPLE, (Object)ref1.getCardinality());
        Assert.assertEquals((Object)"bindReference2", (Object)ref1.getBind());
        Assert.assertEquals((Object)"unbindReference2", (Object)ref1.getUnbind());
    }

    @Test
    public void testActivateMethodName() {
        OsgiMetadataUtil.OsgiMetadata metadata = OsgiMetadataUtil.getMetadata(OsgiServiceUtilTest.Service3.class);
        Assert.assertEquals((Object)"activate", (Object)metadata.getActivateMethodName());
    }

    static class ServiceWithoutMetadata {
        ServiceWithoutMetadata() {
        }
    }

    static class ServiceWithMetadata {
        ServiceWithMetadata() {
        }
    }
}

