/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.testing.mock.osgi.MapUtil;
import org.apache.sling.testing.mock.osgi.MockServiceRegistration;
import org.apache.sling.testing.mock.osgi.NoScrMetadataException;
import org.apache.sling.testing.mock.osgi.OsgiMetadataUtil;
import org.apache.sling.testing.mock.osgi.ReferenceViolationException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import osgimock.org.apache.felix.scr.impl.inject.Annotations;

final class OsgiServiceUtil {
    private OsgiServiceUtil() {
    }

    public static boolean activateDeactivate(Object target, ComponentContext componentContext, boolean activate) {
        Class<?> targetClass = target.getClass();
        OsgiMetadataUtil.OsgiMetadata metadata = OsgiMetadataUtil.getMetadata(targetClass);
        if (metadata == null) {
            throw new NoScrMetadataException(targetClass);
        }
        String methodName = activate ? metadata.getActivateMethodName() : metadata.getDeactivateMethodName();
        boolean fallbackDefaultName = false;
        if (StringUtils.isEmpty((CharSequence)methodName)) {
            fallbackDefaultName = true;
            methodName = activate ? "activate" : "deactivate";
        }
        if (OsgiServiceUtil.invokeLifecycleMethod(target, targetClass, methodName, !activate, componentContext, MapUtil.toMap(componentContext.getProperties()))) {
            return true;
        }
        if (fallbackDefaultName) {
            return false;
        }
        throw new RuntimeException("No matching " + (activate ? "activation" : "deactivation") + " method with name '" + methodName + "'  found in class " + targetClass.getName());
    }

    public static boolean modified(Object target, ComponentContext componentContext, Map<String, Object> properties) {
        Class<?> targetClass = target.getClass();
        OsgiMetadataUtil.OsgiMetadata metadata = OsgiMetadataUtil.getMetadata(targetClass);
        if (metadata == null) {
            throw new NoScrMetadataException(targetClass);
        }
        String methodName = metadata.getModifiedMethodName();
        if (StringUtils.isEmpty((CharSequence)methodName)) {
            return false;
        }
        if (OsgiServiceUtil.invokeLifecycleMethod(target, targetClass, methodName, false, componentContext, properties)) {
            return true;
        }
        throw new RuntimeException("No matching modified method with name '" + methodName + "'  found in class " + targetClass.getName());
    }

    private static boolean invokeLifecycleMethod(Object target, Class<?> targetClass, String methodName, boolean allowIntegerArgument, ComponentContext componentContext, Map<String, Object> properties) {
        Class[] classArray;
        Method method = OsgiServiceUtil.getMethod(targetClass, methodName, new Class[]{ComponentContext.class});
        if (method != null) {
            OsgiServiceUtil.invokeMethod(target, method, new Object[]{componentContext});
            return true;
        }
        method = OsgiServiceUtil.getMethod(targetClass, methodName, new Class[]{BundleContext.class});
        if (method != null) {
            OsgiServiceUtil.invokeMethod(target, method, new Object[]{componentContext.getBundleContext()});
            return true;
        }
        method = OsgiServiceUtil.getMethod(targetClass, methodName, new Class[]{Map.class});
        if (method != null) {
            OsgiServiceUtil.invokeMethod(target, method, new Object[]{MapUtil.toMap(componentContext.getProperties())});
            return true;
        }
        method = OsgiServiceUtil.getMethod(targetClass, methodName, new Class[]{Annotation.class});
        if (method != null) {
            OsgiServiceUtil.invokeMethod(target, method, new Object[]{Annotations.toObject(method.getParameterTypes()[0], MapUtil.toMap(componentContext.getProperties()), componentContext.getBundleContext().getBundle(), false)});
            return true;
        }
        if (allowIntegerArgument && (method = OsgiServiceUtil.getMethod(targetClass, methodName, new Class[]{Integer.TYPE})) != null) {
            OsgiServiceUtil.invokeMethod(target, method, new Object[]{0});
            return true;
        }
        if (allowIntegerArgument && (method = OsgiServiceUtil.getMethod(targetClass, methodName, new Class[]{Integer.class})) != null) {
            OsgiServiceUtil.invokeMethod(target, method, new Object[]{0});
            return true;
        }
        if (allowIntegerArgument) {
            Class[] classArray2 = new Class[6];
            classArray2[0] = ComponentContext.class;
            classArray2[1] = BundleContext.class;
            classArray2[2] = Map.class;
            classArray2[3] = Annotation.class;
            classArray2[4] = Integer.TYPE;
            classArray = classArray2;
            classArray2[5] = Integer.class;
        } else {
            Class[] classArray3 = new Class[4];
            classArray3[0] = ComponentContext.class;
            classArray3[1] = BundleContext.class;
            classArray3[2] = Map.class;
            classArray = classArray3;
            classArray3[3] = Annotation.class;
        }
        Class[] mixedArgsAllowed = classArray;
        method = OsgiServiceUtil.getMethodWithAnyCombinationArgs(targetClass, methodName, mixedArgsAllowed);
        if (method != null) {
            Object[] args = new Object[method.getParameterTypes().length];
            for (int i = 0; i < args.length; ++i) {
                if (method.getParameterTypes()[i] == ComponentContext.class) {
                    args[i] = componentContext;
                    continue;
                }
                if (method.getParameterTypes()[i] == BundleContext.class) {
                    args[i] = componentContext.getBundleContext();
                    continue;
                }
                if (method.getParameterTypes()[i] == Map.class) {
                    args[i] = MapUtil.toMap(componentContext.getProperties());
                    continue;
                }
                if (method.getParameterTypes()[i].isAnnotation()) {
                    args[i] = Annotations.toObject(method.getParameterTypes()[i], MapUtil.toMap(componentContext.getProperties()), componentContext.getBundleContext().getBundle(), false);
                    continue;
                }
                if (method.getParameterTypes()[i] != Integer.TYPE && method.getParameterTypes()[i] != Integer.class) continue;
                args[i] = 0;
            }
            OsgiServiceUtil.invokeMethod(target, method, args);
            return true;
        }
        method = OsgiServiceUtil.getMethod(targetClass, methodName, new Class[0]);
        if (method != null) {
            OsgiServiceUtil.invokeMethod(target, method, new Object[0]);
            return true;
        }
        return false;
    }

    private static Method getMethod(Class clazz, String methodName, Class<?>[] types) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!StringUtils.equals((CharSequence)method.getName(), (CharSequence)methodName) || method.getParameterTypes().length != types.length) continue;
            boolean foundMismatch = false;
            for (int i = 0; i < types.length; ++i) {
                if (method.getParameterTypes()[i] == types[i] || types[i] == Annotation.class && method.getParameterTypes()[i].isAnnotation()) continue;
                foundMismatch = true;
                break;
            }
            if (foundMismatch) continue;
            return method;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            return OsgiServiceUtil.getMethod(superClass, methodName, types);
        }
        return null;
    }

    private static Method getMethodWithAssignableTypes(Class clazz, String methodName, Class<?>[] types) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!StringUtils.equals((CharSequence)method.getName(), (CharSequence)methodName) || method.getParameterTypes().length != types.length) continue;
            boolean foundMismatch = false;
            for (int i = 0; i < types.length; ++i) {
                if (method.getParameterTypes()[i].isAssignableFrom(types[i])) continue;
                foundMismatch = true;
                break;
            }
            if (foundMismatch) continue;
            return method;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            return OsgiServiceUtil.getMethodWithAssignableTypes(superClass, methodName, types);
        }
        return null;
    }

    private static Method getMethodWithAnyCombinationArgs(Class clazz, String methodName, Class<?>[] types) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!StringUtils.equals((CharSequence)method.getName(), (CharSequence)methodName) || method.getParameterTypes().length <= 1) continue;
            boolean foundMismatch = false;
            for (Class<?> parameterType : method.getParameterTypes()) {
                boolean foundAnyMatch = false;
                for (int i = 0; i < types.length; ++i) {
                    if (parameterType != types[i] && (types[i] != Annotation.class || !parameterType.isAnnotation())) continue;
                    foundAnyMatch = true;
                    break;
                }
                if (foundAnyMatch) continue;
                foundMismatch = true;
                break;
            }
            if (foundMismatch) continue;
            return method;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            return OsgiServiceUtil.getMethodWithAnyCombinationArgs(superClass, methodName, types);
        }
        return null;
    }

    private static void invokeMethod(Object target, Method method, Object[] args) {
        try {
            method.setAccessible(true);
            method.invoke(target, args);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Unable to invoke method '" + method.getName() + "' for class " + target.getClass().getName(), ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException("Unable to invoke method '" + method.getName() + "' for class " + target.getClass().getName(), ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("Unable to invoke method '" + method.getName() + "' for class " + target.getClass().getName(), ex.getCause());
        }
    }

    private static Field getField(Class clazz, String fieldName, Class<?> type) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!StringUtils.equals((CharSequence)field.getName(), (CharSequence)fieldName) || !field.getType().equals(type)) continue;
            return field;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            return OsgiServiceUtil.getField(superClass, fieldName, type);
        }
        return null;
    }

    private static Field getFieldWithAssignableType(Class clazz, String fieldName, Class<?> type) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!StringUtils.equals((CharSequence)field.getName(), (CharSequence)fieldName) || !field.getType().isAssignableFrom(type)) continue;
            return field;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            return OsgiServiceUtil.getFieldWithAssignableType(superClass, fieldName, type);
        }
        return null;
    }

    private static void setField(Object target, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(target, value);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Unable to set field '" + field.getName() + "' for class " + target.getClass().getName(), ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException("Unable to set field '" + field.getName() + "' for class " + target.getClass().getName(), ex);
        }
    }

    public static boolean injectServices(Object target, BundleContext bundleContext, Map<String, Object> properties) {
        Class<?> targetClass = target.getClass();
        OsgiMetadataUtil.OsgiMetadata metadata = OsgiMetadataUtil.getMetadata(targetClass);
        if (metadata == null) {
            throw new NoScrMetadataException(targetClass);
        }
        List<OsgiMetadataUtil.Reference> references = metadata.getReferences();
        if (references.isEmpty()) {
            return false;
        }
        for (OsgiMetadataUtil.Reference reference : references) {
            Object o;
            if (properties != null && (o = properties.get(reference.getName() + ".target")) != null && o instanceof String) {
                reference = new OsgiMetadataUtil.DynamicReference(reference, (String)o);
            }
            OsgiServiceUtil.injectServiceReference(reference, target, bundleContext);
        }
        return true;
    }

    private static void injectServiceReference(OsgiMetadataUtil.Reference reference, Object target, BundleContext bundleContext) {
        Class<?> targetClass = target.getClass();
        Class type = reference.getInterfaceTypeAsClass();
        List<ServiceInfo> matchingServices = OsgiServiceUtil.getMatchingServices(type, bundleContext, reference.getTarget());
        if (matchingServices.isEmpty()) {
            if (!reference.isCardinalityOptional()) {
                throw new ReferenceViolationException("Unable to inject mandatory reference '" + reference.getName() + "' for class " + targetClass.getName() + " : no matching services were found.");
            }
            if (reference.isCardinalityMultiple()) {
                OsgiServiceUtil.invokeBindUnbindMethod(reference, target, null, true);
            }
        }
        if (matchingServices.size() > 1 && !reference.isCardinalityMultiple()) {
            matchingServices = matchingServices.subList(0, 1);
        }
        for (ServiceInfo matchingService : matchingServices) {
            OsgiServiceUtil.invokeBindUnbindMethod(reference, target, matchingService, true);
        }
    }

    private static void invokeBindUnbindMethod(OsgiMetadataUtil.Reference reference, Object target, ServiceInfo serviceInfo, boolean bind) {
        block19: {
            String fieldName;
            Class<?> targetClass;
            block20: {
                targetClass = target.getClass();
                String methodName = bind ? reference.getBind() : reference.getUnbind();
                fieldName = reference.getField();
                if (StringUtils.isEmpty((CharSequence)methodName) && StringUtils.isEmpty((CharSequence)fieldName)) {
                    throw new RuntimeException("No bind/unbind method name or file name defined for reference '" + reference.getName() + "' for class " + targetClass.getName());
                }
                if (StringUtils.isNotEmpty((CharSequence)methodName) && serviceInfo != null) {
                    Method method = OsgiServiceUtil.getMethod(targetClass, methodName, new Class[]{ServiceReference.class});
                    if (method != null) {
                        OsgiServiceUtil.invokeMethod(target, method, new Object[]{serviceInfo.getServiceReference()});
                        return;
                    }
                    Class interfaceType = reference.getInterfaceTypeAsClass();
                    method = OsgiServiceUtil.getMethodWithAssignableTypes(targetClass, methodName, new Class[]{interfaceType});
                    if (method != null) {
                        OsgiServiceUtil.invokeMethod(target, method, new Object[]{serviceInfo.getServiceInstance()});
                        return;
                    }
                    method = OsgiServiceUtil.getMethodWithAssignableTypes(targetClass, methodName, new Class[]{interfaceType, Map.class});
                    if (method != null) {
                        OsgiServiceUtil.invokeMethod(target, method, new Object[]{serviceInfo.getServiceInstance(), serviceInfo.getServiceConfig()});
                        return;
                    }
                    method = OsgiServiceUtil.getMethodWithAssignableTypes(targetClass, methodName, new Class[]{ServiceReference.class, interfaceType});
                    if (method != null) {
                        OsgiServiceUtil.invokeMethod(target, method, new Object[]{serviceInfo.getServiceReference(), serviceInfo.getServiceInstance()});
                        return;
                    }
                    throw new RuntimeException((bind ? "Bind" : "Unbind") + " method with name " + methodName + " not found for reference '" + reference.getName() + "' for class " + targetClass.getName());
                }
                if (!StringUtils.isNotEmpty((CharSequence)fieldName)) break block19;
                if (!reference.isCardinalityMultiple()) break block20;
                switch (reference.getFieldCollectionType()) {
                    case SERVICE: 
                    case REFERENCE: {
                        Field field;
                        Object item = null;
                        if (serviceInfo != null) {
                            item = serviceInfo.getServiceInstance();
                            if (reference.getFieldCollectionType() == OsgiMetadataUtil.FieldCollectionType.REFERENCE) {
                                item = serviceInfo.getServiceReference();
                            }
                        }
                        if ((field = OsgiServiceUtil.getFieldWithAssignableType(targetClass, fieldName, Collection.class)) != null) {
                            if (bind) {
                                OsgiServiceUtil.addToCollection(target, field, item);
                            } else {
                                OsgiServiceUtil.removeFromCollection(target, field, item);
                            }
                            return;
                        }
                        field = OsgiServiceUtil.getField(targetClass, fieldName, List.class);
                        if (field != null) {
                            if (bind) {
                                OsgiServiceUtil.addToCollection(target, field, item);
                            } else {
                                OsgiServiceUtil.removeFromCollection(target, field, item);
                            }
                            return;
                        }
                        break block19;
                    }
                    default: {
                        throw new RuntimeException("Field collection type '" + (Object)((Object)reference.getFieldCollectionType()) + "' not supported for reference '" + reference.getName() + "' for class " + targetClass.getName());
                    }
                }
            }
            Class interfaceType = reference.getInterfaceTypeAsClass();
            Field field = OsgiServiceUtil.getFieldWithAssignableType(targetClass, fieldName, interfaceType);
            if (field != null) {
                OsgiServiceUtil.setField(target, field, bind && serviceInfo != null ? serviceInfo.getServiceInstance() : null);
                return;
            }
            field = OsgiServiceUtil.getField(targetClass, fieldName, ServiceReference.class);
            if (field != null) {
                OsgiServiceUtil.setField(target, field, bind && serviceInfo != null ? serviceInfo.getServiceReference() : null);
                return;
            }
        }
    }

    private static void addToCollection(Object target, Field field, Object item) {
        try {
            field.setAccessible(true);
            ArrayList<Object> collection = (ArrayList<Object>)field.get(target);
            if (collection == null) {
                collection = new ArrayList<Object>();
            }
            if (item != null) {
                collection.add(item);
            }
            field.set(target, collection);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Unable to set field '" + field.getName() + "' for class " + target.getClass().getName(), ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException("Unable to set field '" + field.getName() + "' for class " + target.getClass().getName(), ex);
        }
    }

    private static void removeFromCollection(Object target, Field field, Object item) {
        try {
            field.setAccessible(true);
            ArrayList collection = (ArrayList)field.get(target);
            if (collection == null) {
                collection = new ArrayList();
            }
            if (item != null) {
                collection.remove(item);
            }
            field.set(target, collection);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Unable to set field '" + field.getName() + "' for class " + target.getClass().getName(), ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException("Unable to set field '" + field.getName() + "' for class " + target.getClass().getName(), ex);
        }
    }

    public static void invokeBindMethod(OsgiMetadataUtil.Reference reference, Object target, ServiceInfo serviceInfo) {
        OsgiServiceUtil.invokeBindUnbindMethod(reference, target, serviceInfo, true);
    }

    public static void invokeUnbindMethod(OsgiMetadataUtil.Reference reference, Object target, ServiceInfo serviceInfo) {
        OsgiServiceUtil.invokeBindUnbindMethod(reference, target, serviceInfo, false);
    }

    private static List<ServiceInfo> getMatchingServices(Class<?> type, BundleContext bundleContext, String filter) {
        ArrayList<ServiceInfo> matchingServices = new ArrayList<ServiceInfo>();
        try {
            ServiceReference[] references = bundleContext.getServiceReferences(type.getName(), filter);
            if (references != null) {
                for (ServiceReference serviceReference : references) {
                    String[] keys;
                    Object serviceInstance = bundleContext.getService(serviceReference);
                    HashMap<String, Object> serviceConfig = new HashMap<String, Object>();
                    for (String key : keys = serviceReference.getPropertyKeys()) {
                        serviceConfig.put(key, serviceReference.getProperty(key));
                    }
                    matchingServices.add(new ServiceInfo(serviceInstance, serviceConfig, serviceReference));
                }
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        return matchingServices;
    }

    public static List<ReferenceInfo> getMatchingDynamicReferences(SortedSet<MockServiceRegistration> registeredServices, MockServiceRegistration<?> registration) {
        ArrayList<ReferenceInfo> references = new ArrayList<ReferenceInfo>();
        for (MockServiceRegistration existingRegistration : registeredServices) {
            OsgiMetadataUtil.OsgiMetadata metadata = OsgiMetadataUtil.getMetadata(existingRegistration.getService().getClass());
            if (metadata == null) continue;
            for (OsgiMetadataUtil.Reference reference : metadata.getReferences()) {
                if (reference.getPolicy() != OsgiMetadataUtil.ReferencePolicy.DYNAMIC) continue;
                for (String serviceInterface : registration.getClasses()) {
                    if (!StringUtils.equals((CharSequence)serviceInterface, (CharSequence)reference.getInterfaceType())) continue;
                    references.add(new ReferenceInfo(existingRegistration, reference));
                }
            }
        }
        return references;
    }

    public static List<ReferenceInfo> getMatchingStaticGreedyReferences(SortedSet<MockServiceRegistration> registeredServices, MockServiceRegistration<?> registration) {
        ArrayList<ReferenceInfo> references = new ArrayList<ReferenceInfo>();
        for (MockServiceRegistration existingRegistration : registeredServices) {
            OsgiMetadataUtil.OsgiMetadata metadata = OsgiMetadataUtil.getMetadata(existingRegistration.getService().getClass());
            if (metadata == null) continue;
            for (OsgiMetadataUtil.Reference reference : metadata.getReferences()) {
                if (reference.getPolicy() != OsgiMetadataUtil.ReferencePolicy.STATIC || reference.getPolicyOption() != OsgiMetadataUtil.ReferencePolicyOption.GREEDY) continue;
                for (String serviceInterface : registration.getClasses()) {
                    if (!StringUtils.equals((CharSequence)serviceInterface, (CharSequence)reference.getInterfaceType())) continue;
                    references.add(new ReferenceInfo(existingRegistration, reference));
                }
            }
        }
        return references;
    }

    static class ReferenceInfo {
        private final MockServiceRegistration serviceRegistration;
        private final OsgiMetadataUtil.Reference reference;

        public ReferenceInfo(MockServiceRegistration serviceRegistration, OsgiMetadataUtil.Reference reference) {
            this.serviceRegistration = serviceRegistration;
            this.reference = reference;
        }

        public MockServiceRegistration getServiceRegistration() {
            return this.serviceRegistration;
        }

        public OsgiMetadataUtil.Reference getReference() {
            return this.reference;
        }
    }

    static class ServiceInfo {
        private final Object serviceInstance;
        private final Map<String, Object> serviceConfig;
        private final ServiceReference serviceReference;

        public ServiceInfo(Object serviceInstance, Map<String, Object> serviceConfig, ServiceReference serviceReference) {
            this.serviceInstance = serviceInstance;
            this.serviceConfig = serviceConfig;
            this.serviceReference = serviceReference;
        }

        public ServiceInfo(MockServiceRegistration registration) {
            this.serviceInstance = registration.getService();
            this.serviceConfig = MapUtil.toMap(registration.getProperties());
            this.serviceReference = registration.getReference();
        }

        public Object getServiceInstance() {
            return this.serviceInstance;
        }

        public Map<String, Object> getServiceConfig() {
            return this.serviceConfig;
        }

        public ServiceReference getServiceReference() {
            return this.serviceReference;
        }
    }
}

