/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

public class OsgiServiceUtilActivateDeactivateTest {
    private Map<String, Object> map = ImmutableMap.of((Object)"prop1", (Object)"value1", (Object)"prop2.with.periods", (Object)"value2", (Object)"prop3-with-hyphens", (Object)"value3");
    private BundleContext bundleContext = MockOsgi.newBundleContext();

    @Test
    public void testService1() {
        Service1 service = new Service1();
        Assert.assertTrue((boolean)MockOsgi.activate((Object)service, (BundleContext)this.bundleContext, this.map));
        Assert.assertTrue((boolean)service.isActivated());
        Assert.assertSame((Object)this.bundleContext, (Object)service.getComponentContext().getBundleContext());
        Assert.assertTrue((boolean)MockOsgi.deactivate((Object)service, (BundleContext)this.bundleContext, this.map));
        Assert.assertFalse((boolean)service.isActivated());
    }

    @Test
    public void testService2() {
        Service2 service = new Service2();
        Assert.assertTrue((boolean)MockOsgi.activate((Object)service, (BundleContext)this.bundleContext, (Object[])new Object[]{"prop1", "value1"}));
        Assert.assertTrue((boolean)service.isActivated());
        Assert.assertSame((Object)this.bundleContext, (Object)service.getBundleContext());
        Assert.assertTrue((boolean)MockOsgi.deactivate((Object)service, (BundleContext)this.bundleContext, this.map));
        Assert.assertFalse((boolean)service.isActivated());
    }

    @Test
    public void testService3() {
        Service3 service = new Service3();
        Assert.assertTrue((boolean)MockOsgi.activate((Object)service, (BundleContext)this.bundleContext, this.map));
        Assert.assertTrue((boolean)service.isActivated());
        Assert.assertEquals((Object)"value1", (Object)service.getMap().get("prop1"));
        Assert.assertTrue((boolean)MockOsgi.deactivate((Object)service, (BundleContext)this.bundleContext, this.map));
        Assert.assertFalse((boolean)service.isActivated());
    }

    @Test
    public void testService4() {
        Service4 service = new Service4();
        Assert.assertTrue((boolean)MockOsgi.activate((Object)service, (BundleContext)this.bundleContext, this.map));
        Assert.assertTrue((boolean)service.isActivated());
        Assert.assertEquals(this.map, (Object)ImmutableMap.copyOf(service.getMap()));
        Assert.assertTrue((boolean)MockOsgi.deactivate((Object)service, (BundleContext)this.bundleContext, this.map));
        Assert.assertFalse((boolean)service.isActivated());
    }

    @Test
    public void testService5() {
        Service5 service = new Service5();
        Assert.assertTrue((boolean)MockOsgi.activate((Object)service, (BundleContext)this.bundleContext, this.map));
        Assert.assertTrue((boolean)service.isActivated());
        Assert.assertTrue((boolean)MockOsgi.deactivate((Object)service, (BundleContext)this.bundleContext, this.map));
        Assert.assertFalse((boolean)service.isActivated());
    }

    @Test
    public void testService6() {
        Service6 service = new Service6();
        Assert.assertTrue((boolean)MockOsgi.activate((Object)service, (BundleContext)this.bundleContext, this.map));
        Assert.assertTrue((boolean)service.isActivated());
        Assert.assertSame((Object)this.bundleContext, (Object)service.getComponentContext().getBundleContext());
        Assert.assertSame((Object)this.bundleContext, (Object)service.getBundleContext());
        Assert.assertEquals((Object)"value1", (Object)service.getMap().get("prop1"));
        Assert.assertTrue((boolean)MockOsgi.deactivate((Object)service, (BundleContext)this.bundleContext, this.map));
        Assert.assertFalse((boolean)service.isActivated());
    }

    @Test
    public void testService7() {
        Service7 service = new Service7();
        Assert.assertTrue((boolean)MockOsgi.activate((Object)service, (BundleContext)this.bundleContext, this.map));
        Assert.assertTrue((boolean)service.isActivated());
        Assert.assertSame((Object)this.bundleContext, (Object)service.getComponentContext().getBundleContext());
        Assert.assertSame((Object)this.bundleContext, (Object)service.getBundleContext());
        Assert.assertEquals(this.map, (Object)ImmutableMap.copyOf(service.getMap()));
        Assert.assertTrue((boolean)MockOsgi.deactivate((Object)service, (BundleContext)this.bundleContext, this.map));
        Assert.assertFalse((boolean)service.isActivated());
    }

    static Map<String, Object> readAnnotationToMap(ServiceConfig config) {
        return ImmutableMap.of((Object)"prop1", (Object)config.prop1(), (Object)"prop2.with.periods", (Object)config.prop2_with_periods(), (Object)"prop3-with-hyphens", (Object)config.prop3$_$with$_$hyphens());
    }

    @Component
    public static class Service7 {
        private boolean activated;
        private ComponentContext componentContext;
        private BundleContext bundleContext;
        private Map<String, Object> map;

        @Activate
        private void activate(ComponentContext componentContext, ServiceConfig config, BundleContext bundleContext) {
            this.activated = true;
            this.componentContext = componentContext;
            this.bundleContext = bundleContext;
            this.map = OsgiServiceUtilActivateDeactivateTest.readAnnotationToMap(config);
        }

        @Deactivate
        private void deactivate() {
            this.activated = false;
            this.componentContext = null;
            this.bundleContext = null;
            this.map = null;
        }

        public boolean isActivated() {
            return this.activated;
        }

        public ComponentContext getComponentContext() {
            return this.componentContext;
        }

        public BundleContext getBundleContext() {
            return this.bundleContext;
        }

        public Map<String, Object> getMap() {
            return this.map;
        }
    }

    @Component
    public static class Service6 {
        private boolean activated;
        private ComponentContext componentContext;
        private BundleContext bundleContext;
        private Map<String, Object> map;

        @Activate
        private void activate(ComponentContext componentContext, BundleContext bundleContext, Map<String, Object> map) {
            this.activated = true;
            this.componentContext = componentContext;
            this.bundleContext = bundleContext;
            this.map = map;
        }

        @Deactivate
        private void deactivate(Map<String, Object> map, BundleContext bundleContext, int value1, Integer value2) {
            this.activated = false;
            this.componentContext = null;
            this.bundleContext = null;
            this.map = null;
        }

        public boolean isActivated() {
            return this.activated;
        }

        public ComponentContext getComponentContext() {
            return this.componentContext;
        }

        public BundleContext getBundleContext() {
            return this.bundleContext;
        }

        public Map<String, Object> getMap() {
            return this.map;
        }
    }

    @Component
    public static class Service5 {
        private boolean activated;

        @Activate
        private void activate() {
            this.activated = true;
        }

        @Deactivate
        private void deactivate(Integer value) {
            this.activated = false;
        }

        public boolean isActivated() {
            return this.activated;
        }
    }

    @Component
    public static class Service4 {
        private boolean activated;
        private Map<String, Object> map;

        @Activate
        private void activate(ServiceConfig config) {
            this.activated = true;
            this.map = OsgiServiceUtilActivateDeactivateTest.readAnnotationToMap(config);
        }

        @Deactivate
        private void deactivate(int value) {
            this.activated = false;
        }

        public boolean isActivated() {
            return this.activated;
        }

        public Map<String, Object> getMap() {
            return this.map;
        }
    }

    @Component
    public static class Service3 {
        private boolean activated;
        private Map<String, Object> map;

        @Activate
        private void activate(Map<String, Object> map) {
            this.activated = true;
            this.map = map;
        }

        @Deactivate
        private void deactivate(Map<String, Object> map) {
            this.activated = false;
            this.map = null;
        }

        public boolean isActivated() {
            return this.activated;
        }

        public Map<String, Object> getMap() {
            return this.map;
        }
    }

    @Component
    public static class Service2 {
        private boolean activated;
        private BundleContext bundleContext;

        @Activate
        private void activate(BundleContext ctx) {
            this.activated = true;
            this.bundleContext = ctx;
        }

        @Deactivate
        private void deactivate(BundleContext ctx) {
            this.activated = false;
            this.bundleContext = null;
        }

        public boolean isActivated() {
            return this.activated;
        }

        public BundleContext getBundleContext() {
            return this.bundleContext;
        }
    }

    @Component
    public static class Service1 {
        private boolean activated;
        private ComponentContext componentContext;

        @Activate
        private void activate(ComponentContext ctx) {
            this.activated = true;
            this.componentContext = ctx;
        }

        @Deactivate
        private void deactivate(ComponentContext ctx) {
            this.activated = false;
            this.componentContext = null;
        }

        public boolean isActivated() {
            return this.activated;
        }

        public ComponentContext getComponentContext() {
            return this.componentContext;
        }
    }

    public static @interface ServiceConfig {
        public String prop1();

        public String prop2_with_periods();

        public String prop3$_$with$_$hyphens();
    }
}

