/*
 * Decompiled with CFR 0.152.
 */
package osgimock.org.apache.felix.framework.cache;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import osgimock.org.apache.felix.framework.Logger;
import osgimock.org.apache.felix.framework.cache.BundleCache;
import osgimock.org.apache.felix.framework.cache.Content;
import osgimock.org.apache.felix.framework.cache.JarContent;
import osgimock.org.apache.felix.framework.util.Util;
import osgimock.org.apache.felix.framework.util.WeakZipFileFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryContent
implements Content {
    private static final int BUFSIZE = 4096;
    private static final transient String EMBEDDED_DIRECTORY = "-embedded";
    private static final transient String LIBRARY_DIRECTORY = "-lib";
    private final Logger m_logger;
    private final Map m_configMap;
    private final WeakZipFileFactory m_zipFactory;
    private final Object m_revisionLock;
    private final File m_rootDir;
    private final File m_dir;
    private Map m_nativeLibMap;

    public DirectoryContent(Logger logger, Map configMap, WeakZipFileFactory zipFactory, Object revisionLock, File rootDir, File dir) {
        this.m_logger = logger;
        this.m_configMap = configMap;
        this.m_zipFactory = zipFactory;
        this.m_revisionLock = revisionLock;
        this.m_rootDir = rootDir;
        this.m_dir = dir;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasEntry(String name) throws IllegalStateException {
        if (name.length() > 0 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        File file = new File(this.m_dir, name);
        return BundleCache.getSecureAction().fileExists(file) && (!name.endsWith("/") || BundleCache.getSecureAction().isFileDirectory(file));
    }

    @Override
    public Enumeration<String> getEntries() {
        EntriesEnumeration e = new EntriesEnumeration(this.m_dir);
        return e.hasMoreElements() ? e : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getEntryAsBytes(String name) throws IllegalStateException {
        if (name.length() > 0 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        InputStream is = null;
        ByteArrayOutputStream baos = null;
        try {
            is = new BufferedInputStream(BundleCache.getSecureAction().getFileInputStream(new File(this.m_dir, name)));
            baos = new ByteArrayOutputStream(4096);
            byte[] buf = new byte[4096];
            int n = 0;
            while ((n = is.read(buf, 0, buf.length)) >= 0) {
                baos.write(buf, 0, n);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception ex) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception ex) {}
        }
    }

    @Override
    public InputStream getEntryAsStream(String name) throws IllegalStateException, IOException {
        if (name.length() > 0 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        return BundleCache.getSecureAction().getFileInputStream(new File(this.m_dir, name));
    }

    @Override
    public URL getEntryAsURL(String name) {
        if (name.length() > 0 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        try {
            return BundleCache.getSecureAction().toURI(new File(this.m_dir, name)).toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Content getEntryAsContent(String entryName) {
        if (entryName.equals(".")) {
            return new DirectoryContent(this.m_logger, this.m_configMap, this.m_zipFactory, this.m_revisionLock, this.m_rootDir, this.m_dir);
        }
        entryName = entryName.startsWith("/") ? entryName.substring(1) : entryName;
        File embedDir = new File(this.m_rootDir, this.m_dir.getName() + EMBEDDED_DIRECTORY);
        File file = new File(this.m_dir, entryName);
        if (BundleCache.getSecureAction().isFileDirectory(file)) {
            return new DirectoryContent(this.m_logger, this.m_configMap, this.m_zipFactory, this.m_revisionLock, this.m_rootDir, file);
        }
        if (BundleCache.getSecureAction().fileExists(file) && entryName.endsWith(".jar")) {
            File extractDir = new File(embedDir, entryName.lastIndexOf(47) >= 0 ? entryName.substring(0, entryName.lastIndexOf(47)) : entryName);
            Object object = this.m_revisionLock;
            synchronized (object) {
                if (!BundleCache.getSecureAction().fileExists(extractDir) && !BundleCache.getSecureAction().mkdirs(extractDir)) {
                    this.m_logger.log(1, "Unable to extract embedded directory.");
                }
            }
            return new JarContent(this.m_logger, this.m_configMap, this.m_zipFactory, this.m_revisionLock, extractDir, file, null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getEntryAsNativeLibrary(String entryName) {
        String result = null;
        entryName = entryName.startsWith("/") ? entryName.substring(1) : entryName;
        File libDir = new File(this.m_rootDir, this.m_dir.getName() + LIBRARY_DIRECTORY);
        File entryFile = new File(this.m_dir, entryName);
        if (BundleCache.getSecureAction().fileExists(entryFile) && !BundleCache.getSecureAction().isFileDirectory(entryFile)) {
            Object object = this.m_revisionLock;
            synchronized (object) {
                Integer libCount;
                if (this.m_nativeLibMap == null) {
                    this.m_nativeLibMap = new HashMap();
                }
                libCount = (libCount = (Integer)this.m_nativeLibMap.get(entryName)) == null ? new Integer(0) : new Integer(libCount + 1);
                this.m_nativeLibMap.put(entryName, libCount);
                File libFile = new File(libDir, libCount.toString() + File.separatorChar + entryName);
                if (!BundleCache.getSecureAction().fileExists(libFile)) {
                    if (!BundleCache.getSecureAction().fileExists(libFile.getParentFile()) && !BundleCache.getSecureAction().mkdirs(libFile.getParentFile())) {
                        this.m_logger.log(1, "Unable to create library directory.");
                    } else {
                        InputStream is = null;
                        try {
                            is = new BufferedInputStream(BundleCache.getSecureAction().getFileInputStream(entryFile), BundleCache.BUFSIZE);
                            if (is == null) {
                                throw new IOException("No input stream: " + entryName);
                            }
                            BundleCache.copyStreamToFile(is, libFile);
                            String command = (String)this.m_configMap.get("org.osgi.framework.command.execpermission");
                            if (command != null) {
                                Properties props = new Properties();
                                props.setProperty("abspath", libFile.toString());
                                command = Util.substVars(command, "command", null, props);
                                Process p = BundleCache.getSecureAction().exec(command);
                                p.waitFor();
                            }
                            result = BundleCache.getSecureAction().getAbsolutePath(libFile);
                        }
                        catch (Exception ex) {
                            this.m_logger.log(1, "Extracting native library.", ex);
                        }
                        finally {
                            try {
                                if (is != null) {
                                    is.close();
                                }
                            }
                            catch (IOException ex) {}
                        }
                    }
                } else {
                    result = BundleCache.getSecureAction().getAbsolutePath(libFile);
                }
            }
        }
        return result;
    }

    public String toString() {
        return "DIRECTORY " + this.m_dir;
    }

    private static class EntriesEnumeration
    implements Enumeration {
        private final File m_dir;
        private final File[] m_children;
        private int m_counter = 0;

        public EntriesEnumeration(File dir) {
            this.m_dir = dir;
            this.m_children = this.listFilesRecursive(this.m_dir);
        }

        public synchronized boolean hasMoreElements() {
            return this.m_children != null && this.m_counter < this.m_children.length;
        }

        public synchronized Object nextElement() {
            if (this.m_children == null || this.m_counter >= this.m_children.length) {
                throw new NoSuchElementException("No more entry paths.");
            }
            String abs = BundleCache.getSecureAction().getAbsolutePath(this.m_children[this.m_counter]).replace(File.separatorChar, '/');
            StringBuffer sb = new StringBuffer(abs);
            sb.delete(0, BundleCache.getSecureAction().getAbsolutePath(this.m_dir).length() + 1);
            if (BundleCache.getSecureAction().isFileDirectory(this.m_children[this.m_counter])) {
                sb.append('/');
            }
            ++this.m_counter;
            return sb.toString();
        }

        private File[] listFilesRecursive(File dir) {
            File[] children;
            File[] combined = children = BundleCache.getSecureAction().listDirectory(dir);
            for (int i = 0; i < children.length; ++i) {
                File[] grandchildren;
                if (!BundleCache.getSecureAction().isFileDirectory(children[i]) || (grandchildren = this.listFilesRecursive(children[i])).length <= 0) continue;
                File[] tmp = new File[combined.length + grandchildren.length];
                System.arraycopy(combined, 0, tmp, 0, combined.length);
                System.arraycopy(grandchildren, 0, tmp, combined.length, grandchildren.length);
                combined = tmp;
            }
            return combined;
        }
    }
}

