/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.testing.mock.osgi.MockBundleContext;
import org.apache.sling.testing.mock.osgi.MockServiceReference;
import org.apache.sling.testing.mock.osgi.OsgiMetadataUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import osgimock.org.apache.felix.framework.FilterImpl;

class MockServiceRegistration<T>
implements ServiceRegistration<T>,
Comparable<MockServiceRegistration<T>> {
    private static volatile long serviceCounter;
    private final Long serviceId = ++serviceCounter;
    private final Set<String> clazzes;
    private final T service;
    private Dictionary<String, Object> properties;
    private final ServiceReference<T> serviceReference;
    private final MockBundleContext bundleContext;

    public MockServiceRegistration(Bundle bundle, String[] clazzes, T service, Dictionary<String, Object> properties, MockBundleContext bundleContext) {
        this.clazzes = new HashSet<String>((Collection<String>)ImmutableList.copyOf((Object[])clazzes));
        this.service = service instanceof ServiceFactory ? ((ServiceFactory)service).getService(bundleContext.getBundle(), (ServiceRegistration)this) : service;
        this.properties = properties != null ? properties : new Hashtable();
        this.properties.put("service.id", this.serviceId);
        this.properties.put("objectClass", clazzes);
        this.serviceReference = new MockServiceReference(bundle, this);
        this.bundleContext = bundleContext;
        this.readOsgiMetadata();
    }

    public ServiceReference<T> getReference() {
        return this.serviceReference;
    }

    public void setProperties(Dictionary properties) {
        this.properties = properties;
    }

    public void unregister() {
        this.bundleContext.unregisterService(this);
    }

    Dictionary<String, Object> getProperties() {
        return this.properties;
    }

    boolean matches(String clazz, String filter) throws InvalidSyntaxException {
        return !(clazz != null && !this.clazzes.contains(clazz) || filter != null && !new FilterImpl(filter).match(this.properties));
    }

    Set<String> getClasses() {
        return this.clazzes;
    }

    T getService() {
        if (this.service instanceof ServiceFactory) {
            ServiceFactory factory = (ServiceFactory)this.service;
            return (T)factory.getService(this.bundleContext.getBundle(), (ServiceRegistration)this);
        }
        return this.service;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MockServiceRegistration)) {
            return false;
        }
        return this.serviceId.equals(((MockServiceRegistration)obj).serviceId);
    }

    public int hashCode() {
        return this.serviceId.hashCode();
    }

    @Override
    public int compareTo(MockServiceRegistration<T> obj) {
        return this.serviceId.compareTo(obj.serviceId);
    }

    private void readOsgiMetadata() {
        Class<?> serviceClass = this.service.getClass();
        OsgiMetadataUtil.OsgiMetadata metadata = OsgiMetadataUtil.getMetadata(serviceClass);
        if (metadata == null) {
            return;
        }
        this.clazzes.addAll(metadata.getServiceInterfaces());
    }

    public String toString() {
        return "#" + this.serviceId + " [" + StringUtils.join(this.clazzes, (String)",") + "]: " + this.service.toString();
    }
}

