/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.framework.FilterImpl;
import org.apache.sling.testing.mock.osgi.MapMergeUtil;
import org.apache.sling.testing.mock.osgi.MapUtil;
import org.apache.sling.testing.mock.osgi.MatchAllFilter;
import org.apache.sling.testing.mock.osgi.MockBundle;
import org.apache.sling.testing.mock.osgi.MockConfigurationAdmin;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.osgi.MockServiceReference;
import org.apache.sling.testing.mock.osgi.MockServiceRegistration;
import org.apache.sling.testing.mock.osgi.NoScrMetadataException;
import org.apache.sling.testing.mock.osgi.OsgiMetadataUtil;
import org.apache.sling.testing.mock.osgi.OsgiServiceUtil;
import org.apache.sling.testing.mock.osgi.ReferenceViolationException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;

class MockBundleContext
implements BundleContext {
    private final MockBundle bundle;
    private final SortedSet<MockServiceRegistration> registeredServices = new ConcurrentSkipListSet<MockServiceRegistration>();
    private final Map<ServiceListener, Filter> serviceListeners = new ConcurrentHashMap<ServiceListener, Filter>();
    private final Queue<BundleListener> bundleListeners = new ConcurrentLinkedQueue<BundleListener>();
    private final ConfigurationAdmin configAdmin = new MockConfigurationAdmin();
    private File dataFileBaseDir;

    public MockBundleContext() {
        this.bundle = new MockBundle(this);
        this.registerService(ConfigurationAdmin.class.getName(), (Object)this.configAdmin, null);
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public Filter createFilter(String s) throws InvalidSyntaxException {
        if (s == null) {
            return new MatchAllFilter();
        }
        return new FilterImpl(s);
    }

    public ServiceRegistration registerService(String clazz, Object service, Dictionary properties) {
        String[] clazzes = StringUtils.isBlank((CharSequence)clazz) ? new String[]{} : new String[]{clazz};
        return this.registerService(clazzes, service, properties);
    }

    public <S> ServiceRegistration registerService(Class<S> clazz, S service, Dictionary<String, ?> properties) {
        return this.registerService(clazz.getName(), service, properties);
    }

    public ServiceRegistration registerService(String[] clazzes, Object service, Dictionary properties) {
        Dictionary<String, Object> mergedPropertes = MapMergeUtil.propertiesMergeWithOsgiMetadata(service, this.configAdmin, properties);
        MockServiceRegistration registration = new MockServiceRegistration(this.bundle, clazzes, service, mergedPropertes, this);
        this.registeredServices.add(registration);
        this.handleRefsUpdateOnRegister(registration);
        this.notifyServiceListeners(1, registration.getReference());
        return registration;
    }

    private void handleRefsUpdateOnRegister(MockServiceRegistration registration) {
        List<OsgiServiceUtil.ReferenceInfo> affectedDynamicReferences = OsgiServiceUtil.getMatchingDynamicReferences(this.registeredServices, registration);
        block8: for (OsgiServiceUtil.ReferenceInfo referenceInfo : affectedDynamicReferences) {
            OsgiMetadataUtil.Reference reference = referenceInfo.getReference();
            switch (reference.getCardinality()) {
                case MANDATORY_UNARY: {
                    throw new ReferenceViolationException("Mandatory unary reference of type " + reference.getInterfaceType() + " already fulfilled for service " + reference.getServiceClass().getName() + ", registration of new service with this interface failed.");
                }
                case MANDATORY_MULTIPLE: 
                case OPTIONAL_MULTIPLE: 
                case OPTIONAL_UNARY: {
                    OsgiServiceUtil.invokeBindMethod(reference, referenceInfo.getServiceRegistration().getService(), new OsgiServiceUtil.ServiceInfo(registration));
                    continue block8;
                }
            }
            throw new RuntimeException("Unepxected cardinality: " + (Object)((Object)reference.getCardinality()));
        }
        List<OsgiServiceUtil.ReferenceInfo> affectedStaticGreedyReferences = OsgiServiceUtil.getMatchingStaticGreedyReferences(this.registeredServices, registration);
        block9: for (OsgiServiceUtil.ReferenceInfo referenceInfo : affectedStaticGreedyReferences) {
            OsgiMetadataUtil.Reference reference = referenceInfo.getReference();
            switch (reference.getCardinality()) {
                case MANDATORY_UNARY: {
                    throw new ReferenceViolationException("Mandatory unary reference of type " + reference.getInterfaceType() + " already fulfilled for service " + reference.getServiceClass().getName() + ", registration of new service with this interface failed.");
                }
                case MANDATORY_MULTIPLE: 
                case OPTIONAL_MULTIPLE: 
                case OPTIONAL_UNARY: {
                    this.restartService(referenceInfo.getServiceRegistration());
                    continue block9;
                }
            }
            throw new RuntimeException("Unepxected cardinality: " + (Object)((Object)reference.getCardinality()));
        }
    }

    void unregisterService(MockServiceRegistration registration) {
        this.registeredServices.remove(registration);
        this.handleRefsUpdateOnUnregister(registration);
        this.notifyServiceListeners(4, registration.getReference());
    }

    void restartService(MockServiceRegistration registration) {
        Object newService;
        Class<?> serviceClass = registration.getService().getClass();
        Map<String, Object> properties = MapUtil.toMap(registration.getProperties());
        MockOsgi.deactivate(registration.getService(), this);
        this.unregisterService(registration);
        try {
            newService = serviceClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to instantiate service: " + serviceClass);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to access service class: " + serviceClass);
        }
        MockOsgi.injectServices(newService, this);
        MockOsgi.activate(newService, (BundleContext)this, properties);
        this.registerService(serviceClass.getName(), newService, MapUtil.toDictionary(properties));
    }

    private void handleRefsUpdateOnUnregister(MockServiceRegistration registration) {
        List<OsgiServiceUtil.ReferenceInfo> affectedDynamicReferences = OsgiServiceUtil.getMatchingDynamicReferences(this.registeredServices, registration);
        block8: for (OsgiServiceUtil.ReferenceInfo referenceInfo : affectedDynamicReferences) {
            OsgiMetadataUtil.Reference reference = referenceInfo.getReference();
            switch (reference.getCardinality()) {
                case MANDATORY_UNARY: {
                    throw new ReferenceViolationException("Reference of type " + reference.getInterfaceType() + " for service " + reference.getServiceClass().getName() + " is mandatory unary, unregistration of service with this interface failed.");
                }
                case MANDATORY_MULTIPLE: 
                case OPTIONAL_MULTIPLE: 
                case OPTIONAL_UNARY: {
                    OsgiServiceUtil.invokeUnbindMethod(reference, referenceInfo.getServiceRegistration().getService(), new OsgiServiceUtil.ServiceInfo(registration));
                    continue block8;
                }
            }
            throw new RuntimeException("Unepxected cardinality: " + (Object)((Object)reference.getCardinality()));
        }
        List<OsgiServiceUtil.ReferenceInfo> affectedStaticGreedyReferences = OsgiServiceUtil.getMatchingStaticGreedyReferences(this.registeredServices, registration);
        block9: for (OsgiServiceUtil.ReferenceInfo referenceInfo : affectedStaticGreedyReferences) {
            OsgiMetadataUtil.Reference reference = referenceInfo.getReference();
            switch (reference.getCardinality()) {
                case MANDATORY_UNARY: {
                    throw new ReferenceViolationException("Reference of type " + reference.getInterfaceType() + " for service " + reference.getServiceClass().getName() + " is mandatory unary, unregistration of service with this interface failed.");
                }
                case MANDATORY_MULTIPLE: 
                case OPTIONAL_MULTIPLE: 
                case OPTIONAL_UNARY: {
                    this.restartService(referenceInfo.getServiceRegistration());
                    continue block9;
                }
            }
            throw new RuntimeException("Unepxected cardinality: " + (Object)((Object)reference.getCardinality()));
        }
    }

    public ServiceReference getServiceReference(String clazz) {
        try {
            ServiceReference[] serviceRefs = this.getServiceReferences(clazz, null);
            if (serviceRefs != null && serviceRefs.length > 0) {
                return serviceRefs[0];
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        return null;
    }

    public ServiceReference getServiceReference(Class clazz) {
        return this.getServiceReference(clazz.getName());
    }

    public ServiceReference[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        TreeSet<ServiceReference> result = new TreeSet<ServiceReference>(new Comparator<ServiceReference>(){

            @Override
            public int compare(ServiceReference o1, ServiceReference o2) {
                return o2.compareTo((Object)o1);
            }
        });
        for (MockServiceRegistration serviceRegistration : this.registeredServices) {
            if (!serviceRegistration.matches(clazz, filter)) continue;
            result.add(serviceRegistration.getReference());
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new ServiceReference[result.size()]);
    }

    public Collection<ServiceReference> getServiceReferences(Class clazz, String filter) throws InvalidSyntaxException {
        return ImmutableList.copyOf((Object[])this.getServiceReferences(clazz.getName(), filter));
    }

    public ServiceReference[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        return this.getServiceReferences(clazz, filter);
    }

    public Object getService(ServiceReference serviceReference) {
        return ((MockServiceReference)serviceReference).getService();
    }

    public boolean ungetService(ServiceReference serviceReference) {
        return false;
    }

    public void addServiceListener(ServiceListener serviceListener) {
        try {
            this.addServiceListener(serviceListener, null);
        }
        catch (InvalidSyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void addServiceListener(ServiceListener serviceListener, String filter) throws InvalidSyntaxException {
        this.serviceListeners.put(serviceListener, this.createFilter(filter));
    }

    public void removeServiceListener(ServiceListener serviceListener) {
        this.serviceListeners.remove(serviceListener);
    }

    private void notifyServiceListeners(int eventType, ServiceReference serviceReference) {
        ServiceEvent event = new ServiceEvent(eventType, serviceReference);
        for (Map.Entry<ServiceListener, Filter> entry : this.serviceListeners.entrySet()) {
            if (entry.getValue() != null && !entry.getValue().match(serviceReference)) continue;
            entry.getKey().serviceChanged(event);
        }
    }

    public void addBundleListener(BundleListener bundleListener) {
        if (!this.bundleListeners.contains(bundleListener)) {
            this.bundleListeners.add(bundleListener);
        }
    }

    public void removeBundleListener(BundleListener bundleListener) {
        this.bundleListeners.remove(bundleListener);
    }

    void sendBundleEvent(BundleEvent bundleEvent) {
        for (BundleListener bundleListener : this.bundleListeners) {
            bundleListener.bundleChanged(bundleEvent);
        }
    }

    public void addFrameworkListener(FrameworkListener frameworkListener) {
    }

    public void removeFrameworkListener(FrameworkListener frameworkListener) {
    }

    Object locateService(String name, ServiceReference reference) {
        for (MockServiceRegistration serviceRegistration : this.registeredServices) {
            if (serviceRegistration.getReference() != reference) continue;
            return serviceRegistration.getService();
        }
        return null;
    }

    public Bundle[] getBundles() {
        return new Bundle[0];
    }

    public String getProperty(String s) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getDataFile(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Invalid path: " + path);
        }
        MockBundleContext mockBundleContext = this;
        synchronized (mockBundleContext) {
            if (this.dataFileBaseDir == null) {
                this.dataFileBaseDir = Files.createTempDir();
            }
        }
        if (path.isEmpty()) {
            return this.dataFileBaseDir;
        }
        return new File(this.dataFileBaseDir, path);
    }

    public void shutdown() {
        for (MockServiceRegistration serviceRegistration : ImmutableList.copyOf(this.registeredServices).reverse()) {
            try {
                MockOsgi.deactivate(serviceRegistration.getService(), (BundleContext)this, serviceRegistration.getProperties());
            }
            catch (NoScrMetadataException noScrMetadataException) {}
        }
        if (this.dataFileBaseDir != null) {
            try {
                FileUtils.deleteDirectory((File)this.dataFileBaseDir);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Bundle installBundle(String s) {
        throw new UnsupportedOperationException();
    }

    public Bundle installBundle(String s, InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    public Bundle getBundle(long l) {
        throw new UnsupportedOperationException();
    }

    public Bundle getBundle(String location) {
        throw new UnsupportedOperationException();
    }

    public <S> ServiceRegistration registerService(Class<S> clazz, ServiceFactory factory, Dictionary<String, ?> properties) {
        throw new UnsupportedOperationException();
    }
}

