/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.jcr;

import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.AuthorizableExistsException;
import org.apache.jackrabbit.api.security.user.AuthorizableTypeException;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.Query;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.testing.mock.jcr.MockGroup;
import org.apache.sling.testing.mock.jcr.MockUser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockUserManager
implements UserManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Map<String, Authorizable> authorizables = new HashMap<String, Authorizable>();
    private boolean autoSave;

    boolean removeAuthorizable(Authorizable a) throws RepositoryException {
        return this.authorizables.remove(a.getID(), a);
    }

    Set<Authorizable> all(int searchType) throws RepositoryException {
        return this.authorizables.values().stream().filter(a -> {
            boolean match = 3 == searchType ? true : (2 == searchType ? a.isGroup() : (1 == searchType ? !a.isGroup() : false));
            return match;
        }).collect(Collectors.toSet());
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }

    public void autoSave(boolean autoSave) throws RepositoryException {
        this.autoSave = autoSave;
    }

    @NotNull
    public Group createGroup(@NotNull String groupID) throws RepositoryException {
        return this.maybeCreateGroup(groupID, null, null);
    }

    @NotNull
    public Group createGroup(@NotNull Principal principal) throws RepositoryException {
        return this.maybeCreateGroup(null, principal, null);
    }

    @NotNull
    public Group createGroup(@NotNull Principal principal, @Nullable String intermediatePath) throws RepositoryException {
        return this.maybeCreateGroup(null, principal, intermediatePath);
    }

    @NotNull
    public Group createGroup(@NotNull String groupID, @NotNull Principal principal, @Nullable String intermediatePath) throws RepositoryException {
        return this.maybeCreateGroup(groupID, principal, intermediatePath);
    }

    @NotNull
    private Group maybeCreateGroup(@Nullable String groupID, @Nullable Principal principal, @Nullable String intermediatePath) throws RepositoryException {
        if (this.authorizables.containsKey(groupID)) {
            throw new AuthorizableExistsException("Group already exists");
        }
        return (Group)this.authorizables.computeIfAbsent(groupID, id -> new MockGroup((String)id, principal, intermediatePath, this));
    }

    @NotNull
    public User createSystemUser(@NotNull String userID, @Nullable String intermediatePath) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public User createUser(@NotNull String userID, @Nullable String password) throws RepositoryException {
        return this.maybeCreateUser(userID, password, null, null);
    }

    @NotNull
    public User createUser(@NotNull String userID, @Nullable String password, @NotNull Principal principal, @Nullable String intermediatePath) throws RepositoryException {
        return this.maybeCreateUser(userID, password, principal, intermediatePath);
    }

    @NotNull
    private User maybeCreateUser(@Nullable String userID, @Nullable String password, @Nullable Principal principal, @Nullable String intermediatePath) throws RepositoryException {
        if (this.authorizables.containsKey(userID)) {
            throw new AuthorizableExistsException("User already exists");
        }
        return (User)this.authorizables.computeIfAbsent(userID, id -> new MockUser((String)id, principal, intermediatePath, this));
    }

    @NotNull
    public Iterator<Authorizable> findAuthorizables(@NotNull Query query) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Iterator<Authorizable> findAuthorizables(@NotNull String relPath, @Nullable String value) throws RepositoryException {
        return this.findAuthorizables(relPath, value, 3);
    }

    @NotNull
    public Iterator<Authorizable> findAuthorizables(@NotNull String relPath, @Nullable String value, int searchType) throws RepositoryException {
        HashSet<Authorizable> matches = new HashSet<Authorizable>();
        block0: for (Authorizable authorizable : this.authorizables.values()) {
            Value[] property;
            if ((2 != searchType ? (1 != searchType ? 3 != searchType : authorizable.isGroup()) : !authorizable.isGroup()) || (property = authorizable.getProperty(relPath)) == null) continue;
            if (value == null) {
                matches.add(authorizable);
                continue;
            }
            for (Value value2 : property) {
                if (!value.equals(value2.getString())) continue;
                matches.add(authorizable);
                continue block0;
            }
        }
        return matches.iterator();
    }

    @Nullable
    public Authorizable getAuthorizable(@NotNull String id) throws RepositoryException {
        return this.authorizables.get(id);
    }

    @Nullable
    public Authorizable getAuthorizable(@NotNull Principal principal) throws RepositoryException {
        return this.authorizables.get(principal.getName());
    }

    @Nullable
    public <T extends Authorizable> T getAuthorizable(@NotNull String id, @NotNull Class<T> authorizableClass) throws RepositoryException {
        Authorizable a = null;
        Authorizable authorizable = this.authorizables.get(id);
        if (!authorizableClass.isInstance(authorizable)) {
            throw new AuthorizableTypeException("Not the expected authorizable class");
        }
        a = (Authorizable)authorizableClass.cast(authorizable);
        return (T)a;
    }

    @Nullable
    public Authorizable getAuthorizableByPath(@NotNull String path) throws RepositoryException {
        return this.authorizables.values().stream().filter(a -> {
            try {
                return path.equals(a.getPath());
            }
            catch (RepositoryException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Failed to match authorizable path", (Throwable)e);
                }
                return false;
            }
        }).findFirst().orElse(null);
    }
}

