/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.jcr;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.jcr.Credentials;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RangeIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.retention.RetentionManager;
import javax.jcr.security.AccessControlManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.iterator.RangeIteratorAdapter;
import org.apache.jackrabbit.value.ValueFactoryImpl;
import org.apache.sling.testing.mock.jcr.ItemData;
import org.apache.sling.testing.mock.jcr.ItemFilter;
import org.apache.sling.testing.mock.jcr.MockNode;
import org.apache.sling.testing.mock.jcr.MockPrincipalManager;
import org.apache.sling.testing.mock.jcr.MockProperty;
import org.apache.sling.testing.mock.jcr.MockRepository;
import org.apache.sling.testing.mock.jcr.MockUserManager;
import org.apache.sling.testing.mock.jcr.MockWorkspace;
import org.apache.sling.testing.mock.jcr.ResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.ContentHandler;

class MockSession
implements Session,
JackrabbitSession {
    private final MockRepository repository;
    private final Workspace workspace;
    private final Map<String, ItemData> items;
    private final String userId;
    private boolean isLive;
    private boolean hasKnownChanges;
    private MockPrincipalManager principalManager;
    private MockUserManager userManager;
    private AccessControlManager accessControlManager = null;

    public MockSession(MockRepository repository, Map<String, ItemData> items, String userId, String workspaceName) throws RepositoryException {
        this.repository = repository;
        this.workspace = new MockWorkspace(repository, this, workspaceName);
        this.userManager = new MockUserManager();
        this.principalManager = new MockPrincipalManager(this.userManager);
        this.items = items;
        this.userId = userId;
        this.isLive = true;
        this.hasKnownChanges = false;
        this.save();
    }

    private void checkLive() throws RepositoryException {
        if (!this.isLive) {
            throw new RepositoryException("Session is logged out / not live.");
        }
    }

    public ValueFactory getValueFactory() throws RepositoryException {
        this.checkLive();
        return ValueFactoryImpl.getInstance();
    }

    public Item getItem(String absPath) throws RepositoryException {
        this.checkLive();
        ItemData itemData = this.getItemData(absPath);
        if (itemData != null) {
            if (itemData.isNode()) {
                return new MockNode(itemData, this);
            }
            return new MockProperty(itemData, this);
        }
        throw new PathNotFoundException(String.format("No item found at: %s.", absPath));
    }

    public Node getNode(String absPath) throws RepositoryException {
        this.checkLive();
        Item item = this.getItem(absPath);
        if (item instanceof Node) {
            return (Node)item;
        }
        throw new PathNotFoundException(String.format("No node found at: %s.", absPath));
    }

    public Node getNodeByIdentifier(String id) throws RepositoryException {
        this.checkLive();
        for (ItemData item : this.items.values()) {
            if (!item.isNode() || !StringUtils.equals((CharSequence)item.getUuid(), (CharSequence)id)) continue;
            return new MockNode(item, this);
        }
        throw new ItemNotFoundException(String.format("No node found with id: %s.", id));
    }

    public Property getProperty(String absPath) throws RepositoryException {
        this.checkLive();
        Item item = this.getItem(absPath);
        if (item instanceof Property) {
            return (Property)item;
        }
        throw new PathNotFoundException(String.format("No property found at: %s.", absPath));
    }

    public boolean nodeExists(String absPath) throws RepositoryException {
        this.checkLive();
        return this.itemExists(absPath) && this.getItemData(absPath).isNode();
    }

    public boolean propertyExists(String absPath) throws RepositoryException {
        this.checkLive();
        return this.itemExists(absPath) && this.getItemData(absPath).isProperty();
    }

    public void removeItem(String absPath) throws RepositoryException {
        this.checkLive();
        this.removeItemWithChildren(absPath);
    }

    public Node getRootNode() throws RepositoryException {
        this.checkLive();
        return this.getNode("/");
    }

    public Node getNodeByUUID(String uuid) throws RepositoryException {
        this.checkLive();
        return this.getNodeByIdentifier(uuid);
    }

    void addItem(ItemData itemData) {
        this.items.put(itemData.getPath(), itemData);
    }

    private ItemData getItemData(String absPath) {
        String normalizedPath = ResourceUtil.normalize(absPath);
        return this.items.get(normalizedPath);
    }

    private void removeItemWithChildren(String absPath) throws RepositoryException {
        if (!this.itemExists(absPath)) {
            return;
        }
        ItemData parent = this.getItemData(absPath);
        String descendantPrefix = parent.getPath() + "/";
        ArrayList<String> pathsToRemove = new ArrayList<String>();
        pathsToRemove.add(parent.getPath());
        for (String itemPath : this.items.keySet()) {
            if (!itemPath.startsWith(descendantPrefix)) continue;
            pathsToRemove.add(itemPath);
        }
        for (String pathToRemove : pathsToRemove) {
            this.items.remove(pathToRemove);
        }
        this.hasKnownChanges = true;
    }

    RangeIterator listChildren(String parentPath, ItemFilter filter) throws RepositoryException {
        ArrayList<Item> children = new ArrayList<Item>();
        String path = parentPath.replaceFirst("/$", "");
        Pattern pattern = Pattern.compile("^" + Pattern.quote(path) + "/[^/]+$");
        for (ItemData item : this.items.values()) {
            if (!pattern.matcher(item.getPath()).matches() || filter != null && !filter.accept(item)) continue;
            children.add(item.getItem(this));
        }
        return new RangeIteratorAdapter(children.iterator(), (long)children.size());
    }

    void orderBefore(Item source, Item destination) throws RepositoryException {
        if (source == null) {
            return;
        }
        String sourcePath = source.getPath();
        String sourcePathPrefix = String.format("%s/", sourcePath);
        LinkedList<ItemData> itemsToMove = new LinkedList<ItemData>();
        for (String key : new ArrayList<String>(this.items.keySet())) {
            if (!key.equals(sourcePath) && !key.startsWith(sourcePathPrefix)) continue;
            itemsToMove.add(this.items.remove(key));
        }
        if (destination == null) {
            for (ItemData item : itemsToMove) {
                this.items.put(item.getPath(), item);
            }
            return;
        }
        for (String key : new ArrayList<String>(this.items.keySet())) {
            if (key.equals(destination.getPath())) {
                for (ItemData item : itemsToMove) {
                    this.items.put(item.getPath(), item);
                }
            }
            this.items.put(key, this.items.remove(key));
        }
    }

    public boolean hasPendingChanges() throws RepositoryException {
        this.checkLive();
        if (this.hasKnownChanges) {
            return true;
        }
        for (ItemData item : this.items.values()) {
            if (!item.isNew() && !item.isChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean itemExists(String absPath) throws RepositoryException {
        this.checkLive();
        return this.getItemData(absPath) != null;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public String getUserID() {
        return this.userId;
    }

    public String getNamespacePrefix(String uri) throws RepositoryException {
        this.checkLive();
        return this.getWorkspace().getNamespaceRegistry().getPrefix(uri);
    }

    public String[] getNamespacePrefixes() throws RepositoryException {
        this.checkLive();
        return this.getWorkspace().getNamespaceRegistry().getPrefixes();
    }

    public String getNamespaceURI(String prefix) throws RepositoryException {
        this.checkLive();
        return this.getWorkspace().getNamespaceRegistry().getURI(prefix);
    }

    public void setNamespacePrefix(String prefix, String uri) throws RepositoryException {
        this.checkLive();
        this.getWorkspace().getNamespaceRegistry().registerNamespace(prefix, uri);
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void save() throws RepositoryException {
        this.checkLive();
        for (ItemData itemData : this.items.values()) {
            itemData.setIsNew(false);
            itemData.setIsChanged(false);
        }
        this.hasKnownChanges = false;
    }

    public void refresh(boolean keepChanges) throws RepositoryException {
        this.checkLive();
        if (!keepChanges) {
            throw new UnsupportedOperationException();
        }
    }

    public void checkPermission(String absPath, String actions) throws RepositoryException {
        this.checkLive();
    }

    public boolean isLive() {
        return this.isLive;
    }

    public void logout() {
        this.isLive = false;
    }

    public Object getAttribute(String name) {
        return null;
    }

    public String[] getAttributeNames() {
        return new String[0];
    }

    public void addLockToken(String lt) {
        throw new UnsupportedOperationException();
    }

    public void exportDocumentView(String absPath, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void exportDocumentView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void exportSystemView(String absPath, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void exportSystemView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public String[] getLockTokens() {
        throw new UnsupportedOperationException();
    }

    public Session impersonate(Credentials credentials) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void move(String srcAbsPath, String destAbsPath) throws RepositoryException {
        this.checkLive();
        Objects.requireNonNull(srcAbsPath, "parameter 'srcAbsPath' must not be null");
        Objects.requireNonNull(destAbsPath, "parameter 'destAbsPath' must not be null");
        if (ResourceUtil.getName(destAbsPath).matches(".*\\[\\d+\\]")) {
            throw new RepositoryException("The destination path must not have an index on its final element");
        }
        if (this.nodeExists(destAbsPath) && !"true".equals(this.getRepository().getDescriptor("node.type.management.same.name.siblings.supported"))) {
            throw new ItemExistsException("The destination path already exists");
        }
        String destParentPath = ResourceUtil.getParent(destAbsPath);
        if (!this.nodeExists(destParentPath)) {
            throw new PathNotFoundException("The destination parent path does not exist");
        }
        if (!this.itemExists(srcAbsPath)) {
            throw new PathNotFoundException("The source path does not exist");
        }
        ItemData parent = this.getItemData(srcAbsPath);
        if (!parent.isNode()) {
            throw new RepositoryException("The source path must be a node");
        }
        String descendantPrefix = parent.getPath() + "/";
        LinkedHashMap<String, String> pathsToMove = new LinkedHashMap<String, String>();
        pathsToMove.put(parent.getPath(), destAbsPath);
        for (String string : this.items.keySet()) {
            if (!string.startsWith(descendantPrefix)) continue;
            String newPath = String.format("%s/%s", destAbsPath, string.substring(descendantPrefix.length()));
            pathsToMove.put(string, newPath);
        }
        for (Map.Entry entry : pathsToMove.entrySet()) {
            ItemData itemData = this.items.remove(entry.getKey());
            this.addItem(ItemData.cloneItemAtNewPath((String)entry.getValue(), itemData));
        }
        this.hasKnownChanges = true;
    }

    public void removeLockToken(String lt) {
        throw new UnsupportedOperationException();
    }

    public AccessControlManager getAccessControlManager() throws RepositoryException {
        if (this.accessControlManager == null) {
            throw new UnsupportedOperationException();
        }
        return this.accessControlManager;
    }

    public RetentionManager getRetentionManager() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public boolean hasCapability(String methodName, Object target, Object[] arguments) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public boolean hasPermission(String absPath, String actions) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Item getItemOrNull(String absPath) throws RepositoryException {
        Item item = null;
        if (this.itemExists(absPath)) {
            item = this.getItem(absPath);
        }
        return item;
    }

    public Node getNodeOrNull(String absPath) throws RepositoryException {
        Node node = null;
        if (this.nodeExists(absPath)) {
            node = this.getNode(absPath);
        }
        return node;
    }

    public Property getPropertyOrNull(String absPath) throws RepositoryException {
        Property prop = null;
        if (this.propertyExists(absPath)) {
            prop = this.getProperty(absPath);
        }
        return prop;
    }

    public PrincipalManager getPrincipalManager() throws RepositoryException {
        return this.principalManager;
    }

    public UserManager getUserManager() throws RepositoryException {
        return this.userManager;
    }

    public boolean hasPermission(@NotNull String absPath, String ... actions) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void setAccessControlManager(AccessControlManager acm) {
        this.accessControlManager = acm;
    }
}

