/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.jcr;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.jcr.Binary;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.lock.Lock;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.commons.ItemNameMatcher;
import org.apache.jackrabbit.commons.iterator.NodeIteratorAdapter;
import org.apache.jackrabbit.commons.iterator.PropertyIteratorAdapter;
import org.apache.sling.testing.mock.jcr.AbstractItem;
import org.apache.sling.testing.mock.jcr.ItemData;
import org.apache.sling.testing.mock.jcr.ItemFilter;
import org.apache.sling.testing.mock.jcr.MockNodeDefinition;
import org.apache.sling.testing.mock.jcr.MockNodeTypeManager;
import org.apache.sling.testing.mock.jcr.MockProperty;

class MockNode
extends AbstractItem
implements Node {
    public MockNode(ItemData itemData, Session session) {
        super(itemData, session);
    }

    public Node addNode(String relPath) throws RepositoryException {
        return this.addNode(relPath, "nt:unstructured");
    }

    public Node addNode(String relPath, String primaryNodeTypeName) throws RepositoryException {
        String path = this.makeAbsolutePath(relPath);
        NodeType nodeType = this.getSession().getWorkspace().getNodeTypeManager().getNodeType(primaryNodeTypeName);
        ItemData itemData = ItemData.newNode(path, nodeType);
        MockNode node = new MockNode(itemData, this.getSession());
        this.getMockedSession().addItem(itemData);
        node.setProperty("jcr:primaryType", primaryNodeTypeName);
        if (((MockNodeTypeManager)this.getSession().getWorkspace().getNodeTypeManager()).isMode(MockNodeTypeManager.ResolveMode.ONLY_REGISTERED)) {
            PropertyDefinition[] propDefinitions;
            NodeDefinition[] childNodeDefinitions = nodeType.getChildNodeDefinitions();
            if (childNodeDefinitions != null) {
                for (NodeDefinition nodeDefinition : childNodeDefinitions) {
                    if (!nodeDefinition.isAutoCreated()) continue;
                    String defaultPrimaryTypeName = nodeDefinition.getDefaultPrimaryTypeName();
                    node.addNode(nodeDefinition.getName(), defaultPrimaryTypeName);
                }
            }
            if ((propDefinitions = nodeType.getPropertyDefinitions()) != null) {
                for (PropertyDefinition propDefinition : propDefinitions) {
                    if (!propDefinition.isAutoCreated()) continue;
                    Value[] defaultValues = propDefinition.getDefaultValues();
                    if (propDefinition.isMultiple()) {
                        node.setProperty(propDefinition.getName(), defaultValues);
                        continue;
                    }
                    if (defaultValues.length <= 0) continue;
                    node.setProperty(propDefinition.getName(), defaultValues[0]);
                }
            }
        }
        if (StringUtils.equals((CharSequence)primaryNodeTypeName, (CharSequence)"nt:file")) {
            node.setProperty("jcr:created", Calendar.getInstance());
            node.setProperty("jcr:createdBy", this.getMockedSession().getUserID());
        }
        return node;
    }

    public Node getNode(String relPath) throws RepositoryException {
        String path = this.makeAbsolutePath(relPath);
        return this.getSession().getNode(path);
    }

    public NodeIterator getNodes() throws RepositoryException {
        RangeIterator items = this.getMockedSession().listChildren(this.getPath(), new ItemFilter(){

            @Override
            public boolean accept(ItemData item) throws RepositoryException {
                return item.isNode();
            }
        });
        return new NodeIteratorAdapter((Iterator)items, items.getSize());
    }

    public NodeIterator getNodes(String namePattern) throws RepositoryException {
        final Pattern pattern = Pattern.compile(namePattern);
        RangeIterator items = this.getMockedSession().listChildren(this.getPath(), new ItemFilter(){

            @Override
            public boolean accept(ItemData item) throws RepositoryException {
                return item.isNode() && pattern.matcher(item.getName()).matches();
            }
        });
        return new NodeIteratorAdapter((Iterator)items, items.getSize());
    }

    public NodeIterator getNodes(final String[] nameGlobs) throws RepositoryException {
        RangeIterator items = this.getMockedSession().listChildren(this.getPath(), new ItemFilter(){

            @Override
            public boolean accept(ItemData item) throws RepositoryException {
                return item.isNode() && ItemNameMatcher.matches((String)item.getName(), (String[])nameGlobs);
            }
        });
        return new NodeIteratorAdapter((Iterator)items, items.getSize());
    }

    public PropertyIterator getProperties() throws RepositoryException {
        RangeIterator items = this.getMockedSession().listChildren(this.getPath(), new ItemFilter(){

            @Override
            public boolean accept(ItemData item) throws RepositoryException {
                return item.isProperty();
            }
        });
        return new PropertyIteratorAdapter((Iterator)items, items.getSize());
    }

    public PropertyIterator getProperties(String namePattern) throws RepositoryException {
        final Pattern pattern = Pattern.compile(namePattern);
        RangeIterator items = this.getMockedSession().listChildren(this.getPath(), new ItemFilter(){

            @Override
            public boolean accept(ItemData item) throws RepositoryException {
                return item.isProperty() && pattern.matcher(item.getName()).matches();
            }
        });
        return new PropertyIteratorAdapter((Iterator)items, items.getSize());
    }

    public PropertyIterator getProperties(final String[] nameGlobs) throws RepositoryException {
        RangeIterator items = this.getMockedSession().listChildren(this.getPath(), new ItemFilter(){

            @Override
            public boolean accept(ItemData item) throws RepositoryException {
                return item.isProperty() && ItemNameMatcher.matches((String)item.getName(), (String[])nameGlobs);
            }
        });
        return new PropertyIteratorAdapter((Iterator)items, items.getSize());
    }

    public Property getProperty(String relPath) throws RepositoryException {
        String path = this.makeAbsolutePath(relPath);
        return this.getSession().getProperty(path);
    }

    public String getIdentifier() throws RepositoryException {
        return this.itemData.getUuid();
    }

    public String getUUID() throws RepositoryException {
        return this.getIdentifier();
    }

    public boolean hasNode(String relPath) throws RepositoryException {
        String path = this.makeAbsolutePath(relPath);
        return this.getSession().nodeExists(path);
    }

    public boolean hasNodes() throws RepositoryException {
        return this.getNodes().hasNext();
    }

    public boolean hasProperties() throws RepositoryException {
        return this.getProperties().hasNext();
    }

    public boolean hasProperty(String relPath) throws RepositoryException {
        String path = this.makeAbsolutePath(relPath);
        return this.getSession().propertyExists(path);
    }

    public Property setProperty(String name, Value value) throws RepositoryException {
        ItemData itemData = ItemData.newProperty(this.getPath() + "/" + name);
        MockProperty property = new MockProperty(itemData, this.getSession());
        property.setValue(value);
        this.addItemOrRemoveIfValueNull(itemData, value);
        return property;
    }

    public Property setProperty(String name, Value[] values) throws RepositoryException {
        ItemData itemData = ItemData.newProperty(this.getPath() + "/" + name);
        MockProperty property = new MockProperty(itemData, this.getSession());
        property.setValue(values);
        this.addItemOrRemoveIfValueNull(itemData, values);
        return property;
    }

    public Property setProperty(String name, String[] values) throws RepositoryException {
        ItemData itemData = ItemData.newProperty(this.getPath() + "/" + name);
        MockProperty property = new MockProperty(itemData, this.getSession());
        property.setValue(values);
        this.addItemOrRemoveIfValueNull(itemData, values);
        return property;
    }

    public Property setProperty(String name, String value) throws RepositoryException {
        ItemData itemData = ItemData.newProperty(this.getPath() + "/" + name);
        MockProperty property = new MockProperty(itemData, this.getSession());
        property.setValue(value);
        this.addItemOrRemoveIfValueNull(itemData, value);
        return property;
    }

    public Property setProperty(String name, InputStream value) throws RepositoryException {
        ItemData itemData = ItemData.newProperty(this.getPath() + "/" + name);
        MockProperty property = new MockProperty(itemData, this.getSession());
        property.setValue(value);
        this.addItemOrRemoveIfValueNull(itemData, value);
        return property;
    }

    public Property setProperty(String name, boolean value) throws RepositoryException {
        ItemData itemData = ItemData.newProperty(this.getPath() + "/" + name);
        MockProperty property = new MockProperty(itemData, this.getSession());
        property.setValue(value);
        this.addItem(itemData);
        return property;
    }

    public Property setProperty(String name, double value) throws RepositoryException {
        ItemData itemData = ItemData.newProperty(this.getPath() + "/" + name);
        MockProperty property = new MockProperty(itemData, this.getSession());
        property.setValue(value);
        this.addItem(itemData);
        return property;
    }

    public Property setProperty(String name, long value) throws RepositoryException {
        ItemData itemData = ItemData.newProperty(this.getPath() + "/" + name);
        MockProperty property = new MockProperty(itemData, this.getSession());
        property.setValue(value);
        this.addItem(itemData);
        return property;
    }

    public Property setProperty(String name, Calendar value) throws RepositoryException {
        ItemData itemData = ItemData.newProperty(this.getPath() + "/" + name);
        MockProperty property = new MockProperty(itemData, this.getSession());
        property.setValue(value);
        this.addItemOrRemoveIfValueNull(itemData, value);
        return property;
    }

    public Property setProperty(String name, Node value) throws RepositoryException {
        ItemData itemData = ItemData.newProperty(this.getPath() + "/" + name);
        MockProperty property = new MockProperty(itemData, this.getSession());
        property.setValue(value);
        this.addItemOrRemoveIfValueNull(itemData, value);
        return property;
    }

    public Property setProperty(String name, Binary value) throws RepositoryException {
        ItemData itemData = ItemData.newProperty(this.getPath() + "/" + name);
        MockProperty property = new MockProperty(itemData, this.getSession());
        property.setValue(value);
        this.addItemOrRemoveIfValueNull(itemData, value);
        return property;
    }

    public Property setProperty(String name, BigDecimal value) throws RepositoryException {
        ItemData itemData = ItemData.newProperty(this.getPath() + "/" + name);
        MockProperty property = new MockProperty(itemData, this.getSession());
        property.setValue(value);
        this.addItemOrRemoveIfValueNull(itemData, value);
        return property;
    }

    private void addItem(ItemData itemData) {
        this.getMockedSession().addItem(itemData);
        this.itemData.setIsChanged(true);
    }

    private void addItemOrRemoveIfValueNull(ItemData itemData, Object value) throws RepositoryException {
        if (value == null) {
            this.getMockedSession().removeItem(itemData.getPath());
        } else {
            this.getMockedSession().addItem(itemData);
        }
        this.itemData.setIsChanged(true);
    }

    public boolean isNode() {
        return true;
    }

    public boolean isNodeType(String nodeTypeName) throws RepositoryException {
        boolean istype = this.itemData.getNodeType().isNodeType(nodeTypeName);
        if (!istype) {
            istype = Arrays.stream(this.getMixinNodeTypes()).anyMatch(nt -> nt.getName().equals(nodeTypeName));
        }
        return istype;
    }

    public NodeType getPrimaryNodeType() throws RepositoryException {
        return this.itemData.getNodeType();
    }

    public Item getPrimaryItem() throws RepositoryException {
        if (this.hasProperty("jcr:data")) {
            return this.getProperty("jcr:data");
        }
        if (this.hasNode("jcr:content")) {
            return this.getNode("jcr:content");
        }
        throw new ItemNotFoundException();
    }

    public int hashCode() {
        return this.itemData.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MockNode) {
            return this.itemData.equals(((MockNode)obj).itemData);
        }
        return false;
    }

    public NodeType[] getMixinNodeTypes() throws RepositoryException {
        try {
            Value[] mixinNames = this.getProperty("jcr:mixinTypes").getValues();
            return (NodeType[])Arrays.stream(mixinNames).map(value -> {
                try {
                    return value.getString();
                }
                catch (RepositoryException e) {
                    return null;
                }
            }).filter(Objects::nonNull).map(name -> {
                try {
                    return this.getSession().getWorkspace().getNodeTypeManager().getNodeType(name);
                }
                catch (RepositoryException e) {
                    return null;
                }
            }).filter(Objects::nonNull).toArray(NodeType[]::new);
        }
        catch (PathNotFoundException e) {
            return new NodeType[0];
        }
    }

    public void orderBefore(String srcChildRelPath, String destChildRelPath) throws RepositoryException {
        Item srcChild = srcChildRelPath == null ? null : this.getMockedSession().getItem(this.getPath() + "/" + srcChildRelPath);
        Item destChild = destChildRelPath == null ? null : this.getMockedSession().getItem(this.getPath() + "/" + destChildRelPath);
        this.getMockedSession().orderBefore(srcChild, destChild);
    }

    public NodeDefinition getDefinition() throws RepositoryException {
        if (((MockNodeTypeManager)this.getSession().getWorkspace().getNodeTypeManager()).isMode(MockNodeTypeManager.ResolveMode.MOCK_ALL)) {
            return new MockNodeDefinition();
        }
        String nodeName = this.getName();
        NodeDefinition nodeDef = this.findChildNodeDef(nodeName);
        if (nodeDef == null) {
            nodeDef = this.findChildNodeDef("*");
        }
        return nodeDef;
    }

    protected NodeDefinition findChildNodeDef(String name) throws RepositoryException {
        NodeType nt;
        NodeDefinition[] childNodeDefinitions;
        NodeDefinition nodeDef = null;
        Node parent = this.getParent();
        if (parent != null && (nodeDef = (NodeDefinition)Stream.of(childNodeDefinitions = (nt = parent.getPrimaryNodeType()).getChildNodeDefinitions()).filter(def -> name.equals(def.getName())).findFirst().orElse(null)) == null) {
            NodeType nodeType;
            NodeType[] mixinNodeTypes;
            NodeType[] nodeTypeArray = mixinNodeTypes = parent.getMixinNodeTypes();
            int n = nodeTypeArray.length;
            for (int i = 0; i < n && (nodeDef = (NodeDefinition)Stream.of(childNodeDefinitions = (nodeType = nodeTypeArray[i]).getChildNodeDefinitions()).filter(def -> name.equals(def.getName())).findFirst().orElse(null)) == null; ++i) {
            }
        }
        return nodeDef;
    }

    public void setPrimaryType(String primaryNodeTypeName) throws RepositoryException {
        if (!StringUtils.isNotBlank((CharSequence)primaryNodeTypeName)) {
            throw new NoSuchNodeTypeException("Not accepting blank node types");
        }
        NodeType nodeType = this.getSession().getWorkspace().getNodeTypeManager().getNodeType(primaryNodeTypeName);
        this.itemData.setNodeType(nodeType);
        this.setProperty("jcr:primaryType", primaryNodeTypeName);
    }

    public void addMixin(String mixinName) throws RepositoryException {
        if (StringUtils.isNotBlank((CharSequence)mixinName)) {
            if (!this.hasProperty("jcr:mixinTypes")) {
                String[] mixinNames = new String[]{mixinName};
                this.setProperty("jcr:mixinTypes", mixinNames);
            } else {
                Value value = this.getSession().getValueFactory().createValue(mixinName);
                Value[] newValues = (Value[])Stream.concat(Arrays.stream(this.getProperty("jcr:mixinTypes").getValues()), Stream.of(value)).toArray(Value[]::new);
                this.setProperty("jcr:mixinTypes", newValues);
            }
            if (((MockNodeTypeManager)this.getSession().getWorkspace().getNodeTypeManager()).isMode(MockNodeTypeManager.ResolveMode.ONLY_REGISTERED)) {
                PropertyDefinition[] propDefinitions;
                NodeType mixinNodeType = this.getSession().getWorkspace().getNodeTypeManager().getNodeType(mixinName);
                NodeDefinition[] childNodeDefinitions = mixinNodeType.getChildNodeDefinitions();
                if (childNodeDefinitions != null) {
                    for (NodeDefinition nodeDefinition : childNodeDefinitions) {
                        if (!nodeDefinition.isAutoCreated()) continue;
                        String defaultPrimaryTypeName = nodeDefinition.getDefaultPrimaryTypeName();
                        this.addNode(nodeDefinition.getName(), defaultPrimaryTypeName);
                    }
                }
                if ((propDefinitions = mixinNodeType.getPropertyDefinitions()) != null) {
                    for (PropertyDefinition propDefinition : propDefinitions) {
                        if (!propDefinition.isAutoCreated()) continue;
                        Value[] defaultValues = propDefinition.getDefaultValues();
                        if (propDefinition.isMultiple()) {
                            this.setProperty(propDefinition.getName(), defaultValues);
                            continue;
                        }
                        if (defaultValues.length <= 0) continue;
                        this.setProperty(propDefinition.getName(), defaultValues[0]);
                    }
                }
            }
        } else {
            throw new NoSuchNodeTypeException("Not accepting blank mixin name");
        }
    }

    public void removeMixin(String mixinName) throws RepositoryException {
        if (!this.hasProperty("jcr:mixinTypes")) {
            throw new NoSuchNodeTypeException("Cannot remove blank mixin");
        }
        Value[] currentValues = this.getProperty("jcr:mixinTypes").getValues();
        Value valueToBeRemoved = this.getSession().getValueFactory().createValue(mixinName);
        Value[] newValues = (Value[])Arrays.stream(currentValues).filter(value -> !value.equals(valueToBeRemoved)).toArray(Value[]::new);
        this.setProperty("jcr:mixinTypes", newValues);
    }

    public Property setProperty(String name, Value value, int type) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Property setProperty(String name, Value[] values, int type) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Property setProperty(String name, String[] values, int type) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Property setProperty(String name, String value, int type) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public boolean canAddMixin(String mixinName) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void cancelMerge(Version version) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Version checkin() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void checkout() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void doneMerge(Version version) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Version getBaseVersion() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public String getCorrespondingNodePath(String workspaceName) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public int getIndex() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Lock getLock() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public PropertyIterator getReferences() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public VersionHistory getVersionHistory() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public boolean holdsLock() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public boolean isCheckedOut() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public boolean isLocked() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Lock lock(boolean isDeep, boolean isSessionScoped) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public NodeIterator merge(String srcWorkspace, boolean bestEffort) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void restore(String versionName, boolean removeExisting) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void restore(Version version, boolean removeExisting) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void restore(Version version, String relPath, boolean removeExisting) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void restoreByLabel(String versionLabel, boolean removeExisting) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void unlock() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void update(String srcWorkspaceName) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void followLifecycleTransition(String transition) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public String[] getAllowedLifecycleTransistions() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public PropertyIterator getReferences(String name) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public NodeIterator getSharedSet() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public PropertyIterator getWeakReferences() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public PropertyIterator getWeakReferences(String name) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void removeShare() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void removeSharedSet() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void accept(ItemVisitor visitor) throws RepositoryException {
        visitor.visit((Node)this);
    }
}

