/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.jcr;

import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.sling.testing.mock.jcr.MockAuthorizable;
import org.apache.sling.testing.mock.jcr.MockUserManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MockGroup
extends MockAuthorizable
implements Group {
    private Map<String, Authorizable> declaredMembers = new HashMap<String, Authorizable>();

    public MockGroup(@Nullable String id, @Nullable Principal principal, @Nullable String intermediatePath, @NotNull MockUserManager mockUserMgr) {
        super(id, principal, intermediatePath, mockUserMgr);
    }

    @NotNull
    public Iterator<Authorizable> getDeclaredMembers() throws RepositoryException {
        return this.declaredMembers.values().iterator();
    }

    @NotNull
    public Iterator<Authorizable> getMembers() throws RepositoryException {
        HashSet<Authorizable> members = new HashSet<Authorizable>();
        this.calcMembers(members, this, new HashSet<Group>());
        return members.iterator();
    }

    private void calcMembers(Set<Authorizable> members, Group group, Set<Group> processedGroups) throws RepositoryException {
        if (!processedGroups.contains(group)) {
            processedGroups.add(group);
            @NotNull Iterator declaredIt = group.getDeclaredMembers();
            while (declaredIt.hasNext()) {
                Authorizable authorizable = (Authorizable)declaredIt.next();
                members.add(authorizable);
                if (!(authorizable instanceof Group)) continue;
                Group subgroup = (Group)authorizable;
                this.calcMembers(members, subgroup, processedGroups);
            }
        }
    }

    public boolean isDeclaredMember(@NotNull Authorizable authorizable) throws RepositoryException {
        return this.declaredMembers.containsValue(authorizable);
    }

    public boolean isMember(@NotNull Authorizable authorizable) throws RepositoryException {
        boolean value = this.declaredMembers.containsValue(authorizable);
        if (!value) {
            for (Authorizable m : this.declaredMembers.values()) {
                if (m.isGroup()) {
                    value = ((Group)m).isDeclaredMember(authorizable);
                }
                if (!value) continue;
                break;
            }
        }
        return value;
    }

    public boolean addMember(@NotNull Authorizable authorizable) throws RepositoryException {
        boolean added = false;
        if (!this.isMember(authorizable)) {
            this.declaredMembers.put(authorizable.getID(), authorizable);
            ((MockAuthorizable)authorizable).addDeclaredMemberOf(this);
            added = true;
        }
        return added;
    }

    @NotNull
    public Set<String> addMembers(String ... memberIds) throws RepositoryException {
        HashSet<String> added = new HashSet<String>();
        for (String id : memberIds) {
            Authorizable authorizable;
            if (this.declaredMembers.containsKey(id) || (authorizable = this.mockUserMgr.getAuthorizable(id)) == null) continue;
            this.addMember(authorizable);
            added.add(id);
        }
        return added;
    }

    public boolean removeMember(@NotNull Authorizable authorizable) throws RepositoryException {
        return this.declaredMembers.remove(authorizable.getID(), authorizable);
    }

    @NotNull
    public Set<String> removeMembers(String ... memberIds) throws RepositoryException {
        HashSet<String> removed = new HashSet<String>();
        for (String id : memberIds) {
            if (this.declaredMembers.remove(id) == null) continue;
            removed.add(id);
        }
        return removed;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MockGroup [id=");
        builder.append(this.id);
        builder.append("]");
        return builder.toString();
    }
}

