/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.jcr;

import java.nio.file.Paths;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.value.ValueFactoryImpl;
import org.apache.sling.testing.mock.jcr.MockUserManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class MockAuthorizable
implements Authorizable {
    static final String REP_PRINCIPAL_NAME = "rep:principalName";
    protected String id;
    protected Principal principal;
    protected String path;
    protected MockUserManager mockUserMgr;
    protected Map<String, Value[]> propsMap = new HashMap<String, Value[]>();
    protected Set<Group> declaredMemberOf = new HashSet<Group>();

    MockAuthorizable(@Nullable String id, @Nullable Principal principal, @Nullable String intermediatePath, @NotNull MockUserManager mockUserMgr) {
        this.principal = principal;
        this.id = id == null && principal != null ? principal.getName() : id;
        if (principal == null) {
            this.principal = () -> this.id;
        }
        if (intermediatePath == null) {
            intermediatePath = this.isGroup() ? "/home/groups" : "/home/users";
        }
        this.path = Paths.get(intermediatePath, this.id).toString();
        this.mockUserMgr = mockUserMgr;
        this.propsMap.put(REP_PRINCIPAL_NAME, new Value[]{ValueFactoryImpl.getInstance().createValue(this.id)});
    }

    @NotNull
    public String getID() throws RepositoryException {
        return this.id;
    }

    public boolean isGroup() {
        return this instanceof Group;
    }

    @NotNull
    public Principal getPrincipal() throws RepositoryException {
        return this.principal;
    }

    @NotNull
    public Iterator<Group> declaredMemberOf() throws RepositoryException {
        return this.declaredMemberOf.iterator();
    }

    @NotNull
    public Iterator<Group> memberOf() throws RepositoryException {
        HashSet<Group> memberOf = new HashSet<Group>();
        this.calcMemberOf(memberOf, this, new HashSet<Authorizable>());
        return memberOf.iterator();
    }

    private void calcMemberOf(Set<Group> memberOf, Authorizable authorizable, Set<Authorizable> processedAuthorizables) throws RepositoryException {
        if (!processedAuthorizables.contains(authorizable)) {
            processedAuthorizables.add(authorizable);
            @NotNull Iterator declaredIt = authorizable.declaredMemberOf();
            while (declaredIt.hasNext()) {
                Group group = (Group)declaredIt.next();
                memberOf.add(group);
                this.calcMemberOf(memberOf, (Authorizable)group, processedAuthorizables);
            }
        }
    }

    public void remove() throws RepositoryException {
        this.mockUserMgr.removeAuthorizable(this);
    }

    @NotNull
    public Iterator<String> getPropertyNames() throws RepositoryException {
        Set propNames = this.propsMap.keySet().stream().filter(key -> key.indexOf(47) == -1).collect(Collectors.toSet());
        return propNames.iterator();
    }

    @NotNull
    public Iterator<String> getPropertyNames(@NotNull String relPath) throws RepositoryException {
        Set propNames = this.propsMap.keySet().stream().filter(key -> key.startsWith(relPath)).collect(Collectors.toSet());
        return propNames.iterator();
    }

    public boolean hasProperty(@NotNull String relPath) throws RepositoryException {
        return this.propsMap.containsKey(relPath);
    }

    public void setProperty(@NotNull String relPath, @Nullable Value value) throws RepositoryException {
        this.propsMap.put(relPath, new Value[]{value});
    }

    public void setProperty(@NotNull String relPath, @Nullable Value[] value) throws RepositoryException {
        this.propsMap.put(relPath, value);
    }

    @Nullable
    public Value[] getProperty(@NotNull String relPath) throws RepositoryException {
        return this.propsMap.get(relPath);
    }

    public boolean removeProperty(@NotNull String relPath) throws RepositoryException {
        return this.propsMap.remove(relPath) != null;
    }

    @NotNull
    public String getPath() throws RepositoryException {
        return this.path;
    }

    public void addDeclaredMemberOf(Group group) {
        this.declaredMemberOf.add(group);
    }
}

