/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.starter.access.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinition;

public class RestrictionItem {
    private RestrictionDefinition rd;
    private Object value;
    private boolean exists;

    public RestrictionItem(RestrictionDefinition rd, Object value, boolean exists) {
        this.rd = rd;
        this.value = value;
        this.exists = exists;
    }

    public String getName() {
        return this.rd.getName();
    }

    public boolean isMultiValue() {
        return this.rd.getRequiredType().isArray();
    }

    public String getValue() throws RepositoryException {
        String[] values;
        String v = null;
        if (this.value instanceof Value) {
            v = ((Value)this.value).getString();
        } else if (this.value instanceof Value[]) {
            Value[] va = (Value[])this.value;
            if (va.length > 0) {
                v = va[0].getString();
            }
        } else if (this.value instanceof String) {
            v = (String)this.value;
        } else if (this.value instanceof String[] && (values = (String[])this.value).length > 0) {
            v = values[0];
        }
        if (v == null) {
            v = "";
        }
        return v;
    }

    public List<String> getValues() throws RepositoryException {
        ArrayList<String> values = new ArrayList<String>();
        if (this.value instanceof Value) {
            values.add(((Value)this.value).getString());
        } else if (this.value instanceof Value[]) {
            Value[] va;
            for (Value v : va = (Value[])this.value) {
                values.add(v.getString());
            }
        } else if (this.value instanceof String) {
            values.add((String)this.value);
        } else if (this.value instanceof String[]) {
            values.addAll(Arrays.asList((String[])this.value));
        }
        if (values.isEmpty()) {
            values.add("");
        }
        return values;
    }

    public boolean isExists() {
        return this.exists;
    }

    public void setExists(boolean exists) {
        this.exists = exists;
    }

    public boolean isMandatory() {
        return this.rd.isMandatory();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RestrictionItem [name=");
        builder.append(this.rd.getName());
        builder.append(", value=");
        try {
            builder.append(this.getValues());
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        builder.append(", exists=");
        builder.append(this.exists);
        builder.append("]");
        return builder.toString();
    }
}

