/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.starter.access.models;

import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.jcr.Node;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.jcr.jackrabbit.accessmanager.PrivilegesInfo;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;

public abstract class AccessFormPage {
    protected PrivilegesInfo privilegesInfo = null;
    @ScriptVariable
    protected SlingHttpServletRequest request;
    @ScriptVariable
    protected SlingHttpServletResponse response;
    @ScriptVariable
    protected Resource resource;

    @PostConstruct
    protected void init() throws IOException {
        if (!this.getCanReadAccessControl()) {
            if (this.request.getRemoteUser() == null) {
                this.response.sendError(404);
            } else {
                this.response.sendError(403);
            }
        }
    }

    protected PrivilegesInfo getPrivilegesInfo() {
        if (this.privilegesInfo == null) {
            this.privilegesInfo = new PrivilegesInfo();
        }
        return this.privilegesInfo;
    }

    public boolean getCanReadAccessControl() {
        return this.getPrivilegesInfo().canReadAccessControl((Node)this.resource.adaptTo(Node.class));
    }

    public boolean getCanModifyAccessControl() {
        return this.getPrivilegesInfo().canModifyAccessControl((Node)this.resource.adaptTo(Node.class));
    }

    public String getLocation() {
        String location = null;
        if (this.resource != null) {
            location = this.resource.getResourceResolver().map(this.resource.getPath());
        }
        return location;
    }
}

