/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.sitemap.impl;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.sitemap.SitemapGeneratorManager;
import org.apache.sling.sitemap.SitemapInfo;
import org.apache.sling.sitemap.SitemapService;
import org.apache.sling.sitemap.SitemapUtil;
import org.apache.sling.sitemap.impl.SitemapScheduler;
import org.apache.sling.sitemap.impl.SitemapServiceConfiguration;
import org.apache.sling.sitemap.impl.SitemapStorage;
import org.apache.sling.sitemap.impl.SitemapStorageInfo;
import org.apache.sling.sitemap.spi.common.SitemapLinkExternalizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SitemapService.class})
public class SitemapServiceImpl
implements SitemapService {
    private static final Logger LOG = LoggerFactory.getLogger(SitemapServiceImpl.class);
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    private SitemapLinkExternalizer externalizer;
    @Reference
    private SitemapGeneratorManager generatorManager;
    @Reference
    private SitemapStorage storage;
    @Reference
    private SitemapServiceConfiguration sitemapServiceConfiguration;
    private ServiceTracker<SitemapScheduler, SitemapScheduler> schedulers;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.schedulers = new ServiceTracker(bundleContext, SitemapScheduler.class, null);
        this.schedulers.open();
    }

    @Deactivate
    protected void deactivate() {
        this.schedulers.close();
    }

    @Override
    public int getMaxSize() {
        return this.sitemapServiceConfiguration.getMaxSize();
    }

    @Override
    public int getMaxEntries() {
        return this.sitemapServiceConfiguration.getMaxEntries();
    }

    @Override
    public void scheduleGeneration() {
        if (this.schedulers.getServiceReferences() != null) {
            for (ServiceReference scheduler : this.schedulers.getServiceReferences()) {
                ((SitemapScheduler)this.schedulers.getService(scheduler)).run();
            }
        }
    }

    @Override
    public void scheduleGeneration(String name) {
        if (this.schedulers.getServiceReferences() != null) {
            for (ServiceReference scheduler : this.schedulers.getServiceReferences()) {
                ((SitemapScheduler)this.schedulers.getService(scheduler)).schedule(Collections.singleton(name));
            }
        }
    }

    @Override
    public void scheduleGeneration(Resource sitemapRoot) {
        if (this.schedulers.getServiceReferences() == null || !SitemapUtil.isSitemapRoot(sitemapRoot)) {
            return;
        }
        for (ServiceReference scheduler : this.schedulers.getServiceReferences()) {
            Object searchPath = scheduler.getProperty("searchPath");
            if (!(searchPath instanceof String) || !sitemapRoot.getPath().startsWith(searchPath + "/")) continue;
            ((SitemapScheduler)this.schedulers.getService(scheduler)).schedule(sitemapRoot, null);
        }
    }

    @Override
    public void scheduleGeneration(Resource sitemapRoot, String name) {
        if (this.schedulers.getServiceReferences() == null || !SitemapUtil.isSitemapRoot(sitemapRoot)) {
            return;
        }
        for (ServiceReference scheduler : this.schedulers.getServiceReferences()) {
            Object searchPath = scheduler.getProperty("searchPath");
            if (!(searchPath instanceof String) || !sitemapRoot.getPath().startsWith(searchPath + "/")) continue;
            ((SitemapScheduler)this.schedulers.getService(scheduler)).schedule(sitemapRoot, Collections.singleton(name));
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public Collection<SitemapInfo> getSitemapInfo(@NotNull Resource resource) {
        sitemapRoot = SitemapUtil.normalizeSitemapRoot(resource);
        if (sitemapRoot == null) {
            SitemapServiceImpl.LOG.debug("Not a sitemap root: {}", (Object)resource.getPath());
            return Collections.emptySet();
        }
        topLevelSitemapRoot = SitemapUtil.isTopLevelSitemapRoot(sitemapRoot) != false ? sitemapRoot : SitemapUtil.getTopLevelSitemapRoot(sitemapRoot);
        baseUrl = this.externalize(topLevelSitemapRoot);
        if (baseUrl == null) {
            SitemapServiceImpl.LOG.debug("Could not get absolute url to sitemap: {}", (Object)resource.getPath());
            return Collections.emptySet();
        }
        names = new HashSet<String>(this.generatorManager.getNames(sitemapRoot));
        onDemandNames = this.generatorManager.getOnDemandNames(sitemapRoot);
        infos = new ArrayList<SitemapInfo>(names.size() + 1);
        if (this.requiresSitemapIndex(sitemapRoot)) {
            location = baseUrl + '.' + "sitemap-index" + '.' + "xml";
            infos.add(SitemapServiceImpl.newSitemapIndexInfo(location));
        }
        it = names.iterator();
        while (it.hasNext()) {
            name = (String)it.next();
            if (!onDemandNames.contains(name)) continue;
            it.remove();
            selector = SitemapUtil.getSitemapSelector(sitemapRoot, topLevelSitemapRoot, name);
            location = SitemapServiceImpl.newSitemapUrl(baseUrl, selector);
            infos.add(SitemapServiceImpl.newOnDemandSitemapInfo(location, name));
        }
        if (names.isEmpty()) {
            return infos;
        }
        for (SitemapStorageInfo storageInfo : this.storage.getSitemaps(sitemapRoot, names)) {
            location = SitemapServiceImpl.newSitemapUrl(baseUrl, storageInfo.getSitemapSelector());
            infos.add(SitemapServiceImpl.newStoredSitemapInfo(storageInfo.getPath(), location, storageInfo.getName(), storageInfo.getSize(), storageInfo.getEntries()));
            names.remove(storageInfo.getName());
        }
        if (names.isEmpty()) {
            return infos;
        }
        schedulerRefs = this.schedulers.getServiceReferences();
        for (String name : names) {
            if (schedulerRefs == null) ** GOTO lbl-1000
            if (Arrays.stream(schedulerRefs).map((Function<ServiceReference, SitemapScheduler>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getService(org.osgi.framework.ServiceReference ), (Lorg/osgi/framework/ServiceReference;)Lorg/apache/sling/sitemap/impl/SitemapScheduler;)(this.schedulers)).map((Function<SitemapScheduler, Set>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getSitemapInfo$0(org.apache.sling.api.resource.Resource org.apache.sling.sitemap.impl.SitemapScheduler ), (Lorg/apache/sling/sitemap/impl/SitemapScheduler;)Ljava/util/Set;)((Resource)resource)).anyMatch((Predicate<Set>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getSitemapInfo$1(java.lang.String java.util.Set ), (Ljava/util/Set;)Z)((String)name))) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            hasApplicableScheduler = v0;
            selector = SitemapUtil.getSitemapSelector(sitemapRoot, topLevelSitemapRoot, name);
            location = SitemapServiceImpl.newSitemapUrl(baseUrl, selector);
            infos.add(SitemapServiceImpl.newOnDemandSitemapInfo(location, name, hasApplicableScheduler != false ? SitemapInfo.Status.SCHEDULED : SitemapInfo.Status.UNKNOWN));
        }
        return infos;
    }

    private boolean requiresSitemapIndex(@NotNull Resource sitemapRoot) {
        Set<String> names = this.generatorManager.getGenerators(sitemapRoot).keySet();
        return SitemapUtil.isTopLevelSitemapRoot(sitemapRoot) && (names.size() > 1 || SitemapUtil.findSitemapRoots(sitemapRoot.getResourceResolver(), sitemapRoot.getPath()).hasNext() || this.storage.getSitemaps(sitemapRoot, names).size() > 1);
    }

    private String externalize(Resource resource) {
        return (this.externalizer == null ? SitemapLinkExternalizer.DEFAULT : this.externalizer).externalize(resource);
    }

    private static SitemapInfo newSitemapIndexInfo(@NotNull String url) {
        return new SitemapInfoImpl(null, url, "<sitemap-index>", SitemapInfo.Status.ON_DEMAND, -1, -1);
    }

    private static SitemapInfo newOnDemandSitemapInfo(@NotNull String url, @NotNull String name) {
        return SitemapServiceImpl.newOnDemandSitemapInfo(url, name, SitemapInfo.Status.ON_DEMAND);
    }

    private static SitemapInfo newOnDemandSitemapInfo(@NotNull String url, @NotNull String name, @NotNull SitemapInfo.Status status) {
        return new SitemapInfoImpl(null, url, name, status, -1, -1);
    }

    private static SitemapInfo newStoredSitemapInfo(@NotNull String path, @NotNull String url, @NotNull String name, int size, int entries) {
        return new SitemapInfoImpl(path, url, name, SitemapInfo.Status.STORAGE, size, entries);
    }

    private static String newSitemapUrl(String baseUrl, String selector) {
        StringBuilder builder = new StringBuilder(baseUrl.length() + selector.length() + "sitemap".length() + "xml".length() + 3);
        builder.append(baseUrl);
        builder.append('.');
        if (!selector.equals("sitemap")) {
            builder.append("sitemap");
            builder.append('.');
        }
        builder.append(selector);
        builder.append('.');
        builder.append("xml");
        return builder.toString();
    }

    private static /* synthetic */ boolean lambda$getSitemapInfo$1(String name, Set applicableNames) {
        return applicableNames.contains(name);
    }

    private static /* synthetic */ Set lambda$getSitemapInfo$0(Resource resource, SitemapScheduler scheduler) {
        return scheduler.getApplicableNames(resource);
    }

    private static class SitemapInfoImpl
    implements SitemapInfo {
        private final String url;
        private final String path;
        private final String name;
        private final SitemapInfo.Status status;
        private final int size;
        private final int entries;

        private SitemapInfoImpl(@Nullable String path, @NotNull String url, @NotNull String name, @NotNull SitemapInfo.Status status, int size, int entries) {
            this.path = path;
            this.url = url;
            this.name = name;
            this.status = status;
            this.size = size;
            this.entries = entries;
        }

        @Override
        @Nullable
        public String getStoragePath() {
            return this.path;
        }

        @Override
        @NotNull
        public String getUrl() {
            return this.url;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public SitemapInfo.Status getStatus() {
            return this.status;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public int getEntries() {
            return this.entries;
        }

        public String toString() {
            return "SitemapInfoImpl{url='" + this.url + '\'' + ", size=" + this.size + ", entries=" + this.entries + '}';
        }
    }
}

