/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.sitemap.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.apache.sling.sitemap.SitemapGeneratorManager;
import org.apache.sling.sitemap.SitemapUtil;
import org.apache.sling.sitemap.spi.generator.SitemapGenerator;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SitemapScheduler.class, Runnable.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"scheduler.concurrent:Boolean=false", "scheduler.runOn=SINGLE"})
@Designate(ocd=Configuration.class, factory=true)
public class SitemapScheduler
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(SitemapScheduler.class);
    private static final Map<String, Object> AUTH = Collections.singletonMap("sling.service.subservice", "sitemap-reader");
    @Reference
    private JobManager jobManager;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private SitemapGeneratorManager generatorManager;
    @Reference(target="(subServiceName=sitemap-reader)")
    private ServiceUserMapped serviceUserMapped;
    private Set<String> names;
    private Set<String> includeGenerators;
    private Set<String> excludeGenerators;
    private String searchPath;

    @Activate
    protected void activate(Configuration configuration) {
        this.includeGenerators = SitemapScheduler.asSet(configuration.includeGenerators());
        this.excludeGenerators = SitemapScheduler.asSet(configuration.excludeGenerators());
        this.names = SitemapScheduler.asSet(configuration.names());
        this.searchPath = configuration.searchPath();
    }

    @Override
    public void run() {
        this.schedule(null);
    }

    public void schedule(@Nullable Collection<String> includeNames) {
        try (ResourceResolver resolver = this.resourceResolverFactory.getServiceResourceResolver(AUTH);){
            Iterator<Resource> sitemapRoots = SitemapUtil.findSitemapRoots(resolver, this.searchPath);
            while (sitemapRoots.hasNext()) {
                this.schedule(sitemapRoots.next(), includeNames);
            }
        }
        catch (LoginException ex) {
            LOG.warn("Failed start sitemap jobs: {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    public void schedule(Resource sitemapRoot, @Nullable Collection<String> includeNames) {
        Set<String> configuredNames = this.getApplicableNames(sitemapRoot);
        if (includeNames != null) {
            configuredNames.retainAll(includeNames);
        }
        for (String applicableName : configuredNames) {
            this.addJob(sitemapRoot.getPath(), applicableName);
        }
    }

    public Set<String> getApplicableNames(Resource sitemapRoot) {
        Set<String> onDemandNames = this.generatorManager.getOnDemandNames(sitemapRoot);
        Set<String> toSchedule = this.generatorManager.getGenerators(sitemapRoot).entrySet().stream().filter(entry -> this.includeGenerators == null || this.includeGenerators.contains(((SitemapGenerator)entry.getValue()).getClass().getName())).filter(entry -> this.excludeGenerators == null || !this.excludeGenerators.contains(((SitemapGenerator)entry.getValue()).getClass().getName())).filter(entry -> !onDemandNames.contains(entry.getKey())).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (this.names != null) {
            toSchedule.retainAll(this.names);
        }
        return toSchedule;
    }

    protected void addJob(String sitemapRoot, String applicableName) {
        HashMap<String, String> jobProperties = new HashMap<String, String>();
        jobProperties.put("sitemap.name", applicableName);
        jobProperties.put("sitemap.root", sitemapRoot);
        Job job = this.jobManager.addJob("org/apache/sling/sitemap/build", jobProperties);
        LOG.debug("Added job {}", (Object)job.getId());
    }

    @Nullable
    private static Set<String> asSet(@Nullable String[] configuration) {
        if (configuration == null || configuration.length == 0) {
            return null;
        }
        Set<String> result = Arrays.stream(configuration).filter(Objects::nonNull).filter(entry -> !"".equals(entry.trim())).collect(Collectors.toSet());
        return result.isEmpty() ? null : result;
    }

    @ObjectClassDefinition(name="Apache Sling Sitemap - Scheduler")
    static @interface Configuration {
        @AttributeDefinition(name="Name", description="The name of the scheduler configuration")
        public String scheduler_name();

        @AttributeDefinition(name="Schedule", description="A cron expression defining the schedule at which the sitemap generation jobs will be scheduled.")
        public String scheduler_expression();

        @AttributeDefinition(name="Include Generators", description="A list of full qualified class names of SitemapGenerator implementations. If set only the listed SitemapGenerators will be called. If left empty all will be called.")
        public String[] includeGenerators() default {};

        @AttributeDefinition(name="Exclude Generators", description="A list of full qualified class names of SitemapGenerator implementations. If set the listed SitemapGenerators will not be called. If left empty all will be called.")
        public String[] excludeGenerators() default {};

        @AttributeDefinition(name="Names", description="A list of names. If set only sitemaps for the given names will be generated by. If left empty all will be generated.")
        public String[] names() default {};

        @AttributeDefinition(name="Search Path", description="The path under which sitemap roots should be searched for")
        public String searchPath() default "/content";
    }
}

