/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.sitemap.impl.builder.extensions;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.sling.sitemap.builder.Extension;
import org.apache.sling.sitemap.impl.builder.extensions.ExtensionFactory;
import org.apache.sling.sitemap.spi.builder.SitemapExtensionProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ExtensionProviderManager.class}, reference={@Reference(service=SitemapExtensionProvider.class, name="providers", bind="bindExtensionProvider", unbind="unbindExtensionProvider", cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)})
public class ExtensionProviderManager {
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionProviderManager.class);
    private final Map<ServiceReference<?>, Holder> providers = new TreeMap(Collections.reverseOrder());
    private Map<String, String> namespaces;
    private BundleContext bundleContext;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    protected void bindExtensionProvider(ServiceReference<SitemapExtensionProvider> ref) {
        try {
            this.namespaces = null;
            this.providers.put(ref, new Holder(ref));
        }
        catch (ClassCastException ex) {
            LOG.warn("Failed to register ExtensionProvider '{}' as on of the mandatory properties if not of type String.", ref, (Object)ex);
        }
    }

    protected void unbindExtensionProvider(ServiceReference<SitemapExtensionProvider> ref) {
        Holder holder = this.providers.remove(ref);
        if (holder != null && holder.provider != null) {
            this.bundleContext.ungetService(ref);
        }
    }

    @NotNull
    public Map<String, String> getNamespaces() {
        if (this.namespaces == null) {
            this.namespaces = new HashMap<String, String>();
            for (Holder holder : this.providers.values()) {
                this.namespaces.putIfAbsent(holder.namespace, holder.prefix);
            }
        }
        return this.namespaces;
    }

    @Nullable
    public ExtensionFactory getExtensionFactory(Class<? extends Extension> extensionInterface) {
        for (Holder holder : this.providers.values()) {
            if (!holder.extensionInterface.equals(extensionInterface.getName())) continue;
            return new ExtensionFactory(holder.getProvider(), holder.namespace, this.getNamespaces().get(holder.namespace), holder.localName, holder.emptyTag);
        }
        return null;
    }

    private class Holder {
        private final ServiceReference<SitemapExtensionProvider> ref;
        private final String extensionInterface;
        private final String prefix;
        private final String namespace;
        private final String localName;
        private final boolean emptyTag;
        private SitemapExtensionProvider provider;

        private Holder(ServiceReference<SitemapExtensionProvider> ref) {
            this.ref = ref;
            this.prefix = Objects.requireNonNull((String)ref.getProperty("extension.prefix"), "prefix missing");
            this.namespace = Objects.requireNonNull((String)ref.getProperty("extension.namespace"), "namespace missing");
            this.localName = Objects.requireNonNull((String)ref.getProperty("extension.localName"), "local name missing");
            this.extensionInterface = Objects.requireNonNull((String)ref.getProperty("extension.interface"), "prefix missing");
            Object emptyTagProp = ref.getProperty("extension.emptyTag");
            if (emptyTagProp instanceof Boolean) {
                this.emptyTag = (Boolean)emptyTagProp;
            } else if (emptyTagProp instanceof String) {
                this.emptyTag = Boolean.parseBoolean((String)emptyTagProp);
            } else {
                this.emptyTag = false;
                LOG.debug("Unknown type for emptyTag: {}", emptyTagProp);
            }
        }

        private SitemapExtensionProvider getProvider() {
            if (this.provider == null) {
                this.provider = (SitemapExtensionProvider)ExtensionProviderManager.this.bundleContext.getService(this.ref);
            }
            return this.provider;
        }
    }
}

