/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.sitemap.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.sitemap.SitemapException;
import org.apache.sling.sitemap.SitemapGeneratorManager;
import org.apache.sling.sitemap.SitemapUtil;
import org.apache.sling.sitemap.impl.SitemapServiceConfiguration;
import org.apache.sling.sitemap.impl.SitemapStorage;
import org.apache.sling.sitemap.impl.SitemapStorageInfo;
import org.apache.sling.sitemap.impl.builder.SitemapImpl;
import org.apache.sling.sitemap.impl.builder.SitemapIndexImpl;
import org.apache.sling.sitemap.impl.builder.extensions.ExtensionProviderManager;
import org.apache.sling.sitemap.spi.common.SitemapLinkExternalizer;
import org.apache.sling.sitemap.spi.generator.SitemapGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"sling.servlet.selectors=sitemap", "sling.servlet.selectors=sitemap-index", "sling.servlet.extensions=xml"})
public class SitemapServlet
extends SlingSafeMethodsServlet {
    static final String SITEMAP_SELECTOR = "sitemap";
    static final String SITEMAP_INDEX_SELECTOR = "sitemap-index";
    static final String SITEMAP_EXTENSION = "xml";
    private static final Logger LOG = LoggerFactory.getLogger(SitemapServlet.class);
    private static final SitemapGenerator.Context NOOP_CONTEXT = new SitemapGenerator.Context(){

        @Override
        @Nullable
        public <T> T getProperty(@NotNull String name, @NotNull Class<T> cls) {
            return null;
        }

        @Override
        @NotNull
        public <T> T getProperty(@NotNull String name, @NotNull T defaultValue) {
            return defaultValue;
        }

        @Override
        public void setProperty(@NotNull String name, @Nullable Object data) {
        }
    };
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    private SitemapLinkExternalizer externalizer;
    @Reference
    private SitemapGeneratorManager generatorManager;
    @Reference
    private ExtensionProviderManager extensionProviderManager;
    @Reference
    private SitemapStorage storage;
    @Reference
    private SitemapServiceConfiguration sitemapServiceConfiguration;

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            Resource requestedResource = SitemapUtil.normalizeSitemapRoot(request.getResource());
            if (!SitemapUtil.isSitemapRoot(requestedResource)) {
                response.sendError(400);
                return;
            }
            response.setCharacterEncoding("utf-8");
            response.setContentType("application/xml");
            List<String> selectors = Arrays.asList(request.getRequestPathInfo().getSelectors());
            if (selectors.size() == 1 && selectors.contains(SITEMAP_INDEX_SELECTOR)) {
                this.doGetSitemapIndex(request, response, requestedResource);
            } else if (selectors.size() == 1 && selectors.contains(SITEMAP_SELECTOR)) {
                this.doGetSitemap(response, requestedResource, selectors.get(0));
            } else if (selectors.size() == 2 && selectors.get(0).equals(SITEMAP_SELECTOR)) {
                this.doGetSitemap(response, requestedResource, selectors.get(1));
            } else {
                response.sendError(400);
            }
        }
        catch (SitemapException ex) {
            if (ex.getCause() instanceof IOException) {
                throw (IOException)ex.getCause();
            }
            throw new ServletException((Throwable)ex);
        }
    }

    protected void doGetSitemapIndex(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, Resource topLevelSitemapRoot) throws IOException, SitemapException {
        SitemapIndexImpl sitemapIndex = new SitemapIndexImpl(response.getWriter());
        Set<String> addedSitemapSelectors = this.addOnDemandSitemapsToIndex(request, topLevelSitemapRoot, sitemapIndex);
        for (SitemapStorageInfo storageInfo : this.storage.getSitemaps(topLevelSitemapRoot)) {
            if (addedSitemapSelectors.contains(storageInfo.getSitemapSelector())) continue;
            String location = this.externalize(request, SitemapServlet.getSitemapLink(topLevelSitemapRoot, storageInfo.getSitemapSelector()));
            Calendar lastModified = storageInfo.getLastModified();
            if (location != null && lastModified != null) {
                sitemapIndex.addSitemap(location, lastModified.toInstant());
                continue;
            }
            if (location != null) {
                sitemapIndex.addSitemap(location);
                continue;
            }
            LOG.debug("Could not get absolute url for sitemap served from {}", (Object)storageInfo.getSitemapSelector());
        }
        sitemapIndex.close();
    }

    protected void doGetSitemap(@NotNull SlingHttpServletResponse response, Resource topLevelSitemapRoot, String sitemapSelector) throws SitemapException, IOException {
        Set<String> onDemandNames = this.generatorManager.getOnDemandNames(topLevelSitemapRoot);
        if (!onDemandNames.isEmpty()) {
            Map<Resource, String> candidates = SitemapUtil.resolveSitemapRoots(topLevelSitemapRoot, sitemapSelector);
            for (Map.Entry<Resource, String> entry : candidates.entrySet()) {
                String name;
                Resource sitemapRoot = entry.getKey();
                SitemapGenerator generator = this.generatorManager.getGenerator(sitemapRoot, name = entry.getValue());
                if (generator == null || !onDemandNames.contains(name)) continue;
                SitemapImpl sitemap = new SitemapImpl(response.getWriter(), this.extensionProviderManager);
                generator.generate(sitemapRoot, name, sitemap, NOOP_CONTEXT);
                sitemap.close();
                return;
            }
        }
        if (!this.storage.copySitemap(topLevelSitemapRoot, sitemapSelector, (OutputStream)response.getOutputStream())) {
            response.sendError(404);
        }
    }

    private Set<String> addOnDemandSitemapsToIndex(SlingHttpServletRequest request, Resource parentSitemapRoot, SitemapIndexImpl index) throws SitemapException {
        HashSet<String> addedSitemapSelectors = new HashSet<String>();
        Iterator<Resource> sitemapRoots = SitemapUtil.findSitemapRoots(request.getResourceResolver(), parentSitemapRoot.getPath());
        if (!sitemapRoots.hasNext()) {
            sitemapRoots = Collections.singleton(parentSitemapRoot).iterator();
        }
        while (sitemapRoots.hasNext()) {
            Resource sitemapRoot = sitemapRoots.next();
            Set<String> applicableNames = this.generatorManager.getOnDemandNames(sitemapRoot);
            for (String applicableName : applicableNames) {
                String sitemapSelector = SitemapUtil.getSitemapSelector(sitemapRoot, parentSitemapRoot, applicableName);
                String location = this.externalize(request, SitemapServlet.getSitemapLink(sitemapRoot, sitemapSelector));
                if (location != null) {
                    index.addSitemap(location);
                    addedSitemapSelectors.add(sitemapSelector);
                    continue;
                }
                LOG.debug("Could not get absolute url for on-demand sitemap: {}", (Object)sitemapSelector);
            }
        }
        return addedSitemapSelectors;
    }

    private String externalize(SlingHttpServletRequest request, String uri) {
        return (this.externalizer == null ? SitemapLinkExternalizer.DEFAULT : this.externalizer).externalize(request, uri);
    }

    private static String getSitemapLink(Resource sitemapRoot, String sitemapSelector) {
        String link = sitemapRoot.getPath() + '.' + SITEMAP_SELECTOR + '.';
        if (SITEMAP_SELECTOR.equals(sitemapSelector)) {
            return link + SITEMAP_EXTENSION;
        }
        return link + sitemapSelector + '.' + SITEMAP_EXTENSION;
    }
}

