/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.settings.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Properties;
import java.util.TreeSet;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(service={SlingPropertiesPrinter.class}, property={"felix.webconsole.label=slingprops", "felix.webconsole.title=Sling Properties", "felix.webconsole.configprinter.modes=always"})
public class SlingPropertiesPrinter {
    private static String HEADLINE = "Apache Sling Launchpad Properties";
    private final Properties props;

    @Activate
    public SlingPropertiesPrinter(BundleContext bundleContext) throws IOException {
        block16: {
            String propUrl = bundleContext.getProperty("sling.properties.url");
            if (propUrl != null) {
                try (InputStream is = new URL(propUrl).openStream();){
                    Properties tmp = new Properties();
                    tmp.load(is);
                    for (Object key : tmp.keySet()) {
                        String value = bundleContext.getProperty(key.toString());
                        if (value == null) continue;
                        tmp.put(key, value);
                    }
                    this.props = tmp;
                    break block16;
                }
                catch (IOException ioe) {
                    throw new IOException("Unable to read sling properties from " + propUrl, ioe);
                }
            }
            throw new IllegalStateException("No bundle context property 'sling.properties.url' provided");
        }
    }

    public void printConfiguration(PrintWriter pw) {
        pw.println(HEADLINE);
        pw.println();
        TreeSet<Object> keys = new TreeSet<Object>(this.props.keySet());
        for (Object e : keys) {
            pw.print(e);
            pw.print(" = ");
            Object value = this.props.get(e);
            if (value != null) {
                pw.print(value.toString());
            }
            pw.println();
        }
    }

    public void printConfiguration(PrintWriter printWriter, String mode) {
        if (!"zip".equals(mode)) {
            this.printConfiguration(printWriter);
        } else {
            String contents = null;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.props.store(baos, HEADLINE);
                contents = baos.toString("8859_1");
            }
            catch (IOException ioe) {
                this.printConfiguration(printWriter);
                return;
            }
            printWriter.write(contents);
        }
    }
}

