/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.SyntheticResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

public class LocationCollector {
    protected static final String CACHE_KEY = LocationCollector.class.getName() + ".CacheKey";
    private final String[] searchPath;
    private Map<String, Resource> cacheMap;
    private final ResourceResolver resolver;
    private final String baseResourceType;
    private final String resourceType;
    private final String resourceSuperType;
    private final boolean useResourceCaching;
    private final Set<String> usedResourceTypes = new HashSet<String>();
    private final List<String> result = new ArrayList<String>();

    private LocationCollector(@NotNull String resourceType, @NotNull String resourceSuperType, @NotNull String baseResourceType, @NotNull ResourceResolver resolver, @NotNull Map<String, Resource> cacheMap, boolean useResourceCaching) {
        this.resourceType = resourceType;
        this.resourceSuperType = resourceSuperType;
        this.baseResourceType = baseResourceType;
        this.resolver = resolver;
        this.cacheMap = cacheMap;
        this.useResourceCaching = useResourceCaching;
        String[] tmpPath = resolver.getSearchPath();
        if (tmpPath.length == 0) {
            tmpPath = new String[]{"/"};
        }
        this.searchPath = tmpPath;
        this.usedResourceTypes.add(this.resourceType);
        this.collectPaths();
    }

    @NotNull
    private List<String> getResolvedLocations() {
        return this.result;
    }

    private void collectPaths() {
        String superType;
        String rt = this.resourceType;
        while ((rt = (superType = this.handleResourceType(rt))) != null) {
        }
        boolean blankResourceType = this.resourceType == null || this.resourceType.isBlank();
        String defaultResourceTypeSuffix = blankResourceType ? "" : this.baseResourceType;
        for (String spath : this.searchPath) {
            this.result.add(spath + defaultResourceTypeSuffix);
        }
    }

    @Nullable
    private String handleResourceType(@NotNull String resourceType) {
        boolean isBlank = resourceType == null || resourceType.isBlank();
        boolean isAbsoluteResourceType = resourceType.startsWith("/");
        String rst = null;
        if (!isBlank) {
            if (isAbsoluteResourceType) {
                this.result.add(ResourceUtil.resourceTypeToPath((String)resourceType));
            } else {
                for (String spath : this.searchPath) {
                    this.result.add(spath + ResourceUtil.resourceTypeToPath((String)resourceType));
                }
            }
            rst = this.getResourceSuperType(resourceType);
        }
        return rst;
    }

    @Nullable
    private String getResourceSuperType(@NotNull String resourceType) {
        if (resourceType.equals(this.baseResourceType)) {
            return null;
        }
        String superType = resourceType.equals(this.resourceType) && this.resourceSuperType != null ? this.resourceSuperType : this.getResourceSuperTypeInternal(resourceType);
        if (superType != null) {
            if (this.usedResourceTypes.contains(superType)) {
                LoggerFactory.getLogger(this.getClass()).error("Circular dependency in resource type hierarchy detected! Check super types of {}", (Object)superType);
                superType = null;
            } else {
                this.usedResourceTypes.add(superType);
            }
        }
        return superType;
    }

    @Nullable
    private String getResourceSuperTypeInternal(@NotNull String resourceType) {
        String rst;
        block2: {
            String rtPath;
            block1: {
                rtPath = ResourceUtil.resourceTypeToPath((String)resourceType);
                rst = null;
                if (!rtPath.startsWith("/")) break block1;
                Resource rtResource = this.resolveResource(rtPath);
                if (rtResource == null) break block2;
                rst = rtResource.getResourceSuperType();
                break block2;
            }
            for (String path : this.searchPath) {
                String candidatePath = path + rtPath;
                Resource rtResource = this.resolveResource(candidatePath);
                if (rtResource == null || rtResource.getResourceSuperType() == null) continue;
                rst = rtResource.getResourceSuperType();
                break;
            }
        }
        return rst;
    }

    @Nullable
    private Resource resolveResource(@NotNull String path) {
        if (this.useResourceCaching && this.cacheMap.containsKey(path)) {
            return this.cacheMap.get(path);
        }
        Resource r = this.resolver.getResource(path);
        this.cacheMap.put(path, r);
        return r;
    }

    @NotNull
    static List<Resource> getLocations(@NotNull String resourceType, @NotNull String resourceSuperType, @NotNull String baseResourceType, @NotNull ResourceResolver resolver, boolean useResourceCaching) {
        Map<String, Resource> cacheMap = LocationCollector.getCacheMap(resolver);
        LocationCollector collector = new LocationCollector(resourceType, resourceSuperType, baseResourceType, resolver, cacheMap, useResourceCaching);
        return collector.getResolvedLocations().stream().map(LocationCollector::removeTrailingSlash).map(path -> LocationCollector.getResource(resolver, path, cacheMap)).collect(Collectors.toList());
    }

    private static Map<String, Resource> getCacheMap(@NotNull ResourceResolver resolver) {
        Map cacheMap;
        Object c = resolver.getPropertyMap().get(CACHE_KEY);
        if (c != null) {
            cacheMap = c instanceof Map ? (Map)resolver.getPropertyMap().get(CACHE_KEY) : new HashMap();
        } else {
            cacheMap = Collections.synchronizedMap(new HashMap());
            resolver.getPropertyMap().put(CACHE_KEY, cacheMap);
        }
        return cacheMap;
    }

    @NotNull
    protected static Resource getResource(@NotNull ResourceResolver resolver, @NotNull String path, @NotNull Map<String, Resource> cacheMap) {
        if (cacheMap.containsKey(path) && cacheMap.get(path) != null) {
            return cacheMap.get(path);
        }
        Resource res = resolver.getResource(path);
        if (res == null) {
            res = new SyntheticResource(resolver, path, "$synthetic$");
        }
        cacheMap.put(path, res);
        return res;
    }

    @NotNull
    private static String removeTrailingSlash(@NotNull String input) {
        if (input.endsWith("/")) {
            return input.substring(0, input.length() - 1);
        }
        return input;
    }

    public static void clearCache(ResourceResolver resolver) {
        Object cache = resolver.getPropertyMap().get(CACHE_KEY);
        if (cache instanceof Map) {
            Map cacheMap = (Map)cache;
            cacheMap.clear();
        }
    }
}

