/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.servlets.resolver.internal.helper.LocationIterator;
import org.apache.sling.servlets.resolver.internal.helper.WeightedResource;

public abstract class AbstractResourceCollector {
    protected final String baseResourceType;
    protected final String extension;
    protected int hashCode;
    protected final String resourceType;
    protected final String resourceSuperType;
    protected final String[] executionPaths;

    protected AbstractResourceCollector(String baseResourceType, String resourceType, String resourceSuperType, String extension, String[] executionPaths) {
        this.baseResourceType = baseResourceType;
        this.resourceType = resourceType;
        this.resourceSuperType = resourceSuperType;
        this.extension = extension;
        this.executionPaths = executionPaths;
    }

    public final Collection<Resource> getServlets(ResourceResolver resolver, List<String> scriptExtensions) {
        TreeSet<WeightedResource> resources = new TreeSet<WeightedResource>((o1, o2) -> {
            String o1Parent = ResourceUtil.getParent((String)o1.getPath());
            String o2Parent = ResourceUtil.getParent((String)o2.getPath());
            if (o1Parent != null && o2Parent != null && o1Parent.equals(o2Parent)) {
                String o2ScriptWithoutExtension;
                String o1ScriptWithoutExtension;
                String o1ScriptName = o1.getName();
                String o2ScriptName = o2.getName();
                String o1Extension = this.getScriptExtension(o1ScriptName);
                String o2Extension = this.getScriptExtension(o2ScriptName);
                if (StringUtils.isNotEmpty((CharSequence)o1Extension) && StringUtils.isNotEmpty((CharSequence)o2Extension) && (o1ScriptWithoutExtension = o1ScriptName.substring(0, o1ScriptName.lastIndexOf("." + o1Extension))).equals(o2ScriptWithoutExtension = o2ScriptName.substring(0, o2ScriptName.lastIndexOf("." + o2Extension)))) {
                    int o2ExtensionIndex;
                    int o1ExtensionIndex = scriptExtensions.indexOf(o1Extension);
                    if (o1ExtensionIndex == (o2ExtensionIndex = scriptExtensions.indexOf(o2Extension)) || o1ExtensionIndex == -1 || o2ExtensionIndex == -1) {
                        return o1.compareTo((WeightedResource)o2);
                    }
                    if (o1ExtensionIndex > o2ExtensionIndex) {
                        return -1;
                    }
                    return 1;
                }
            }
            return o1.compareTo((WeightedResource)o2);
        });
        LocationIterator locations = new LocationIterator(this.resourceType, this.resourceSuperType, this.baseResourceType, resolver);
        while (locations.hasNext()) {
            String location = (String)locations.next();
            String path = location.endsWith("/") ? location.substring(0, location.length() - 1) : location;
            Resource locationRes = this.getResource(resolver, path);
            this.getWeightedResources(resources, locationRes);
        }
        ArrayList<Resource> result = new ArrayList<Resource>(resources.size());
        result.addAll(resources);
        return result;
    }

    protected abstract void getWeightedResources(Set<WeightedResource> var1, Resource var2);

    protected final void addWeightedResource(Set<WeightedResource> resources, Resource resource, int numSelectors, int methodPrefixWeight) {
        WeightedResource lr = new WeightedResource(resources.size(), resource, numSelectors, methodPrefixWeight);
        resources.add(lr);
    }

    protected final Resource getResource(ResourceResolver resolver, String path) {
        Resource res = resolver.getResource(path);
        if (res == null) {
            if (!path.startsWith("/")) {
                path = "/".concat(path);
            }
            res = new SyntheticResource(resolver, path, "$synthetic$");
        }
        return res;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractResourceCollector)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        AbstractResourceCollector o = (AbstractResourceCollector)obj;
        return this.stringEquals(this.resourceType, o.resourceType) && this.stringEquals(this.resourceSuperType, o.resourceSuperType) && this.stringEquals(this.extension, o.extension) && this.stringEquals(this.baseResourceType, o.baseResourceType);
    }

    public int hashCode() {
        return this.hashCode;
    }

    protected boolean stringEquals(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    private String getScriptExtension(String scriptName) {
        int lastIndexOf = scriptName.lastIndexOf(46);
        if (lastIndexOf > -1 && lastIndexOf < scriptName.length() - 1) {
            return scriptName.substring(lastIndexOf + 1);
        }
        return null;
    }
}

