/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal.resource;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.Servlet;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.servlets.resolver.internal.resource.ServletResourceProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletResourceProviderFactory {
    public static final String SERVLET_PATH_EXTENSION = ".servlet";
    private static final String[] DEFAULT_SERVLET_METHODS = new String[]{"GET", "HEAD"};
    private static final String ALL_METHODS = "*";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String servletRoot;
    private final int servletRootIndex;
    private final List<String> searchPath;

    static String ensureServletNameExtension(String servletPath) {
        if (servletPath.endsWith(SERVLET_PATH_EXTENSION)) {
            return servletPath;
        }
        return servletPath.concat(SERVLET_PATH_EXTENSION);
    }

    public ServletResourceProviderFactory(String servletRoot, List<String> searchPath) {
        this.searchPath = searchPath;
        boolean isNumber = false;
        int index = -1;
        if (!servletRoot.startsWith("/")) {
            try {
                index = Integer.valueOf(servletRoot);
                isNumber = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!isNumber) {
            if (!servletRoot.startsWith("/")) {
                servletRoot = "/".concat(servletRoot);
            }
            if (!servletRoot.endsWith("/")) {
                servletRoot = servletRoot.concat("/");
            }
            this.servletRoot = servletRoot;
            this.servletRootIndex = -1;
        } else {
            this.servletRoot = null;
            this.servletRootIndex = index;
        }
    }

    public ServletResourceProvider create(ServiceReference<Servlet> ref, Servlet servlet) {
        HashSet<String> pathSet = new HashSet<String>();
        this.addByPath(pathSet, ref);
        this.addByType(pathSet, ref);
        if (pathSet.isEmpty()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("create({}): ServiceReference has no registration settings, ignoring", (Object)ServletResourceProviderFactory.getServiceReferenceInfo(ref));
            }
            return null;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("create({}): Registering servlet for paths {}", (Object)ServletResourceProviderFactory.getServiceReferenceInfo(ref), pathSet);
        }
        String resourceSuperType = PropertiesUtil.toString((Object)ref.getProperty("sling.servlet.resourceSuperType"), null);
        HashSet<String> resourceSuperTypeMarkers = new HashSet<String>();
        if (StringUtils.isNotEmpty((CharSequence)resourceSuperType) && !"sling/bundle/resource".equals(resourceSuperType)) {
            for (String rt : PropertiesUtil.toStringArray((Object)ref.getProperty("sling.servlet.resourceTypes"))) {
                if (!rt.startsWith("/")) {
                    rt = this.getPrefix(ref).concat(ResourceUtil.resourceTypeToPath((String)rt));
                }
                resourceSuperTypeMarkers.add(rt);
                pathSet.add(rt);
            }
        }
        return new ServletResourceProvider(servlet, pathSet, resourceSuperTypeMarkers, resourceSuperType);
    }

    private String getPrefix(ServiceReference<Servlet> ref) {
        Object value = ref.getProperty("sling.servlet.prefix");
        if (value == null) {
            if (this.servletRoot != null) {
                return this.servletRoot;
            }
            value = this.servletRootIndex;
        }
        int index = -1;
        if (value instanceof Number) {
            index = ((Number)value).intValue();
        } else {
            String s = value.toString();
            if (!s.startsWith("/")) {
                boolean isNumber = false;
                try {
                    index = Integer.valueOf(s);
                    isNumber = true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (!isNumber) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("getPrefix({}): Configuration property is ignored {}", (Object)ServletResourceProviderFactory.getServiceReferenceInfo(ref), value);
                    }
                    if (this.servletRoot != null) {
                        return this.servletRoot;
                    }
                    index = this.servletRootIndex;
                }
            } else {
                return s;
            }
        }
        if (index == -1 || index >= this.searchPath.size()) {
            index = this.searchPath.size() - 1;
        }
        return this.searchPath.get(index);
    }

    private void addByPath(Set<String> pathSet, ServiceReference<Servlet> ref) {
        String[] paths = PropertiesUtil.toStringArray((Object)ref.getProperty("sling.servlet.paths"));
        if (paths != null && paths.length > 0) {
            for (String path : paths) {
                if (!path.startsWith("/")) {
                    path = this.getPrefix(ref).concat(path);
                }
                pathSet.add(path);
                String[] types = PropertiesUtil.toStringArray((Object)ref.getProperty("sling.servlet.resourceTypes"));
                if (types != null && types.length != 0 && !StringUtils.isEmpty((CharSequence)FilenameUtils.getExtension((String)path))) continue;
                pathSet.add(ServletResourceProviderFactory.ensureServletNameExtension(path));
            }
        }
    }

    private void addByType(Set<String> pathSet, ServiceReference<Servlet> ref) {
        String[] types = PropertiesUtil.toStringArray((Object)ref.getProperty("sling.servlet.resourceTypes"));
        String[] paths = PropertiesUtil.toStringArray((Object)ref.getProperty("sling.servlet.paths"));
        boolean hasPathRegistration = true;
        if (paths == null || paths.length == 0) {
            hasPathRegistration = false;
        }
        if (types == null || types.length == 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("addByType({}): no resource types declared", (Object)ServletResourceProviderFactory.getServiceReferenceInfo(ref));
            }
            return;
        }
        String[] selectors = PropertiesUtil.toStringArray((Object)ref.getProperty("sling.servlet.selectors"));
        if (selectors == null) {
            selectors = new String[]{null};
        }
        String[] extensions = PropertiesUtil.toStringArray((Object)ref.getProperty("sling.servlet.extensions"));
        String[] methods = PropertiesUtil.toStringArray((Object)ref.getProperty("sling.servlet.methods"));
        if (methods == null || methods.length == 0) {
            if (!(extensions != null && extensions.length != 0 || hasPathRegistration)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("addByType({}): No methods declared, assuming GET/HEAD", (Object)ServletResourceProviderFactory.getServiceReferenceInfo(ref));
                }
                methods = DEFAULT_SERVLET_METHODS;
            }
        } else if (methods.length == 1 && ALL_METHODS.equals(methods[0])) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("addByType({}): Assuming all methods for '*'", (Object)ServletResourceProviderFactory.getServiceReferenceInfo(ref));
            }
            methods = null;
        }
        for (String type : types) {
            if (!(type = ResourceUtil.resourceTypeToPath((String)type)).startsWith("/")) {
                type = this.getPrefix(ref) + type;
            }
            if (!type.endsWith("/")) {
                type = type + "/";
            }
            for (String selector : selectors) {
                String selPath = type;
                if (selector != null && selector.length() > 0) {
                    selPath = selPath + selector.replace('.', '/') + ".";
                }
                boolean pathAdded = false;
                if (extensions != null) {
                    if (methods != null) {
                        for (String ext : extensions) {
                            for (String method : methods) {
                                pathSet.add(selPath + ext + "." + method + SERVLET_PATH_EXTENSION);
                                pathAdded = true;
                            }
                        }
                    } else {
                        for (String ext : extensions) {
                            pathSet.add(selPath + ext + SERVLET_PATH_EXTENSION);
                            pathAdded = true;
                        }
                    }
                } else if (methods != null) {
                    for (String method : methods) {
                        pathSet.add(selPath + method + SERVLET_PATH_EXTENSION);
                        pathAdded = true;
                    }
                }
                if (pathAdded || hasPathRegistration) continue;
                pathSet.add(selPath.substring(0, selPath.length() - 1) + SERVLET_PATH_EXTENSION);
            }
        }
    }

    public static String getServiceReferenceInfo(ServiceReference<Servlet> reference) {
        StringBuilder sb = new StringBuilder("service ");
        sb.append(String.valueOf(reference.getProperty("service.id")));
        Object servletName = reference.getProperty("sling.core.servletName");
        Object pid = reference.getProperty("service.pid");
        Object componentName = reference.getProperty("component.name");
        if (pid != null && pid.equals(componentName)) {
            componentName = null;
        }
        if (servletName != null || pid != null || componentName != null) {
            sb.append(" (");
            boolean needsComma = false;
            if (servletName != null) {
                sb.append("name=");
                sb.append(servletName);
                needsComma = true;
            }
            if (pid != null) {
                if (needsComma) {
                    sb.append(", ");
                }
                sb.append("pid=");
                sb.append(pid);
                needsComma = true;
            }
            if (componentName != null) {
                if (needsComma) {
                    sb.append(", ");
                }
                sb.append("component=");
                sb.append(componentName);
            }
            sb.append(")");
        }
        sb.append(" from ");
        Bundle bundle = reference.getBundle();
        if (bundle == null) {
            sb.append("uninstalled bundle");
        } else {
            sb.append("bundle ");
            if (bundle.getSymbolicName() == null) {
                sb.append(String.valueOf(bundle.getBundleId()));
            } else {
                sb.append(bundle.getSymbolicName());
                sb.append(":");
                sb.append(bundle.getVersion());
                sb.append(" (");
                sb.append(String.valueOf(bundle.getBundleId()));
                sb.append(") ");
            }
        }
        String[] ocs = (String[])reference.getProperty("objectClass");
        if (ocs != null) {
            sb.append("[");
            for (int i = 0; i < ocs.length; ++i) {
                sb.append(ocs[i]);
                if (i >= ocs.length - 1) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        return sb.toString();
    }
}

