/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal.helper;

import java.util.Iterator;
import java.util.Set;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.servlets.resolver.internal.SlingServletResolver;
import org.apache.sling.servlets.resolver.internal.helper.AbstractResourceCollector;
import org.apache.sling.servlets.resolver.internal.helper.WeightedResource;

public class NamedScriptResourceCollector
extends AbstractResourceCollector {
    private final String scriptName;

    public static NamedScriptResourceCollector create(String name, Resource resource, String[] executionPaths) {
        String baseResourceType;
        String resourceSuperType;
        String resourceType;
        if (resource != null) {
            resourceType = resource.getResourceType();
            resourceSuperType = resource.getResourceSuperType();
            baseResourceType = "sling/servlet/default";
        } else {
            resourceType = "";
            resourceSuperType = null;
            baseResourceType = "";
        }
        String scriptName = name;
        int pos = name.lastIndexOf(46);
        String extension = pos == -1 ? null : name.substring(pos);
        return new NamedScriptResourceCollector(baseResourceType, resourceType, resourceSuperType, scriptName, extension, executionPaths);
    }

    public NamedScriptResourceCollector(String baseResourceType, String resourceType, String resourceSuperType, String scriptName, String extension, String[] executionPaths) {
        super(baseResourceType, resourceType, resourceSuperType, extension, executionPaths);
        this.scriptName = scriptName;
        String key = baseResourceType + ':' + this.scriptName + ':' + this.resourceType + ':' + (this.resourceSuperType == null ? "" : this.resourceSuperType) + ':' + (this.extension == null ? "" : this.extension);
        this.hashCode = key.hashCode();
    }

    @Override
    protected void getWeightedResources(Set<WeightedResource> resources, Resource location) {
        String name;
        Resource current;
        int pos;
        Resource current2;
        String path;
        ResourceResolver resolver = location.getResourceResolver();
        if (this.extension != null && SlingServletResolver.isPathAllowed(path = ResourceUtil.normalize((String)(location.getPath() + '/' + this.scriptName)), this.executionPaths) && (current2 = resolver.getResource(path)) != null) {
            this.addWeightedResource(resources, current2, 0, 2);
        }
        if ((pos = this.scriptName.lastIndexOf(47)) == -1) {
            current = location;
            name = this.scriptName;
        } else {
            current = this.getResource(resolver, location.getPath() + '/' + this.scriptName.substring(0, pos));
            name = this.scriptName.substring(pos + 1);
        }
        Iterator children = resolver.listChildren(current);
        while (children.hasNext()) {
            String currentScriptName;
            int lastDot;
            Resource child = (Resource)children.next();
            if (!SlingServletResolver.isPathAllowed(child.getPath(), this.executionPaths) || (lastDot = (currentScriptName = child.getName()).lastIndexOf(46)) < 0 || !currentScriptName.substring(0, lastDot).equals(name)) continue;
            this.addWeightedResource(resources, child, 0, 1);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.scriptName == null ? 0 : this.scriptName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamedScriptResourceCollector other = (NamedScriptResourceCollector)obj;
        return !(this.scriptName == null ? other.scriptName != null : !this.scriptName.equals(other.scriptName));
    }
}

