/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.bundle.tracker.internal.request;

import java.util.Set;
import javax.servlet.RequestDispatcher;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.apache.sling.servlets.resolver.bundle.tracker.ResourceType;

public class RequestWrapper
extends SlingHttpServletRequestWrapper {
    private final Set<ResourceType> wiredResourceTypes;

    public RequestWrapper(SlingHttpServletRequest wrappedRequest, Set<ResourceType> wiredResourceTypes) {
        super(wrappedRequest);
        this.wiredResourceTypes = wiredResourceTypes;
    }

    public RequestDispatcher getRequestDispatcher(Resource resource, RequestDispatcherOptions options) {
        if (resource == null) {
            return null;
        }
        if (options != null && StringUtils.isEmpty((CharSequence)options.getForceResourceType())) {
            options.setForceResourceType(resource.getResourceType());
        }
        RequestDispatcherOptions processedOptions = this.processOptions(options);
        return super.getRequestDispatcher(resource, processedOptions);
    }

    public RequestDispatcher getRequestDispatcher(String path, RequestDispatcherOptions options) {
        if (path == null) {
            return null;
        }
        RequestDispatcherOptions processedOptions = this.processOptions(options);
        return super.getRequestDispatcher(path, processedOptions);
    }

    private RequestDispatcherOptions processOptions(RequestDispatcherOptions options) {
        if (options != null) {
            RequestDispatcherOptions requestDispatcherOptions = new RequestDispatcherOptions();
            requestDispatcherOptions.setForceResourceType(options.getForceResourceType());
            requestDispatcherOptions.setAddSelectors(options.getAddSelectors());
            requestDispatcherOptions.setReplaceSelectors(options.getReplaceSelectors());
            requestDispatcherOptions.setReplaceSuffix(options.getReplaceSuffix());
            String forcedResourceType = options.getForceResourceType();
            if (StringUtils.isNotEmpty((CharSequence)forcedResourceType)) {
                for (ResourceType wiredResourceType : this.wiredResourceTypes) {
                    String type = wiredResourceType.getType();
                    if (!type.equals(forcedResourceType)) continue;
                    requestDispatcherOptions.setForceResourceType(wiredResourceType.toString());
                    break;
                }
            }
            return requestDispatcherOptions;
        }
        return null;
    }
}

