/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal.resource;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.servlets.resolver.internal.resource.ServletResource;
import org.apache.sling.servlets.resolver.internal.resource.ServletResourceProvider;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

public class MergingServletResourceProvider {
    private final List<Pair<ServletResourceProvider, ServiceReference<?>>> registrations = new ArrayList();
    private final AtomicReference<ConcurrentHashMap<String, Set<String>>> tree = new AtomicReference(new ConcurrentHashMap());
    private final AtomicReference<ConcurrentHashMap<String, Pair<ServletResourceProvider, ServiceReference<?>>>> providers = new AtomicReference(new ConcurrentHashMap());

    synchronized void add(ServletResourceProvider provider, ServiceReference<?> reference) {
        this.registrations.add(Pair.of((Object)((Object)provider), reference));
        ConcurrentHashMap<String, Set<String>> localTree = this.localTree();
        ConcurrentHashMap<String, Pair<ServletResourceProvider, ServiceReference<?>>> localProvs = this.localProviders();
        this.index(localTree, localProvs, Arrays.asList(this.registrations.get(this.registrations.size() - 1)));
        this.tree.set(localTree);
        this.providers.set(localProvs);
    }

    synchronized boolean remove(ServletResourceProvider provider, ServiceReference<?> reference) {
        boolean found = false;
        Iterator<Pair<ServletResourceProvider, ServiceReference<?>>> regIter = this.registrations.iterator();
        while (regIter.hasNext()) {
            Pair<ServletResourceProvider, ServiceReference<?>> reg = regIter.next();
            if (reg.getLeft() == provider) {
                regIter.remove();
                found = true;
                continue;
            }
            Bundle bundle = ((ServiceReference)reg.getRight()).getBundle();
            if (bundle != null && bundle.getState() != 16) continue;
            regIter.remove();
            found = true;
        }
        if (found) {
            ConcurrentHashMap<String, Set<String>> localTree = new ConcurrentHashMap<String, Set<String>>();
            ConcurrentHashMap localProvs = new ConcurrentHashMap();
            this.index(localTree, localProvs, this.registrations);
            this.tree.set(localTree);
            this.providers.set(localProvs);
        }
        return found;
    }

    synchronized void clear() {
        this.registrations.clear();
        this.tree.set(new ConcurrentHashMap());
        this.providers.set(new ConcurrentHashMap());
    }

    private ConcurrentHashMap<String, Set<String>> localTree() {
        ConcurrentHashMap<String, Set<String>> localTree = new ConcurrentHashMap<String, Set<String>>();
        for (Map.Entry<String, Set<String>> entry : this.tree.get().entrySet()) {
            localTree.put(entry.getKey(), Collections.synchronizedSet(new LinkedHashSet(entry.getValue())));
        }
        return localTree;
    }

    private ConcurrentHashMap<String, Pair<ServletResourceProvider, ServiceReference<?>>> localProviders() {
        return new ConcurrentHashMap((Map)this.providers.get());
    }

    private void index(ConcurrentHashMap<String, Set<String>> tree, ConcurrentHashMap<String, Pair<ServletResourceProvider, ServiceReference<?>>> providers, List<Pair<ServletResourceProvider, ServiceReference<?>>> registrations) {
        for (Pair<ServletResourceProvider, ServiceReference<?>> reference : registrations) {
            for (String path : ((ServletResourceProvider)((Object)reference.getLeft())).getServletPaths()) {
                String current = "";
                for (String part : path.split("/")) {
                    Set<String> childs = tree.get(current);
                    if (childs == null) {
                        childs = Collections.synchronizedSet(new LinkedHashSet());
                        tree.put(current, childs);
                    }
                    current = current + "/" + part;
                    current = current.trim().replace("//", "/");
                    childs.add(current);
                }
                Pair<ServletResourceProvider, ServiceReference<?>> old = providers.put(path, reference);
                if (old == null || ((ServiceReference)reference.getRight()).compareTo(old.getRight()) >= 0) continue;
                providers.put(path, old);
            }
        }
    }

    public boolean isRootOf(String path) {
        if (path != null && path.startsWith("/")) {
            int idx = path.indexOf(47, 1);
            if (idx != -1) {
                path = path.substring(0, idx);
                return this.tree.get().containsKey(path);
            }
            return true;
        }
        return false;
    }

    public Resource getResource(ResolveContext resolveContext, String path) {
        Object result;
        Pair<ServletResourceProvider, ServiceReference<?>> provider;
        Resource wrapped = null;
        ResourceProvider parentProvider = resolveContext.getParentResourceProvider();
        if (parentProvider != null) {
            wrapped = parentProvider.getResource(resolveContext.getParentResolveContext(), path, null, null);
        }
        if ((provider = this.providers.get().get(path)) != null) {
            result = ((ServletResourceProvider)((Object)provider.getLeft())).getResource((ResolveContext<Object>)resolveContext, path, null, null);
            if (result instanceof ServletResource) {
                ((ServletResource)((Object)result)).setWrappedResource(wrapped);
            }
        } else {
            result = wrapped != null ? wrapped : null;
            if (result == null && this.tree.get().containsKey(path)) {
                result = new SyntheticResource(resolveContext.getResourceResolver(), path, "sling:syntheticResourceProviderResource");
            }
        }
        return result;
    }

    public Iterator<Resource> listChildren(ResolveContext ctx, Resource parent) {
        Set<String> paths;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        ResourceProvider parentProvider = ctx.getParentResourceProvider();
        if (parentProvider != null) {
            Iterator iter = parentProvider.listChildren(ctx.getParentResolveContext(), parent);
            while (iter != null && iter.hasNext()) {
                Resource resource = (Resource)iter.next();
                result.put(resource.getPath(), resource);
            }
        }
        if ((paths = this.tree.get().get(parent.getPath())) != null) {
            for (String path : paths.toArray(new String[0])) {
                Pair<ServletResourceProvider, ServiceReference<?>> provider = this.providers.get().get(path);
                if (provider != null) {
                    Resource resource = ((ServletResourceProvider)((Object)provider.getLeft())).getResource((ResolveContext<Object>)ctx, path, null, parent);
                    if (resource == null) continue;
                    Resource wrapped = result.put(path, resource);
                    if (!(resource instanceof ServletResource)) continue;
                    ((ServletResource)resource).setWrappedResource(wrapped);
                    continue;
                }
                if (result.containsKey(path)) continue;
                result.put(path, new SyntheticResource(ctx.getResourceResolver(), path, "sling:syntheticResourceProviderResource"));
            }
        }
        return result.values().iterator();
    }
}

