/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.bundle.tracker.internal;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.GenericServlet;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.servlets.resolver.bundle.tracker.BundledRenderUnit;
import org.apache.sling.servlets.resolver.bundle.tracker.BundledRenderUnitCapability;
import org.apache.sling.servlets.resolver.bundle.tracker.BundledRenderUnitFinder;
import org.apache.sling.servlets.resolver.bundle.tracker.ResourceType;
import org.apache.sling.servlets.resolver.bundle.tracker.TypeProvider;
import org.apache.sling.servlets.resolver.bundle.tracker.internal.BundledHooks;
import org.apache.sling.servlets.resolver.bundle.tracker.internal.BundledRenderUnitCapabilityImpl;
import org.apache.sling.servlets.resolver.bundle.tracker.internal.BundledScriptServlet;
import org.apache.sling.servlets.resolver.bundle.tracker.internal.TypeProviderImpl;
import org.apache.sling.servlets.resolver.internal.resource.ServletMounter;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.bundle.Capability;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleReference;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={})
@Capability(namespace="osgi.extender", name="sling.scripting", version="1.0.0")
public class BundledScriptTracker
implements BundleTrackerCustomizer<List<ServiceRegistration<Servlet>>> {
    static final String NS_SLING_SCRIPTING_EXTENDER = "sling.scripting";
    private static final Logger LOGGER = LoggerFactory.getLogger(BundledScriptTracker.class);
    private static final String REGISTERING_BUNDLE = "BundledScriptTracker.registering_bundle";
    public static final String NS_SLING_SERVLET = "sling.servlet";
    public static final String AT_VERSION = "version";
    public static final String AT_SCRIPT_ENGINE = "scriptEngine";
    public static final String AT_SCRIPT_EXTENSION = "scriptExtension";
    public static final String AT_EXTENDS = "extends";
    private static final String[] DEFAULT_SERVLET_METHODS = new String[]{"GET", "HEAD"};
    @Reference
    private BundledRenderUnitFinder bundledRenderUnitFinder;
    @Reference
    private ServletMounter mounter;
    private volatile BundleContext m_context;
    private volatile BundleTracker<List<ServiceRegistration<Servlet>>> m_tracker;
    private volatile Map<Set<String>, ServiceRegistration<Servlet>> m_dispatchers = new HashMap<Set<String>, ServiceRegistration<Servlet>>();
    private final AtomicLong idCounter = new AtomicLong(0L);

    @Activate
    protected void activate(BundleContext context) {
        this.m_context = context;
        this.m_tracker = new BundleTracker(context, 32, (BundleTrackerCustomizer)this);
        this.m_tracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this.m_tracker.close();
    }

    public List<ServiceRegistration<Servlet>> addingBundle(Bundle bundle, BundleEvent event) {
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (bundleWiring.getRequiredWires("osgi.extender").stream().map(BundleWire::getProvider).map(BundleReference::getBundle).anyMatch(this.m_context.getBundle()::equals)) {
            LOGGER.debug("Inspecting bundle {} for {} capability.", (Object)bundle.getSymbolicName(), (Object)NS_SLING_SERVLET);
            List capabilities = bundleWiring.getCapabilities(NS_SLING_SERVLET);
            Set<TypeProvider> requiresChain = this.collectRequiresChain(bundleWiring);
            if (!capabilities.isEmpty()) {
                List<ServiceRegistration<Servlet>> serviceRegistrations = capabilities.stream().flatMap(cap -> {
                    Hashtable<String, Object> properties = new Hashtable<String, Object>();
                    properties.put("sling.core.servletName", BundledScriptServlet.class.getName());
                    properties.put("service.description", BundledScriptServlet.class.getName() + cap.getAttributes());
                    BundledRenderUnitCapability bundledRenderUnitCapability = BundledRenderUnitCapabilityImpl.fromBundleCapability(cap);
                    BundledRenderUnit executable = null;
                    TypeProviderImpl baseTypeProvider = new TypeProviderImpl(bundledRenderUnitCapability, bundle);
                    LinkedHashSet<TypeProvider> inheritanceChain = new LinkedHashSet<TypeProvider>();
                    inheritanceChain.add(baseTypeProvider);
                    if (!bundledRenderUnitCapability.getResourceTypes().isEmpty()) {
                        String extendedResourceTypeString;
                        String[] resourceTypesRegistrationValue = new String[bundledRenderUnitCapability.getResourceTypes().size()];
                        int rtIndex = 0;
                        for (ResourceType resourceType2 : bundledRenderUnitCapability.getResourceTypes()) {
                            resourceTypesRegistrationValue[rtIndex++] = resourceType2.toString();
                        }
                        properties.put("sling.servlet.resourceTypes", resourceTypesRegistrationValue);
                        String extension = bundledRenderUnitCapability.getExtension();
                        if (!StringUtils.isEmpty((CharSequence)extension)) {
                            properties.put("sling.servlet.extensions", extension);
                        }
                        if (!bundledRenderUnitCapability.getSelectors().isEmpty()) {
                            properties.put("sling.servlet.selectors", bundledRenderUnitCapability.getSelectors().toArray());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)bundledRenderUnitCapability.getMethod())) {
                            properties.put("sling.servlet.methods", bundledRenderUnitCapability.getMethod());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)(extendedResourceTypeString = bundledRenderUnitCapability.getExtendedResourceType()))) {
                            this.collectInheritanceChain(inheritanceChain, bundleWiring, extendedResourceTypeString);
                            inheritanceChain.stream().filter(typeProvider -> typeProvider.getBundledRenderUnitCapability().getResourceTypes().stream().anyMatch(resourceType -> resourceType.getType().equals(extendedResourceTypeString))).findFirst().ifPresent(typeProvider -> {
                                for (ResourceType type : typeProvider.getBundledRenderUnitCapability().getResourceTypes()) {
                                    if (!type.getType().equals(extendedResourceTypeString)) continue;
                                    properties.put("sling.servlet.resourceSuperType", type.toString());
                                }
                            });
                        }
                        Set aggregate = Stream.concat(inheritanceChain.stream(), requiresChain.stream()).collect(Collectors.toCollection(LinkedHashSet::new));
                        executable = this.bundledRenderUnitFinder.findUnit(bundle.getBundleContext(), inheritanceChain, (Set<TypeProvider>)aggregate);
                    } else if (StringUtils.isNotEmpty((CharSequence)bundledRenderUnitCapability.getPath()) && StringUtils.isNotEmpty((CharSequence)bundledRenderUnitCapability.getScriptEngineName())) {
                        Set aggregate = Stream.concat(inheritanceChain.stream(), requiresChain.stream()).collect(Collectors.toCollection(LinkedHashSet::new));
                        executable = this.bundledRenderUnitFinder.findUnit(bundle.getBundleContext(), baseTypeProvider, (Set<TypeProvider>)aggregate);
                    }
                    ArrayList<ServiceRegistration<Servlet>> regs = new ArrayList<ServiceRegistration<Servlet>>();
                    if (executable != null) {
                        BundledRenderUnit finalExecutable = executable;
                        String executableParentPath = ResourceUtil.getParent((String)executable.getPath());
                        if (executable.getPath().equals(bundledRenderUnitCapability.getPath())) {
                            properties.put("sling.servlet.paths", executable.getPath());
                        } else {
                            if (!bundledRenderUnitCapability.getResourceTypes().isEmpty() && bundledRenderUnitCapability.getSelectors().isEmpty() && StringUtils.isEmpty((CharSequence)bundledRenderUnitCapability.getExtension()) && StringUtils.isEmpty((CharSequence)bundledRenderUnitCapability.getMethod())) {
                                String scriptName = FilenameUtils.getName((String)executable.getPath());
                                String scriptNameNoExtension = scriptName.substring(0, scriptName.lastIndexOf(46));
                                boolean noMatch = bundledRenderUnitCapability.getResourceTypes().stream().noneMatch(resourceType -> {
                                    String resourceTypePath = resourceType.toString();
                                    int lastSlash = resourceTypePath.lastIndexOf(47);
                                    String label = lastSlash > -1 ? resourceTypePath.substring(lastSlash + 1) : resourceTypePath;
                                    return label.equals(scriptNameNoExtension);
                                });
                                if (noMatch) {
                                    ArrayList<String> paths = new ArrayList<String>();
                                    paths.add(finalExecutable.getPath());
                                    bundledRenderUnitCapability.getResourceTypes().forEach(resourceType -> {
                                        String resourceTypePath = resourceType.toString();
                                        int lastSlash = resourceTypePath.lastIndexOf(47);
                                        String label = lastSlash > -1 ? resourceTypePath.substring(lastSlash + 1) : resourceTypePath;
                                        if (StringUtils.isNotEmpty((CharSequence)executableParentPath) && executableParentPath.equals(resourceTypePath)) {
                                            paths.add(resourceTypePath + "/" + label + ".servlet");
                                        }
                                    });
                                    properties.put("sling.servlet.paths", paths.toArray(new String[0]));
                                }
                            }
                            if (!properties.containsKey("sling.servlet.paths")) {
                                bundledRenderUnitCapability.getResourceTypes().forEach(resourceType -> {
                                    if (StringUtils.isNotEmpty((CharSequence)executableParentPath) && executableParentPath.equals(resourceType.toString())) {
                                        properties.put("sling.servlet.paths", finalExecutable.getPath());
                                    }
                                });
                            }
                        }
                        regs.add(this.register(bundle.getBundleContext(), (Servlet)new BundledScriptServlet(inheritanceChain, executable), properties));
                    } else {
                        LOGGER.warn(String.format("Unable to locate an executable for capability %s.", cap));
                    }
                    return regs.stream();
                }).collect(Collectors.toList());
                this.refreshDispatcher(serviceRegistrations);
                return serviceRegistrations;
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    private ServiceRegistration<Servlet> register(final BundleContext context, Servlet servlet, final Hashtable<String, Object> properties) {
        if (this.mounter.mountProviders()) {
            return context.registerService(Servlet.class, (Object)servlet, properties);
        }
        final Long id = this.idCounter.getAndIncrement();
        properties.put("service.id", id);
        properties.put(BundledHooks.class.getName(), "true");
        final ServiceReference reference = (ServiceReference)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ServiceReference.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.equals(ServiceReference.class.getMethod("getProperty", String.class))) {
                    return properties.get(args[0]);
                }
                if (method.equals(ServiceReference.class.getMethod("getPropertyKeys", new Class[0]))) {
                    return properties.keySet().toArray(new String[0]);
                }
                if (method.equals(ServiceReference.class.getMethod("getBundle", new Class[0]))) {
                    return context.getBundle();
                }
                if (method.equals(ServiceReference.class.getMethod("getUsingBundles", new Class[0]))) {
                    return new Bundle[]{BundledScriptTracker.this.m_context.getBundle()};
                }
                if (method.equals(ServiceReference.class.getMethod("isAssignableTo", Bundle.class, String.class))) {
                    return Servlet.class.getName().equals(args[1]);
                }
                if (method.equals(ServiceReference.class.getMethod("compareTo", Object.class))) {
                    return this.compareTo(args[0]);
                }
                if (method.getName().equals("equals") && Arrays.equals(method.getParameterTypes(), new Class[]{Object.class})) {
                    return args[0] instanceof ServiceReference && this.compareTo(args[0]) == 0;
                }
                if (method.getName().equals("hashCode") && method.getParameterCount() == 0) {
                    return id.intValue();
                }
                throw new UnsupportedOperationException(method.toGenericString());
            }

            private int compareTo(Object arg) {
                Integer otherRank;
                Long otherId;
                ServiceReference other = (ServiceReference)arg;
                Long id2 = "true".equals(other.getProperty(BundledHooks.class.getName())) ? (Long)properties.get("service.id") : Long.valueOf(-1L);
                if (id2.equals(otherId = (Long)other.getProperty("service.id"))) {
                    return 0;
                }
                Object rankObj = properties.get("service.ranking");
                Object otherRankObj = other.getProperty("service.ranking");
                rankObj = rankObj == null ? Integer.valueOf(0) : rankObj;
                otherRankObj = otherRankObj == null ? Integer.valueOf(0) : otherRankObj;
                Integer rank = rankObj instanceof Integer ? (Integer)rankObj : Integer.valueOf(0);
                Integer n = otherRank = otherRankObj instanceof Integer ? (Integer)otherRankObj : Integer.valueOf(0);
                if (rank.compareTo(otherRank) < 0) {
                    return -1;
                }
                if (rank.compareTo(otherRank) > 0) {
                    return 1;
                }
                return id2.compareTo(otherId) < 0 ? 1 : -1;
            }
        });
        this.mounter.bindServlet(servlet, (ServiceReference<Servlet>)reference);
        return (ServiceRegistration)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ServiceRegistration.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.equals(ServiceRegistration.class.getMethod("getReference", new Class[0]))) {
                    return reference;
                }
                if (method.equals(ServiceRegistration.class.getMethod("setProperties", Dictionary.class))) {
                    return null;
                }
                if (method.equals(ServiceRegistration.class.getMethod("unregister", new Class[0]))) {
                    BundledScriptTracker.this.mounter.unbindServlet((ServiceReference<Servlet>)reference);
                    return null;
                }
                if (method.getName().equals("equals") && Arrays.equals(method.getParameterTypes(), new Class[]{Object.class})) {
                    return args[0] instanceof ServiceRegistration && reference.compareTo((Object)((ServiceRegistration)args[0]).getReference()) == 0;
                }
                if (method.getName().equals("hashCode") && method.getParameterCount() == 0) {
                    return id.intValue();
                }
                throw new UnsupportedOperationException(method.toGenericString());
            }
        });
    }

    private void refreshDispatcher(List<ServiceRegistration<Servlet>> regs) {
        HashMap<Set<String>, ServiceRegistration<Servlet>> dispatchers = new HashMap<Set<String>, ServiceRegistration<Servlet>>();
        Stream.concat(this.m_tracker.getTracked().values().stream(), Stream.of(regs)).flatMap(Collection::stream).filter(ref -> BundledScriptTracker.getResourceTypeVersion(ref.getReference()) != null).map(this::toProperties).collect(Collectors.groupingBy(BundledScriptTracker::getResourceTypes)).forEach((rt, propList) -> {
            ServiceRegistration<Servlet> reg;
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            properties.put("sling.core.servletName", DispatcherServlet.class.getName());
            properties.put("sling.servlet.resourceTypes", rt.toArray());
            Set<String> methods = propList.stream().map(props -> props.getOrDefault("sling.servlet.methods", new String[]{"GET", "HEAD"})).map(PropertiesUtil::toStringArray).map(Arrays::asList).flatMap(Collection::stream).collect(Collectors.toSet());
            Set<String> extensions = propList.stream().map(props -> props.getOrDefault("sling.servlet.extensions", new String[]{"html"})).map(PropertiesUtil::toStringArray).map(Arrays::asList).flatMap(Collection::stream).collect(Collectors.toSet());
            properties.put("sling.servlet.extensions", extensions.toArray(new String[0]));
            if (!methods.equals(new HashSet<String>(Arrays.asList("GET", "HEAD")))) {
                properties.put("sling.servlet.methods", methods.toArray(new String[0]));
            }
            if ((reg = this.m_dispatchers.remove(rt)) == null) {
                Optional<BundleContext> registeringBundle = propList.stream().map(props -> {
                    Bundle bundle = (Bundle)props.get(REGISTERING_BUNDLE);
                    if (bundle != null) {
                        return bundle.getBundleContext();
                    }
                    return null;
                }).findFirst();
                properties.put("service.description", DispatcherServlet.class.getName() + "{" + "sling.servlet.resourceTypes" + "=" + rt + "; " + "sling.servlet.extensions" + "=" + extensions + "; " + "sling.servlet.methods" + "=" + methods + "}");
                properties.put(BundledHooks.class.getName(), "true");
                reg = this.register(registeringBundle.orElse(this.m_context), (Servlet)new DispatcherServlet((Set<String>)rt), properties);
            } else if (!new HashSet<String>(Arrays.asList(PropertiesUtil.toStringArray((Object)reg.getReference().getProperty("sling.servlet.methods"), (String[])new String[0]))).equals(methods)) {
                reg.setProperties(properties);
            }
            dispatchers.put((Set<String>)rt, reg);
        });
        this.m_dispatchers.values().forEach(ServiceRegistration::unregister);
        this.m_dispatchers = dispatchers;
    }

    private Hashtable<String, Object> toProperties(ServiceRegistration<?> reg) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        ServiceReference ref = reg.getReference();
        this.set("sling.servlet.resourceTypes", ref, result);
        this.set("sling.servlet.extensions", ref, result);
        this.set("sling.servlet.selectors", ref, result);
        this.set("sling.servlet.methods", ref, result);
        result.put(REGISTERING_BUNDLE, reg.getReference().getBundle());
        return result;
    }

    private void set(String key, ServiceReference<?> ref, Hashtable<String, Object> props) {
        Object value = ref.getProperty(key);
        if (value != null) {
            props.put(key, value);
        }
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, List<ServiceRegistration<Servlet>> regs) {
        LOGGER.warn("Unexpected modified event {} for bundle {}.", (Object)event, (Object)bundle);
    }

    public void removedBundle(Bundle bundle, BundleEvent event, List<ServiceRegistration<Servlet>> regs) {
        LOGGER.debug("Bundle {} removed", (Object)bundle.getSymbolicName());
        regs.forEach(ServiceRegistration::unregister);
        this.refreshDispatcher(Collections.emptyList());
    }

    private static String getResourceTypeVersion(ServiceReference<?> ref) {
        String[] values = PropertiesUtil.toStringArray((Object)ref.getProperty("sling.servlet.resourceTypes"));
        if (values != null) {
            String resourceTypeValue = values[0];
            ResourceType resourceType = ResourceType.parseResourceType(resourceTypeValue);
            return resourceType.getVersion();
        }
        return null;
    }

    private static Set<String> getResourceTypes(Hashtable<String, Object> props) {
        String[] values;
        HashSet<String> resourceTypes = new HashSet<String>();
        for (String resourceTypeValue : values = PropertiesUtil.toStringArray((Object)props.get("sling.servlet.resourceTypes"))) {
            resourceTypes.add(ResourceType.parseResourceType(resourceTypeValue).getType());
        }
        return resourceTypes;
    }

    private void collectInheritanceChain(@NotNull Set<TypeProvider> providers, @NotNull BundleWiring wiring, @NotNull String extendedResourceType) {
        for (BundleWire wire : wiring.getRequiredWires(NS_SLING_SERVLET)) {
            BundledRenderUnitCapability wiredCapability = BundledRenderUnitCapabilityImpl.fromBundleCapability(wire.getCapability());
            if (!wiredCapability.getSelectors().isEmpty()) continue;
            for (ResourceType resourceType : wiredCapability.getResourceTypes()) {
                if (!extendedResourceType.equals(resourceType.getType())) continue;
                Bundle providingBundle = wire.getProvider().getBundle();
                providers.add(new TypeProviderImpl(wiredCapability, providingBundle));
                String wiredExtends = wiredCapability.getExtendedResourceType();
                if (!StringUtils.isNotEmpty((CharSequence)wiredExtends)) continue;
                this.collectInheritanceChain(providers, wire.getProviderWiring(), wiredExtends);
            }
        }
    }

    private Set<TypeProvider> collectRequiresChain(@NotNull BundleWiring wiring) {
        LinkedHashSet<TypeProvider> requiresChain = new LinkedHashSet<TypeProvider>();
        for (BundleWire wire : wiring.getRequiredWires(NS_SLING_SERVLET)) {
            BundledRenderUnitCapability wiredCapability = BundledRenderUnitCapabilityImpl.fromBundleCapability(wire.getCapability());
            if (!wiredCapability.getSelectors().isEmpty()) continue;
            Bundle providingBundle = wire.getProvider().getBundle();
            requiresChain.add(new TypeProviderImpl(wiredCapability, providingBundle));
        }
        return requiresChain;
    }

    private class DispatcherServlet
    extends GenericServlet {
        private final Set<String> m_rt;

        DispatcherServlet(Set<String> rt) {
            this.m_rt = rt;
        }

        public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
            SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)req;
            Optional<ServiceRegistration> target = BundledScriptTracker.this.m_tracker.getTracked().values().stream().flatMap(Collection::stream).filter(reg -> !reg.getReference().getBundle().equals(BundledScriptTracker.this.m_context.getBundle())).filter(reg -> BundledScriptTracker.getResourceTypeVersion(reg.getReference()) != null).filter(reg -> {
                Hashtable props = BundledScriptTracker.this.toProperties(reg);
                return BundledScriptTracker.getResourceTypes(props).equals(this.m_rt) && Arrays.asList(PropertiesUtil.toStringArray(props.get("sling.servlet.methods"), (String[])new String[]{"GET", "HEAD"})).contains(slingRequest.getMethod()) && Arrays.asList(PropertiesUtil.toStringArray(props.get("sling.servlet.extensions"), (String[])new String[]{"html"})).contains(slingRequest.getRequestPathInfo().getExtension() == null ? "html" : slingRequest.getRequestPathInfo().getExtension());
            }).min((left, right) -> {
                boolean la = Arrays.asList(PropertiesUtil.toStringArray(BundledScriptTracker.this.toProperties(left).get("sling.servlet.selectors"), (String[])new String[0])).containsAll(Arrays.asList(slingRequest.getRequestPathInfo().getSelectors()));
                boolean ra = Arrays.asList(PropertiesUtil.toStringArray(BundledScriptTracker.this.toProperties(right).get("sling.servlet.selectors"), (String[])new String[0])).containsAll(Arrays.asList(slingRequest.getRequestPathInfo().getSelectors()));
                if (la && ra || !la && !ra) {
                    return new Version(BundledScriptTracker.getResourceTypeVersion(right.getReference())).compareTo(new Version(BundledScriptTracker.getResourceTypeVersion(left.getReference())));
                }
                if (la) {
                    return -1;
                }
                return 1;
            });
            if (target.isPresent()) {
                String[] targetRT = PropertiesUtil.toStringArray((Object)target.get().getReference().getProperty("sling.servlet.resourceTypes"));
                if (targetRT == null || targetRT.length == 0) {
                    ((SlingHttpServletResponse)res).sendError(404);
                } else {
                    String rt = targetRT[0];
                    RequestDispatcherOptions options = new RequestDispatcherOptions();
                    options.setForceResourceType(rt);
                    RequestDispatcher dispatcher = slingRequest.getRequestDispatcher(slingRequest.getResource(), options);
                    if (dispatcher != null) {
                        String contentType;
                        if (slingRequest.getAttribute("javax.servlet.include.servlet_path") == null && (contentType = slingRequest.getResponseContentType()) != null) {
                            res.setContentType(contentType);
                            if (contentType.startsWith("text/")) {
                                res.setCharacterEncoding("UTF-8");
                            }
                        }
                        dispatcher.include(req, res);
                    } else {
                        ((SlingHttpServletResponse)res).sendError(404);
                    }
                }
            } else {
                ((SlingHttpServletResponse)res).sendError(404);
            }
        }
    }
}

