/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal;

import java.util.Arrays;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.engine.RequestUtil;
import org.apache.sling.servlets.resolver.internal.resource.SlingServletConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PathBasedServletAcceptor {
    public static final Logger LOGGER = LoggerFactory.getLogger(PathBasedServletAcceptor.class);
    private static final String STRICT_PATHS_SERVICE_PROPERTY = "sling.servlet.paths.strict";

    PathBasedServletAcceptor() {
    }

    boolean accept(SlingHttpServletRequest request, Servlet servlet) {
        ServletConfig rawCfg = servlet.getServletConfig();
        if (!(rawCfg instanceof SlingServletConfig)) {
            LOGGER.error("Did not get a SlingServletConfig for {}", (Object)RequestUtil.getServletName((Servlet)servlet));
            return true;
        }
        SlingServletConfig config = (SlingServletConfig)rawCfg;
        String servletName = RequestUtil.getServletName((Servlet)servlet);
        boolean accepted = true;
        Object strictPaths = config.getServiceProperty(STRICT_PATHS_SERVICE_PROPERTY);
        if (strictPaths != null && Boolean.valueOf(strictPaths.toString()).booleanValue()) {
            accepted = this.accept(servletName, config, "sling.servlet.extensions", request.getRequestPathInfo().getExtension()) && this.accept(servletName, config, "sling.servlet.selectors", request.getRequestPathInfo().getSelectors()) && this.accept(servletName, config, "sling.servlet.methods", request.getMethod());
        }
        LOGGER.debug("accepted={} for {}", (Object)accepted, (Object)servletName);
        return accepted;
    }

    private boolean accept(String servletName, SlingServletConfig config, String servicePropertyKey, String ... requestValues) {
        String[] propValues = PathBasedServletAcceptor.toStringArray(config.getServiceProperty(servicePropertyKey));
        if (propValues == null) {
            LOGGER.debug("Property {} is null or empty, not checking that value for {}", (Object)servicePropertyKey, (Object)servletName);
            return true;
        }
        boolean accepted = false;
        block0: for (String rValue : requestValues) {
            for (String pValue : propValues) {
                if (rValue == null || !rValue.equals(pValue)) continue;
                accepted = true;
                continue block0;
            }
        }
        LOGGER.debug("accepted={} for property {} and servlet {}", new Object[]{accepted, servicePropertyKey, servletName});
        return accepted;
    }

    private static String[] toStringArray(Object value) {
        if (value instanceof String) {
            return new String[]{(String)value};
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value instanceof Object[]) {
            Object[] objArray = (Object[])value;
            return (String[])Arrays.copyOf(objArray, objArray.length, String[].class);
        }
        return null;
    }
}

