/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.api.request.RequestUtil;
import org.apache.sling.api.request.SlingRequestEvent;
import org.apache.sling.api.request.SlingRequestListener;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.servlets.OptingServlet;
import org.apache.sling.api.servlets.ServletResolver;
import org.apache.sling.engine.servlets.ErrorHandler;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.apache.sling.servlets.resolver.internal.ResolverConfig;
import org.apache.sling.servlets.resolver.internal.ScriptResource;
import org.apache.sling.servlets.resolver.internal.defaults.DefaultErrorHandlerServlet;
import org.apache.sling.servlets.resolver.internal.defaults.DefaultServlet;
import org.apache.sling.servlets.resolver.internal.helper.AbstractResourceCollector;
import org.apache.sling.servlets.resolver.internal.helper.NamedScriptResourceCollector;
import org.apache.sling.servlets.resolver.internal.helper.ResourceCollector;
import org.apache.sling.servlets.resolver.internal.resolution.ResolutionCache;
import org.apache.sling.servlets.resolver.internal.resource.SlingServletConfig;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="org.apache.sling.servlets.resolver.SlingServletResolver", service={ServletResolver.class, ErrorHandler.class, SlingRequestListener.class}, property={"service.description=Apache Sling Servlet Resolver and Error Handler", "service.vendor=The Apache Software Foundation"})
@Designate(ocd=ResolverConfig.class)
public class SlingServletResolver
implements ServletResolver,
SlingRequestListener,
ErrorHandler {
    private static final String SERVICE_USER = "scripts";
    public static final Logger LOGGER = LoggerFactory.getLogger(SlingServletResolver.class);
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference(target="(|(subServiceName=scripts)(!(subServiceName=*)))")
    private ServiceUserMapped scriptServiceUserMapped;
    @Reference
    private ResolutionCache resolutionCache;
    @Reference(target="(name=org.apache.sling)")
    private ServletContext servletContext;
    private volatile Servlet defaultServlet;
    private volatile Servlet fallbackErrorServlet;
    private volatile ResourceResolver sharedScriptResolver;
    private volatile String[] executionPaths;
    private volatile String[] defaultExtensions;
    private final ThreadLocal<ResourceResolver> perThreadScriptResolver = new ThreadLocal();

    public Servlet resolveServlet(SlingHttpServletRequest request) {
        Resource resource = request.getResource();
        RequestProgressTracker tracker = request.getRequestProgressTracker();
        String timerName = "resolveServlet(" + resource.getPath() + ")";
        tracker.startTimer(timerName);
        String type = resource.getResourceType();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("resolveServlet called for resource {}", (Object)resource);
        }
        ResourceResolver scriptResolver = this.getScriptResourceResolver();
        Servlet servlet = null;
        if (type != null && type.length() > 0) {
            servlet = this.resolveServletInternal(request, null, type, scriptResolver);
        }
        if (servlet == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No specific servlet found, trying default");
            }
            servlet = this.getDefaultServlet();
        }
        if (servlet == null) {
            tracker.logTimer(timerName, "Servlet resolution failed. See log for details", new Object[0]);
        } else {
            tracker.logTimer(timerName, "Using servlet {0}", new Object[]{RequestUtil.getServletName((Servlet)servlet)});
        }
        if (LOGGER.isDebugEnabled()) {
            if (servlet != null) {
                LOGGER.debug("Servlet {} found for resource={}", (Object)RequestUtil.getServletName((Servlet)servlet), (Object)resource);
            } else {
                LOGGER.debug("No servlet found for resource={}", (Object)resource);
            }
        }
        return servlet;
    }

    public Servlet resolveServlet(Resource resource, String scriptName) {
        if (resource == null) {
            throw new IllegalArgumentException("Resource must not be null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("resolveServlet called for resource {} with script name {}", (Object)resource, (Object)scriptName);
        }
        ResourceResolver scriptResolver = this.getScriptResourceResolver();
        Servlet servlet = this.resolveServletInternal(null, resource, scriptName, scriptResolver);
        if (LOGGER.isDebugEnabled()) {
            if (servlet != null) {
                LOGGER.debug("Servlet {} found for resource {} and script name {}", new Object[]{RequestUtil.getServletName((Servlet)servlet), resource, scriptName});
            } else {
                LOGGER.debug("No servlet found for resource {} and script name {}", (Object)resource, (Object)scriptName);
            }
        }
        return servlet;
    }

    public Servlet resolveServlet(ResourceResolver resolver, String scriptName) {
        if (resolver == null) {
            throw new IllegalArgumentException("Resource resolver must not be null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("resolveServlet called for for script name {}", (Object)scriptName);
        }
        ResourceResolver scriptResolver = this.getScriptResourceResolver();
        Servlet servlet = this.resolveServletInternal(null, null, scriptName, scriptResolver);
        if (LOGGER.isDebugEnabled()) {
            if (servlet != null) {
                LOGGER.debug("Servlet {} found for script name {}", (Object)RequestUtil.getServletName((Servlet)servlet), (Object)scriptName);
            } else {
                LOGGER.debug("No servlet found for script name {}", (Object)scriptName);
            }
        }
        return servlet;
    }

    private Servlet getServlet(Resource scriptResource) {
        if (scriptResource == null) {
            return null;
        }
        if (scriptResource.getResourceResolver() == this.sharedScriptResolver || "sling/bundle/resource".equals(scriptResource.getResourceSuperType())) {
            return (Servlet)scriptResource.adaptTo(Servlet.class);
        }
        return new ScriptResource(scriptResource, this.perThreadScriptResolver, this.sharedScriptResolver).adaptTo(Servlet.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleError(int status, String message, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        if (request.getAttribute("javax.servlet.error.request_uri") != null) {
            LOGGER.error("handleError: Recursive invocation. Not further handling status " + status + "(" + message + ")");
            return;
        }
        RequestProgressTracker tracker = request.getRequestProgressTracker();
        String timerName = "handleError:status=" + status;
        tracker.startTimer(timerName);
        ResourceResolver scriptResolver = this.getScriptResourceResolver();
        try {
            Resource resource = this.getErrorResource(request);
            ResourceCollector locationUtil = new ResourceCollector(String.valueOf(status), "sling/servlet/errorhandler", resource, this.executionPaths);
            Servlet servlet = this.getServletInternal(locationUtil, request, scriptResolver);
            if (servlet == null) {
                servlet = this.getDefaultErrorServlet(request, resource, scriptResolver);
            }
            request.setAttribute("javax.servlet.error.status_code", (Object)new Integer(status));
            request.setAttribute("javax.servlet.error.message", (Object)message);
            Object servletName = request.getAttribute("sling.core.current.servletName");
            if (servletName instanceof String) {
                request.setAttribute("javax.servlet.error.servlet_name", servletName);
            }
            tracker.logTimer(timerName, "Using handler {0}", new Object[]{RequestUtil.getServletName((Servlet)servlet)});
            this.handleError(servlet, (HttpServletRequest)request, (HttpServletResponse)response);
        }
        finally {
            tracker.logTimer(timerName, "Error handler finished", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleError(Throwable throwable, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        if (request.getAttribute("javax.servlet.error.request_uri") != null) {
            LOGGER.error("handleError: Recursive invocation. Not further handling Throwable:", throwable);
            return;
        }
        RequestProgressTracker tracker = request.getRequestProgressTracker();
        String timerName = "handleError:throwable=" + throwable.getClass().getName();
        tracker.startTimer(timerName);
        ResourceResolver scriptResolver = this.getScriptResourceResolver();
        try {
            Servlet servlet = null;
            Resource resource = this.getErrorResource(request);
            for (Class<?> tClass = throwable.getClass(); servlet == null && tClass != Object.class; tClass = tClass.getSuperclass()) {
                ResourceCollector locationUtil = new ResourceCollector(tClass.getSimpleName(), "sling/servlet/errorhandler", resource, this.executionPaths);
                servlet = this.getServletInternal(locationUtil, request, scriptResolver);
            }
            if (servlet == null) {
                servlet = this.getDefaultErrorServlet(request, resource, scriptResolver);
            }
            request.setAttribute("javax.servlet.error.exception", (Object)throwable);
            request.setAttribute("javax.servlet.error.exception_type", throwable.getClass());
            request.setAttribute("javax.servlet.error.message", (Object)throwable.getMessage());
            tracker.logTimer(timerName, "Using handler {0}", new Object[]{RequestUtil.getServletName((Servlet)servlet)});
            this.handleError(servlet, (HttpServletRequest)request, (HttpServletResponse)response);
        }
        finally {
            tracker.logTimer(timerName, "Error handler finished", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceResolver getScriptResourceResolver() {
        ResourceResolver scriptResolver = this.perThreadScriptResolver.get();
        if (scriptResolver == null) {
            ResourceResolver resourceResolver = this.sharedScriptResolver;
            synchronized (resourceResolver) {
                this.sharedScriptResolver.refresh();
            }
            scriptResolver = this.sharedScriptResolver;
        }
        return scriptResolver;
    }

    public void onEvent(SlingRequestEvent event) {
        ResourceResolver resolver;
        if (event.getType() == SlingRequestEvent.EventType.EVENT_INIT) {
            try {
                this.perThreadScriptResolver.set(this.sharedScriptResolver.clone(null));
            }
            catch (LoginException e) {
                LOGGER.error("Unable to create new script resolver clone", (Throwable)e);
            }
        } else if (event.getType() == SlingRequestEvent.EventType.EVENT_DESTROY && (resolver = this.perThreadScriptResolver.get()) != null) {
            this.perThreadScriptResolver.remove();
            resolver.close();
        }
    }

    private Resource getErrorResource(SlingHttpServletRequest request) {
        Resource res = request.getResource();
        if (res == null) {
            res = new SyntheticResource(request.getResourceResolver(), request.getPathInfo(), "sling/servlet/errorhandler");
        }
        return res;
    }

    private Servlet resolveServletInternal(SlingHttpServletRequest request, Resource resource, String scriptName, ResourceResolver resolver) {
        AbstractResourceCollector locationUtil;
        Servlet servlet = null;
        if (scriptName.charAt(0) == '/') {
            String scriptPath = ResourceUtil.normalize((String)scriptName);
            if (SlingServletResolver.isPathAllowed(scriptPath, this.executionPaths)) {
                Resource res = resolver.getResource(scriptPath);
                servlet = this.getServlet(res);
                if (servlet != null && LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Servlet {} found using absolute resource type {}", (Object)RequestUtil.getServletName((Servlet)servlet), (Object)scriptName);
                }
            } else if (request != null) {
                request.getRequestProgressTracker().log("Will not look for a servlet at {0} as it is not in the list of allowed paths", new Object[]{scriptName});
            }
        }
        if (servlet == null && (servlet = this.getServletInternal(locationUtil = request != null ? ResourceCollector.create(request, this.executionPaths, this.defaultExtensions) : NamedScriptResourceCollector.create(scriptName, resource, this.executionPaths), request, resolver)) != null && LOGGER.isDebugEnabled()) {
            LOGGER.debug("getServletInternal returns servlet {}", (Object)RequestUtil.getServletName((Servlet)servlet));
        }
        return servlet;
    }

    private Servlet getServletInternal(AbstractResourceCollector locationUtil, SlingHttpServletRequest request, ResourceResolver resolver) {
        ResolutionCache localCache = this.resolutionCache;
        Servlet scriptServlet = localCache.get(locationUtil);
        if (scriptServlet != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Using cached servlet {}", (Object)RequestUtil.getServletName((Servlet)scriptServlet));
            }
            return scriptServlet;
        }
        Collection<Resource> candidates = locationUtil.getServlets(resolver, localCache.getScriptEngineExtensions());
        if (LOGGER.isDebugEnabled()) {
            if (candidates.isEmpty()) {
                LOGGER.debug("No servlet candidates found");
            } else {
                LOGGER.debug("Ordered list of servlet candidates follows");
                for (Resource candidateResource : candidates) {
                    LOGGER.debug("Servlet candidate: {}", (Object)candidateResource.getPath());
                }
            }
        }
        boolean hasOptingServlet = false;
        for (Resource candidateResource : candidates) {
            LOGGER.debug("Checking if candidate resource {} adapts to servlet and accepts request", (Object)candidateResource.getPath());
            Servlet candidate = this.getServlet(candidateResource);
            if (candidate != null) {
                boolean servletAcceptsRequest;
                boolean isOptingServlet = candidate instanceof OptingServlet;
                boolean bl = servletAcceptsRequest = !isOptingServlet || request != null && ((OptingServlet)candidate).accepts(request);
                if (servletAcceptsRequest) {
                    if (!hasOptingServlet && !isOptingServlet) {
                        localCache.put(locationUtil, candidate);
                    }
                    LOGGER.debug("Using servlet provided by candidate resource {}", (Object)candidateResource.getPath());
                    return candidate;
                }
                if (isOptingServlet) {
                    hasOptingServlet = true;
                }
                LOGGER.debug("Candidate {} does not accept request, ignored", (Object)candidateResource.getPath());
                continue;
            }
            LOGGER.debug("Candidate {} does not adapt to a servlet, ignored", (Object)candidateResource.getPath());
        }
        return null;
    }

    private Servlet getDefaultServlet() {
        if (this.defaultServlet == null) {
            try {
                DefaultServlet servlet = new DefaultServlet();
                servlet.init(new SlingServletConfig(this.servletContext, null, "Apache Sling Core Default Servlet"));
                this.defaultServlet = servlet;
            }
            catch (ServletException se) {
                LOGGER.error("Failed to initialize default servlet", (Throwable)se);
            }
        }
        return this.defaultServlet;
    }

    private Servlet getDefaultErrorServlet(SlingHttpServletRequest request, Resource resource, ResourceResolver resolver) {
        ResourceCollector locationUtil = new ResourceCollector("default", "sling/servlet/errorhandler", resource, this.executionPaths);
        Servlet servlet = this.getServletInternal(locationUtil, request, resolver);
        if (servlet != null) {
            return servlet;
        }
        if (this.fallbackErrorServlet == null) {
            try {
                DefaultErrorHandlerServlet defaultServlet = new DefaultErrorHandlerServlet();
                defaultServlet.init(new SlingServletConfig(this.servletContext, null, "Sling (Ad Hoc) Default Error Handler Servlet"));
                this.fallbackErrorServlet = defaultServlet;
            }
            catch (ServletException se) {
                LOGGER.error("Failed to initialize error servlet", (Throwable)se);
            }
        }
        return this.fallbackErrorServlet;
    }

    private void handleError(Servlet errorHandler, HttpServletRequest request, HttpServletResponse response) throws IOException {
        request.setAttribute("javax.servlet.error.request_uri", (Object)request.getRequestURI());
        if (request.getAttribute("javax.servlet.error.servlet_name") == null) {
            request.setAttribute("javax.servlet.error.servlet_name", (Object)errorHandler.getServletConfig().getServletName());
        }
        try {
            errorHandler.service((ServletRequest)request, (ServletResponse)response);
            response.flushBuffer();
            response.getWriter().close();
        }
        catch (Throwable t) {
            LOGGER.error("Calling the error handler resulted in an error", t);
            LOGGER.error("Original error " + request.getAttribute("javax.servlet.error.exception_type"), (Throwable)request.getAttribute("javax.servlet.error.exception"));
            IOException x = new IOException("Error handler failed: " + t.getClass().getName());
            x.initCause(t);
            throw x;
        }
    }

    @Activate
    protected void activate(ResolverConfig config) throws LoginException {
        this.sharedScriptResolver = this.resourceResolverFactory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", SERVICE_USER));
        this.executionPaths = SlingServletResolver.getExecutionPaths(config.servletresolver_paths());
        this.defaultExtensions = config.servletresolver_defaultExtensions();
        this.getDefaultServlet();
    }

    @Modified
    protected void modified(ResolverConfig config) throws LoginException {
        this.deactivate();
        this.activate(config);
    }

    @Deactivate
    protected void deactivate() {
        this.resolutionCache.flushCache();
        if (this.fallbackErrorServlet != null) {
            try {
                this.fallbackErrorServlet.destroy();
            }
            catch (Throwable throwable) {
            }
            finally {
                this.fallbackErrorServlet = null;
            }
        }
        if (this.sharedScriptResolver != null) {
            this.sharedScriptResolver.close();
            this.sharedScriptResolver = null;
        }
    }

    public static boolean isPathAllowed(String path, String[] executionPaths) {
        if (executionPaths == null || executionPaths.length == 0) {
            LOGGER.debug("Accepting servlet at '{}' as there are no configured execution paths.", (Object)path);
            return true;
        }
        if (path == null || path.length() == 0) {
            LOGGER.debug("Ignoring servlet with empty path.");
            return false;
        }
        for (String config : executionPaths) {
            if (config.endsWith("/")) {
                if (!path.startsWith(config)) continue;
                LOGGER.debug("Accepting servlet at '{}' as the path is prefixed with configured execution path '{}'.", (Object)path, (Object)config);
                return true;
            }
            if (!path.equals(config)) continue;
            LOGGER.debug("Accepting servlet at '{}' as the path equals configured execution path '{}'.", (Object)path, (Object)config);
            return true;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Ignoring servlet at '{}' as the path is not in the configured execution paths.", (Object)path);
        }
        return false;
    }

    public static String[] getExecutionPaths(String[] paths) {
        String[] executionPaths = paths;
        if (executionPaths != null) {
            if (executionPaths.length == 0) {
                executionPaths = null;
            } else {
                boolean hasRoot = false;
                for (String path : executionPaths) {
                    if (path != null && path.length() != 0 && !path.equals("/")) continue;
                    hasRoot = true;
                    break;
                }
                if (hasRoot) {
                    executionPaths = null;
                }
            }
        }
        return executionPaths;
    }
}

